/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.SimpleDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class IstiCalendarPanel
extends JPanel {
    public static final String[] MONTH_TEXT = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final int MIN_YEAR = 1970;
    public static final int MAX_YEAR = 2070;
    protected final Calendar calendar;
    protected final Calendar workingCalendar;
    protected final Date minTime;
    protected final Date maxTime;
    protected JDialog dialog = null;
    protected final JPanel topPanel = new JPanel();
    protected final JPanel monthPanel = new JPanel(new BorderLayout());
    protected final JPanel yearPanel = new JPanel(new BorderLayout());
    protected final JButton previousMonthButton = new BasicArrowButton(7);
    protected final JButton previousYearButton = new BasicArrowButton(7);
    protected final JComboBox monthComboBox = new JComboBox<String>(MONTH_TEXT);
    protected final YearJComboBox yearComboBox = new YearJComboBox();
    protected final JButton nextYearButton = new BasicArrowButton(3);
    protected final JButton nextMonthButton = new BasicArrowButton(3);
    protected final CalendarTableModel tableModel = new CalendarTableModel();
    protected final JTable table = new JTable(this.tableModel);
    static /* synthetic */ Class class$java$lang$String;

    public IstiCalendarPanel() {
        this((Calendar)null);
    }

    public IstiCalendarPanel(Calendar cal) {
        this(cal, null, null);
    }

    public IstiCalendarPanel(Calendar cal, Date minTime, Date maxTime) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this.calendar = cal;
        this.workingCalendar = (Calendar)this.calendar.clone();
        this.minTime = minTime;
        this.maxTime = maxTime;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public static void createDialog(Component owner, Calendar calendar) {
        IstiCalendarPanel.createDialog(owner, calendar, "Calendar");
    }

    public static void createDialog(Component owner, Calendar calendar, String title) {
        IstiCalendarPanel.createDialog(owner, calendar, title, null, null);
    }

    public static void createDialog(Component owner, Calendar calendar, String title, Date minTime, Date maxTime) {
        IstiCalendarPanel panel = new IstiCalendarPanel(calendar, minTime, maxTime);
        SimpleDialog dlg = new SimpleDialog(owner, title, true, (Component)panel, new JButton("Cancel"));
        panel.setDialog(dlg);
        dlg.setResizable(false);
        dlg.show();
    }

    private void jbInit() throws Exception {
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.previousMonthButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int previousMonth;
                int currentMonth = IstiCalendarPanel.this.workingCalendar.get(2);
                if (currentMonth == 0) {
                    int year = IstiCalendarPanel.this.workingCalendar.get(1);
                    if (year > IstiCalendarPanel.this.yearComboBox.minYear) {
                        IstiCalendarPanel.this.workingCalendar.add(1, -1);
                    }
                    previousMonth = 11;
                } else {
                    previousMonth = currentMonth - 1;
                }
                IstiCalendarPanel.this.workingCalendar.set(2, previousMonth);
                IstiCalendarPanel.this.updateDays();
            }
        });
        this.previousYearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int year = IstiCalendarPanel.this.workingCalendar.get(1);
                if (year > IstiCalendarPanel.this.yearComboBox.minYear) {
                    IstiCalendarPanel.this.workingCalendar.add(1, -1);
                }
                IstiCalendarPanel.this.updateDays();
            }
        });
        this.yearComboBox.setCalendar(this.workingCalendar);
        this.yearComboBox.setMinTime(this.minTime);
        this.yearComboBox.setMaxTime(this.maxTime);
        this.yearComboBox.updateYears();
        this.nextYearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int year = IstiCalendarPanel.this.workingCalendar.get(1);
                if (year < IstiCalendarPanel.this.yearComboBox.maxYear) {
                    IstiCalendarPanel.this.workingCalendar.add(1, 1);
                }
                IstiCalendarPanel.this.updateDays();
            }
        });
        this.nextYearButton.setHorizontalTextPosition(2);
        this.nextMonthButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int nextMonth;
                int currentMonth = IstiCalendarPanel.this.workingCalendar.get(2);
                if (currentMonth == 11) {
                    nextMonth = 0;
                    int year = IstiCalendarPanel.this.workingCalendar.get(1);
                    if (year < IstiCalendarPanel.this.yearComboBox.maxYear) {
                        IstiCalendarPanel.this.workingCalendar.add(1, 1);
                    }
                } else {
                    nextMonth = currentMonth + 1;
                }
                IstiCalendarPanel.this.workingCalendar.set(2, nextMonth);
                IstiCalendarPanel.this.updateDays();
            }
        });
        this.nextMonthButton.setHorizontalTextPosition(2);
        this.monthComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IstiCalendarPanel.this.workingCalendar.set(2, IstiCalendarPanel.this.monthComboBox.getSelectedIndex());
                IstiCalendarPanel.this.updateDays();
            }
        });
        this.yearComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (IstiCalendarPanel.this.yearComboBox.isInitYearsInProgress()) {
                    return;
                }
                IstiCalendarPanel.this.workingCalendar.set(1, IstiCalendarPanel.this.yearComboBox.getYear());
                IstiCalendarPanel.this.updateDays();
            }
        });
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.topPanel.setLayout(new FlowLayout(1, 20, 0));
        this.monthPanel.add((Component)this.previousMonthButton, "West");
        Font monthFont = this.monthComboBox.getFont();
        this.monthComboBox.setFont(new Font(monthFont.getFontName(), monthFont.getStyle(), monthFont.getSize() * 3 / 2));
        this.monthPanel.add((Component)this.monthComboBox, "Center");
        this.monthPanel.add((Component)this.nextMonthButton, "East");
        this.topPanel.add(this.monthPanel);
        this.yearPanel.add((Component)this.previousYearButton, "West");
        Font yearFont = this.yearComboBox.getFont();
        this.yearComboBox.setFont(new Font(yearFont.getFontName(), yearFont.getStyle(), yearFont.getSize() * 3 / 2));
        this.yearPanel.add((Component)this.yearComboBox, "Center");
        this.yearPanel.add((Component)this.nextYearButton, "East");
        this.topPanel.add(this.yearPanel);
        this.table.setPreferredScrollableViewportSize(this.table.getMinimumSize());
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            tableColumn.setResizable(false);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.setDefaultRenderer(this.tableModel.getColumnClass(0), new CalendarTableCellRenderer());
        this.updateDays();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() || !(e.getSource() instanceof ListSelectionModel)) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    IstiCalendarPanel.this.processTimeDateChange();
                }
            }
        });
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.addColumnModelListener(new TableColumnModelListener(){

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() || !(e.getSource() instanceof ListSelectionModel)) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    IstiCalendarPanel.this.processTimeDateChange();
                }
            }
        });
    }

    protected void updateDays() {
        this.table.clearSelection();
        int month = this.workingCalendar.get(2);
        int year = this.workingCalendar.get(1);
        this.tableModel.updateData(this.workingCalendar);
        this.monthComboBox.setSelectedIndex(month);
        this.yearComboBox.setYear(year);
        if (month == this.calendar.get(2) && year == this.calendar.get(1)) {
            int dayOfMonth = this.calendar.get(5);
            this.table.changeSelection(this.tableModel.getRowIndex(dayOfMonth), this.tableModel.getColumnIndex(dayOfMonth), false, false);
        }
    }

    protected void processTimeDateChange() {
        int newDay;
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        try {
            newDay = Integer.parseInt(this.tableModel.getValueAt(row, col).toString());
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newDay <= 0) {
            return;
        }
        int oldMonth = this.calendar.get(2);
        int oldDay = this.calendar.get(5);
        int oldYear = this.calendar.get(1);
        int newMonth = this.monthComboBox.getSelectedIndex();
        int newYear = this.yearComboBox.getYear();
        if (oldMonth == newMonth && oldDay == newDay && oldYear == newYear) {
            return;
        }
        this.calendar.set(2, newMonth);
        this.calendar.set(5, newDay);
        this.calendar.set(1, newYear);
        if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
            this.dialog.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class CalendarTableCellRenderer
    extends DefaultTableCellRenderer {
        public CalendarTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }
    }

    protected static class CalendarTableModel
    extends AbstractTableModel {
        private static final int MAX_ROW = 6;
        private static final int MAX_COL = 7;
        private static final String[] columnNames = new String[]{"S", "M", "T", "W", "T", "F", "S"};
        private final int minDayOfMonth;
        private int firstDayOfMonth;
        private int lastDayOfMonth;

        protected CalendarTableModel() {
            this.firstDayOfMonth = this.minDayOfMonth = Calendar.getInstance().getMinimum(5);
            this.lastDayOfMonth = Calendar.getInstance().getMaximum(5);
        }

        public void updateData(Calendar calendar) {
            calendar.set(5, this.minDayOfMonth);
            this.firstDayOfMonth = calendar.get(7);
            this.lastDayOfMonth = calendar.getActualMaximum(5);
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            return 6;
        }

        public String getColumnName(int columnIndex) {
            return columnNames[columnIndex];
        }

        protected int getDayOfMonthIndex(int dayOfMonth) {
            return dayOfMonth + (this.firstDayOfMonth - 1) - this.minDayOfMonth;
        }

        protected int getColumnIndex(int dayOfMonth) {
            int columnIndex = this.getDayOfMonthIndex(dayOfMonth) % 7;
            return columnIndex;
        }

        protected int getRowIndex(int dayOfMonth) {
            int rowIndex = this.getDayOfMonthIndex(dayOfMonth) / 7;
            return rowIndex;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String value = "";
            int index = rowIndex * 7 + columnIndex + 1;
            if (index < this.firstDayOfMonth) {
                return value;
            }
            int dayOfMonth = index + 1 - this.firstDayOfMonth;
            if (dayOfMonth > this.lastDayOfMonth) {
                return value;
            }
            value = String.valueOf(dayOfMonth);
            return value;
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = IstiCalendarPanel.class$("java.lang.String")) : class$java$lang$String;
        }
    }

    protected static class YearJComboBox
    extends JComboBox {
        private int minYear = 1970;
        private int maxYear = 2070;
        private TimeZone timeZone = null;
        private boolean initYearsFlag = false;

        public YearJComboBox() {
            this.updateYears();
        }

        public YearJComboBox(Calendar value) {
            this.setCalendar(value);
            this.updateYears();
        }

        public YearJComboBox(TimeZone value) {
            this.timeZone = value;
            this.updateYears();
        }

        public int getYear() {
            int index = this.getSelectedIndex();
            if (index >= 0) {
                return index + this.minYear;
            }
            return this.minYear;
        }

        public int getYear(Date date) {
            Calendar cal = this.getCalendar();
            cal.setTime(date);
            return cal.get(1);
        }

        public boolean isInitYearsInProgress() {
            return this.initYearsFlag;
        }

        public final void setCalendar(Calendar value) {
            this.setTimeZone(value.getTimeZone());
            this.setYear(value.get(1));
        }

        public void setMaxTime(Date date) {
            this.setMaxTime(date, false);
        }

        public void setMaxTime(Date date, boolean updateYearsFlag) {
            int newMaxYear = date == null ? 2070 : this.getYear(date);
            if (this.maxYear != newMaxYear) {
                this.maxYear = newMaxYear;
                if (updateYearsFlag) {
                    this.updateYears();
                }
            }
        }

        public void setMinTime(Date date) {
            this.setMinTime(date, false);
        }

        public void setMinTime(Date date, boolean updateYearsFlag) {
            int newMinYear = date == null ? 1970 : this.getYear(date);
            if (this.minYear != newMinYear) {
                this.minYear = newMinYear;
                if (updateYearsFlag) {
                    this.updateYears();
                }
            }
        }

        public final void setTimeZone(TimeZone value) {
            this.timeZone = value;
        }

        public void setYear(int year) {
            if (this.initYearsFlag) {
                return;
            }
            if (year < this.minYear) {
                this.minYear = year;
                this.initYears();
            } else if (year > this.maxYear) {
                this.maxYear = year;
                this.initYears();
            }
            this.setSelectedIndex(year - this.minYear);
        }

        public final void updateYears() {
            if (this.initYearsFlag) {
                return;
            }
            int currentYear = this.getYear();
            if (currentYear < this.minYear) {
                currentYear = this.minYear;
            } else if (currentYear > this.maxYear) {
                currentYear = this.maxYear;
            }
            this.initYears();
            this.setYear(currentYear);
        }

        protected Calendar getCalendar() {
            Calendar cal = Calendar.getInstance();
            if (this.timeZone != null) {
                cal.setTimeZone(this.timeZone);
            }
            return cal;
        }

        private final void initYears() {
            this.initYearsFlag = true;
            this.removeAllItems();
            for (int year = this.minYear; year <= this.maxYear; ++year) {
                this.addItem(String.valueOf(year));
            }
            this.initYearsFlag = false;
        }
    }
}

