/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.UtilFns;
import com.isti.util.gui.HandJButton;
import com.isti.util.gui.IstiColorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.colorchooser.DefaultColorSelectionModel;

public class IstiColorSelector
extends DefaultColorSelectionModel {
    private static final String SIZING_STRING = "0x" + UtilFns.toHexString(0, 8);
    protected final JButton button;
    protected Vector listenerList = new Vector();

    public IstiColorSelector(Color c, final String title) {
        this.button = new HandJButton(title);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        FontMetrics metObj = ((Component)this.button).getFontMetrics(this.button.getFont());
        this.button.setPreferredSize(new Dimension(metObj.stringWidth(SIZING_STRING) + 15, metObj.getHeight() + 4));
        this.button.setContentAreaFilled(false);
        this.button.setOpaque(true);
        this.setSelectedColor(c);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color c = IstiColorChooser.showDialog(IstiColorSelector.this.button, title, IstiColorSelector.this.getSelectedColor());
                if (c != null) {
                    IstiColorSelector.this.setSelectedColor(c);
                }
            }
        });
    }

    public Component getSelectionComponent() {
        return this.button;
    }

    public void setSelectedColor(Color color) {
        super.setSelectedColor(color);
        this.button.setBackground(UtilFns.createOpaqueColor(color));
        if (color.getRed() + color.getGreen() < 150) {
            this.button.setForeground(Color.white);
        } else {
            this.button.setForeground(Color.black);
        }
        this.button.setText(UtilFns.getColorDisplayName(color.getRGB()));
        this.fireActionPerformed(new ActionEvent(this, 1001, "color selected"));
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.toArray();
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((ActionListener)listeners[i]).actionPerformed(event);
        }
    }
}

