/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.CallBackStringFlag;
import com.isti.util.LaunchBrowser;
import com.isti.util.URLRefDecoder;
import com.isti.util.UtilFns;
import com.isti.util.gui.IstiDialogPopup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class ViewHTMLPanel
extends JPanel {
    protected final JEditorPane editorPaneObj;
    protected final JScrollPane scrollPaneObj;
    protected final Vector historyVec = new Vector();
    protected final int xSize;
    protected final int ySize;
    protected final CallBackStringFlag remoteLinkCallBackObj;
    protected final JTextField locationTextFieldObj;
    protected final URL originalUrlObj;
    protected URL currentUrlObj = null;
    protected LaunchBrowser launchBrowserObj = null;
    protected IstiDialogPopup hostDialogObj = null;
    protected Object userInputValueObj = null;
    protected boolean dialogClosedFlag = false;
    public static final CallBackStringFlag REMLINK_NOACTION_CALLBACK = new CallBackStringFlag(){

        public boolean callBackFlagMethod(String str) {
            return false;
        }
    };

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj, boolean backButtonFlag, boolean launchButtonFlag, String initialRefStr, CallBackStringFlag remoteLinkCallBackObj, boolean locationBarFlag) {
        this.xSize = xSize;
        this.ySize = ySize;
        if (launchBrowserObj != null) {
            this.launchBrowserObj = launchBrowserObj;
        }
        this.remoteLinkCallBackObj = remoteLinkCallBackObj;
        this.editorPaneObj = new JEditorPane();
        this.editorPaneObj.setEditable(false);
        this.editorPaneObj.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hEvtObj) {
                if (hEvtObj.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (hEvtObj instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)hEvtObj;
                        HTMLDocument doc = (HTMLDocument)ViewHTMLPanel.this.editorPaneObj.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(evt);
                    } else {
                        ViewHTMLPanel.this.setPage(hEvtObj.getURL(), true);
                    }
                }
            }
        });
        this.scrollPaneObj = new JScrollPane(this.editorPaneObj);
        this.editorPaneObj.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (ViewHTMLPanel.this.scrollPaneObj != null) {
                    ViewHTMLPanel.this.scrollPaneObj.requestFocus();
                }
            }
        });
        JPanel buttonsPanel = new JPanel(new FlowLayout(0, 20, 0));
        if (backButtonFlag) {
            JButton backButton = new JButton("Back");
            backButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evtObj) {
                    Object obj;
                    int vecSize = ViewHTMLPanel.this.historyVec.size();
                    if (vecSize > 0 && (obj = ViewHTMLPanel.this.historyVec.remove(vecSize - 1)) instanceof URL) {
                        ViewHTMLPanel.this.doSetPage((URL)obj, false);
                    }
                }
            });
            backButton.setToolTipText("Return to previous location");
            buttonsPanel.add(backButton);
        }
        if (launchButtonFlag) {
            JButton launchButton = new JButton("Launch Browser");
            launchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evtObj) {
                    if (ViewHTMLPanel.this.currentUrlObj != null) {
                        ViewHTMLPanel.this.doLaunchBrowser(ViewHTMLPanel.this.currentUrlObj);
                    }
                }
            });
            launchButton.setToolTipText("View document in web browser");
            buttonsPanel.add(launchButton);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPaneObj, "Center");
        if (locationBarFlag) {
            this.locationTextFieldObj = new JTextField();
            JButton goButtonObj = new JButton("Go");
            ActionListener locActionObj = new ActionListener(){

                public void actionPerformed(ActionEvent evtObj) {
                    boolean retFlag;
                    URL locUrlObj;
                    String locStr = ViewHTMLPanel.this.locationTextFieldObj.getText();
                    try {
                        locUrlObj = new URL(locStr);
                    }
                    catch (MalformedURLException ex) {
                        locUrlObj = null;
                    }
                    if (locUrlObj == null) {
                        try {
                            locUrlObj = new URL("http://" + locStr);
                        }
                        catch (MalformedURLException ex) {
                            // empty catch block
                        }
                    }
                    if (locUrlObj != null) {
                        try {
                            retFlag = ViewHTMLPanel.this.setPage(locUrlObj);
                        }
                        catch (Exception ex) {
                            retFlag = false;
                            ex.printStackTrace();
                        }
                    } else {
                        retFlag = false;
                    }
                    if (!retFlag) {
                        ViewHTMLPanel.this.showMessageText("Unable to show location:  " + locStr);
                    }
                }
            };
            this.locationTextFieldObj.addActionListener(locActionObj);
            goButtonObj.addActionListener(locActionObj);
            this.locationTextFieldObj.setToolTipText("Location viewed in window");
            goButtonObj.setToolTipText("Click to view entered location");
            JPanel locationBarPanel = new JPanel(new GridBagLayout());
            GridBagConstraints contraints = new GridBagConstraints(0, 0, 1, 1, 0.1, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
            locationBarPanel.add((Component)new JLabel("Location:  "), contraints);
            ++contraints.gridx;
            contraints.anchor = 10;
            contraints.fill = 2;
            contraints.weightx = 1.0;
            contraints.anchor = 10;
            locationBarPanel.add((Component)this.locationTextFieldObj, contraints);
            ++contraints.gridx;
            contraints.fill = 0;
            contraints.weightx = 0.1;
            locationBarPanel.add((Component)goButtonObj, contraints);
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)buttonsPanel, "West");
            topPanel.add((Component)locationBarPanel, "Center");
            topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.add((Component)topPanel, "North");
        } else {
            this.locationTextFieldObj = null;
            buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.add((Component)buttonsPanel, "North");
        }
        this.originalUrlObj = urlObj;
        if (urlObj != null && initialRefStr != null) {
            this.historyVec.add(urlObj);
            urlObj = UtilFns.setURLReference(urlObj, initialRefStr);
        }
        this.doSetPage(urlObj, false);
    }

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj, boolean backButtonFlag, boolean launchButtonFlag, String initialRefStr, CallBackStringFlag remoteLinkCallBackObj) {
        this(urlObj, xSize, ySize, launchBrowserObj, backButtonFlag, launchButtonFlag, initialRefStr, remoteLinkCallBackObj, false);
    }

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj, boolean backButtonFlag, boolean launchButtonFlag, String initialRefStr) {
        this(urlObj, xSize, ySize, launchBrowserObj, backButtonFlag, launchButtonFlag, initialRefStr, null, false);
    }

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj, boolean backButtonFlag, boolean launchButtonFlag, String initialRefStr, boolean locationBarFlag) {
        this(urlObj, xSize, ySize, launchBrowserObj, backButtonFlag, launchButtonFlag, initialRefStr, null, locationBarFlag);
    }

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj, boolean backButtonFlag, boolean launchButtonFlag) {
        this(urlObj, xSize, ySize, launchBrowserObj, backButtonFlag, launchButtonFlag, null, null, false);
    }

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj, boolean backButtonFlag, boolean launchButtonFlag, boolean locationBarFlag) {
        this(urlObj, xSize, ySize, launchBrowserObj, backButtonFlag, launchButtonFlag, null, null, locationBarFlag);
    }

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj, boolean backButtonFlag, boolean launchButtonFlag, CallBackStringFlag remoteLinkCallBackObj, boolean locationBarFlag) {
        this(urlObj, xSize, ySize, launchBrowserObj, backButtonFlag, launchButtonFlag, null, remoteLinkCallBackObj, locationBarFlag);
    }

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj, boolean backButtonFlag, boolean launchButtonFlag, CallBackStringFlag remoteLinkCallBackObj) {
        this(urlObj, xSize, ySize, launchBrowserObj, backButtonFlag, launchButtonFlag, null, remoteLinkCallBackObj, false);
    }

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj, String initialRefStr) {
        this(urlObj, xSize, ySize, launchBrowserObj, true, true, initialRefStr, null, false);
    }

    public ViewHTMLPanel(URL urlObj, int xSize, int ySize, LaunchBrowser launchBrowserObj) {
        this(urlObj, xSize, ySize, launchBrowserObj, true, true, null, null);
    }

    public Object showInDialog(Component parentComponent, String titleStr, boolean modalFlag, Object button1Obj, Object button2Obj) {
        this.dialogClosedFlag = false;
        Object[] optionsArr = button1Obj != null ? (button2Obj != null ? new Object[]{button1Obj, button2Obj} : new Object[]{button1Obj}) : (button2Obj != null ? new Object[]{button2Obj} : new Object[]{"Close"});
        this.hostDialogObj = new IstiDialogPopup(parentComponent, (Object)this, titleStr, optionsArr, 0, modalFlag);
        this.hostDialogObj.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evtObj) {
                ViewHTMLPanel.this.hostDialogObj = null;
            }
        });
        if (this.scrollPaneObj != null) {
            this.hostDialogObj.setInitialFocusComponent(this.scrollPaneObj);
        }
        this.hostDialogObj.setSize(this.xSize - 5, this.ySize + 95);
        this.hostDialogObj.setLocationRelativeTo(parentComponent);
        this.hostDialogObj.setResizable(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ViewHTMLPanel.this.hostDialogObj.setSize(ViewHTMLPanel.this.xSize, ViewHTMLPanel.this.ySize + 100);
                ViewHTMLPanel.this.revalidate();
                ViewHTMLPanel.this.hostDialogObj.validate();
                ViewHTMLPanel.this.hostDialogObj.repaint();
            }
        });
        this.userInputValueObj = this.hostDialogObj.show();
        return this.userInputValueObj;
    }

    public Object showInDialog(Component parentComponent, String titleStr, boolean modalFlag, Object button1Obj) {
        return this.showInDialog(parentComponent, titleStr, modalFlag, button1Obj, null);
    }

    public void showInDialog(Component parentComponent, String titleStr, boolean modalFlag) {
        this.showInDialog(parentComponent, titleStr, modalFlag, null, null);
    }

    public void showInDialog(Component parentComponent, String titleStr) {
        this.showInDialog(parentComponent, titleStr, true, null, null);
    }

    public void closeDialog() {
        JDialog dlgObj;
        this.dialogClosedFlag = true;
        if (this.hostDialogObj != null) {
            this.hostDialogObj.waitForDialogVisible(5000);
        }
        if ((dlgObj = this.getHostDialog()) != null) {
            dlgObj.dispose();
        }
    }

    public final boolean setPage(URL urlObj, boolean historyFlag) {
        if (urlObj == null) {
            return true;
        }
        String str = urlObj.toString();
        if (!str.startsWith("jar:") && (UtilFns.isURLAddress(str) || str.indexOf(".htm") <= 0)) {
            if (this.remoteLinkCallBackObj == null) {
                return this.doLaunchBrowser(urlObj);
            }
            return this.remoteLinkCallBackObj.callBackFlagMethod(str);
        }
        return this.doSetPage(urlObj, historyFlag);
    }

    public boolean setPage(URL urlObj) {
        return this.setPage(urlObj, true);
    }

    public final boolean doSetPage(URL urlObj, boolean historyFlag) {
        if (urlObj == null) {
            return true;
        }
        try {
            if (this.currentUrlObj == null || !urlObj.equals(this.currentUrlObj)) {
                int p;
                String refStr = urlObj.getRef();
                if (refStr != null && (p = refStr.indexOf(37)) > 0 && p < refStr.length() - 2 && Character.isDigit(refStr.charAt(p + 1)) && Character.isDigit(refStr.charAt(p + 2))) {
                    this.editorPaneObj.setPage(UtilFns.setURLReference(urlObj, URLRefDecoder.decode(refStr)));
                } else {
                    this.editorPaneObj.setPage(urlObj);
                }
                if (historyFlag && this.currentUrlObj != null) {
                    this.historyVec.add(this.currentUrlObj);
                }
                this.currentUrlObj = urlObj;
                if (this.locationTextFieldObj != null) {
                    this.locationTextFieldObj.setText(urlObj.toString());
                }
            }
            return true;
        }
        catch (Exception ex) {
            System.err.println("Unable to display page (\"" + urlObj + "\"):  " + ex);
            if (this.currentUrlObj != null) {
                try {
                    this.editorPaneObj.setPage(this.currentUrlObj);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public final boolean doSetPage(URL urlObj) {
        return this.doSetPage(urlObj, true);
    }

    public boolean setPageRef(String refStr) {
        if (this.currentUrlObj != null) {
            return this.setPage(UtilFns.setURLReference(this.currentUrlObj, refStr));
        }
        return false;
    }

    public boolean showMessageText(String msgStr) {
        try {
            if (this.currentUrlObj != null) {
                if (this.historyVec.size() <= 0 || !this.currentUrlObj.equals(this.historyVec.lastElement())) {
                    this.historyVec.add(this.currentUrlObj);
                }
                this.currentUrlObj = null;
            }
            this.editorPaneObj.read((InputStream)new ByteArrayInputStream(msgStr != null ? msgStr.getBytes() : new byte[]{}), (Object)new HTMLDocument());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void clearHistory() {
        this.historyVec.clear();
    }

    public void resetViewer() {
        this.historyVec.clear();
        this.setPage(this.originalUrlObj, false);
    }

    protected boolean doLaunchBrowser(URL targetUrlObj) {
        String urlStr = UtilFns.setURLReference(targetUrlObj, null).toString();
        if (urlStr.startsWith("jar:")) {
            FileInputStream tempStmObj;
            int p = urlStr.lastIndexOf(47);
            if (p < 0 || p >= urlStr.length() - 1) {
                System.err.println("Unable to launch browser to view \"" + urlStr + "\"");
                return false;
            }
            urlStr = urlStr.substring(p + 1);
            try {
                tempStmObj = new FileInputStream(urlStr);
                if (tempStmObj != null) {
                    ((InputStream)tempStmObj).close();
                }
            }
            catch (Exception ex) {
                tempStmObj = null;
            }
            if (tempStmObj == null) {
                System.err.println("Unable to access \"" + urlStr + "\" before launching browser");
                return false;
            }
        }
        if (this.launchBrowserObj == null) {
            this.launchBrowserObj = new LaunchBrowser();
        }
        if (this.launchBrowserObj.showURL(urlStr, "ViewHTMLBrowser")) {
            this.closeDialog();
            return true;
        }
        System.err.println("Error launching browser:  " + this.launchBrowserObj.getErrorMessage());
        return false;
    }

    public void requestFocus() {
        super.requestFocus();
        JDialog dlgObj = this.getHostDialog();
        if (dlgObj != null) {
            dlgObj.requestFocus();
        }
    }

    public void setDialogVisible(boolean flgVal) {
        super.setVisible(flgVal);
        JDialog dlgObj = this.getHostDialog();
        if (dlgObj != null) {
            ((Component)dlgObj).setVisible(flgVal);
        }
    }

    public boolean isVisible() {
        JDialog dlgObj = this.getHostDialog();
        if (dlgObj != null && dlgObj.isVisible()) {
            return super.isVisible();
        }
        return false;
    }

    public JDialog getHostDialog() {
        if (this.hostDialogObj != null) {
            return this.hostDialogObj.getDialogObj();
        }
        Container compObj = this;
        do {
            if (!((compObj = compObj.getParent()) instanceof JDialog)) continue;
            return (JDialog)compObj;
        } while (compObj != null);
        return null;
    }

    public Object getInputValue() {
        return this.userInputValueObj;
    }

    public boolean getDialogClosedFlag() {
        return this.dialogClosedFlag;
    }
}

