/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.gui.textvalidator.TextValidator;
import com.isti.util.gui.textvalidator.ValidatedDocument;
import javax.swing.JTextField;

public class ValidatedJTextField
extends JTextField {
    private final ValidatedDocument document;

    public ValidatedJTextField(ValidatedDocument document) {
        super(document, null, document != null ? document.maxNumChars : 0);
        this.document = document;
    }

    public ValidatedJTextField(TextValidator tv) {
        this(ValidatedJTextField.getValidatedDocument(tv));
        this.setTextValidator(tv);
        if (tv != null && tv.getColumns() >= 0) {
            this.setColumns(tv.getColumns());
        }
    }

    public double getDoubleValue() {
        try {
            if (this.getText() != null && this.getText().length() > 0) {
                return Double.parseDouble(this.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public static ValidatedDocument getValidatedDocument(TextValidator tv) {
        if (tv == null) {
            return null;
        }
        return new ValidatedDocument(tv.getSpecialChars(), tv.isNumeric(), tv.getMaxNumChars(), tv.getAllowedFlag());
    }

    public int getIntegerValue() {
        try {
            if (this.getText() != null && this.getText().length() > 0) {
                return Integer.parseInt(this.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public TextValidator getTextValidator() {
        if (this.document != null) {
            return this.document.getTextValidator();
        }
        return null;
    }

    public final ValidatedJTextField setTextValidator(TextValidator tv) {
        String toolTipText = this.getToolTipText();
        if (toolTipText == null || toolTipText.length() <= 0) {
            if (tv != null) {
                toolTipText = tv.getToolTipText();
            }
            if (toolTipText != null) {
                this.setToolTipText(toolTipText);
            }
        }
        if (this.document != null) {
            this.document.setTextValidator(tv);
        }
        return this;
    }

    public void setValue(int val) {
        this.setText(Integer.toString(val));
    }

    public void setValue(double val) {
        this.setText(Double.toString(val));
    }

    public void setValue(Object val) {
        String s = val != null ? val.toString() : null;
        this.setText(s);
    }
}

