/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.menu;

import com.isti.util.IstiXmlLoader;
import com.isti.util.gui.HandJButton;
import com.isti.util.gui.IstiPopupMenu;
import com.isti.util.menu.IstiMenuListener;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import org.jdom.Element;

public class IstiMenuLoader
extends IstiXmlLoader {
    public static final String TOP_MENU_BAR_NAME = "TopMenu";
    private Object topMenuBarObject = null;
    private Hashtable nameHashTable = new Hashtable();
    private ActionListener actionListener = null;
    private final String rootElementName = "Menus";
    private boolean menuLoadInProgressFlag = false;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public IstiMenuLoader() {
        this(null);
    }

    public IstiMenuLoader(ActionListener l) {
        this.setDefaultActionListener(l);
    }

    public Object getChildMenuObject(int childIndex, Object parentObject) {
        return this.processChildElement(this.getRootElement(), childIndex, parentObject);
    }

    public Frame createFrameWithMenuBar(Object topMenuObject) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        return this.createFrameWithMenuBar(topMenuObject, d.width / 2, d.height / 2);
    }

    public Frame createFrameWithMenuBar(Object topMenuObject, int width, int height) {
        Frame frameObj;
        if (topMenuObject instanceof MenuBar) {
            frameObj = new Frame();
            frameObj.setMenuBar((MenuBar)topMenuObject);
        } else if (topMenuObject instanceof JMenuBar) {
            frameObj = new JFrame();
            ((JFrame)frameObj).setJMenuBar((JMenuBar)topMenuObject);
        } else {
            this.setErrorMessage("Top menu object is not a MenuBar or JMenuBar: " + topMenuObject.getClass());
            return null;
        }
        ((Component)frameObj).setSize(width, height);
        Dimension dimObj = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frameObj).setLocation((dimObj.width - frameObj.getSize().width) / 2, (dimObj.height - frameObj.getSize().height) / 2);
        return frameObj;
    }

    public Object getTopMenuBarObject() {
        if (this.topMenuBarObject == null) {
            this.topMenuBarObject = this.getTopMenuObject(TOP_MENU_BAR_NAME);
        }
        return this.topMenuBarObject;
    }

    public Object getTopMenuObject() {
        return this.processChildElement(this.getRootElement(), 0, null);
    }

    public Object getTopMenuObject(int index) {
        return this.processChildElement(this.getRootElement(), index, null);
    }

    public Object getTopMenuObject(String name) {
        return this.processChildElement(this.getRootElement(), "Name", name, null);
    }

    public boolean loadFile(String fileName) {
        boolean fileLoaded = super.loadFile(fileName, "Menus");
        return fileLoaded;
    }

    protected void processErrorMessage(String str) {
        System.out.println(str);
    }

    public final void setDefaultActionListener(ActionListener l) {
        this.actionListener = l;
    }

    protected Object processElement(Element element, Object parentObject, Element parentElement) {
        if (element.getName().equalsIgnoreCase("MenuSeparator")) {
            if (!parentElement.getName().equalsIgnoreCase("Menu")) {
                this.processErrorMessage(this.getClass() + ".processElement - " + element.getName() + " cannot be added to: " + parentElement.getName());
                return null;
            }
            this.addMenuSeparator(parentObject);
            return null;
        }
        Object menuItem = null;
        if (element.getName().equalsIgnoreCase("MenuLoad")) {
            this.menuLoadInProgressFlag = true;
            String loadNameString = element.getAttributeValue("LoadName");
            menuItem = this.loadMenuItem(loadNameString, parentObject, parentElement);
            this.menuLoadInProgressFlag = false;
            if (menuItem == null) {
                this.processErrorMessage(this.getClass() + ".processElement - Failed to load menu item: " + loadNameString);
            }
            return null;
        }
        String nameString = element.getAttributeValue("Name");
        if (nameString == null) {
            this.processErrorMessage(this.getClass() + ".processElement - " + "Name" + " string not found for: " + element.getName());
            return null;
        }
        if (!this.menuLoadInProgressFlag && this.nameHashTable.containsKey(nameString)) {
            this.processErrorMessage(this.getClass() + ".processElement - " + "Name" + " string is not unique: " + nameString);
            return null;
        }
        String classString = element.getAttributeValue("Class");
        if (element.getName().equalsIgnoreCase("MenuBar") || element.getName().equalsIgnoreCase("PopupMenu")) {
            if (!parentElement.getName().equalsIgnoreCase("Menus")) {
                this.processErrorMessage(this.getClass() + ".processElement - " + element.getName() + " cannot be added to: " + parentElement.getName());
                return null;
            }
            if (classString == null) {
                menuItem = element.getName().equalsIgnoreCase("MenuBar") ? new JMenuBar() : new IstiPopupMenu();
            }
        } else if (element.getName().equalsIgnoreCase("Menu")) {
            if (!(parentElement.getName().equalsIgnoreCase("MenuBar") || parentElement.getName().equalsIgnoreCase("PopupMenu") || parentElement.getName().equalsIgnoreCase("Menu"))) {
                this.processErrorMessage(this.getClass() + ".processElement - " + element.getName() + " cannot be added to: " + parentElement.getName());
                return null;
            }
            if (classString == null) {
                menuItem = new JMenu();
            }
        } else if (element.getName().equalsIgnoreCase("MenuItem") || element.getName().equalsIgnoreCase("CheckboxMenuItem")) {
            if (parentElement.getName().equalsIgnoreCase("MenuBar") && element.getName().equalsIgnoreCase("MenuItem")) {
                menuItem = new MenuBarMenuItem();
            } else {
                if (!parentElement.getName().equalsIgnoreCase("PopupMenu") && !parentElement.getName().equalsIgnoreCase("Menu")) {
                    this.processErrorMessage(this.getClass() + ".processElement - " + element.getName() + " cannot be added to: " + parentElement.getName());
                    return null;
                }
                if (classString == null) {
                    menuItem = element.getName().equalsIgnoreCase("MenuItem") ? new JMenuItem() : new JCheckBoxMenuItem();
                }
            }
        } else {
            this.processErrorMessage(this.getClass() + ".processElement - Unknown tag: " + element.getName());
            return null;
        }
        if (classString != null) {
            menuItem = this.getComponentForClass(classString);
        }
        if (menuItem == null) {
            if (this.getErrorFlag()) {
                this.processErrorMessage(this.getClass() + ".processElement - Menu item creation error: " + this.getErrorMessage());
                this.clearErrorMessage();
            } else {
                this.processErrorMessage(this.getClass() + ".processElement - Menu item creation error with element: " + element.getName());
            }
            return null;
        }
        if (!this.menuLoadInProgressFlag) {
            this.nameHashTable.put(nameString, menuItem);
        }
        if (menuItem instanceof MenuBarMenuItem) {
            this.addMenuItem(new SpaceMenuItem(), parentObject);
        }
        this.addMenuItem(menuItem, parentObject);
        this.processElementAttributes(element, menuItem);
        if (menuItem instanceof JMenu && ((JMenu)menuItem).getItemCount() <= 0 && ((JMenu)menuItem).getName().trim().length() <= 0) {
            ((JMenu)menuItem).setEnabled(false);
        }
        if (nameString.equals(TOP_MENU_BAR_NAME)) {
            this.topMenuBarObject = menuItem;
        }
        return menuItem;
    }

    protected void processElementAttributes(Element element, Object menuItem) {
        String acceleratorString;
        String mnemonicString;
        String nameString = element.getAttributeValue("Name");
        if (nameString != null) {
            if (menuItem instanceof MenuComponent) {
                ((MenuComponent)menuItem).setName(nameString);
            } else if (menuItem instanceof Component) {
                ((Component)menuItem).setName(nameString);
            } else {
                this.processErrorMessage(this.getClass() + ".processElementAttributes - Do not know how to set name for: " + menuItem);
            }
        }
        if (element.getName().equalsIgnoreCase("Menu") || element.getName().equalsIgnoreCase("MenuItem") || element.getName().equalsIgnoreCase("CheckboxMenuItem")) {
            String textString = element.getAttributeValue("DisplayText");
            if (textString == null) {
                textString = nameString;
            }
            if (textString != null) {
                if (menuItem instanceof MenuItem) {
                    ((MenuItem)menuItem).setLabel(textString);
                } else if (menuItem instanceof AbstractButton) {
                    ((AbstractButton)menuItem).setText(textString);
                } else {
                    this.processErrorMessage(this.getClass() + ".processElementAttributes - " + "Do not know how to set display text for: " + menuItem);
                }
            }
        }
        if ((element.getName().equalsIgnoreCase("Menu") || element.getName().equalsIgnoreCase("MenuItem") || element.getName().equalsIgnoreCase("CheckboxMenuItem")) && (mnemonicString = element.getAttributeValue("Mnemonic")) != null) {
            if (menuItem instanceof AbstractButton) {
                ((AbstractButton)menuItem).setMnemonic(mnemonicString.charAt(0));
            } else if (!(menuItem instanceof MenuItem)) {
                this.processErrorMessage(this.getClass() + ".processElementAttributes - " + "Do not know how to set mnemonic for: " + menuItem);
            }
        }
        if ((element.getName().equalsIgnoreCase("MenuItem") || element.getName().equalsIgnoreCase("CheckboxMenuItem")) && (acceleratorString = element.getAttributeValue("Accelerator")) != null) {
            KeyStroke keystroke = KeyStroke.getKeyStroke(acceleratorString);
            if (keystroke == null) {
                this.processErrorMessage(this.getClass() + ".processElementAttributes - " + "Cannot convert to keystroke: " + acceleratorString);
            } else if (menuItem instanceof MenuItem) {
                int modifiers = keystroke.getModifiers();
                boolean useShiftModifier = (modifiers & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != modifiers;
                MenuShortcut menuShortcut = new MenuShortcut(keystroke.getKeyCode(), useShiftModifier);
                ((MenuItem)menuItem).setShortcut(menuShortcut);
            } else if (menuItem instanceof JMenuItem) {
                ((JMenuItem)menuItem).setAccelerator(keystroke);
            } else if (!(menuItem instanceof AbstractButton)) {
                this.processErrorMessage(this.getClass() + ".processElementAttributes - " + "Do not know how to set the menu accelerator for: " + menuItem);
            }
        }
        ActionListener l = null;
        if (!element.getName().equalsIgnoreCase("MenuBar") && !element.getName().equalsIgnoreCase("PopupMenu")) {
            String handlerString = element.getAttributeValue("Handler");
            l = this.addActionListener(menuItem, handlerString);
        }
        if (element.getName().equalsIgnoreCase("CheckboxMenuItem")) {
            String selectedString = element.getAttributeValue("Selected");
            if (selectedString == null && l instanceof IstiMenuListener) {
                boolean isSelected = ((IstiMenuListener)((Object)l)).isMenuItemSelected(menuItem);
                selectedString = new Boolean(isSelected).toString();
            }
            if (selectedString != null) {
                boolean selectedFlag = new Boolean(selectedString);
                if (menuItem instanceof CheckboxMenuItem) {
                    ((CheckboxMenuItem)menuItem).setState(selectedFlag);
                } else if (menuItem instanceof AbstractButton) {
                    ((AbstractButton)menuItem).setSelected(selectedFlag);
                } else if (!(menuItem instanceof MenuItem)) {
                    this.processErrorMessage(this.getClass() + ".processElementAttributes - Do not know how to set state for: " + menuItem);
                }
            }
        }
    }

    protected ActionListener addActionListener(Object menuItem, String handlerString) {
        if (menuItem instanceof MenuBar || menuItem instanceof JMenuBar) {
            return null;
        }
        ActionListener l = this.actionListener;
        if (handlerString != null) {
            Object object = this.getComponentForClass(handlerString);
            if (object instanceof ActionListener) {
                l = (ActionListener)object;
            } else if (object == null) {
                this.processErrorMessage(this.getClass() + ".addActionListener - getComponentForClass: " + this.getErrorMessage());
                this.clearErrorMessage();
            } else {
                this.processErrorMessage(this.getClass() + ".addActionListener - Handler does not have an action listener:" + handlerString);
            }
        } else {
            ActionListener[] als = null;
            if (menuItem instanceof MenuItem) {
                MenuContainer mc = ((MenuItem)menuItem).getParent();
                if (mc instanceof MenuItem) {
                    als = (ActionListener[])((MenuItem)((Object)mc)).getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = IstiMenuLoader.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
                } else if (mc != null && !(mc instanceof MenuBar)) {
                    this.processErrorMessage(this.getClass() + ".addActionListener - " + "Do not know how to get action listener for parent: " + mc);
                }
            } else if (menuItem instanceof Component) {
                JPopupMenu pm;
                Component pmInvoker;
                Container mc = ((Component)menuItem).getParent();
                if (mc instanceof JPopupMenu && (pmInvoker = (pm = (JPopupMenu)mc).getInvoker()) != null) {
                    als = (ActionListener[])pmInvoker.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = IstiMenuLoader.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
                }
                if (mc != null && als == null) {
                    als = (ActionListener[])mc.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = IstiMenuLoader.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
                }
            } else {
                this.processErrorMessage(this.getClass() + ".addActionListener - " + "Do not know how to get action listener for: " + menuItem);
            }
            if (als != null && als.length >= 1) {
                l = als[0];
            }
        }
        if (menuItem instanceof MenuItem) {
            ((MenuItem)menuItem).addActionListener(l);
            if (menuItem instanceof CheckboxMenuItem && l instanceof ItemListener) {
                ((CheckboxMenuItem)menuItem).addItemListener((ItemListener)((Object)l));
            }
        } else if (menuItem instanceof AbstractButton) {
            ((AbstractButton)menuItem).addActionListener(l);
        } else {
            this.processErrorMessage(this.getClass() + ".addActionListener - Do not know how to add action listener for: " + menuItem);
        }
        return l;
    }

    protected void addMenuItem(Object menuItem, Object parentObject) {
        if (parentObject == null) {
            return;
        }
        if (parentObject instanceof MenuBar && menuItem instanceof Menu) {
            ((MenuBar)parentObject).add((Menu)menuItem);
        } else if (parentObject instanceof Menu && menuItem instanceof MenuItem) {
            ((Menu)parentObject).add((MenuItem)menuItem);
        } else if (parentObject instanceof Container && menuItem instanceof Component) {
            ((Container)parentObject).add((Component)menuItem);
        } else {
            this.processErrorMessage(this.getClass() + ".addMenuItem - Do not know how to handle parent " + parentObject + "and menu item " + menuItem);
        }
    }

    protected void addMenuSeparator(Object parentObject) {
        if (parentObject == null) {
            return;
        }
        if (parentObject instanceof Menu) {
            ((Menu)parentObject).addSeparator();
        } else if (parentObject instanceof JMenu) {
            ((JMenu)parentObject).addSeparator();
        } else {
            this.processErrorMessage(this.getClass() + ".addMenuSeparator - " + "Do not know how to append a new separator for: " + parentObject);
        }
    }

    protected Object loadMenuItem(String name, Object parentObject, Element parentElement) {
        if (name == null || parentObject == null || parentElement == null) {
            return null;
        }
        Element element = super.findElement("Name", name);
        if (element != null) {
            Object object = this.processElement(element, parentObject, parentElement);
            if (object != null) {
                this.processChildren(element, object);
            }
            return object;
        }
        return null;
    }

    public Object findMenuItem(String name) {
        return this.findMenuItem(this.getTopMenuBarObject(), name);
    }

    public Object findMenuItem(Object menuObject, String name) {
        Object menuItem = null;
        if (menuObject instanceof MenuElement) {
            menuItem = this.findMenuItem((MenuElement)menuObject, name);
        } else if (menuObject instanceof Component) {
            menuItem = this.findMenuItem((Component)menuObject, name);
        } else if (menuObject instanceof MenuComponent) {
            menuItem = this.findMenuItem((MenuComponent)menuObject, name);
        }
        if (menuItem != null) {
            return menuItem;
        }
        if (menuObject instanceof MenuBar) {
            return this.findMenuItem((MenuBar)menuObject, name);
        }
        if (menuObject instanceof Menu) {
            return this.findMenuItem((Menu)menuObject, name);
        }
        return menuItem;
    }

    public Object updateMenuItemShown(String name, boolean showItemFlag) {
        return this.updateMenuItemShown(this.getTopMenuBarObject(), name, showItemFlag);
    }

    public Object updateMenuItemShown(Object menuObject, String name, boolean showItemFlag) {
        Object menuItem = this.findMenuItem(menuObject, name);
        if (menuItem instanceof MenuItem) {
            ((MenuItem)menuItem).setEnabled(showItemFlag);
        } else if (menuItem instanceof JMenuItem) {
            ((JMenuItem)menuItem).setVisible(showItemFlag);
            ((JMenuItem)menuItem).setEnabled(showItemFlag);
        } else if (menuItem instanceof AbstractButton) {
            ((AbstractButton)menuItem).setVisible(showItemFlag);
            ((AbstractButton)menuItem).setEnabled(showItemFlag);
        } else if (menuItem != null) {
            this.processErrorMessage(this.getClass() + ".setMenuItemShown - " + "Do not know how to set shown for: " + menuItem);
        }
        return menuItem;
    }

    protected Object findMenuItem(MenuComponent menuObject, String name) {
        if (name.equalsIgnoreCase(menuObject.getName())) {
            return menuObject;
        }
        return null;
    }

    protected Object findMenuItem(Component menuObject, String name) {
        if (name.equalsIgnoreCase(menuObject.getName())) {
            return menuObject;
        }
        return null;
    }

    protected Object findMenuItem(MenuElement menuObject, String name) {
        if (name.equalsIgnoreCase(menuObject.getComponent().getName())) {
            return menuObject;
        }
        Object menuItem = null;
        MenuElement[] menuElements = menuObject.getSubElements();
        for (int i = 0; i < menuElements.length && (menuItem = this.findMenuItem(menuElements[i], name)) == null; ++i) {
        }
        return menuItem;
    }

    protected Object findMenuItem(MenuBar menuObject, String name) {
        Object menuItem = null;
        for (int i = 0; i < menuObject.getMenuCount(); ++i) {
            Menu menu = menuObject.getMenu(i);
            if (name.equalsIgnoreCase(menu.getName())) {
                return menu;
            }
            menuItem = this.findMenuItem(menu, name);
            if (menuItem != null) break;
        }
        return menuItem;
    }

    protected Object findMenuItem(Menu menuObject, String name) {
        Object menuItem = null;
        for (int i = 0; i < menuObject.getItemCount(); ++i) {
            MenuItem item = menuObject.getItem(i);
            if (name.equalsIgnoreCase(item.getName())) {
                return item;
            }
            menuItem = this.findMenuItem(item, name);
            if (menuItem != null) break;
        }
        return menuItem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class SpaceMenuItem
    extends JMenu {
        public SpaceMenuItem() {
            super("   ");
            this.setEnabled(false);
        }
    }

    protected static class MenuBarMenuItem
    extends HandJButton {
        public MenuBarMenuItem() {
            this.setBackground(null);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

