/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.menu;

import java.awt.Component;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class IstiMenuPopper
implements MouseListener {
    boolean enabled = true;
    private Object popupMenu;

    public static IstiMenuPopper createMenuPopper(PopupMenu popupMenu) {
        return IstiMenuPopper.createMenuPopper((Object)popupMenu, null);
    }

    public static IstiMenuPopper createMenuPopper(PopupMenu popupMenu, Component component) {
        return IstiMenuPopper.createMenuPopper((Object)popupMenu, component);
    }

    public static IstiMenuPopper createMenuPopper(JPopupMenu popupMenu) {
        return IstiMenuPopper.createMenuPopper((Object)popupMenu, null);
    }

    public static IstiMenuPopper createMenuPopper(JPopupMenu popupMenu, JComponent component) {
        return IstiMenuPopper.createMenuPopper((Object)popupMenu, (Component)component);
    }

    protected static IstiMenuPopper createMenuPopper(Object popupMenu, Component component) {
        if (popupMenu == null) {
            return null;
        }
        return new IstiMenuPopper(popupMenu).add(component);
    }

    public IstiMenuPopper add(Component component) {
        if (component == null) {
            return this;
        }
        component.addMouseListener(this);
        if (this.popupMenu instanceof PopupMenu) {
            component.add((PopupMenu)this.popupMenu);
        } else if (component instanceof JComponent && this.popupMenu instanceof JPopupMenu) {
            ((JComponent)component).add((JPopupMenu)this.popupMenu);
        }
        return this;
    }

    public IstiMenuPopper(Object popupMenu) {
        this.popupMenu = popupMenu;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseExited(MouseEvent e) {
        this.processMouseEvent(e);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        if (e.isPopupTrigger()) {
            Component component = e.getComponent();
            if (this.popupMenu instanceof PopupMenu) {
                ((PopupMenu)this.popupMenu).show(component, e.getX(), e.getY());
            } else if (this.popupMenu instanceof JPopupMenu) {
                ((JPopupMenu)this.popupMenu).show(component, e.getX(), e.getY());
            }
        }
    }
}

