/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.FifoHashtable;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.ViewHTMLPanel;
import com.isti.util.propertyeditor.PropertyComponentPanel;
import com.isti.util.propertyeditor.PropertyEditorFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class BasePropertyInspector
extends JPanel {
    private final JTabbedPane tabbedPaneObj = new JTabbedPane();
    private JScrollPane scrollPane = null;
    private IstiDialogPopup dialogObj = null;
    private IstiDialogPopup.CloseListener dialogCloseListenerObj = null;
    protected final ConfigLowerButtonPanel lowerButtonPanelObj = new ConfigLowerButtonPanel();
    private Map currentProps = null;
    private Map defaultProps = null;
    private Hashtable editorsTable = new Hashtable();
    private Hashtable allEditors = null;
    private final Map tabTable = new FifoHashtable();
    private boolean initialFocusOnFirstCompFlag = false;
    private Component firstFocusComponentObj = null;
    private String defaultTabTitle = "Other";
    protected boolean saveAsTextFlag = true;
    protected boolean centerFlag = false;
    public static final String CHANGE_ALL_PROPSTR = "ChangeAll";

    protected BasePropertyInspector() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPaneObj, "Center");
        this.add((Component)this.lowerButtonPanelObj, "South");
    }

    public BasePropertyInspector(Map props) {
        this();
        this.addProperties(props);
    }

    public Map getProperties() {
        return this.currentProps;
    }

    protected Collection getPropertyKeys() {
        return null;
    }

    protected final void addProperties(Map props) {
        String tabTitle;
        this.currentProps = props;
        TreeSet propertyKeys = this.getPropertyKeys();
        if (propertyKeys == null) {
            propertyKeys = new TreeSet(props.keySet());
        }
        this.allEditors = new Hashtable(propertyKeys.size());
        String key = null;
        PropertyComponentPanel cfgPropCompPanel = null;
        Iterator<Object> it = propertyKeys.iterator();
        while (it.hasNext()) {
            try {
                Hashtable<String, PropertyEditor> editors;
                Object tableObj;
                key = (String)it.next();
                tabTitle = this.getTabTitle(key);
                if (tabTitle == null) {
                    tabTitle = "";
                }
                if ((tableObj = this.tabTable.get(tabTitle)) instanceof PropertyComponentPanel) {
                    cfgPropCompPanel = (PropertyComponentPanel)tableObj;
                    editors = (Hashtable<String, PropertyEditor>)this.editorsTable.get(cfgPropCompPanel);
                } else {
                    cfgPropCompPanel = this.createPropertyComponentPanel();
                    this.tabTable.put(tabTitle, cfgPropCompPanel);
                    editors = new Hashtable<String, PropertyEditor>();
                    this.editorsTable.put(cfgPropCompPanel, editors);
                }
                Component propertyLabel = this.createPropertyLabel(key);
                PropertyEditor editor = this.createPropertyEditor(key);
                if (editor == null) continue;
                Component comp = editor.getCustomEditor();
                String toolTipText = this.getToolTipText(key);
                if (toolTipText != null && toolTipText.length() > 0) {
                    this.setToolTipText(propertyLabel, toolTipText);
                    this.setToolTipText(comp, toolTipText);
                }
                cfgPropCompPanel.addProperty(propertyLabel, comp);
                this.allEditors.put(key, editor);
                editors.put(key, editor);
            }
            catch (Exception ex) {
                System.err.println("BasePropertyInspector.addProperties():  Error adding setting (key=\"" + key + "\"):  " + ex);
                ex.printStackTrace();
            }
        }
        it = this.tabTable.keySet().iterator();
        while (it.hasNext()) {
            tabTitle = (String)it.next();
            if (tabTitle.length() <= 0 && this.scrollPane != null) continue;
            cfgPropCompPanel = (PropertyComponentPanel)this.tabTable.get(tabTitle);
            this.addTab(tabTitle, cfgPropCompPanel);
            if (this.firstFocusComponentObj != null || tabTitle.length() <= 0) continue;
            this.firstFocusComponentObj = cfgPropCompPanel.getFirstFocusComponentObj();
        }
        if (this.tabbedPaneObj.getTabCount() <= 1 && this.scrollPane != null) {
            this.add((Component)this.scrollPane, "Center");
            if (this.firstFocusComponentObj == null && cfgPropCompPanel != null) {
                this.firstFocusComponentObj = cfgPropCompPanel.getFirstFocusComponentObj();
            }
        }
    }

    public void addTab(String tabTitle, JPanel tabPanel) {
        this.scrollPane = new JScrollPane(tabPanel, 20, 30);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setAlignmentY(0.0f);
        if (tabTitle.length() > 0) {
            this.tabbedPaneObj.addTab(tabTitle, this.scrollPane);
        }
    }

    public void setDefaultProperties(Map props) {
        if (props != null && props.size() > 0) {
            this.defaultProps = props;
        }
        this.lowerButtonPanelObj.defaultsButton.setEnabled(this.defaultProps != null);
    }

    public void addHelpActionListener(ActionListener listenerObj) {
        this.lowerButtonPanelObj.addHelpListener(listenerObj);
    }

    public void addHelpActionViewHTMLPanel(final ViewHTMLPanel panelObj, final boolean useTabRefsFlag, final Component parentComponent, final String titleStr, final boolean modalFlag) {
        this.lowerButtonPanelObj.addHelpListener(new ActionListener(){

            public void actionPerformed(ActionEvent evtObj) {
                String tabStr;
                if (useTabRefsFlag && (tabStr = BasePropertyInspector.this.getCurrentTabName()) != null) {
                    panelObj.setPageRef(tabStr);
                }
                panelObj.showInDialog(parentComponent, titleStr, modalFlag);
            }
        });
    }

    public void setInitialFocusOnFirstCompFlag(boolean flgVal) {
        this.initialFocusOnFirstCompFlag = flgVal;
    }

    protected Object getCurrentValue(String key) {
        if (this.currentProps != null) {
            return this.currentProps.get(key);
        }
        return null;
    }

    protected Object getDefaultValue(String key) {
        if (this.defaultProps != null) {
            return this.defaultProps.get(key);
        }
        return null;
    }

    protected String getTabTitle(String key) {
        return this.defaultTabTitle;
    }

    protected Component createPropertyLabel(String key) {
        return PropertyEditorFactory.createPropertyLabel(key);
    }

    protected PropertyComponentPanel createPropertyComponentPanel() {
        return new PropertyComponentPanel();
    }

    protected PropertyEditor createPropertyEditor(String key) {
        Object valueObj = this.currentProps.get(key);
        return PropertyEditorFactory.createPropertyEditor(key, valueObj);
    }

    public PropertyComponentPanel getSpecifiedComponentPanel(String tabNameStr) {
        int idx;
        Component compObj = tabNameStr != null ? ((idx = this.tabbedPaneObj.indexOfTab(tabNameStr)) >= 0 ? this.tabbedPaneObj.getComponentAt(idx) : null) : this.tabbedPaneObj.getSelectedComponent();
        if (compObj instanceof JScrollPane && (compObj = ((JScrollPane)compObj).getViewport().getView()) instanceof PropertyComponentPanel) {
            return (PropertyComponentPanel)compObj;
        }
        return null;
    }

    public PropertyComponentPanel getSelectedComponentPanel() {
        return this.getSpecifiedComponentPanel(null);
    }

    protected Hashtable getSelectedComponentPanelEditors() {
        return this.getSelectedComponentPanelEditors(this.getSelectedComponentPanel());
    }

    protected Hashtable getSelectedComponentPanelEditors(PropertyComponentPanel key) {
        Object editors;
        if (key != null && (editors = this.editorsTable.get(key)) instanceof Hashtable) {
            return (Hashtable)editors;
        }
        return null;
    }

    public void loadCurrentConfigSettings() {
        this.loadCurrentConfigSettings(true);
    }

    public void loadCurrentConfigSettings(boolean loadAllFlag) {
        String key = null;
        Object value = null;
        Hashtable editors = loadAllFlag || this.tabbedPaneObj.getTabCount() <= 1 ? this.allEditors : this.getSelectedComponentPanelEditors();
        if (editors == null) {
            return;
        }
        Enumeration e = editors.keys();
        while (e.hasMoreElements()) {
            try {
                key = (String)e.nextElement();
                value = this.getCurrentValue(key);
                PropertyEditor editor = (PropertyEditor)this.allEditors.get(key);
                if (value == null) continue;
                editor.setValue(value);
            }
            catch (ClassCastException ex) {
                System.err.println("BasePropertyInspector.loadCurrentConfigSettings():  Error loading setting (key=\"" + key + "\", value=\"" + value + "\"):  " + ex);
                ex.printStackTrace();
            }
        }
    }

    public void loadDefaultConfigSettings(boolean loadAllFlag) {
        String key = null;
        Object value = null;
        Hashtable editors = loadAllFlag || this.tabbedPaneObj.getTabCount() <= 1 ? this.allEditors : this.getSelectedComponentPanelEditors();
        if (editors == null) {
            return;
        }
        Enumeration e = editors.keys();
        while (e.hasMoreElements()) {
            try {
                key = (String)e.nextElement();
                value = this.getDefaultValue(key);
                PropertyEditor editor = (PropertyEditor)this.allEditors.get(key);
                if (value == null) continue;
                editor.setValue(value);
            }
            catch (ClassCastException ex) {
                System.err.println("BasePropertyInspector.loadDefaultConfigSettings():  Error loading setting (key=\"" + key + "\", value=\"" + value + "\"):  " + ex);
                ex.printStackTrace();
            }
        }
    }

    public String getToolTipText(String key) {
        return null;
    }

    protected void setToolTipText(Component comp, String text) {
        if (comp instanceof JPanel) {
            JPanel panel = (JPanel)comp;
            Component[] components = panel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                this.setToolTipText(components[i], text);
            }
        } else if (comp instanceof JComponent) {
            ((JComponent)comp).setToolTipText(text);
        }
    }

    protected void commitConfigSettings() {
        boolean propertyChangeFlag = false;
        String key = null;
        Object itemValue = null;
        Enumeration e = this.allEditors.keys();
        while (e.hasMoreElements()) {
            try {
                key = (String)e.nextElement();
                PropertyEditor editor = (PropertyEditor)this.allEditors.get(key);
                itemValue = this.currentProps.get(key);
                Object editorValue = BasePropertyInspector.getEditorValue(key, editor, itemValue, this.saveAsTextFlag);
                if (editorValue == null) continue;
                this.setValue(key, editorValue);
                propertyChangeFlag = true;
            }
            catch (Exception ex) {
                System.err.println("BasePropertyInspector.commitConfigSettings():  Error committing setting (key=\"" + key + "\", value=\"" + itemValue + "\"):  " + ex);
                ex.printStackTrace();
            }
        }
        if (propertyChangeFlag) {
            this.firePropertyChange(CHANGE_ALL_PROPSTR, null, null);
        }
    }

    public static Object getEditorValue(String key, PropertyEditor editor, Object itemValue, boolean saveAsTextFlag) {
        Object editorValue = null;
        if (!saveAsTextFlag) {
            editorValue = editor.getValue();
        }
        if (editorValue == null ? (editorValue = editor.getAsText()) == null || itemValue.toString().equals(editorValue) : itemValue.equals(editorValue)) {
            return null;
        }
        return editorValue;
    }

    public void setValue(String key, Object value) {
        this.currentProps.put(key, value);
    }

    public void createPanelActionListeners() {
        this.lowerButtonPanelObj.addOkListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasePropertyInspector.this.commitConfigSettings();
                BasePropertyInspector.this.setVisible(false);
            }
        });
        this.lowerButtonPanelObj.addCancelListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasePropertyInspector.this.setVisible(false);
            }
        });
        this.lowerButtonPanelObj.addResetListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasePropertyInspector.this.loadCurrentConfigSettings(false);
            }
        });
        this.lowerButtonPanelObj.addDefaultListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasePropertyInspector.this.loadDefaultConfigSettings(false);
            }
        });
    }

    public void createDialog(Component parent, String name, String displayText, boolean modalFlag) {
        if (this.dialogObj != null) {
            return;
        }
        this.dialogObj = new IstiDialogPopup(parent, (Object)this, displayText, null, modalFlag);
        if (!this.centerFlag) {
            try {
                Frame frame = JOptionPane.getFrameForComponent(parent);
                if (frame != null) {
                    Dimension parentSize = frame.getSize();
                    this.dialogObj.setLocation(7 + parentSize.width, 2);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.dialogObj.addCloseListener(new IstiDialogPopup.CloseListener(){

            public void dialogClosed(Object evtObj) {
                IstiDialogPopup.CloseListener listenerObj = BasePropertyInspector.this.dialogCloseListenerObj;
                if (listenerObj != null) {
                    listenerObj.dialogClosed(evtObj);
                }
            }
        });
        this.lowerButtonPanelObj.addOkListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasePropertyInspector.this.commitConfigSettings();
                BasePropertyInspector.this.dialogObj.setVisible(false);
            }
        });
        this.lowerButtonPanelObj.addCancelListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasePropertyInspector.this.dialogObj.setVisible(false);
            }
        });
        this.lowerButtonPanelObj.addResetListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasePropertyInspector.this.loadCurrentConfigSettings(false);
            }
        });
        this.lowerButtonPanelObj.addDefaultListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasePropertyInspector.this.loadDefaultConfigSettings(false);
            }
        });
        if (this.initialFocusOnFirstCompFlag && this.firstFocusComponentObj != null) {
            this.dialogObj.setInitialFocusComponent(this.firstFocusComponentObj);
        }
    }

    public void showDialog(boolean waitFlag) {
        this.loadCurrentConfigSettings(true);
        if (this.dialogObj != null) {
            this.dialogObj.pack();
            if (waitFlag) {
                this.dialogObj.showAndWait();
            } else {
                this.dialogObj.show();
            }
        }
    }

    public void showDialog() {
        this.showDialog(false);
    }

    public void showDialog(Component parent, String name, String displayText, boolean modalFlag, boolean waitFlag) {
        if (this.dialogObj == null) {
            this.createDialog(parent, name, displayText, modalFlag);
        }
        if (!this.dialogObj.isVisible()) {
            this.showDialog(waitFlag);
        } else {
            this.dialogObj.requestFocus();
        }
    }

    public void showDialog(Component parent, String name, String displayText, boolean modalFlag) {
        this.showDialog(parent, name, displayText, modalFlag, false);
    }

    public void showDialog(Component parent, String name, String displayText) {
        this.showDialog(parent, name, displayText, true);
    }

    public void closeDialog(boolean commitFlag) {
        if (this.dialogObj != null && this.dialogObj.isVisible()) {
            if (commitFlag) {
                this.commitConfigSettings();
            }
            this.dialogObj.setVisible(false);
        }
    }

    public void closeDialog() {
        this.closeDialog(false);
    }

    public String getCurrentTabName() {
        try {
            int idx = this.tabbedPaneObj.getSelectedIndex();
            if (idx >= 0) {
                return this.tabbedPaneObj.getTitleAt(idx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setSelectedTabIndex(int idxVal) {
        try {
            this.tabbedPaneObj.setSelectedIndex(idxVal);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelectedTabName(String tabNameStr) {
        try {
            int idx = this.tabbedPaneObj.indexOfTab(tabNameStr);
            if (idx >= 0) {
                this.tabbedPaneObj.setSelectedIndex(idx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDialogCloseListenerObj(IstiDialogPopup.CloseListener listenerObj) {
        this.dialogCloseListenerObj = listenerObj;
    }

    public boolean addComponentToTab(String tabNameStr, Component labelObj, Component compObj) {
        PropertyComponentPanel panelObj = this.getSpecifiedComponentPanel(tabNameStr);
        if (panelObj != null) {
            panelObj.addProperty(labelObj, compObj);
            return true;
        }
        return false;
    }

    public boolean addComponentToTab(String tabNameStr, Component compObj) {
        return this.addComponentToTab(tabNameStr, null, compObj);
    }

    protected JButton getOkButton() {
        return this.lowerButtonPanelObj.okButton;
    }

    protected JButton getCancelButton() {
        return this.lowerButtonPanelObj.cancelButton;
    }

    protected JButton getResetButton() {
        return this.lowerButtonPanelObj.resetButton;
    }

    protected JButton getDefaultsButton() {
        return this.lowerButtonPanelObj.defaultsButton;
    }

    public Component getFirstFocusComponentObj() {
        return this.firstFocusComponentObj;
    }

    protected class ConfigLowerButtonPanel
    extends JPanel {
        protected final String okString = UIManager.getString("ColorChooser.okText");
        protected final String cancelString = UIManager.getString("ColorChooser.cancelText");
        protected final String resetString = UIManager.getString("ColorChooser.resetText");
        protected static final String defaultsString = "Defaults";
        protected static final String helpString = "Help";
        protected final JButton okButton = new JButton(this.okString);
        protected final JButton cancelButton = new JButton(this.cancelString);
        protected final JButton resetButton = new JButton(this.resetString);
        protected final JButton defaultsButton = new JButton("Defaults");
        protected final JButton helpButton = new JButton("Help");

        public ConfigLowerButtonPanel() {
            this.setLayout(new FlowLayout(1));
            this.okButton.setActionCommand("OK");
            this.okButton.setToolTipText("Accept changes");
            this.add(this.okButton);
            this.cancelButton.setActionCommand("cancel");
            this.cancelButton.setToolTipText("Cancel changes");
            this.add(this.cancelButton);
            this.resetButton.setToolTipText("Reset the settings above to the starting values");
            this.add(this.resetButton);
            this.defaultsButton.setEnabled(false);
            this.defaultsButton.setToolTipText("Restore the settings above to the original defaults (where available)");
            this.add(this.defaultsButton);
            this.helpButton.setVisible(false);
            this.helpButton.setToolTipText("Show help information for the settings");
            this.add(this.helpButton);
        }

        public void addOkListener(ActionListener l) {
            this.okButton.addActionListener(l);
        }

        public void addCancelListener(ActionListener l) {
            this.cancelButton.addActionListener(l);
        }

        public void addResetListener(ActionListener l) {
            this.resetButton.addActionListener(l);
        }

        public void addDefaultListener(ActionListener l) {
            this.defaultsButton.addActionListener(l);
        }

        public void addHelpListener(ActionListener l) {
            this.helpButton.addActionListener(l);
            this.helpButton.setVisible(l != null);
        }
    }
}

