/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import java.util.Arrays;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static double min(double[] dArray) {
        double d = Double.MAX_VALUE;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, dArray[i]);
        }
        return d;
    }

    public static double max(double[] dArray) {
        double d = Double.MIN_VALUE;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, dArray[i]);
        }
        return d;
    }

    public static double[] trim(double[] dArray, double d, double d2) {
        int n = 0;
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            if (!(dArray[i] >= d) || !(dArray[i] <= d2)) continue;
            dArray2[n++] = dArray[i];
        }
        return ArrayUtils.trim(dArray2, n);
    }

    public static double[] trim(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    public static double[] merge(double[] dArray, double[] dArray2) {
        int n;
        boolean bl = false;
        int n2 = dArray.length;
        int n3 = dArray2.length;
        int n4 = n2 + n3;
        double[] dArray3 = new double[n4];
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            boolean[] blArray = new boolean[]{true, true};
            double[] dArray4 = new double[]{dArray[n], n3 > n ? dArray2[n] : Double.NaN};
            for (int i = 0; i < n5 && (blArray[0] || blArray[1]); ++i) {
                blArray[0] = blArray[0] && dArray3[n] != dArray4[0];
                blArray[1] = blArray[1] && dArray3[n] != dArray4[1];
            }
            if (blArray[0]) {
                dArray3[n5++] = dArray4[0];
            }
            if (!blArray[1] || dArray4[0] == dArray4[1]) continue;
            dArray3[n5++] = dArray4[1];
        }
        for (n = n2; n < n3; ++n) {
            boolean bl2 = true;
            double d = dArray2[n];
            for (int i = 0; i < n5 && bl2; ++i) {
                bl2 = dArray3[n] != d;
            }
            if (!bl2) continue;
            dArray3[n5++] = d;
        }
        double[] dArray5 = new double[n5];
        System.arraycopy(dArray3, 0, dArray5, 0, n5);
        Arrays.sort(dArray5);
        return dArray5;
    }

    public static double[] boundedMerge(double[] dArray, double[] dArray2) {
        double d = Math.max(ArrayUtils.min(dArray), ArrayUtils.min(dArray2));
        double d2 = Math.min(ArrayUtils.max(dArray), ArrayUtils.max(dArray2));
        return ArrayUtils.merge(ArrayUtils.trim(dArray, d, d2), ArrayUtils.trim(dArray2, d, d2));
    }

    public static double[] diff(double[] dArray, boolean bl) {
        int n = dArray.length;
        if (bl) {
            for (int i = 1; i < n; ++i) {
                dArray[i - 1] = dArray[i] - dArray[i - 1];
            }
        } else {
            for (int i = n - 1; i > 0; ++i) {
                dArray[i] = dArray[i] - dArray[i - 1];
            }
        }
        return dArray;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double average(double[] dArray) {
        return ArrayUtils.sum(dArray) / (double)dArray.length;
    }

    public static double dotProduct(double[] dArray, double[] dArray2) throws IllegalArgumentException {
        if (dArray.length != dArray2.length) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Vectors must be the same length to take their dot product.");
            illegalArgumentException.fillInStackTrace();
            throw illegalArgumentException;
        }
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double[] abs(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.abs(dArray[i]);
        }
        return dArray;
    }
}

