/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

public class MathUtils {
    public static double linearInterp(double d, double d2, double d3, double d4, double d5) {
        if (d == d2) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("X1 and X1 were equal. Cannot interpolate these values.");
            illegalArgumentException.fillInStackTrace();
            throw illegalArgumentException;
        }
        return d3 + (d5 - d) / (d2 - d) * (d4 - d3);
    }

    public static double linearExtrap(double d, double d2, double d3, double d4, double d5) {
        if (d == d2) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("X1 and X1 were equal. Cannot extrapolate these values.");
            illegalArgumentException.fillInStackTrace();
            throw illegalArgumentException;
        }
        double d6 = (d4 - d3) / (d2 - d);
        double d7 = d4 - d6 * d2;
        return d6 * d5 + d7;
    }

    public static double precisionFloor(double d, double d2) {
        if (d < 0.0) {
            return -1.0 * MathUtils.precisionCeil(Math.abs(d), d2);
        }
        int n = (int)(d / d2);
        double d3 = d - d2 * (double)n;
        if (d3 == 0.0) {
            return d;
        }
        return d2 * (double)n;
    }

    public static double precisionCeil(double d, double d2) {
        if (d < 0.0) {
            return -1.0 * MathUtils.precisionFloor(Math.abs(d), d2);
        }
        int n = (int)(d / d2);
        double d3 = d - d2 * (double)n;
        if (d3 == 0.0) {
            return d;
        }
        return d2 * (double)(n + 1);
    }
}

