/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DiscreteParameterConstraintAPI;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;

public class ParameterList
implements Serializable {
    protected static final String C = "ParameterList";
    protected static final boolean D = false;
    protected ArrayList params = new ArrayList();
    protected Hashtable constraintNameMap = new Hashtable();

    public void addParameterList(ParameterList list2) throws ParameterException {
        ListIterator it = list2.getParametersIterator();
        while (it.hasNext()) {
            ParameterAPI param = (ParameterAPI)it.next();
            if (this.containsParameter(param)) continue;
            this.addParameter(param);
        }
    }

    public void addParameter(ParameterAPI param) throws ParameterException {
        String S = "ParameterList: addParameter(): ";
        String name = param.getName();
        String constraintName = param.getConstraintName();
        if (this.getIndexOf(name) != -1) {
            throw new ParameterException(S + "A Parameter already exists named " + name);
        }
        this.params.add(param);
        if (constraintName == null || constraintName.equals("") || constraintName.equals(name)) {
            return;
        }
        if (this.constraintNameMap.containsKey(constraintName)) {
            this.params.remove(name);
            throw new ParameterException(S + "A Parameter already exists with this constraint named " + constraintName);
        }
        this.constraintNameMap.put(constraintName, name);
    }

    public String getParameterName(String name) {
        if (this.constraintNameMap.containsKey(name)) {
            return (String)this.constraintNameMap.get(name);
        }
        return name;
    }

    public ParameterAPI getParameter(String name) throws ParameterException {
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index != -1) {
            ParameterAPI param = (ParameterAPI)this.params.get(index);
            return param;
        }
        String S = "ParameterList: getParameter(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    public Object getValue(String name) throws ParameterException {
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index != -1) {
            ParameterAPI param = (ParameterAPI)this.params.get(index);
            Object obj = param.getValue();
            return obj;
        }
        String S = "ParameterList: getValue(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    public void setValue(String name, Object value) throws ParameterException, ConstraintException {
        String S = "ParameterList: setValue(): ";
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index == -1) {
            throw new ParameterException(S + "No parameter exists named " + name);
        }
        ParameterAPI param = (ParameterAPI)this.params.get(index);
        param.setValue(value);
    }

    public String getType(String name) throws ParameterException {
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index != -1) {
            ParameterAPI param = (ParameterAPI)this.params.get(index);
            String str = param.getType();
            return str;
        }
        String S = "ParameterList: getType(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    public boolean containsParameter(ParameterAPI param) {
        String name = param.getName();
        int index = this.getIndexOf(name);
        return index != -1;
    }

    public boolean containsParameter(String paramName) {
        int index = this.getIndexOf(paramName);
        return index != -1;
    }

    public void removeParameter(ParameterAPI param) throws ParameterException {
        String name = param.getName();
        this.removeParameter(name);
    }

    public void removeParameter(String name) throws ParameterException {
        int index = this.getIndexOf(name);
        if (index == -1) {
            String S = "ParameterList: removeParameter(): ";
            throw new ParameterException(S + "No Parameter exist named " + name + ", unable to remove");
        }
        this.params.remove(index);
    }

    public void updateParameter(ParameterAPI param) throws ParameterException {
        String name = param.getName();
        this.removeParameter(name);
        this.addParameter(param);
    }

    public ListIterator getParametersIterator() {
        ArrayList v = new ArrayList();
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            Object obj = this.params.get(i);
            v.add(obj);
        }
        return v.listIterator();
    }

    public void replaceParameter(String parameterName, ParameterAPI param) {
        int index = this.getIndexOf(parameterName = this.getParameterName(parameterName));
        if (index != -1) {
            this.removeParameter(parameterName);
            this.addParameter(param);
        }
    }

    public int compareTo(Object obj) {
        ParameterAPI param1;
        ParameterAPI param2;
        int result = 0;
        if (!(obj instanceof ParameterList)) {
            throw new ClassCastException("ParameterListObject not a ParameterList, unable to compare");
        }
        ParameterList paramList = (ParameterList)obj;
        ListIterator it = paramList.getParametersIterator();
        if (this.size() != paramList.size()) {
            return -1;
        }
        while (it.hasNext() && (result = (param2 = this.getParameter((param1 = (ParameterAPI)it.next()).getName())).compareTo(param1)) == 0) {
        }
        return result;
    }

    public ListIterator getParameterNamesIterator() {
        ArrayList<String> v = new ArrayList<String>();
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            ParameterAPI obj = (ParameterAPI)this.params.get(i);
            v.add(obj.getName());
        }
        return v.listIterator();
    }

    public void clear() {
        this.params.clear();
    }

    public int size() {
        return this.params.size();
    }

    public boolean equals(ParameterList list) {
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator it = this.getParametersIterator();
        while (it.hasNext()) {
            ParameterAPI param1 = (ParameterAPI)it.next();
            if (!list.containsParameter(param1.getName())) {
                return false;
            }
            ParameterAPI param2 = list.getParameter(param1.getName());
            if (!((Object)param1).equals(param2)) {
                return false;
            }
            try {
                if (param1.compareTo(param2) == 0) continue;
                return false;
            }
            catch (ClassCastException ee) {
                return false;
            }
        }
        return true;
    }

    public boolean equalNames(ParameterList list) {
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator it = this.getParametersIterator();
        while (it.hasNext()) {
            ParameterAPI param1 = (ParameterAPI)it.next();
            if (list.containsParameter(param1.getName())) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        String S = "ParameterList: clone(): ";
        ParameterList list = new ParameterList();
        if (this.size() < 1) {
            return list;
        }
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            ParameterAPI param = (ParameterAPI)this.params.get(i);
            list.addParameter((ParameterAPI)param.clone());
        }
        return list;
    }

    public String toString() {
        String S = "ParameterList: toString():";
        StringBuffer b = new StringBuffer();
        boolean first = true;
        ArrayList<String> v = new ArrayList<String>();
        int vectorSize = this.params.size();
        for (int i = 0; i < vectorSize; ++i) {
            ParameterAPI param = (ParameterAPI)this.params.get(i);
            v.add(param.getName());
        }
        Iterator it = v.iterator();
        while (it.hasNext()) {
            int size;
            String key = (String)it.next();
            int index = this.getIndexOf(key);
            ParameterAPI param = (ParameterAPI)this.params.get(index);
            ParameterConstraintAPI constraint = param.getConstraint();
            boolean ok = true;
            if (constraint instanceof DiscreteParameterConstraintAPI && (size = ((DiscreteParameterConstraintAPI)constraint).size()) < 2) {
                ok = false;
            }
            if (!ok) continue;
            String val = "N/A";
            Object obj = param.getValue();
            if (obj != null) {
                val = obj.toString();
            }
            if (first) {
                first = false;
                b.append(key + " = " + val);
                continue;
            }
            b.append(", " + key + " = " + val);
        }
        return b.toString();
    }

    public String getParameterListMetadataString() {
        int size = this.params.size();
        StringBuffer metaData = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < size; ++i) {
            ParameterAPI tempParam = (ParameterAPI)this.params.get(i);
            if (first) {
                metaData.append(tempParam.getMetadataString());
                first = false;
                continue;
            }
            metaData.append("; " + tempParam.getMetadataString());
        }
        return metaData.toString();
    }

    private int getIndexOf(String key) {
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            ParameterAPI param = (ParameterAPI)this.params.get(i);
            if (!key.equalsIgnoreCase(param.getName())) continue;
            return i;
        }
        return -1;
    }
}

