/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSetCalc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.calc.GaussianDistCalc;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.util.FileUtils;
import org.opensha.util.SystemPropertiesUtils;

public class IM_EventSetCalcTest {
    private String dirName;
    private float[] rupRates;
    private float[] meanVals;
    private float[] sigVals;
    private ArbitrarilyDiscretizedFunc averagedFunction;
    private boolean first = true;
    private int numIMRsToAverageTheCurve = 0;
    double[] imlVals = new double[]{0.005, 0.007, 0.0098, 0.0137, 0.0192, 0.0269, 0.0376, 0.0527, 0.0738, 0.103, 0.145, 0.203, 0.284, 0.397, 0.556, 0.778, 1.09, 1.52, 2.13};

    public IM_EventSetCalcTest(String dirName) {
        this.dirName = dirName;
    }

    private void readFile(String fileName) throws FileNotFoundException, IOException {
        StringTokenizer st;
        int i;
        ArrayList fileLines = FileUtils.loadFile(fileName);
        int numEntries = fileLines.size();
        if (this.first) {
            this.rupRates = new float[numEntries];
            this.meanVals = new float[numEntries];
            this.sigVals = new float[numEntries];
        }
        for (i = 0; i < numEntries; ++i) {
            st = new StringTokenizer((String)fileLines.get(i));
            st.nextToken();
            st.nextToken();
            this.meanVals[i] = Float.parseFloat(st.nextToken().trim());
            this.sigVals[i] = Float.parseFloat(st.nextToken().trim());
        }
        fileLines = null;
        if (this.first) {
            fileLines = FileUtils.loadFile(this.dirName + SystemPropertiesUtils.getSystemFileSeparator() + "src_rup_metadata.txt");
            for (i = 0; i < numEntries; ++i) {
                st = new StringTokenizer((String)fileLines.get(i));
                st.nextToken();
                st.nextToken();
                this.rupRates[i] = Float.parseFloat(st.nextToken().trim());
            }
        }
        this.first = false;
        fileLines = null;
    }

    private void getAverageAnnualizedRates() {
        this.initArbFunction();
        try {
            File file = new File(this.dirName);
            String absPath = file.getAbsolutePath() + SystemPropertiesUtils.getSystemFileSeparator();
            File[] files = file.listFiles();
            int numFiles = files.length;
            for (int i = 0; i < numFiles; ++i) {
                String fileName = files[i].getName();
                if (!fileName.endsWith(".txt") || fileName.contains("rup")) continue;
                ++this.numIMRsToAverageTheCurve;
                this.readFile(absPath + fileName);
                this.createArbFuncForEachIML();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.averageArbFunction();
        System.out.println(this.averagedFunction.toString());
    }

    private void initArbFunction() {
        this.averagedFunction = new ArbitrarilyDiscretizedFunc();
        int numIMLs = this.imlVals.length;
        for (int i = 0; i < numIMLs; ++i) {
            this.averagedFunction.set(this.imlVals[i], 0.0);
        }
    }

    private void averageArbFunction() {
        int numIMLs = this.imlVals.length;
        for (int i = 0; i < numIMLs; ++i) {
            this.averagedFunction.set(i, this.averagedFunction.getY(i) / (double)this.numIMRsToAverageTheCurve);
        }
    }

    private void createArbFuncForEachIML() {
        int numIMLs = this.imlVals.length;
        int numMeanVals = this.meanVals.length;
        for (int i = 0; i < numIMLs; ++i) {
            double imlExceedRate = 0.0;
            for (int j = 0; j < numMeanVals; ++j) {
                double stRndVar = (Math.log(this.imlVals[i]) - (double)this.meanVals[j]) / (double)this.sigVals[j];
                imlExceedRate += GaussianDistCalc.getExceedProb(stRndVar, 1, 3.0) * (double)this.rupRates[j];
            }
            this.averagedFunction.set(this.imlVals[i], this.averagedFunction.getY(i) + imlExceedRate);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage :\n\tjava -jar [jarfileName] [inputDirectory]\n\n");
            System.out.println("jarfileName : Name of the executable jar file, by default it is IM_EventSetCalcTest.jar");
            System.out.println("input directory name : Name of the input directory where all the data files are located for each AttennuationRelationship. This test application will read those files and then generate the averaged annualized rates curves.");
            System.exit(0);
        }
        IM_EventSetCalcTest imEventSetCalcTest = new IM_EventSetCalcTest(args[0]);
        imEventSetCalcTest.getAverageAnnualizedRates();
    }
}

