/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.messaging.saaj.util.StringManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.MailcapCommandMap;
import javax.mail.Header;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentPartImpl
extends AttachmentPart {
    protected static Log log = LogFactory.getLog((String)"javax.xml.messaging.saaj.soap");
    protected static StringManager sm = StringManager.getManager("com.sun.xml.messaging.saaj.soap");
    MimeHeaders headers = new MimeHeaders();
    private DataHandler dataHandler;

    public int getSize() throws SOAPException {
        if (this.dataHandler == null) {
            return 0;
        }
        ByteOutputStream bout = new ByteOutputStream();
        try {
            this.dataHandler.writeTo((OutputStream)bout);
        }
        catch (IOException ex) {
            log.error((Object)sm.getString("SAAJ0501.soap.data.handler.err", new String[]{ex.getLocalizedMessage()}));
            throw new SOAPExceptionImpl("Data handler error: " + ex);
        }
        byte[] bytes = bout.getBytes();
        if (bytes != null) {
            return bytes.length;
        }
        return -1;
    }

    public void clearContent() {
        this.dataHandler = null;
    }

    public Object getContent() throws SOAPException {
        try {
            return this.getDataHandler().getContent();
        }
        catch (IOException ex) {
            throw new SOAPExceptionImpl(ex);
        }
        catch (SOAPException ex) {
            throw ex;
        }
    }

    public void setContent(Object object, String contentType) throws IllegalArgumentException {
        DataHandler dh = new DataHandler(object, contentType);
        this.setDataHandler(dh);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.dataHandler == null) {
            log.error((Object)sm.getString("SAAJ0502.soap.no.handler.for.attachment"));
            throw new SOAPExceptionImpl("No data handler associated with this attachment");
        }
        return this.dataHandler;
    }

    public void setDataHandler(DataHandler dataHandler) throws IllegalArgumentException {
        if (dataHandler == null) {
            log.error((Object)sm.getString("SAAJ0503.soap.no.null.to.dataHandler"));
            throw new IllegalArgumentException("Null dataHandler argument to setDataHandler");
        }
        this.dataHandler = dataHandler;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("SAAJ0580.soap.set.Content-Type", new String[]{dataHandler.getContentType()}));
        }
        this.setMimeHeader("Content-Type", dataHandler.getContentType());
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.headers.removeHeader(header);
    }

    public String[] getMimeHeader(String name) {
        return this.headers.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.headers.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.headers.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.headers.getNonMatchingHeaders(names);
    }

    boolean hasAllHeaders(MimeHeaders hdrs) {
        Iterator i = hdrs.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader hdr = (MimeHeader)i.next();
            String[] values = this.headers.getHeader(hdr.getName());
            boolean found = false;
            if (values != null) {
                int j = 0;
                while (j < values.length) {
                    if (hdr.getValue().equalsIgnoreCase(values[j])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    MimeBodyPart getMimePart() throws SOAPException {
        try {
            MimeBodyPart envelope = new MimeBodyPart();
            envelope.setDataHandler(this.dataHandler);
            AttachmentPartImpl.copyMimeHeaders(this.headers, envelope);
            return envelope;
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("SAAJ0504.soap.cannot.externalize.attachment"));
            throw new SOAPExceptionImpl("Unable to externalize attachment", ex);
        }
    }

    public static void copyMimeHeaders(MimeHeaders headers, MimeBodyPart mbp) throws SOAPException {
        Iterator i = headers.getAllHeaders();
        while (i.hasNext()) {
            try {
                MimeHeader mh = (MimeHeader)i.next();
                mbp.addHeader(mh.getName(), mh.getValue());
            }
            catch (Exception ex) {
                log.error((Object)sm.getString("SAAJ0505.soap.cannot.copy.mime.hdr"));
                throw new SOAPExceptionImpl("Unable to copy MIME header", ex);
            }
        }
    }

    public static void copyMimeHeaders(MimeBodyPart mbp, AttachmentPartImpl ap) throws SOAPException {
        try {
            Enumeration e = mbp.getNonMatchingHeaders(new String[]{"Content-Type"});
            while (e.hasMoreElements()) {
                Header hdr = (Header)e.nextElement();
                ap.addMimeHeader(hdr.getName(), hdr.getValue());
            }
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("SAAJ0506.soap.cannot.copy.mime.hdrs.into.attachment"));
            throw new SOAPExceptionImpl("Unable to copy MIME headers into attachment", ex);
        }
    }

    static {
        try {
            CommandMap map = CommandMap.getDefaultCommandMap();
            if (!(map instanceof MailcapCommandMap)) {
                throw new SOAPExceptionImpl("Default CommandMap is not a MailcapCommandMap");
            }
            MailcapCommandMap mailMap = (MailcapCommandMap)map;
            String hndlrStr = ";;x-java-content-handler=";
            mailMap.addMailcap("text/xml" + hndlrStr + "com.sun.xml.messaging.saaj.soap.XmlDataContentHandler");
            mailMap.addMailcap("image/jpeg" + hndlrStr + "com.sun.xml.messaging.saaj.soap.JpegDataContentHandler");
            mailMap.addMailcap("text/plain" + hndlrStr + "com.sun.mail.handlers.text_plain");
        }
        catch (Throwable t) {
            log.fatal((Object)sm.getString("SAAJ0508.soap.cannot.register.handlers"), t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t.getLocalizedMessage());
        }
    }
}

