/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.SOAPPartImpl;
import com.sun.xml.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.messaging.saaj.util.RejectDoctypeSaxFilter;
import com.sun.xml.messaging.saaj.util.StringManager;
import com.sun.xml.messaging.saaj.util.transform.EfficientStreamingTransformer;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class EnvelopeFactory {
    protected static Log log = LogFactory.getLog((String)"javax.xml.messaging.saaj.soap");
    protected static StringManager sm = StringManager.getManager("com.sun.xml.messaging.saaj.soap");

    public static Envelope createEnvelope(Source src, SOAPPartImpl soapPart) throws SOAPException {
        if (src instanceof StreamSource) {
            RejectDoctypeSaxFilter rejectFilter;
            InputSource is = SAXSource.sourceToInputSource(src);
            try {
                rejectFilter = new RejectDoctypeSaxFilter();
            }
            catch (Exception ex) {
                log.error((Object)sm.getString("SAAJ0510.soap.cannot.create.envelope"));
                throw new SOAPExceptionImpl("Unable to create envelope from given source: ", ex);
            }
            src = new SAXSource(rejectFilter, is);
        }
        try {
            Transformer transformer = EfficientStreamingTransformer.newTransformer();
            DOMResult result = new DOMResult((Node)((Object)soapPart));
            transformer.transform(src, result);
            return (Envelope)soapPart.getEnvelope();
        }
        catch (Exception ex) {
            if (ex instanceof SOAPVersionMismatchException) {
                throw (SOAPVersionMismatchException)((Object)ex);
            }
            log.error((Object)sm.getString("SAAJ0511.soap.cannot.create.envelope"));
            throw new SOAPExceptionImpl("Unable to create envelope from given source: ", ex);
        }
    }
}

