/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.messaging.saaj.soap.SOAPIOException;
import com.sun.xml.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.messaging.saaj.soap.impl.EnvelopeImpl;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.messaging.saaj.util.JAXMStreamSource;
import com.sun.xml.messaging.saaj.util.MimeHeadersUtil;
import com.sun.xml.messaging.saaj.util.StringManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class SOAPPartImpl
extends SOAPPart
implements SOAPDocument {
    protected static Log log = LogFactory.getLog((String)"javax.xml.messaging.saaj.soap");
    protected static StringManager sm = StringManager.getManager("com.sun.xml.messaging.saaj.soap");
    protected MimeHeaders headers;
    protected Envelope envelope;
    protected Source source;
    protected SOAPDocumentImpl document = new SOAPDocumentImpl(this);

    protected SOAPPartImpl() {
        this.headers = new MimeHeaders();
        this.headers.setHeader("Content-Type", this.getContentType());
    }

    protected abstract String getContentType();

    protected abstract Envelope createEnvelopeFromSource() throws SOAPException;

    protected abstract Envelope createEmptyEnvelope(String var1) throws SOAPException;

    protected abstract SOAPPartImpl duplicateType();

    public SOAPEnvelope getEnvelope() throws SOAPException {
        this.lookForEnvelope();
        if (this.envelope != null) {
            if (this.source != null) {
                this.document.removeChild((Node)((Object)this.envelope));
                this.envelope = this.createEnvelopeFromSource();
            }
            return this.envelope;
        }
        if (this.source != null) {
            this.envelope = this.createEnvelopeFromSource();
            this.source = null;
        } else {
            this.envelope = this.createEmptyEnvelope(null);
            this.document.insertBefore((Node)((Object)this.envelope), null);
        }
        return this.envelope;
    }

    protected void lookForEnvelope() throws SOAPException {
        Element envelopeChildElement = this.document.doGetDocumentElement();
        if (envelopeChildElement != null && !(envelopeChildElement instanceof Envelope)) {
            if (!(envelopeChildElement instanceof ElementImpl)) {
                log.error((Object)sm.getString("SAAJ0512.soap.incorrect.factory.used"));
                throw new SOAPExceptionImpl("Unable to create envelope: incorrect factory used during tree construction");
            }
            ElementImpl soapElement = (ElementImpl)((Object)envelopeChildElement);
            if (soapElement.getLocalName().equalsIgnoreCase("Envelope") && !soapElement.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && !soapElement.getNamespaceURI().equals("http://www.w3.org/2002/06/soap-envelope")) {
                log.error((Object)sm.getString("SAAJ0513.soap.unknown.ns"));
                throw new SOAPVersionMismatchException("Unable to create envelope from given source because the namespace was not recognized");
            }
            log.error((Object)sm.getString("SAAJ0514.soap.root.elem.not.named.envelope"));
            throw new SOAPExceptionImpl("Unable to create envelope from given source because the root element is not named \"Envelope\"");
        }
        this.envelope = (EnvelopeImpl)((Object)envelopeChildElement);
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.headers.removeHeader(header);
    }

    public String[] getMimeHeader(String name) {
        return this.headers.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.headers.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.headers.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.headers.getNonMatchingHeaders(names);
    }

    public Source getContent() throws SOAPException {
        if (this.source != null) {
            return this.source;
        }
        return ((Envelope)this.getEnvelope()).getContent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setContent(Source source) throws SOAPException {
        try {
            if (!(source instanceof StreamSource)) {
                this.source = source;
                return;
            }
            InputStream is = ((StreamSource)source).getInputStream();
            Reader rdr = ((StreamSource)source).getReader();
            if (is != null) {
                this.source = new JAXMStreamSource(is);
                return;
            }
            if (rdr != null) {
                this.source = new JAXMStreamSource(rdr);
                return;
            }
            log.error((Object)sm.getString("SAAJ0544.soap.no.valid.reader.for.src"));
            throw new SOAPExceptionImpl("Source does not have a valid Reader or InputStream");
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("SAAJ0545.soap.cannot.set.src.for.part"));
            throw new SOAPExceptionImpl("Error setting the source for SOAPPart: " + ex.getMessage());
        }
    }

    public ByteInputStream getContentAsStream() throws IOException {
        InputStream is;
        if (this.source != null && this.source instanceof StreamSource && (is = ((StreamSource)this.source).getInputStream()) != null) {
            if (!(is instanceof ByteInputStream)) {
                log.error((Object)sm.getString("SAAJ0546.soap.stream.incorrect.type"));
                throw new IOException("Internal error: stream not of the right type");
            }
            return (ByteInputStream)is;
        }
        ByteOutputStream b = new ByteOutputStream();
        Envelope env = null;
        try {
            env = (Envelope)this.getEnvelope();
            env.output(b);
        }
        catch (SOAPException soapException) {
            log.error((Object)sm.getString("SAAJ0547.soap.cannot.externalize"));
            throw new SOAPIOException("SOAP exception while trying to externalize: ", soapException);
        }
        return new ByteInputStream(b.getBytes(), b.getCount());
    }

    MimeBodyPart getMimePart() throws SOAPException {
        try {
            MimeBodyPart headerEnvelope = new MimeBodyPart();
            headerEnvelope.setDataHandler(this.getDataHandler());
            AttachmentPartImpl.copyMimeHeaders(this.headers, headerEnvelope);
            return headerEnvelope;
        }
        catch (SOAPException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("SAAJ0548.soap.cannot.externalize.hdr"));
            throw new SOAPExceptionImpl("Unable to externalize header", ex);
        }
    }

    MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    DataHandler getDataHandler() {
        DataSource ds = new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                throw new IOException("Illegal Operation");
            }

            public String getContentType() {
                return this.getContentType();
            }

            public String getName() {
                return SOAPPartImpl.this.getContentId();
            }

            public InputStream getInputStream() throws IOException {
                return SOAPPartImpl.this.getContentAsStream();
            }
        };
        return new DataHandler(ds);
    }

    public SOAPDocumentImpl getDocument() {
        return this.document;
    }

    public SOAPPartImpl getSOAPPart() {
        return this;
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    protected void doGetDocumentElement() {
        try {
            this.lookForEnvelope();
        }
        catch (SOAPException e) {}
    }

    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.document.importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.document.appendChild(newChild);
    }

    public Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    protected SOAPPartImpl doCloneNode() {
        SOAPPartImpl newSoapPart = this.duplicateType();
        newSoapPart.headers = MimeHeadersUtil.copy(this.headers);
        newSoapPart.source = this.source;
        return newSoapPart;
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public NodeList getChildNodes() {
        return this.document.getChildNodes();
    }

    public Node getFirstChild() {
        return this.document.getFirstChild();
    }

    public Node getLastChild() {
        return this.document.getLastChild();
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public Node getNextSibling() {
        return this.document.getNextSibling();
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public short getNodeType() {
        return this.document.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public Node getParentNode() {
        return this.document.getParentNode();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    public Node insertBefore(Node arg0, Node arg1) throws DOMException {
        return this.document.insertBefore(arg0, arg1);
    }

    public boolean isSupported(String arg0, String arg1) {
        return this.document.isSupported(arg0, arg1);
    }

    public void normalize() {
        this.document.normalize();
    }

    public Node removeChild(Node arg0) throws DOMException {
        return this.document.removeChild(arg0);
    }

    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        return this.document.replaceChild(arg0, arg1);
    }

    public void setNodeValue(String arg0) throws DOMException {
        this.document.setNodeValue(arg0);
    }

    public void setPrefix(String arg0) throws DOMException {
        this.document.setPrefix(arg0);
    }
}

