/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.impl;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.messaging.saaj.soap.impl.ElementFactory;
import com.sun.xml.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.messaging.saaj.soap.impl.FaultImpl;
import com.sun.xml.messaging.saaj.soap.name.NameImpl;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BodyImpl
extends ElementImpl
implements SOAPBody {
    private SOAPFault fault;

    protected BodyImpl(SOAPDocumentImpl ownerDoc, NameImpl bodyName) {
        super(ownerDoc, bodyName);
    }

    protected abstract NameImpl getFaultName(String var1);

    protected abstract boolean isFault(SOAPElement var1);

    protected abstract SOAPBodyElement createBodyElement(Name var1);

    protected abstract SOAPFault createFaultElement();

    public SOAPFault addFault() throws SOAPException {
        if (this.hasFault()) {
            ElementImpl.log.error((Object)ElementImpl.sm.getString("SAAJ0110.impl.fault.already.exists"));
            throw new SOAPExceptionImpl("Error: Fault already exists");
        }
        this.fault = this.createFaultElement();
        this.addNode((Node)this.fault);
        this.fault.setFaultCode((Name)NameImpl.create("Server", null, "http://schemas.xmlsoap.org/soap/envelope/"));
        this.fault.setFaultString("Fault string, and possibly fault code, not set");
        return this.fault;
    }

    public SOAPFault addFault(Name faultCode, String faultString, Locale locale) throws SOAPException {
        SOAPFault fault = this.addFault();
        fault.setFaultCode(faultCode);
        fault.setFaultString(faultString, locale);
        return fault;
    }

    public SOAPFault addFault(Name faultCode, String faultString) throws SOAPException {
        SOAPFault fault = this.addFault();
        fault.setFaultCode(faultCode);
        fault.setFaultString(faultString);
        return fault;
    }

    void initializeFault() {
        FaultImpl flt = (FaultImpl)this.findFault();
        this.fault = flt;
    }

    protected SOAPElement findFault() {
        Iterator eachChild = this.getChildElementNodes();
        while (eachChild.hasNext()) {
            SOAPElement child = (SOAPElement)eachChild.next();
            if (!this.isFault(child)) continue;
            return child;
        }
        return null;
    }

    public boolean hasFault() {
        this.initializeFault();
        return this.fault != null;
    }

    public SOAPFault getFault() {
        if (this.hasFault()) {
            return this.fault;
        }
        return null;
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        SOAPBodyElement newBodyElement = (SOAPBodyElement)ElementFactory.createNamedElement(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), name.getLocalName(), name.getPrefix(), name.getURI());
        if (newBodyElement == null) {
            newBodyElement = this.createBodyElement(name);
        }
        this.addNode((Node)newBodyElement);
        return newBodyElement;
    }

    public void setParentElement(SOAPElement element) throws SOAPException {
        if (!(element instanceof SOAPEnvelope)) {
            ElementImpl.log.error((Object)ElementImpl.sm.getString("SAAJ0111.impl.body.parent.must.be.envelope"));
            throw new IllegalArgumentException("Parent of SOAPBody has to be a SOAPEnvelope");
        }
        super.setParentElement(element);
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        return this.addBodyElement(name);
    }

    public SOAPBodyElement addDocument(Document document) throws SOAPException {
        DocumentFragment docFrag = document.createDocumentFragment();
        Element rootElement = document.getDocumentElement();
        docFrag.appendChild(rootElement);
        Document ownerDoc = this.getOwnerDocument();
        Node replacingNode = ownerDoc.importNode(docFrag, true);
        this.addNode(replacingNode);
        Iterator i = this.getChildElements(NameImpl.copyElementName(rootElement));
        if (i.hasNext()) {
            return (SOAPBodyElement)i.next();
        }
        return null;
    }

    protected SOAPElement convertToSoapElement(Element element) {
        if (element instanceof SOAPBodyElement) {
            return (SOAPElement)element;
        }
        return ElementImpl.replaceElementWithSOAPElement(element, (ElementImpl)this.createBodyElement(NameImpl.copyElementName(element)));
    }
}

