/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.util;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.util.StringManager;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class RejectDoctypeSaxFilter
extends XMLFilterImpl
implements XMLReader,
LexicalHandler {
    protected static Log log = LogFactory.getLog((String)"javax.xml.messaging.saaj.soap");
    protected static StringManager sm = StringManager.getManager("com.sun.xml.messaging.saaj.util");
    static final String LEXICAL_HANDLER_PROP = "http://xml.org/sax/properties/lexical-handler";
    private LexicalHandler lexicalHandler;

    public RejectDoctypeSaxFilter() throws SOAPException {
        XMLReader xmlReader;
        SAXParser saxParser;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            saxParser = spf.newSAXParser();
        }
        catch (Exception e) {
            log.error((Object)sm.getString("SAAJ0601.util.newSAXParser.exception"));
            throw new SOAPExceptionImpl("Couldn't get a SAX parser while constructing a RejectDoctypeSaxFilter", e);
        }
        try {
            xmlReader = saxParser.getXMLReader();
        }
        catch (Exception e) {
            log.error((Object)sm.getString("SAAJ0602.util.getXMLReader.exception"));
            throw new SOAPExceptionImpl("Couldn't get an XMLReader while constructing a RejectDoctypeSaxFilter", e);
        }
        try {
            xmlReader.setProperty(LEXICAL_HANDLER_PROP, this);
        }
        catch (Exception e) {
            log.error((Object)sm.getString("SAAJ0603.util.setProperty.exception"));
            throw new SOAPExceptionImpl("Couldn't set the lexical handler property while constructing a RejectDoctypeSaxFilter", e);
        }
        this.setParent(xmlReader);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROP.equals(name)) {
            this.lexicalHandler = (LexicalHandler)value;
        } else {
            super.setProperty(name, value);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        throw new SAXException("Document Type Declaration is not allowed");
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }
}

