/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.RepaintManager;
import javax.swing.Timer;
import org.jpedal.MultiDisplay;
import org.jpedal.PageOffsets;
import org.jpedal.PdfPanel;
import org.jpedal.SingleDisplay;
import org.jpedal.color.ColorSpaces;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfHeightTable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.gui.Hotspots;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.PdfReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.rendering.DefaultAcroRenderer;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.PdfPageObject;
import org.jpedal.objects.structuredtext.MarkedContentGenerator;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.w3c.dom.Document;

public class PdfDecoder
extends PdfPanel
implements Printable,
Pageable {
    private static final long serialVersionUID = 1107156907326450528L;
    public static final String version = "3.50b52";
    public static final boolean optimiseType3Rendering = false;
    boolean isOptimisedImage = false;
    File tempURLFile;
    boolean downloadCreated = false;
    JFrame download = null;
    JPanel p;
    JProgressBar pb;
    JLabel downloadMessage;
    JLabel downloadFile;
    JButton saveLocal;
    int downloadCount = 0;
    boolean oldSetup = false;
    boolean useARGBFix = true;
    boolean docIsLandscaped = false;
    boolean printOnlyVisible = false;
    private Rectangle clipVr = null;
    private int duplexGapEven = 0;
    private int duplexGapOdd = 0;
    private boolean isPDf = false;
    private boolean isMultiPageTiff = false;
    private Map formKids = new HashMap();
    private final Map overlayType = new HashMap();
    private final Map overlayColors = new HashMap();
    private final Map overlayObj = new HashMap();
    private final Map overlayTypeG = new HashMap();
    private final Map overlayColorsG = new HashMap();
    private final Map overlayObjG = new HashMap();
    private Map fdfData = null;
    private boolean isXFA = false;
    private Javascript javascript = null;
    ImageHandler customImageHandler = null;
    PdfObjectReader currentPdfFile;
    private static boolean debugFonts = false;
    private PdfAnnots printAnnots = null;
    private PageLookup pageLookup = new PageLookup();
    private boolean isBackgroundDecoding = false;
    private OutlineData outlineData = null;
    private Object outlineObject = null;
    private String XMLObject;
    private final MarkedContentGenerator content = new MarkedContentGenerator();
    private PdfImageData pdfImages = new PdfImageData();
    private PdfImageData pdfBackgroundImages = new PdfImageData();
    private PdfData pdfData;
    private PdfData pdfBackgroundData;
    public static PdfHeightTable currentHeightLookupData = null;
    public static boolean isRunningOnMac = false;
    public static boolean isRunningOnWindows = false;
    public static boolean isRunningOnLinux = false;
    public static boolean clipOnMac = false;
    public static boolean debugPrint = false;
    private boolean hasViewListener = false;
    private RefreshLayout viewListener = new RefreshLayout();
    private boolean oddPagesOnly = false;
    private boolean evenPagesOnly = false;
    private boolean pagesPrintedInReverse = false;
    private boolean stopPrinting = false;
    private String pdfVersion = "";
    private int lastWidth;
    private int lastPage;
    public static boolean isDraft = true;
    private boolean useForms = true;
    private Graphics2D g2 = null;
    private boolean hasEmbeddedFonts = false;
    private String fontsInFile = "";
    public static int dpi = 72;
    public static boolean embedWidthData = false;
    private boolean hasOutline = false;
    private int start = 0;
    private int end = -1;
    public static final boolean inDemo = false;
    public static float multiplyer = 1.0f;
    public static boolean hires = false;
    private static int GLOBAL_IMAGE_UPSCALE = 1;
    private PdfStreamDecoder currentPrintDecoder = null;
    private DynamicVectorRenderer printRender = null;
    private int lastPrintedPage = -1;
    public static final int TEXT = 1;
    public static final int RAWIMAGES = 2;
    public static final int FINALIMAGES = 4;
    protected static final int PAGEDATA = 8;
    public static final int RAWCOMMANDS = 16;
    public static final int CLIPPEDIMAGES = 32;
    public static final int TEXTCOLOR = 64;
    public static final int CMYKIMAGES = 128;
    public static final int XFORMMETADATA = 256;
    public static final int COLOR = 512;
    public static final int RENDERTEXT = 1;
    public static final int RENDERIMAGES = 2;
    private byte[][] annotList;
    private int annotPage = -1;
    private boolean isForm = false;
    private static int extractionMode = 7;
    protected static int renderMode = 7;
    private PdfStreamDecoder current;
    Map pagesReferences = new Hashtable();
    private Map pagesRead = new HashMap();
    PdfObject globalResources;
    public static boolean enforceFontSubstitution = false;
    private boolean showImageable = false;
    public static String defaultFont = null;
    private Map pageFormats = new Hashtable();
    private static final String separator = System.getProperty("file.separator");
    private static boolean isXMLExtraction = true;
    private boolean includeImages;
    private StatusBar statusBar = null;
    public static boolean use13jPEGConversion = false;
    private boolean usePageScaling = false;
    boolean useHiResImageForDisplay = false;
    private boolean operationSuccessful = true;
    private String pageErrorMessages = "";
    String filename;
    private ObjectStore backgroundObjectStoreRef = new ObjectStore();
    private SetOfIntegerSyntax range;
    private int[] listOfPages;
    private static final boolean flattenDebug = false;
    public static final int TEXTGLYPHPRINT = 1;
    public static final int NOTEXTPRINT = 0;
    public static final int TEXTSTRINGPRINT = 2;
    private int lastPageDecoded = -1;
    private boolean isCustomPrinting = false;
    public static final int SUBSTITUTE_FONT_USING_FILE_NAME = 1;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME = 2;
    public static final int SUBSTITUTE_FONT_USING_FAMILY_NAME = 3;
    public static final int SUBSTITUTE_FONT_USING_FULL_FONT_NAME = 4;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME_USE_FAMILY_NAME_IF_DUPLICATES = 5;
    private static int fontSubstitutionMode = 1;
    ObjectStore objectPrintStoreRef = new ObjectStore();
    public static final int BORDER_SHOW = 1;
    public static final int BORDER_HIDE = 0;
    public static int CURRENT_BORDER_STYLE = 1;
    public static boolean showErrorMessages;
    public static boolean useFullSizeImage;
    public static int samplingUsed;
    private boolean isOpen = false;
    private int textPrint = 0;
    private int minimumCacheSize = -1;
    String decodeStatus = "";
    private int currentPrintPage = 0;
    private boolean imagesProcessedFully;
    private Object customSwingHandle;
    private Object userExpressionEngine;
    private boolean generateGlyphOnRender;
    private boolean thumbnailsBeingDrawn;
    private float oldScaling = -1.0f;
    private boolean useJavascript = true;
    private boolean centerOnScaling = true;
    public static boolean extAtBestQuality;
    private int pageMode = 1;

    public int getPageFromObjectRef(String string) {
        return this.pageLookup.convertObjectToPageNumber(string);
    }

    public void setBorderStyle(int n) {
        CURRENT_BORDER_STYLE = n;
    }

    public int getBorderStyle() {
        return CURRENT_BORDER_STYLE;
    }

    protected void setMultiPageOffsets(int[] nArray, int[] nArray2) {
        if (this.formsAvailable && this.formRenderer != null) {
            this.formRenderer.getCompData().setPageDisplacements(nArray, nArray2);
        }
    }

    public void setPrintIndent(int n, int n2) {
        this.duplexGapOdd = n;
        this.duplexGapEven = n2;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public Document getMarkedContent() {
        return this.content.getMarkedContentTree(this.currentPdfFile, this, this.pageLookup);
    }

    public void setPageData(PdfPageData pdfPageData) {
        this.pageData = pdfPageData;
    }

    public void setAlternativeOutlines(Rectangle[] rectangleArray, String string) {
        this.alternateOutlines = rectangleArray;
        this.altName = string;
        this.repaint();
    }

    public void flushAdditionalPages() {
        this.pages.clearAdditionalPages();
        this.xOffset = 0;
        this.additionalPageCount = 0;
    }

    public void addAdditionalPage(DynamicVectorRenderer dynamicVectorRenderer, int n, int n2) {
        this.pages.addAdditionalPage(dynamicVectorRenderer, n, n2);
        if (this.additionalPageCount == 0) {
            this.lastWidth = this.xOffset + n2;
            this.xOffset += n;
        } else {
            this.xOffset += n;
            this.lastWidth += this.lastPage;
        }
        ++this.additionalPageCount;
        this.lastPage = n;
        this.updateUI();
    }

    public int getXDisplacement() {
        return this.lastWidth;
    }

    public int getAdditionalPageCount() {
        return this.additionalPageCount;
    }

    public void updatePageNumberDisplayed(int n) {
        if (n != -1 && this.customSwingHandle != null) {
            ((GUIFactory)this.customSwingHandle).setPage(n);
        }
    }

    public int getlastPageDecoded() {
        return this.lastPageDecoded;
    }

    public void setlastPageDecoded(int n) {
        this.lastPageDecoded = n;
    }

    public void setSubstitutedFontAliases(String string, String[] stringArray) {
        if (stringArray != null) {
            String string2 = string.toLowerCase();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray[i].toLowerCase();
                if (string3.equals(string2)) continue;
                FontMappings.fontSubstitutionAliasTable.put(string3, string2);
            }
        }
    }

    private String addFonts(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.endsWith("/") & !string3.endsWith("\\")) {
                string3 = string3 + separator;
            }
            PdfDecoder.addTTDir(string3, string2);
        }
        return string2;
    }

    public void resetViewableArea() {
        if (this.viewableArea != null) {
            this.viewableArea = null;
            this.setPageRotation(this.displayRotation);
            this.repaint();
        }
    }

    public AffineTransform setViewableArea(Rectangle rectangle) throws PdfException {
        if (rectangle != null) {
            double d = rectangle.getX();
            double d2 = rectangle.getY();
            double d3 = rectangle.getWidth();
            double d4 = rectangle.getHeight();
            double d5 = this.pageData.getCropBoxWidth(this.pageNumber);
            double d6 = this.pageData.getCropBoxHeight(this.pageNumber);
            if (d < 0.0 || d2 < 0.0 || d + d3 > d5 || d2 + d4 > d6) {
                throw new PdfException("Viewport is not totally enclosed within displayed panel.");
            }
            if (d5 != d3 || d6 != d4) {
                this.viewableArea = rectangle;
                this.currentDisplay.setOptimiseDrawing(false);
                this.setPageRotation(this.displayRotation);
                this.repaint();
            }
        } else {
            this.resetViewableArea();
        }
        return this.viewScaling;
    }

    public static String setFontDirs(String[] stringArray) {
        String string = null;
        if (FontMappings.fontSubstitutionTable == null) {
            FontMappings.fontSubstitutionTable = new HashMap();
            FontMappings.fontSubstitutionFontID = new HashMap();
            FontMappings.fontPossDuplicates = new HashMap();
            FontMappings.fontPropertiesTable = new HashMap();
        }
        try {
            if (stringArray == null) {
                LogWriter.writeLog("Null font parameter passed");
                FontMappings.fontSubstitutionAliasTable.clear();
                FontMappings.fontSubstitutionLocation.clear();
                FontMappings.fontSubstitutionTable.clear();
                FontMappings.fontSubstitutionFontID.clear();
                FontMappings.fontPossDuplicates.clear();
                FontMappings.fontPropertiesTable.clear();
            } else {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = stringArray[i];
                    if (!string2.endsWith("/") & !string2.endsWith("\\")) {
                        string2 = string2 + separator;
                    }
                    if (debugFonts) {
                        System.out.println("Looking in " + string2 + " for fonts");
                    }
                    string = PdfDecoder.addTTDir(string2, string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to run setFontDirs " + exception.getMessage());
        }
        return string;
    }

    private static String addTTDir(String string, String string2) {
        File file;
        if (FontMappings.fontSubstitutionTable == null) {
            FontMappings.fontSubstitutionTable = new HashMap();
            FontMappings.fontSubstitutionFontID = new HashMap();
            FontMappings.fontPossDuplicates = new HashMap();
            FontMappings.fontPropertiesTable = new HashMap();
        }
        if ((file = new File(string)).exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string3 = stringArray[i];
                    PdfDecoder.addFontFile(string3, string);
                }
            }
        } else {
            string2 = string2 == null ? string : string2 + ',' + string;
        }
        return string2;
    }

    public static void setFontSubstitutionMode(int n) {
        fontSubstitutionMode = n;
    }

    public static int getFontSubstitutionMode() {
        return fontSubstitutionMode;
    }

    public static void addFontFile(String string, String string2) {
        if (FontMappings.fontSubstitutionTable == null) {
            FontMappings.fontSubstitutionTable = new HashMap();
            FontMappings.fontSubstitutionFontID = new HashMap();
            FontMappings.fontPossDuplicates = new HashMap();
            FontMappings.fontPropertiesTable = new HashMap();
        }
        if (string2 != null && !string2.endsWith("/") && !string2.endsWith("\\")) {
            string2 = string2 + separator;
        }
        String string3 = string.toLowerCase();
        int n = StandardFonts.getFontType(string3);
        if (debugFonts) {
            System.out.println(n + " " + string3);
        }
        if (n != 8) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string2 + string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            if (fileInputStream != null) {
                int n2 = string.indexOf(46);
                String string4 = n2 == -1 ? string.toLowerCase() : string.substring(0, n2).toLowerCase();
                if (debugFonts) {
                    System.out.println("Added " + string4);
                }
                if (fontSubstitutionMode == 1) {
                    if (n == 1228944677) {
                        FontMappings.fontSubstitutionTable.put(string4, "/Type1");
                    } else {
                        FontMappings.fontSubstitutionTable.put(string4, "/TrueType");
                    }
                    FontMappings.fontSubstitutionLocation.put(string4, string2 + string);
                    FontMappings.fontPropertiesTable.put(string4, StandardFonts.getFontDetails(n, string2 + string));
                } else if (n == 7 || n == 1217103210) {
                    if (fontSubstitutionMode == 5) {
                        String[] stringArray = new String[]{};
                        try {
                            stringArray = StandardFonts.readNamesFromFont(n, string2 + string, 2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        String[] stringArray2 = new String[]{};
                        try {
                            stringArray2 = StandardFonts.readNamesFromFont(n, string2 + string, 3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        int n3 = stringArray.length;
                        for (int i = 0; i < n3; ++i) {
                            if (stringArray[i] == null) {
                                stringArray[i] = Strip.stripAllSpaces(string4);
                            }
                            if (stringArray2[i] == null) {
                                stringArray2[i] = Strip.stripAllSpaces(string4);
                            }
                            Object v = FontMappings.fontSubstitutionTable.get(stringArray[i]);
                            Object v2 = FontMappings.fontPossDuplicates.get(stringArray[i]);
                            if (v == null && v2 == null) {
                                FontMappings.fontSubstitutionTable.put(stringArray[i], "/TrueType");
                                FontMappings.fontSubstitutionLocation.put(stringArray[i], string2 + string);
                                FontMappings.fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                                FontMappings.fontPossDuplicates.put(stringArray[i], stringArray2[i]);
                                continue;
                            }
                            if (stringArray2[i].equals(stringArray[i])) continue;
                            FontMappings.fontSubstitutionTable.put(stringArray[i], "/TrueType");
                            FontMappings.fontSubstitutionLocation.put(stringArray[i], string2 + string);
                            FontMappings.fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                            FontMappings.fontPropertiesTable.put(stringArray[i], StandardFonts.getFontDetails(n, string2 + string));
                            if (v2.equals("DONE")) continue;
                            FontMappings.fontPossDuplicates.put(stringArray[i], "DONE");
                            FontMappings.fontSubstitutionTable.remove(stringArray[i]);
                            FontMappings.fontSubstitutionTable.put(stringArray2[i], "/TrueType");
                            String string5 = (String)FontMappings.fontSubstitutionLocation.get(stringArray[i]);
                            FontMappings.fontSubstitutionLocation.remove(stringArray[i]);
                            FontMappings.fontSubstitutionLocation.put(stringArray2[i], string5);
                            FontMappings.fontSubstitutionFontID.remove(stringArray[i]);
                            FontMappings.fontSubstitutionFontID.put(stringArray2[i], new Integer(i));
                            FontMappings.fontPropertiesTable.remove(stringArray2[i]);
                            FontMappings.fontPropertiesTable.put(stringArray2[i], StandardFonts.getFontDetails(n, string2 + string));
                        }
                    } else {
                        String[] stringArray = new String[]{};
                        try {
                            stringArray = StandardFonts.readNamesFromFont(n, string2 + string, fontSubstitutionMode);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i] == null) {
                                stringArray[i] = Strip.stripAllSpaces(string4);
                            }
                            FontMappings.fontSubstitutionTable.put(stringArray[i], "/TrueType");
                            FontMappings.fontSubstitutionLocation.put(stringArray[i], string2 + string);
                            FontMappings.fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                            FontMappings.fontPropertiesTable.put(stringArray[i], StandardFonts.getFontDetails(n, string2 + string));
                        }
                    }
                }
            } else {
                LogWriter.writeLog("No fonts found at " + string2);
            }
        }
    }

    public int getPageAlignment() {
        return this.alignment;
    }

    public final void init(boolean bl) {
        embedWidthData = bl;
    }

    public PdfDecoder(boolean bl) {
        this.pages = new SingleDisplay(this);
        this.renderPage = bl;
        this.setLayout(null);
        this.startup();
    }

    public PdfDecoder(int n, boolean bl) {
        this.pages = new SingleDisplay(this);
        this.renderPage = bl;
        extractionMode = 1;
        this.setLayout(null);
        this.init(true);
        this.startup();
        PdfStreamDecoder.runningStoryPad = true;
    }

    private void startup() {
        Object object;
        String string;
        String string2;
        this.formsAvailable = PdfStreamDecoder.isFormSupportAvailable();
        if (this.formsAvailable) {
            this.formRenderer = new DefaultAcroRenderer();
            this.setJavascript();
            this.formRenderer.resetHandler(null, this, 5);
            this.formRenderer.resetHandler(null, this, 7);
        }
        if ((string2 = System.getProperty("debug")) != null) {
            LogWriter.setupLogFile(true, 1, "", "v", false);
        }
        try {
            string = System.getProperty("org.jpedal.fontmaps");
            if (string != null) {
                object = new StringTokenizer(string, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "=:");
                    int n = stringTokenizer.countTokens() - 1;
                    String[] stringArray = new String[n];
                    String string4 = stringTokenizer.nextToken();
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = stringTokenizer.nextToken();
                    }
                    this.setSubstitutedFontAliases(string4, stringArray);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to read org.jpedal.fontmaps " + exception.getMessage());
        }
        try {
            string = System.getProperty("org.jpedal.fontdirs");
            object = null;
            if (string != null) {
                object = this.addFonts(string, (String)object);
            }
            if (object != null) {
                LogWriter.writeLog("Could not find " + (String)object);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to read FontDirs " + exception.getMessage());
        }
        if (this.renderPage) {
            this.setToolTipText("image preview");
            this.highlightFont = new Font("Lucida", 1, this.size);
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public PdfDecoder() {
        this.pages = new SingleDisplay(this);
        this.renderPage = true;
        this.setLayout(null);
        this.startup();
    }

    public final void closePdfFile() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.displayScaling = null;
        this.lastPageDecoded = -1;
        this.stopDecoding();
        this.pages.disableScreen();
        this.pagesRead.clear();
        if (this.javascript != null) {
            this.javascript.closeFile();
        }
        this.overlayType.clear();
        this.overlayColors.clear();
        this.overlayObj.clear();
        this.overlayTypeG.clear();
        this.overlayColorsG.clear();
        this.overlayObjG.clear();
        if (this.formsAvailable) {
            this.currentAcroFormData = null;
            if (this.formRenderer != null) {
                this.formRenderer.openFile(this.pageCount);
                this.formRenderer.resetFormData(this.currentAcroFormData, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
            }
        }
        if (this.hasViewListener) {
            this.hasViewListener = false;
            this.pages.flushPageCaches();
            this.removeComponentListener(this.viewListener);
        }
        if (this.currentPdfFile != null) {
            this.currentPdfFile.closePdfFile();
        }
        this.currentPdfFile = null;
        this.pages.disableScreen();
        this.currentDisplay.flush();
        this.objectStoreRef.flush();
        ObjectStore.flushPages();
        this.objectPrintStoreRef.flush();
        this.oldScaling = -1.0f;
        this.pageCount = 0;
    }

    public final byte[] getPdfBuffer() {
        byte[] byArray = null;
        if (this.currentPdfFile != null) {
            byArray = this.currentPdfFile.getPdfBuffer();
        }
        return byArray;
    }

    public final PdfData getPdfBackgroundData() {
        return this.pdfBackgroundData;
    }

    public final PdfData getPdfData() throws PdfException {
        if ((extractionMode & 1) == 0) {
            throw new PdfException("[PDF] Page data object requested will be empty as text extraction disabled. Enable with PdfDecoder method setExtractionMode(PdfDecoder.TEXT | other values");
        }
        return this.pdfData;
    }

    public final PdfPageData getPdfBackgroundPageData() {
        return this.pageData;
    }

    public final boolean hasOutline() {
        return this.hasOutline;
    }

    public final Document getOutlineAsXML() {
        if (this.outlineData == null && this.outlineObject != null) {
            try {
                this.outlineData = new OutlineData(this.pageCount);
                this.outlineData.readOutlineFileMetadata(this.outlineObject, this.currentPdfFile, this.pageLookup);
            }
            catch (Exception exception) {
                System.out.println("Exception " + exception + " accessing outline " + this.outlineObject);
                this.outlineData = null;
            }
        }
        if (this.outlineData != null) {
            return this.outlineData.getList();
        }
        return null;
    }

    public final PdfPageData getPdfPageData() {
        return this.pageData;
    }

    public void setPagePrintRange(int n, int n2) throws PdfException {
        this.start = n;
        this.end = n2;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.pageCount;
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if (n < 1 || n2 < 1 || n > this.pageCount || n2 > this.pageCount) {
            throw new PdfException(Messages.getMessage("PdfViewerPrint.InvalidPageRange") + ' ' + n + ' ' + n2);
        }
    }

    public void setPrintPageMode(int n) {
        this.oddPagesOnly = (n & 0x10) == 16;
        this.evenPagesOnly = (n & 0x20) == 32;
        this.pagesPrintedInReverse = (n & 0x40) == 64;
    }

    public void setPagePrintRange(SetOfIntegerSyntax setOfIntegerSyntax) throws PdfException {
        int n;
        int n2;
        if (setOfIntegerSyntax == null) {
            throw new PdfException("[PDF] null page range entered");
        }
        this.range = setOfIntegerSyntax;
        this.start = setOfIntegerSyntax.next(0);
        int n3 = 0;
        for (n2 = 0; n2 < this.pageCount; ++n2) {
            if (!setOfIntegerSyntax.contains(n2)) continue;
            ++n3;
        }
        this.listOfPages = new int[n3 + 1];
        n2 = this.start;
        this.end = this.start;
        if (setOfIntegerSyntax.contains(Integer.MAX_VALUE)) {
            this.end = this.pageCount;
        } else {
            while (setOfIntegerSyntax.next(n2) != -1) {
                ++n2;
            }
            this.end = n2;
        }
        if (this.start > this.end) {
            n = this.start;
            this.start = this.end;
            this.end = n;
        }
        n = 0;
        for (int i = this.start; i < this.end + 1; ++i) {
            if (!setOfIntegerSyntax.contains(i) || this.oddPagesOnly && (i & 1) != 1 || this.evenPagesOnly && (i & 1) != 0) continue;
            this.listOfPages[n] = i - this.start;
            ++n;
        }
        if (this.start < 1 || this.end < 1 || this.start > this.pageCount || this.end > this.pageCount) {
            throw new PdfException(Messages.getMessage("PdfViewerPrint.InvalidPageRange") + ' ' + this.start + ' ' + this.end);
        }
    }

    public void setTextPrint(int n) {
        this.textPrint = n;
    }

    public void setCenterOnScaling(boolean bl) {
        this.centerOnScaling = bl;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        block114: {
            PdfPageObject pdfPageObject = null;
            PdfObject pdfObject = null;
            if (this.stopPrinting) {
                this.stopPrinting = false;
                this.start = 0;
                this.end = 0;
                return 1;
            }
            n2 = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            if (this.range == null && (this.oddPagesOnly || this.evenPagesOnly)) {
                n *= 2;
            } else if (this.range != null) {
                n = this.listOfPages[n];
            }
            try {
                double d = 1.0;
                if (this.usePageScaling) {
                    d = this.scaling;
                }
                int n3 = this.end;
                int n4 = this.start;
                if (this.pagesPrintedInReverse) {
                    n4 = this.start;
                    n3 = this.end;
                    n = this.end - n;
                } else if (this.end != -1 && this.end < this.start) {
                    n4 = this.end;
                    n3 = this.start;
                    n = this.start - n;
                } else {
                    n = this.start + n;
                }
                if (this.end == -1) {
                    ++n;
                }
                this.currentPrintPage = n;
                if (n > this.pageCount | this.end != -1 & n > n3) {
                    this.currentPrintPage = -1;
                    if (debugPrint) {
                        System.out.println("no such page");
                    }
                    return 1;
                }
                if (!(this.end == -1 | n >= n4 & n <= n3)) break block114;
                this.operationSuccessful = true;
                this.pageErrorMessages = "";
                try {
                    Object[] objectArray;
                    Color[] colorArray;
                    Object object;
                    Object object2;
                    double d2;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    Object object3;
                    String string = (String)this.pagesReferences.get(new Integer(n));
                    if (string == null && !this.isCustomPrinting) break block114;
                    if (this.currentPdfFile == null && !this.isCustomPrinting) {
                        throw new PrinterException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    if (!this.isCustomPrinting) {
                        pdfPageObject = new PdfPageObject(string);
                        this.currentPdfFile.readObject(pdfPageObject, string, false, null);
                        pdfObject = ((PdfObject)pdfPageObject).getDictionary(2004251818);
                        object3 = ((PdfObject)pdfPageObject).getKeyArray(1044338049);
                        this.printAnnots = null;
                        if (object3 != null) {
                            this.printAnnots = new PdfAnnots(this.currentPdfFile, null);
                            this.printAnnots.readAnnots((byte[][])object3);
                        }
                    }
                    if (this.printHotspots != null && !this.isCustomPrinting) {
                        this.printHotspots.flushAnnotationsDisplayed();
                    }
                    if (this.lastPrintedPage != n) {
                        this.currentPrintDecoder = new PdfStreamDecoder(true);
                        this.currentPrintDecoder.setExternalImageRender(this.customImageHandler);
                        this.currentPrintDecoder.setTextPrint(this.textPrint);
                        this.currentPrintDecoder.optimiseDisplayForPrinting();
                        this.currentPrintDecoder.setStore(this.objectPrintStoreRef);
                        if (!this.isCustomPrinting) {
                            try {
                                this.currentPrintDecoder.init(true, this.renderPage, renderMode, 0, this.pageData, n, null, this.currentPdfFile);
                            }
                            catch (PdfException pdfException) {
                                throw new PdfFontException(pdfException.getMessage());
                            }
                            if (this.globalResources != null) {
                                this.currentPrintDecoder.readResources(this.globalResources, true);
                            }
                            if (pdfObject != null) {
                                this.currentPrintDecoder.readResources(pdfObject, true);
                            }
                        }
                    }
                    object3 = new AffineTransform();
                    int n11 = this.pageData.getMediaBoxWidth(n);
                    int n12 = this.pageData.getMediaBoxHeight(n);
                    int n13 = this.pageData.getMediaBoxX(n);
                    int n14 = this.pageData.getMediaBoxY(n);
                    int n15 = n10 = this.pageData.getCropBoxX(n);
                    int n16 = n9 = this.pageData.getCropBoxY(n);
                    int n17 = n8 = this.pageData.getCropBoxWidth(n) + 1;
                    int n18 = n7 = this.pageData.getCropBoxHeight(n) + 1;
                    int n19 = this.pageData.getRotation(this.currentPrintPage);
                    if (this.usePDFPaperSize) {
                        this.createCustomPaper(pageFormat, n8, n7);
                    }
                    int n20 = (int)pageFormat.getImageableX();
                    int n21 = (int)pageFormat.getImageableY();
                    int n22 = (int)pageFormat.getImageableWidth() - 1;
                    boolean bl = n22 > (n6 = (int)pageFormat.getImageableHeight() - 1) && n17 < n18 || n22 < n6 && n17 > n18;
                    this.docIsLandscaped = false;
                    if ((this.displayRotation == 0 && bl || n17 >= n18) && this.printOnlyVisible) {
                        this.docIsLandscaped = true;
                    }
                    if (!this.isPrintAutoRotateAndCenter && !this.usePDFPaperSize) {
                        bl = n19 == 90 || n19 == 270 ? !bl : false;
                    }
                    if (this.docIsLandscaped && this.isPrintAutoRotateAndCenter) {
                        bl = false;
                    }
                    if (bl) {
                        n11 = this.pageData.getMediaBoxHeight(n);
                        n12 = this.pageData.getMediaBoxWidth(n);
                        n13 = this.pageData.getMediaBoxY(n);
                        n14 = this.pageData.getMediaBoxX(n);
                        n15 = n10 = this.pageData.getCropBoxY(n);
                        n16 = n9 = this.pageData.getCropBoxX(n);
                        n17 = n8 = this.pageData.getCropBoxHeight(n) + 1;
                        n18 = n7 = this.pageData.getCropBoxWidth(n) + 1;
                    }
                    if (this.showImageable) {
                        Rectangle rectangle = new Rectangle(n20, n21, n22, n6);
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        graphics2D.setColor(Color.red);
                        graphics2D.fill(rectangle);
                        graphics2D.setColor(Color.white);
                        for (n5 = 0; n5 < 1000; n5 += 50) {
                            graphics2D.draw(new Line2D.Float(n5, 0.0f, n5, 1000.0f));
                            graphics2D.draw(new Line2D.Float(0.0f, n5, 1000.0f, n5));
                        }
                        graphics2D.draw(rectangle);
                        graphics2D.draw(new Line2D.Float(n20, n21, n20 + n22, n21 + n6));
                        graphics2D.draw(new Line2D.Float(n20, n21 + n6, n20 + n22, n21));
                    }
                    double d3 = 1.0;
                    n5 = n17;
                    int n23 = n18;
                    if (this.usePageScaling && (n5 = (int)((double)n17 * d)) > n22 | (n23 = (int)((double)n18 * d)) > n6) {
                        n5 = n17;
                        n23 = n18;
                        d = 1.0;
                    }
                    double d4 = (double)n22 / (double)n5;
                    double d5 = (double)n6 / (double)n23;
                    boolean bl2 = true;
                    if (d4 < d5) {
                        d2 = d4;
                    } else {
                        bl2 = false;
                        d2 = d5;
                    }
                    boolean bl3 = false;
                    if (this.usePageScaling) {
                        d3 = d2;
                        if (n5 > n22 | n23 > n6) {
                            n5 = (int)((double)n5 * d3);
                            n23 = (int)((double)n23 * d3);
                        }
                    } else {
                        switch (this.pageScalingMode) {
                            case 1: {
                                d3 = d2;
                                bl3 = true;
                                break;
                            }
                            case 2: {
                                if (d2 < 1.0) {
                                    d3 = d2;
                                }
                                bl3 = true;
                                break;
                            }
                        }
                        f = -n20;
                        f2 = -n21;
                        if (this.pageScalingMode == 1 || d3 < 1.0) {
                            if (bl2) {
                                f = 0.0f;
                            } else {
                                f2 = 0.0f;
                            }
                        }
                        if (!(!this.centerOnScaling || !bl3 && !this.isPrintAutoRotateAndCenter || this.docIsLandscaped && this.isPrintAutoRotateAndCenter)) {
                            ((AffineTransform)object3).translate(((double)n22 - (double)n17 * d3) / 2.0, ((double)n6 - (double)n18 * d3) / 2.0);
                        }
                    }
                    if (bl) {
                        if (this.usePDFPaperSize && n22 < n6 && !this.oldSetup) {
                            ((AffineTransform)object3).scale(-1.0, 1.0);
                            ((AffineTransform)object3).translate(-n20, 0.0);
                        } else if (!(this.isPrintAutoRotateAndCenter || n19 != 0 && n19 != 180)) {
                            ((AffineTransform)object3).scale(1.0, -1.0);
                            ((AffineTransform)object3).translate(0.0, -n21);
                        } else {
                            ((AffineTransform)object3).scale(-1.0, 1.0);
                            ((AffineTransform)object3).translate(-n20, 0.0);
                        }
                        ((AffineTransform)object3).scale(d3, d3);
                        ((AffineTransform)object3).rotate(1.5707963267948966);
                        if (bl3 || this.isPrintAutoRotateAndCenter) {
                            ((AffineTransform)object3).translate((double)(-f2) / d3, (double)(-f) / d3);
                        }
                        ((AffineTransform)object3).translate(n16, -n15);
                    } else {
                        ((AffineTransform)object3).translate(-((double)n15 * d3), (double)n16 * d3);
                        ((AffineTransform)object3).translate(n20, n21);
                        if (d3 != 1.0) {
                            if (this.usePageScaling) {
                                ((AffineTransform)object3).translate(n5, n23);
                                ((AffineTransform)object3).scale(1.0, -1.0);
                                ((AffineTransform)object3).translate(-n5, 0.0);
                            } else {
                                ((AffineTransform)object3).translate((double)n5 * d3, (double)n23 * d3);
                                ((AffineTransform)object3).scale(1.0, -1.0);
                                ((AffineTransform)object3).translate((double)(-n5) * d3, 0.0);
                            }
                            ((AffineTransform)object3).scale(d3, d3);
                        } else {
                            ((AffineTransform)object3).translate(n5, n23);
                            ((AffineTransform)object3).scale(1.0, -1.0);
                            ((AffineTransform)object3).translate(-n5, 0.0);
                            ((AffineTransform)object3).scale(d, d);
                        }
                    }
                    n15 = n10;
                    n16 = n9;
                    n17 = n8;
                    n18 = n7;
                    RepaintManager repaintManager = RepaintManager.currentManager(this);
                    repaintManager.setDoubleBufferingEnabled(false);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHints(ColorSpaces.hints);
                    graphics2D.transform((AffineTransform)object3);
                    SingleDisplay singleDisplay = new SingleDisplay(this);
                    Rectangle rectangle = singleDisplay.getDisplayedRectangle();
                    if (this.printOnlyVisible) {
                        object2 = new AffineTransform();
                        object = new AffineTransform();
                        colorArray = new AffineTransform();
                        objectArray = new AffineTransform();
                        double d6 = 0.0;
                        double d7 = 0.0;
                        double d8 = 0.0;
                        boolean bl4 = false;
                        double[] dArray = this.workoutParameters(this.displayRotation, this.scaling, rectangle, n5, n23);
                        this.clipVr = this.workoutClipping(this.displayRotation, this.scaling, rectangle, n5, n23);
                        if (this.docIsLandscaped) {
                            if (this.isPrintAutoRotateAndCenter) {
                                d6 = (double)(n6 - 2 * this.insetH) / (dArray[2] * d3);
                                d8 = d7 = (double)(n22 - 2 * this.insetW) / (dArray[3] * d3);
                                bl4 = true;
                                if (d6 < d8) {
                                    d8 = d6;
                                    bl4 = false;
                                }
                            }
                            if (bl4) {
                                this.isPrintAutoRotateAndCenter = false;
                            }
                            if (!this.isPrintAutoRotateAndCenter) {
                                colorArray.translate(-(((double)n22 - ((double)n17 + 0.0 / d3) * d3) / 2.0) / d3, -(((double)n6 - ((double)n18 + 0.0 / d3) * d3) / 2.0) / d3);
                                graphics2D.transform((AffineTransform)colorArray);
                                d6 = (double)(n6 - 2 * this.insetH) / (dArray[3] * d3);
                                d8 = d7 = (double)(n22 - 2 * this.insetW) / (dArray[2] * d3);
                                if (d6 < d8) {
                                    d8 = d6;
                                }
                                ((AffineTransform)object2).translate(dArray[0] + (double)this.insetW / d8, dArray[1] + (double)this.insetH / d8);
                                ((AffineTransform)object).scale(d8, d8);
                                graphics2D.transform((AffineTransform)object);
                                graphics2D.transform((AffineTransform)object2);
                                if (d8 == d7) {
                                    objectArray.translate(0.0, ((double)(n6 / 2) - dArray[3] * d3 * d8 / 2.0) / d8 / d3);
                                } else {
                                    objectArray.translate(((double)(n22 / 2) - dArray[2] * d3 * d8 / 2.0) / d8 / d3, 0.0);
                                }
                                graphics2D.transform((AffineTransform)objectArray);
                                graphics2D.clip(this.clipVr);
                            } else if (this.isPrintAutoRotateAndCenter) {
                                colorArray.translate(0.0, -((double)n6 - ((double)n18 + 0.0 / d3) * d3) / d3);
                                graphics2D.transform((AffineTransform)colorArray);
                                d6 = (double)(n6 - 2 * this.insetH) / (dArray[2] * d3);
                                d8 = d7 = (double)(n22 - 2 * this.insetW) / (dArray[3] * d3);
                                if (d6 < d8) {
                                    d8 = d6;
                                }
                                ((AffineTransform)object2).rotate(1.5707963267948966);
                                ((AffineTransform)object2).translate(0.0, -dArray[3]);
                                ((AffineTransform)object2).translate(dArray[0] + (double)this.insetW / d8, dArray[1] - (double)this.insetH / d8);
                                ((AffineTransform)object).scale(d8, d8);
                                graphics2D.transform((AffineTransform)object);
                                graphics2D.transform((AffineTransform)object2);
                                if (d8 == d7) {
                                    objectArray.translate(((double)(n6 / 2) - dArray[2] * d3 * d8 / 2.0) / d8 / d3, 0.0);
                                } else {
                                    objectArray.translate(0.0, -((double)(n22 / 2) - dArray[3] * d3 * d8 / 2.0) / d8 / d3);
                                }
                                graphics2D.transform((AffineTransform)objectArray);
                                graphics2D.clip(this.clipVr);
                            }
                        } else {
                            d6 = (double)(n6 - 2 * this.insetW) / (dArray[2] * d3);
                            d7 = (double)n22 / (dArray[3] * d3);
                            d8 = d7;
                            if (!(d6 < d8)) {
                                bl4 = true;
                            }
                            if (bl4) {
                                this.isPrintAutoRotateAndCenter = false;
                            }
                            if (!this.isPrintAutoRotateAndCenter) {
                                colorArray.translate(-(Math.abs(((double)n22 - ((double)n17 + 0.0 / d3) * d3) / 2.0) / d3), -(Math.abs(((double)n6 - ((double)n18 + 0.0 / d3) * d3) / 2.0) / d3));
                                graphics2D.transform((AffineTransform)colorArray);
                                d6 = (double)(n6 - 2 * this.insetH) / (dArray[3] * d3);
                                d8 = d7 = (double)(n22 - 2 * this.insetW) / (dArray[2] * d3);
                                if (d6 < d8) {
                                    d8 = d6;
                                }
                                ((AffineTransform)object2).translate(dArray[0] + (double)this.insetW / d8, dArray[1] + (double)this.insetH / d8);
                                ((AffineTransform)object).scale(d8, d8);
                                graphics2D.transform((AffineTransform)object);
                                graphics2D.transform((AffineTransform)object2);
                                if (d8 == d7) {
                                    objectArray.translate(0.0, ((double)(n6 / 2) - dArray[3] * d8 / 2.0) / d8);
                                } else {
                                    objectArray.translate(((double)(n22 / 2) - dArray[2] * d8 / 2.0) / d8, 0.0);
                                }
                                graphics2D.transform((AffineTransform)objectArray);
                                graphics2D.clip(this.clipVr);
                            } else {
                                colorArray.translate(-(((double)n22 - ((double)n17 + 0.0 / d3) * d3) / 2.0) / d3, -(((double)n6 - ((double)n18 + 0.0 / d3) * d3) / 2.0) / d3);
                                graphics2D.transform((AffineTransform)colorArray);
                                d6 = (double)(n6 - 2 * this.insetH) / (dArray[2] * d3);
                                d8 = d7 = (double)(n22 - 2 * this.insetW) / (dArray[3] * d3);
                                if (d6 < d8) {
                                    d8 = d6;
                                }
                                ((AffineTransform)object2).rotate(1.5707963267948966);
                                ((AffineTransform)object2).translate(0.0, -dArray[3]);
                                ((AffineTransform)object2).translate(dArray[0] + (double)this.insetW / d8, dArray[1] - (double)this.insetH / d8);
                                ((AffineTransform)object).scale(d8, d8);
                                graphics2D.transform((AffineTransform)object);
                                graphics2D.transform((AffineTransform)object2);
                                if (d8 == d7) {
                                    objectArray.translate(((double)(n6 / 2) - dArray[2] * d8 / 2.0) / d8, 0.0);
                                } else {
                                    objectArray.translate(0.0, -((double)(n22 / 2) - dArray[3] * d8 / 2.0) / d8);
                                }
                                graphics2D.transform((AffineTransform)objectArray);
                                graphics2D.clip(this.clipVr);
                            }
                        }
                    }
                    if (this.useARGBFix && ColorSpaceConvertor.isUsingARGB) {
                        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                        object2 = new Color(255, 255, 255, 1);
                        graphics2D.setColor((Color)object2);
                        graphics2D.drawLine(0, 0, 1, 1);
                    }
                    if (this.showImageable) {
                        graphics2D.setColor(Color.black);
                        if (bl) {
                            graphics2D.draw(new Rectangle(n14, n13, n12, n11));
                            graphics2D.drawLine(n14, n13, n12 + n14, n11 + n13);
                            graphics2D.drawLine(n14, n11 + n13, n12 + n14, n13);
                        } else {
                            graphics2D.draw(new Rectangle(n13, n14, n11, n12));
                            graphics2D.drawLine(n13, n14, n11 + n13, n12 + n14);
                            graphics2D.drawLine(n13, n12 + n14, n11 + n13, n14);
                        }
                        graphics2D.setColor(highlightColor);
                        if (bl) {
                            graphics2D.draw(new Rectangle(n16, n15, n18, n17));
                            graphics2D.drawLine(n16, n15, n18 + n16, n17 + n15);
                            graphics2D.drawLine(n16, n17 + n15, n18 + n16, n15);
                        } else {
                            graphics2D.draw(new Rectangle(n15, n16, n17, n18));
                            graphics2D.drawLine(n15, n16, n17 + n15, n18 + n16);
                            graphics2D.drawLine(n15, n18 + n16, n17 + n15, n16);
                        }
                    } else if (bl) {
                        graphics2D.clip(new Rectangle(n16, n15, n18, n17));
                    } else {
                        graphics2D.clip(new Rectangle(n15, n16, n17, n18));
                    }
                    this.currentPrintDecoder.getRenderer().setScalingValues(n15, n18 + n16, (float)d3);
                    if (this.lastPrintedPage != n) {
                        if (!this.isCustomPrinting) {
                            try {
                                this.currentPrintDecoder.decodePageContent(pdfPageObject, 0, 0, null, null);
                                object2 = new Integer(-1);
                                object = (int[])this.overlayTypeG.get(object2);
                                colorArray = (Color[])this.overlayColorsG.get(object2);
                                objectArray = (Object[])this.overlayObjG.get(object2);
                                this.currentPrintDecoder.getRenderer().drawAdditionalObjectsOverPage((int[])object, colorArray, objectArray);
                                Integer n24 = new Integer(n);
                                int[] nArray = (int[])this.overlayType.get(n24);
                                Color[] colorArray2 = (Color[])this.overlayColors.get(n24);
                                Object[] objectArray2 = (Object[])this.overlayObj.get(n24);
                                this.currentPrintDecoder.getRenderer().drawAdditionalObjectsOverPage(nArray, colorArray2, objectArray2);
                            }
                            catch (PdfException pdfException) {
                                pdfException.printStackTrace();
                                throw new PrinterException(pdfException.getMessage());
                            }
                        }
                        this.lastPrintedPage = n;
                    }
                    if (this.duplexGapOdd != 0 || this.duplexGapEven != 0) {
                        object2 = graphics2D.getClip();
                        if (n % 2 != 1) {
                            graphics2D.translate(this.duplexGapEven, 0);
                        } else {
                            graphics2D.translate(this.duplexGapOdd, 0);
                        }
                        if (object2 != null) {
                            graphics2D.setClip((Shape)object2);
                        }
                    }
                    if (!this.isCustomPrinting) {
                        this.currentPrintDecoder.print(graphics2D, null, this.showImageable, this.currentPrintPage);
                    } else if (this.printRender == null) {
                        System.out.println("No data for page " + n);
                        LogWriter.writeLog("No data for page " + n);
                    } else {
                        this.printRender.paint(graphics2D, null, null, null, false, false);
                    }
                    graphics2D.setClip(null);
                    if (!this.isCustomPrinting && this.printAnnots != null && this.printHotspots != null) {
                        this.printHotspots.setHotspots(this.printAnnots);
                    }
                    if (this.printHotspots != null) {
                        this.printHotspots.addHotspotsToDisplay(graphics2D, this.userAnnotIcons, n);
                    }
                    if (this.formsAvailable && this.formRenderer != null) {
                        this.formRenderer.getCompData().setPageValues((float)d, 0);
                        this.formRenderer.createDisplayComponentsForPage(n);
                        this.formRenderer.getCompData().renderFormsOntoG2(graphics2D, n, (float)d, 0, this.displayRotation);
                    }
                    if (this.useBorder && this.myBorder != null) {
                        this.myBorder.paintBorder(this, graphics2D, n15, n16, n17, n18);
                    }
                    repaintManager.setDoubleBufferingEnabled(true);
                    if (!this.currentPrintDecoder.isPageSuccessful()) {
                        this.operationSuccessful = false;
                        this.pageErrorMessages = this.pageErrorMessages + this.currentPrintDecoder.getPageFailureMessage();
                    }
                    if (!this.operationSuccessful && debugPrint) {
                        System.out.println("Not Successful=" + this.operationSuccessful + '\n' + this.pageErrorMessages);
                    }
                }
                catch (PdfFontException pdfFontException) {
                    this.operationSuccessful = false;
                    this.pageErrorMessages = this.pageErrorMessages + "Missing substitute fonts\n";
                    if (debugPrint) {
                        System.out.println("Exception e=" + pdfFontException);
                    }
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
            }
            catch (Error error) {
                this.operationSuccessful = false;
                this.pageErrorMessages = this.pageErrorMessages + "Memory Error on printing\n";
                if (!debugPrint) break block114;
                System.out.println("Error=" + error);
            }
        }
        if (!this.operationSuccessful) {
            n2 = 1;
        }
        return n2;
    }

    private Rectangle workoutClipping(int n, float f, Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = null;
        double d = rectangle.getX();
        double d2 = rectangle.getY();
        double d3 = rectangle.getWidth();
        double d4 = rectangle.getHeight();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (n) {
            case 0: {
                n4 = (int)((float)(rectangle.x - this.insetW) / this.scaling);
                n5 = (int)((float)n3 - (float)(rectangle.y + rectangle.height - this.insetH) / this.scaling);
                n6 = (int)((float)rectangle.width / this.scaling) - 1;
                n7 = (int)((float)rectangle.height / this.scaling);
                break;
            }
            case 90: {
                n4 = (int)((d2 - (double)this.insetH) / (double)this.scaling);
                n5 = (int)((d - (double)this.insetW) / (double)this.scaling);
                n6 = (int)(d4 / (double)this.scaling);
                n7 = (int)(d3 / (double)this.scaling);
                break;
            }
            case 180: {
                n5 = (int)(d2 / (double)this.scaling - (double)((float)this.insetH / this.scaling));
                n4 = (int)((double)n2 - (d + d3 - (double)this.insetW) / (double)this.scaling);
                n6 = (int)(d3 / (double)this.scaling);
                n7 = (int)(d4 / (double)this.scaling);
                break;
            }
            case 270: {
                n4 = (int)((double)n2 - (d2 + d4 - (double)this.insetH) / (double)this.scaling);
                n5 = (int)((double)n3 - (d + d3 - (double)this.insetW) / (double)this.scaling);
                n6 = (int)(d4 / (double)this.scaling);
                n7 = (int)(d3 / (double)this.scaling);
            }
        }
        rectangle2 = new Rectangle(n4, n5, n6, n7);
        return rectangle2;
    }

    private double[] workoutParameters(int n, float f, Rectangle rectangle, int n2, int n3) {
        double[] dArray = new double[4];
        double d = rectangle.getX();
        double d2 = rectangle.getY();
        double d3 = rectangle.getWidth();
        double d4 = rectangle.getHeight();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        switch (n) {
            case 0: {
                d5 = -((d - (double)this.insetW) / (double)this.scaling);
                d6 = -((double)n3 - (d2 + d4 - (double)this.insetH) / (double)this.scaling);
                d7 = d3 / (double)this.scaling;
                d8 = d4 / (double)this.scaling;
                break;
            }
            case 90: {
                d5 = -((d2 - (double)this.insetH) / (double)this.scaling);
                d6 = -((d - (double)this.insetW) / (double)this.scaling);
                d7 = d4 / (double)this.scaling;
                d8 = d3 / (double)this.scaling;
                break;
            }
            case 180: {
                d6 = -((d2 - (double)this.insetH) / (double)this.scaling);
                d5 = -((double)n2 - (d + d3 - (double)this.insetW) / (double)this.scaling);
                d7 = d3 / (double)this.scaling;
                d8 = d4 / (double)this.scaling;
                break;
            }
            case 270: {
                d5 = -((double)n2 - (d2 + d4 - (double)this.insetW) / (double)this.scaling);
                d6 = -((double)n3 - (d + d3 - (double)this.insetH) / (double)this.scaling);
                d7 = d4 / (double)this.scaling;
                d8 = d3 / (double)this.scaling;
            }
        }
        dArray[0] = d5;
        dArray[1] = d6;
        dArray[2] = d7;
        dArray[3] = d8;
        return dArray;
    }

    private void createCustomPaper(PageFormat pageFormat, int n, int n2) {
        Paper paper = new Paper();
        if (this.pageCount == 1) {
            paper.setSize(n, n2);
            paper.setImageableArea(0.0, 0.0, n, n2);
        } else {
            int n3 = 0;
            int n4 = 0;
            for (int i = this.start; i <= this.end; ++i) {
                if (n > this.pageData.getMediaBoxWidth(i) + 1 || n2 > this.pageData.getMediaBoxHeight(i) + 1) continue;
                n3 = this.pageData.getMediaBoxWidth(i) + 1;
                n4 = this.pageData.getMediaBoxHeight(i) + 1;
            }
            paper.setSize(n3, n4);
            paper.setImageableArea(0.0, 0.0, n, n2);
        }
        pageFormat.setPaper(paper);
    }

    public BufferedImage getPageAsImage(int n) throws PdfException {
        return this.getPageAsImage(n, false);
    }

    public BufferedImage getPageAsTransparentImage(int n) throws PdfException {
        return this.getPageAsImage(n, true);
    }

    private BufferedImage getPageAsImage(int n, boolean bl) throws PdfException {
        BufferedImage bufferedImage = null;
        String string = System.getProperty("org.jpedal.upscale");
        if (string != null) {
            this.isOptimisedImage = true;
            try {
                GLOBAL_IMAGE_UPSCALE = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (extAtBestQuality) {
            useFullSizeImage = true;
            multiplyer = GLOBAL_IMAGE_UPSCALE;
            bufferedImage = this.getPageAsImageSub(n, bl);
            if (samplingUsed != -1) {
                multiplyer = samplingUsed;
                bufferedImage = this.getPageAsImageSub(n, bl);
                samplingUsed = -1;
                multiplyer = 1.0f;
            }
            useFullSizeImage = false;
            this.getPageAsImageSub(n, bl);
        } else {
            multiplyer = GLOBAL_IMAGE_UPSCALE;
            bufferedImage = this.getPageAsImageSub(n, bl);
        }
        this.isOptimisedImage = false;
        return bufferedImage;
    }

    private BufferedImage getPageAsImageSub(int n, boolean bl) throws PdfException {
        BufferedImage bufferedImage = null;
        if (n > this.pageCount | n < 1) {
            LogWriter.writeLog("Page " + n + " not in range");
        } else {
            PdfAnnots pdfAnnots = null;
            Object var5_5 = null;
            String string = (String)this.pagesReferences.get(new Integer(n));
            if (string != null) {
                int n2;
                int n3;
                if (this.currentPdfFile == null) {
                    throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                }
                PdfPageObject pdfPageObject = new PdfPageObject(string);
                this.currentPdfFile.resetCache();
                this.currentPdfFile.readObject(pdfPageObject, string, false, null);
                PdfObject pdfObject = ((PdfObject)pdfPageObject).getDictionary(2004251818);
                if (this.printHotspots != null) {
                    this.printHotspots.flushAnnotationsDisplayed();
                }
                if (!extAtBestQuality) {
                    multiplyer = this.pageData.getScalingValue();
                }
                AffineTransform affineTransform = this.setPageParametersForImage(1.0f * multiplyer, n);
                int n4 = this.pageData.getMediaBoxWidth(n);
                int n5 = this.pageData.getMediaBoxHeight(n);
                int n6 = this.pageData.getRotation(n);
                int n7 = this.pageData.getCropBoxWidth(n);
                int n8 = this.pageData.getCropBoxHeight(n);
                int n9 = this.pageData.getCropBoxX(n);
                int n10 = this.pageData.getCropBoxY(n);
                boolean bl2 = false;
                if (n6 == 90 || n6 == 270) {
                    n3 = (int)((float)n7 * multiplyer);
                    n2 = (int)((float)n8 * multiplyer);
                    bl2 = true;
                } else {
                    n2 = (int)((float)n7 * multiplyer);
                    n3 = (int)((float)n8 * multiplyer);
                }
                bufferedImage = new BufferedImage(n2, n3, 2);
                Graphics graphics = bufferedImage.getGraphics();
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (!bl) {
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(0, 0, n2, n3);
                }
                ObjectStore objectStore = new ObjectStore();
                PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder();
                pdfStreamDecoder.setExternalImageRender(this.customImageHandler);
                pdfStreamDecoder.setName(this.filename);
                pdfStreamDecoder.setStore(objectStore);
                if (bl) {
                    DynamicVectorRenderer dynamicVectorRenderer = new DynamicVectorRenderer(this.pageNumber, false, 5000, objectStore);
                    pdfStreamDecoder.init(true, this.renderPage, renderMode, 0, this.pageData, n, dynamicVectorRenderer, this.currentPdfFile);
                } else {
                    pdfStreamDecoder.init(true, this.renderPage, renderMode, 0, this.pageData, n, null, this.currentPdfFile);
                }
                if (this.globalResources != null) {
                    pdfStreamDecoder.readResources(this.globalResources, true);
                }
                if (pdfObject != null) {
                    pdfStreamDecoder.readResources(pdfObject, true);
                }
                pdfStreamDecoder.getRenderer().setScalingValues(n9, (float)n8 * multiplyer + (float)n10, 1.0f);
                graphics2D.setRenderingHints(ColorSpaces.hints);
                graphics2D.transform(affineTransform);
                if (bl2) {
                    if (n6 == 90) {
                        if (n10 < 0) {
                            graphics2D.translate(-n9, -n10);
                        } else {
                            graphics2D.translate(-n9, n10);
                        }
                    } else if (n10 < 0) {
                        graphics2D.translate(-n9, n5 - n8 + n10);
                    } else {
                        graphics2D.translate(-n9, n5 - n8 - n10);
                    }
                }
                pdfStreamDecoder.setDirectRendering(graphics2D);
                if (pdfPageObject != null) {
                    pdfStreamDecoder.decodePageContent(pdfPageObject, 0, 0, null, null);
                }
                graphics2D.setClip(null);
                if (pdfAnnots != null && this.printHotspots != null) {
                    this.printHotspots.setHotspots(pdfAnnots);
                }
                if (this.printHotspots != null) {
                    this.printHotspots.addHotspotsToDisplay(graphics2D, this.userAnnotIcons, n);
                }
                if (this.formsAvailable && this.formRenderer != null) {
                    this.formRenderer.getCompData().setPageValues(this.scaling, 0);
                    this.formRenderer.createDisplayComponentsForPage(n);
                    this.formRenderer.getCompData().renderFormsOntoG2(graphics2D, n, this.scaling, 0, this.displayRotation);
                    this.formRenderer.getCompData().resetScaledLocation(this.oldScaling, this.displayRotation, 0);
                }
                objectStore.flush();
            }
            if (!this.isOptimisedImage && !bl && bufferedImage != null) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
        }
        return bufferedImage;
    }

    public final void flushObjectValues(boolean bl) {
        if (this.pdfData != null) {
            this.pdfData.flushTextList(bl);
        }
        if (this.currentAcroFormData != null) {
            this.currentAcroFormData = new PdfFormData(false);
        }
        if (this.pdfImages != null && bl) {
            this.pdfImages.clearImageData();
        }
    }

    public final PdfImageData getPdfImageData() {
        return this.pdfImages;
    }

    public final PdfImageData getPdfBackgroundImageData() {
        return this.pdfBackgroundImages;
    }

    public final PdfAnnots getPdfAnnotsData(AcroRenderer acroRenderer) {
        if (this.annotsData == null) {
            try {
                if (this.annotList != null) {
                    this.annotsData = new PdfAnnots(this.currentPdfFile, null);
                    this.annotsData.readAnnots(this.annotList);
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("[PDF] " + exception + " with annotation");
            }
        }
        return this.annotsData;
    }

    private void readAcroForm(Object object) {
        String string;
        Object object2;
        Object object3;
        Object object4;
        String string2 = "";
        this.formKids.clear();
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        if (!this.useForms) {
            return;
        }
        LogWriter.writeLog("Form data being read");
        Vector<String> vector = new Vector<String>();
        Map map = object instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)object), (String)object, false, null) : (Map)object;
        boolean bl = this.isXFA = map.get("XFA") != null;
        if (this.isXFA) {
            Object v;
            if (this.currentAcroFormData == null) {
                this.currentAcroFormData = new PdfFormData(false);
            }
            if ((v = map.get("XFA")) instanceof String) {
                String string3 = (String)v;
                if (string3.endsWith(" R")) {
                    object4 = this.currentPdfFile.readStream(string3, true);
                } else if (string3.indexOf(91) == -1) {
                    LogWriter.writeFormLog("{PdfDecoder.readAcroForm} Not implemented - XFA form stream in PdfDecoder as Object is direct eg. /XFA 23 0 R", false);
                } else {
                    string3 = Strip.removeArrayDeleminators(string3);
                    object4 = new StringTokenizer(string3, "()", true);
                    while (((StringTokenizer)object4).hasMoreTokens()) {
                        object3 = ((StringTokenizer)object4).nextToken();
                        if (!((String)object3).equals("(")) continue;
                        object3 = ((StringTokenizer)object4).nextToken();
                        ((StringTokenizer)object4).nextToken();
                        if (((String)object3).equals("template")) {
                            object2 = ((StringTokenizer)object4).nextToken().trim();
                            try {
                                this.currentAcroFormData.setXFAFormData(0, this.currentPdfFile.readStream((String)object2, true));
                            }
                            catch (PdfException pdfException) {
                                pdfException.printStackTrace();
                            }
                            continue;
                        }
                        if (((String)object3).equals("datasets")) {
                            object2 = ((StringTokenizer)object4).nextToken().trim();
                            try {
                                this.currentAcroFormData.setXFAFormData(1, this.currentPdfFile.readStream((String)object2, true));
                            }
                            catch (PdfException pdfException) {
                                pdfException.printStackTrace();
                            }
                            continue;
                        }
                        if (!((String)object3).equals("config")) continue;
                        object2 = ((StringTokenizer)object4).nextToken().trim();
                        try {
                            this.currentAcroFormData.setXFAFormData(2, this.currentPdfFile.readStream((String)object2, true));
                        }
                        catch (PdfException pdfException) {
                            pdfException.printStackTrace();
                        }
                    }
                }
            } else {
                System.out.println("Not implemented -XFA form function in PdfDecoder");
                if (showErrorMessages) {
                    JOptionPane.showMessageDialog(null, "Not implemented -XFA form function in PdfDecoder");
                }
            }
        }
        if ((string = (String)map.get("Fields")) != null) {
            int n = string.indexOf(93);
            if (n != 0) {
                string = string.substring(0, n + 1);
            }
            string = Strip.removeArrayDeleminators(string);
            boolean bl2 = true;
            object4 = new StringTokenizer(string, "R");
            object3 = new HashMap<String, String>();
            object3.put("T", "x");
            object3.put("TM", "x");
            object3.put("TU", "x");
            object3.put("CA", "x");
            object3.put("R", "x");
            object3.put("V", "x");
            object3.put("RC", "x");
            object3.put("DA", "x");
            object3.put("DV", "x");
            object3.put("JS", "x");
            if (((StringTokenizer)object4).hasMoreTokens()) {
                string2 = this.stripNulls(((StringTokenizer)object4).nextToken().trim() + " R");
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    vector.addElement(this.stripNulls(((StringTokenizer)object4).nextToken().trim() + " R"));
                }
            } else {
                bl2 = false;
            }
            object2 = null;
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            while (bl2) {
                String string4;
                int n2;
                Object object5;
                Object object6;
                Object object7;
                Map map2 = this.currentPdfFile.readObject(new PdfObject(string2), string2, false, (Map)object3);
                Map map3 = (Map)hashMap.get(string2);
                if (map2.containsKey("T")) {
                    if (map2.containsKey("Kids")) {
                        object7 = (String)this.currentPdfFile.resolveToMapOrString("T", map2.get("T"));
                        object6 = (String)map2.get("Parent");
                        while (object6 != null) {
                            Map map4 = this.currentPdfFile.readObject(new PdfObject((String)object6), (String)object6, false, (Map)object3);
                            String string5 = (String)this.currentPdfFile.resolveToMapOrString("T", map4.get("T"));
                            if (string5 == null) continue;
                            object7 = string5 + '.' + (String)object7;
                            object6 = (String)map4.get("Parent");
                        }
                        map2.put("T", object7);
                        hashMap2.put(string2, object7);
                    } else {
                        object7 = map2.get("Parent");
                        if (object7 == null) {
                            map2.put("T", this.currentPdfFile.resolveToMapOrString("T", map2.get("T")));
                        } else {
                            map2.put("T", hashMap2.get(object7) + "." + this.currentPdfFile.resolveToMapOrString("T", map2.get("T")));
                        }
                    }
                    if (this.fdfData != null && (object6 = (String)this.fdfData.get(object7 = (String)map2.get("T"))) != null) {
                        map2.put("V", object6);
                    }
                }
                if (map3 != null) {
                    object7 = map3.keySet().iterator();
                    while (object7.hasNext()) {
                        object6 = object7.next();
                        object5 = map3.get(object6);
                        if (map2.containsKey(object6)) continue;
                        map2.put(object6, object5);
                    }
                }
                boolean bl3 = true;
                object6 = (String)map2.get("FT");
                if (object6 != null && ((String)object6).indexOf("Btn") != -1) {
                    object5 = (String)map2.get("Ff");
                    if (object5 == null) {
                        bl3 = false;
                    } else {
                        int n3 = Integer.parseInt(object5);
                        if ((n3 & 0x10000) != 65536) {
                            bl3 = false;
                        }
                    }
                }
                if ((object5 = (String)map2.get("Kids")) != null) {
                    Object object8 = object5;
                    if (((String)object8).startsWith("[")) {
                        object8 = Strip.removeArrayDeleminators((String)object8).trim();
                    }
                    object2 = new StringTokenizer((String)object8, "R");
                    n2 = bl3 ? 1 : ((StringTokenizer)object2).countTokens();
                } else {
                    n2 = 0;
                }
                String string6 = (String)map2.get("Type");
                if (n2 > 1 || string6 != null && string6.equals("/Annot")) {
                    if (this.currentAcroFormData == null) {
                        this.currentAcroFormData = new PdfFormData(false);
                    }
                    if (n2 == 0) {
                        n2 = 1;
                    }
                    this.currentAcroFormData.incrementCount(n2);
                    if (this.pageCount < 2) {
                        map2.put("PageNumber", "1");
                    }
                    if (map2.containsKey("P")) {
                        try {
                            string4 = map2.get("P");
                            if (string4 != null && this.pageLookup != null && string4 instanceof String) {
                                int n4 = this.pageLookup.convertObjectToPageNumber(string4);
                                map2.put("PageNumber", String.valueOf(n4));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (n2 > 1) {
                        string4 = (String)map2.get("Kids");
                        object2 = new StringTokenizer(Strip.removeArrayDeleminators(string4), "R");
                        HashMap<String, Map> hashMap3 = new HashMap<String, Map>();
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            String string7 = ((StringTokenizer)object2).nextToken().trim() + " R";
                            this.formKids.put(string7, string2);
                            Map map5 = this.currentPdfFile.readObject(new PdfObject(string7), string7, false, (Map)object3);
                            map5.put("PageNumber", "1");
                            String string8 = (String)map2.get("T");
                            if (string8 != null) {
                                map5.put("T", string8);
                            }
                            if (map5.containsKey("P")) {
                                try {
                                    Object v = map5.get("P");
                                    if (v != null && this.pageLookup != null && v instanceof String) {
                                        int n5 = this.pageLookup.convertObjectToPageNumber((String)v);
                                        map5.put("PageNumber", String.valueOf(n5));
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            hashMap3.put(string7, map5);
                        }
                        map2.put("Kids", hashMap3);
                    }
                    map2.put("obj", string2);
                    try {
                        this.currentAcroFormData.addFormElement(map2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (n2 == 1) {
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        string4 = ((StringTokenizer)object2).nextToken().trim() + " R";
                        vector.addElement(string4);
                        map2.remove("Kids");
                        hashMap.put(string4, map2);
                    }
                }
                if (vector.isEmpty()) break;
                string2 = (String)vector.firstElement();
                vector.removeElement(string2);
            }
        }
    }

    private String stripNulls(String string) {
        int n = string.lastIndexOf("null");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 4).trim();
    }

    public final void setRenderMode(int n) {
        renderMode = n;
        extractionMode = n;
    }

    public final void setExtractionMode(int n) {
        extractionMode = n;
    }

    public static void modifyJPedalParameters(Map map) throws PdfException {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k instanceof Integer) {
                Integer n = (Integer)k;
                Object v = map.get(n);
                if (n.equals(JPedalSettings.TEXT_INVERTED_COLOUR)) {
                    if (v instanceof Color) {
                        backgroundColor = (Color)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_INVERTED_COLOUR expects a Color value");
                }
                if (n.equals(JPedalSettings.TEXT_HIGHLIGHT_COLOUR)) {
                    if (v instanceof Color) {
                        highlightColor = (Color)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_HIGHLIGHT_COLOUR expects a Color value");
                }
                if (n.equals(JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS)) {
                    if (v instanceof Boolean) {
                        Boolean bl = (Boolean)v;
                        PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts = bl;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS expects a Boolean value");
                }
                if (n.equals(JPedalSettings.DISPLAY_INVISIBLE_TEXT)) {
                    if (v instanceof Boolean) {
                        Boolean bl = (Boolean)v;
                        PdfStreamDecoder.showInvisibleText = bl;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.DISPLAY_INVISIBLE_TEXT expects a Boolean value");
                }
                if (n.equals(JPedalSettings.CACHE_LARGE_FONTS)) {
                    if (v instanceof Integer) {
                        Integer n2 = (Integer)v;
                        FontData.maxSizeAllowedInMemory = n2;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.CACHE_LARGE_FONTS expects an Integer value");
                }
                if (n.equals(JPedalSettings.IMAGE_UPSCALE)) {
                    int n3 = 0;
                    if (v instanceof Integer) {
                        String string = System.getProperty("org.jpedal.upscale");
                        GLOBAL_IMAGE_UPSCALE = (Integer)v;
                        if (string != null) {
                            try {
                                n3 = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Parameter of \"org.jpedal.upscale\" is not a valid number, the value form the map will be used instead");
                                n3 = 1;
                            }
                            if (n3 != GLOBAL_IMAGE_UPSCALE) {
                                GLOBAL_IMAGE_UPSCALE = (Integer)v;
                                throw new PdfException("JPedalSettings.IMAGE_UPSCALE - second parameter of a different value has already been passed as JVM command");
                            }
                            GLOBAL_IMAGE_UPSCALE = n3;
                        }
                        if (GLOBAL_IMAGE_UPSCALE >= 1) continue;
                        GLOBAL_IMAGE_UPSCALE = 1;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.IMAGE_UPSCALE expects an Integer value");
                }
                if (n.equals(JPedalSettings.IMAGE_HIRES)) {
                    if (v instanceof Boolean) {
                        Boolean bl = (Boolean)v;
                        hires = bl;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.IMAGE_HIRES expects a Boolean value");
                }
                if (n.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY)) {
                    if (v instanceof Boolean) {
                        Boolean bl = (Boolean)v;
                        extAtBestQuality = bl;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY expects a Boolean value");
                }
                throw new PdfException("Unknown or unsupported key " + n);
            }
            throw new PdfException("Unknown or unsupported key (not Integer) " + k);
        }
    }

    public final void markAllPagesAsUnread() {
    }

    public final boolean isForm() {
        return this.isForm;
    }

    public final PdfFormData getPdfFormData() {
        return this.currentAcroFormData;
    }

    protected Map readObjectForPage(PdfObject pdfObject, String string, int n, boolean bl) {
        Map map = this.currentPdfFile.readObject(pdfObject, string, false, null);
        if (this.formsAvailable && this.renderPage && !this.stopDecoding) {
            if (this.formRenderer != null && this.currentAcroFormData != null && !this.stopDecoding) {
                this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation);
                this.formRenderer.createDisplayComponentsForPage(n);
            }
            if (bl) {
                this.lastFormPage = -1;
                this.lastEnd = -1;
                this.lastStart = -1;
            }
        }
        return map;
    }

    public final PdfFileInformation getFileInformationData() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.readPdfFileMetadata(this.XMLObject);
        }
        return null;
    }

    public final void setExtractionMode(int n, int n2, float f) {
        if (dpi % 72 != 0) {
            LogWriter.writeLog("Dpi is not a factor of 72- this may cause problems");
        }
        dpi = n2;
        this.scaling = f;
        this.pageData.setScalingValue(f);
        extractionMode = n;
    }

    public final PdfAnnots decodePageForAnnotations(int n) {
        if (n == this.annotPage) {
            return this.annotsData;
        }
        this.annotsData = null;
        if (n > this.pageCount) {
            LogWriter.writeLog("Page out of bounds");
        } else {
            String string = (String)this.pagesReferences.get(new Integer(n));
            if (string != null) {
                PdfPageObject pdfPageObject = new PdfPageObject(string);
                this.currentPdfFile.readObject(pdfPageObject, string, false, null);
                byte[][] byArray = ((PdfObject)pdfPageObject).getKeyArray(1044338049);
                if (byArray != null) {
                    this.annotsData = new PdfAnnots(this.currentPdfFile, null);
                    this.annotsData.readAnnots(byArray);
                }
                this.annotPage = n;
            }
        }
        return this.annotsData;
    }

    public final BufferedImage getPageAsThumbnail(int n, int n2) {
        DynamicVectorRenderer dynamicVectorRenderer = new DynamicVectorRenderer(n, true, 1000, this.objectStoreRef);
        dynamicVectorRenderer.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
        try {
            if (n > this.pageCount) {
                LogWriter.writeLog("Page " + n + " out of bounds");
            } else {
                int n3 = this.pageData.getMediaBoxX(n);
                int n4 = this.pageData.getMediaBoxY(n);
                int n5 = this.pageData.getMediaBoxWidth(n);
                int n6 = this.pageData.getMediaBoxHeight(n);
                String string = (String)this.pagesReferences.get(new Integer(n));
                if (string != null) {
                    PdfPageObject pdfPageObject = new PdfPageObject(string);
                    this.currentPdfFile.readObject(pdfPageObject, string, false, null);
                    PdfObject pdfObject = ((PdfObject)pdfPageObject).getDictionary(2004251818);
                    if (pdfPageObject != null) {
                        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.useHiResImageForDisplay);
                        pdfStreamDecoder.setExternalImageRender(this.customImageHandler);
                        pdfStreamDecoder.setName(this.filename);
                        pdfStreamDecoder.setStore(this.objectStoreRef);
                        pdfStreamDecoder.init(true, true, renderMode, 0, this.pageData, n, dynamicVectorRenderer, this.currentPdfFile);
                        if (this.globalResources != null) {
                            pdfStreamDecoder.readResources(this.globalResources, true);
                        }
                        if (pdfObject != null) {
                            pdfStreamDecoder.readResources(pdfObject, true);
                        }
                        int n7 = this.pageData.getRotation(n);
                        dynamicVectorRenderer.init(n5, n6, n7);
                        pdfStreamDecoder.decodePageContent(pdfPageObject, n3, n4, null, null);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BufferedImage bufferedImage = this.getImageFromRenderer(n2, dynamicVectorRenderer, n);
        return bufferedImage;
    }

    public void setStatusBarObject(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public void waitForRenderingToFinish() {
        while (this.isDecoding()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public boolean isDecoding() {
        boolean bl = true;
        if (!(this.isDecoding || this.pages.isDecoding() || this.current != null && !this.current.exitedDecoding())) {
            bl = false;
        }
        return bl;
    }

    public final void stopPrinting() {
        this.stopPrinting = true;
    }

    public void stopDecoding() {
        if (this.stopDecoding) {
            return;
        }
        this.pages.stopGeneratingPage();
        this.stopDecoding = true;
        if (this.currentPdfFile != null) {
            this.currentPdfFile.setInterruptRefReading(true);
        }
        if (this.current != null) {
            this.current.terminateDecoding();
        }
        while (this.isDecoding()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.currentPdfFile != null) {
            this.currentPdfFile.setInterruptRefReading(false);
        }
        this.stopDecoding = false;
        if (this.renderPage && this.formsAvailable && this.formRenderer != null) {
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
    }

    public DynamicVectorRenderer getDynamicRenderer() {
        return this.currentDisplay;
    }

    public final void decodePageForMarkedContent(String string, Object object) throws Exception {
        if (!this.stopDecoding) {
            int n = string.indexOf(32) != -1 ? this.pageLookup.convertObjectToPageNumber(string) : Integer.parseInt(string);
            String string2 = (String)this.pagesReferences.get(new Integer(n));
            if (string2 != null && this.currentPdfFile == null) {
                throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
            }
            PdfPageObject pdfPageObject = new PdfPageObject(string2);
            this.currentPdfFile.readObject(pdfPageObject, string2, false, null);
            PdfObject pdfObject = ((PdfObject)pdfPageObject).getDictionary(2004251818);
            if (pdfPageObject != null) {
                PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.useHiResImageForDisplay);
                pdfStreamDecoder.setName(this.filename);
                pdfStreamDecoder.setStore(this.objectStoreRef);
                pdfStreamDecoder.includeImages();
                pdfStreamDecoder.setStatusBar(this.statusBar);
                int n2 = 7;
                if (!this.stopDecoding) {
                    pdfStreamDecoder.init(true, false, renderMode, n2, this.pageData, n, null, this.currentPdfFile);
                    if (this.globalResources != null) {
                        pdfStreamDecoder.readResources(this.globalResources, true);
                    }
                    if (pdfObject != null) {
                        pdfStreamDecoder.readResources(pdfObject, true);
                    }
                }
                pdfStreamDecoder.setMapForMarkedContent(object);
                pdfStreamDecoder.decodePageContent(pdfPageObject, 0, 0, null, null);
            }
        }
    }

    public final void decodeOtherPages(int n) {
        this.pages.decodeOtherPages(this.pageNumber, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decodePage(int n) throws Exception {
        this.lastPageDecoded = n;
        this.decodeStatus = "";
        if (this.displayView != 1) {
            return;
        }
        this.stopDecoding();
        this.currentPdfFile.resetCache();
        if (this.isDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already");
            this.isDecoding = false;
        } else {
            try {
                this.isDecoding = true;
                this.cursorBoxOnScreen = null;
                if (this.renderPage && this.formsAvailable && this.formRenderer != null) {
                    this.formRenderer.removeDisplayComponentsFromScreen();
                    this.lastFormPage = -1;
                }
                this.currentDisplay.flush();
                this.pages.refreshDisplay();
                if (n > this.pageCount || n < 1) {
                    LogWriter.writeLog("Page out of bounds");
                } else if (!this.stopDecoding) {
                    Object object;
                    Timer timer = null;
                    if (this.statusBar != null) {
                        object = new ProgressListener();
                        timer = new Timer(500, (ActionListener)object);
                        timer.start();
                    }
                    this.pageNumber = n;
                    object = (String)this.pagesReferences.get(new Integer(n));
                    if (object != null && this.currentPdfFile == null) {
                        throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    PdfPageObject pdfPageObject = new PdfPageObject((String)object);
                    this.currentPdfFile.readObject(pdfPageObject, (String)object, false, null);
                    PdfObject pdfObject = ((PdfObject)pdfPageObject).getDictionary(2004251818);
                    if (pdfPageObject != null && !this.stopDecoding) {
                        if (!this.showAnnotations || n > 100) {
                            if (this.annotPage != n) {
                                this.annotPage = n;
                                this.annotList = ((PdfObject)pdfPageObject).getKeyArray(1044338049);
                                this.annotsData = null;
                            }
                            if (this.renderPage && !this.stopDecoding) {
                                this.pagesRead.put(new Integer(n), "x");
                                this.annotsData = this.getPdfAnnotsData(this.formRenderer);
                            }
                            if (this.formsAvailable && this.showAnnotations && this.annotsData != null) {
                                this.formRenderer.resetAnnotData(this.annotsData, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
                            }
                        }
                        byte[][] byArray = ((PdfObject)pdfPageObject).getKeyArray(1216184967);
                        if (this.displayHotspots != null && !this.stopDecoding) {
                            this.displayHotspots.flushAnnotationsDisplayed();
                        }
                        if (byArray != null && !this.stopDecoding) {
                            this.current = new PdfStreamDecoder(this.useHiResImageForDisplay);
                            this.current.setExternalImageRender(this.customImageHandler);
                            this.current.setName(this.filename);
                            this.current.setStore(this.objectStoreRef);
                            if (this.includeImages) {
                                this.current.includeImages();
                            }
                            this.current.setStatusBar(this.statusBar);
                            this.currentDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                            if (!this.stopDecoding) {
                                this.current.init(true, this.renderPage, renderMode, extractionMode, this.pageData, n, this.currentDisplay, this.currentPdfFile);
                            }
                            if (this.globalResources != null) {
                                this.current.readResources(this.globalResources, true);
                            }
                            if (pdfObject != null) {
                                this.current.readResources(pdfObject, true);
                            }
                            if (!this.stopDecoding) {
                                this.current.setStatusBar(this.statusBar);
                            }
                            int n2 = this.pageData.getMediaBoxWidth(this.pageNumber);
                            int n3 = this.pageData.getMediaBoxHeight(this.pageNumber);
                            int n4 = this.pageData.getRotation(this.pageNumber);
                            this.currentDisplay.init(n2, n3, n4);
                            if (this.g2 != null) {
                                this.current.setDirectRendering(this.g2);
                            }
                            try {
                                if (!this.stopDecoding) {
                                    this.current.decodePageContent(pdfPageObject, 0, 0, null, null);
                                }
                            }
                            catch (Error error) {
                                this.decodeStatus = this.decodeStatus + "Error in decoding page " + error.toString();
                            }
                            if (!this.stopDecoding) {
                                this.hasEmbeddedFonts = this.current.hasEmbeddedFonts();
                                this.fontsInFile = PdfStreamDecoder.getFontsInFile();
                                this.pdfData = this.current.getText();
                                if (embedWidthData) {
                                    this.pdfData.widthIsEmbedded();
                                }
                                this.pdfData.maxX = n2;
                                this.pdfData.maxY = n3;
                                this.pdfImages = this.current.getImages();
                                this.pageLines = this.current.getPageLines();
                            }
                            this.imagesProcessedFully = this.current.hasAllImages();
                            this.current = null;
                        }
                    }
                    if (timer != null) {
                        timer.stop();
                        this.statusBar.setProgress(100);
                    }
                    this.isDecoding = false;
                    if (this.formsAvailable && this.renderPage && !this.stopDecoding) {
                        if (this.formRenderer != null && !this.formRenderer.ignoreForms()) {
                            this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation);
                            this.formRenderer.createDisplayComponentsForPage(n);
                        }
                        if (this.javascript != null && this.useJavascript && this.formRenderer != null) {
                            this.formRenderer.getActionHandler().PO(this.pageNumber);
                            this.formRenderer.getActionHandler().O(this.pageNumber);
                        }
                        this.validate();
                    }
                    if (this.annotsData != null && this.displayHotspots != null && !this.stopDecoding) {
                        this.displayHotspots.setHotspots(this.annotsData);
                    }
                }
                this.current = null;
                this.currentDisplay.flagDecodingFinished();
            }
            finally {
                this.isDecoding = false;
            }
        }
    }

    public void printAdditionalObjectsOverPage(int n, int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        Integer n2 = new Integer(n);
        if (objectArray == null) {
            this.overlayType.remove(n2);
            this.overlayColors.remove(n2);
            this.overlayObj.remove(n2);
        } else {
            int n3;
            int[] nArray2 = (int[])this.overlayType.get(n2);
            if (nArray2 == null) {
                this.overlayType.put(n2, nArray);
            } else {
                int n4 = nArray2.length;
                n3 = nArray.length;
                int[] nArray3 = new int[n4 + n3];
                System.arraycopy(nArray2, 0, nArray3, 0, n4);
                System.arraycopy(nArray, 0, nArray3, n4, n3);
                this.overlayType.put(n2, nArray3);
            }
            Color[] colorArray2 = (Color[])this.overlayColors.get(n2);
            if (colorArray2 == null) {
                this.overlayColors.put(n2, colorArray);
            } else {
                n3 = colorArray2.length;
                int n5 = colorArray.length;
                Color[] colorArray3 = new Color[n3 + n5];
                System.arraycopy(colorArray2, 0, colorArray3, 0, n3);
                System.arraycopy(colorArray, 0, colorArray3, n3, n5);
                this.overlayColors.put(n2, colorArray3);
            }
            Object[] objectArray2 = (Object[])this.overlayObj.get(n2);
            if (nArray2 == null) {
                this.overlayObj.put(n2, objectArray);
            } else {
                int n6 = objectArray2.length;
                int n7 = objectArray.length;
                Object[] objectArray3 = new Object[n6 + n7];
                System.arraycopy(objectArray2, 0, objectArray3, 0, n6);
                System.arraycopy(objectArray, 0, objectArray3, n6, n7);
                this.overlayObj.put(n2, objectArray3);
            }
        }
    }

    public void printAdditionalObjectsOverAllPages(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        Integer n = new Integer(-1);
        if (objectArray == null) {
            this.overlayTypeG.remove(n);
            this.overlayColorsG.remove(n);
            this.overlayObjG.remove(n);
        } else {
            int n2;
            int[] nArray2 = (int[])this.overlayTypeG.get(n);
            if (nArray2 == null) {
                this.overlayTypeG.put(n, nArray);
            } else {
                int n3 = nArray2.length;
                n2 = nArray.length;
                int[] nArray3 = new int[n3 + n2];
                System.arraycopy(nArray2, 0, nArray3, 0, n3);
                System.arraycopy(nArray, 0, nArray3, n3, n2);
                this.overlayTypeG.put(n, nArray3);
            }
            Color[] colorArray2 = (Color[])this.overlayColorsG.get(n);
            if (colorArray2 == null) {
                this.overlayColorsG.put(n, colorArray);
            } else {
                n2 = colorArray2.length;
                int n4 = colorArray.length;
                Color[] colorArray3 = new Color[n2 + n4];
                System.arraycopy(colorArray2, 0, colorArray3, 0, n2);
                System.arraycopy(colorArray, 0, colorArray3, n2, n4);
                this.overlayColorsG.put(n, colorArray3);
            }
            Object[] objectArray2 = (Object[])this.overlayObjG.get(n);
            if (nArray2 == null) {
                this.overlayObjG.put(n, objectArray);
            } else {
                int n5 = objectArray2.length;
                int n6 = objectArray.length;
                Object[] objectArray3 = new Object[n5 + n6];
                System.arraycopy(objectArray2, 0, objectArray3, 0, n5);
                System.arraycopy(objectArray, 0, objectArray3, n5, n6);
                this.overlayObjG.put(n, objectArray3);
            }
        }
    }

    public void drawAdditionalObjectsOverPage(int n, int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        if (n == this.pageNumber) {
            this.currentDisplay.drawAdditionalObjectsOverPage(nArray, colorArray, objectArray);
        }
        this.pages.refreshDisplay();
    }

    public void flushAdditionalObjectsOnPage(int n) throws PdfException {
        if (n == this.pageNumber) {
            this.currentDisplay.flushAdditionalObjOnPage();
        }
        this.pages.refreshDisplay();
    }

    public void useHiResScreenDisplay(boolean bl) {
        this.useHiResImageForDisplay = bl;
    }

    public final void decodePageInBackground(int n) throws Exception {
        if (this.isBackgroundDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in background");
        } else {
            this.isBackgroundDecoding = true;
            if (n > this.pageCount) {
                LogWriter.writeLog("Page out of bounds");
            } else {
                String string = (String)this.pagesReferences.get(new Integer(n));
                if (string != null) {
                    if (this.currentPdfFile == null) {
                        throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    PdfPageObject pdfPageObject = new PdfPageObject(string);
                    this.currentPdfFile.readObject(pdfPageObject, string, false, null);
                    PdfObject pdfObject = ((PdfObject)pdfPageObject).getDictionary(2004251818);
                    if (pdfPageObject != null) {
                        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder();
                        pdfStreamDecoder.setExternalImageRender(this.customImageHandler);
                        pdfStreamDecoder.setName(this.filename);
                        pdfStreamDecoder.setStore(this.backgroundObjectStoreRef);
                        pdfStreamDecoder.init(true, false, 0, extractionMode, this.pageData, n, null, this.currentPdfFile);
                        if (this.globalResources != null) {
                            pdfStreamDecoder.readResources(this.globalResources, true);
                        }
                        if (pdfObject != null) {
                            pdfStreamDecoder.readResources(pdfObject, true);
                        }
                        pdfStreamDecoder.decodePageContent(pdfPageObject, 0, 0, null, null);
                        this.pdfBackgroundData = pdfStreamDecoder.getText();
                        if (embedWidthData) {
                            this.pdfBackgroundData.widthIsEmbedded();
                        }
                        int n2 = this.pageData.getMediaBoxWidth(n);
                        int n3 = this.pageData.getMediaBoxHeight(n);
                        this.pdfBackgroundData.maxX = n2;
                        this.pdfBackgroundData.maxY = n3;
                        this.pdfBackgroundImages = pdfStreamDecoder.getImages();
                    }
                }
            }
            this.isBackgroundDecoding = false;
        }
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final boolean isEncrypted() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isEncrypted();
        }
        return false;
    }

    public final boolean isPasswordSupplied() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isPasswordSupplied();
        }
        return false;
    }

    public boolean isFileViewable() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isFileViewable();
        }
        return false;
    }

    public boolean isExtractionAllowed() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isExtractionAllowed();
        }
        return false;
    }

    public int getPDFflag(Integer n) {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.getPDFflag(n);
        }
        return -1;
    }

    private void verifyAccess() {
        if (this.currentPdfFile != null) {
            try {
                this.openPdfFile();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " opening file");
            }
        }
    }

    public final void setDefaultDisplayFont(String string) throws PdfFontException {
        boolean bl = false;
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].toLowerCase().equals(string.toLowerCase())) continue;
            bl = true;
            defaultFont = stringArray[i];
            i = n;
        }
        if (!bl) {
            throw new PdfFontException("Font " + string + " is not available.");
        }
    }

    public final void setEncryptionPassword(String string) throws PdfException {
        if (this.currentPdfFile == null) {
            throw new PdfException("Must open PdfDecoder file first");
        }
        this.currentPdfFile.setEncryptionPassword(string);
        this.verifyAccess();
    }

    public final void openPdfArray(byte[] byArray) throws PdfException {
        LogWriter.writeMethod("{openPdfArray}", 0);
        this.globalResources = null;
        this.pagesReferences.clear();
        try {
            this.currentPdfFile = new PdfReader();
            this.currentPdfFile.openPdfFile(byArray);
            this.openPdfFile();
            if (this.stopDecoding) {
                this.closePdfFile();
            }
            this.objectStoreRef.storeFileName("r" + System.currentTimeMillis());
        }
        catch (Exception exception) {
            throw new PdfException("[PDF] OpenPdfArray generated exception " + exception.getMessage());
        }
    }

    public final void openPdfFile(String string) throws PdfException {
        this.displayScaling = null;
        LogWriter.writeMethod("{openPdfFile " + string + '}', 0);
        this.filename = string;
        this.globalResources = null;
        this.pagesReferences.clear();
        this.objectStoreRef.storeFileName(string);
        this.currentPdfFile = new PdfReader();
        if (!this.stopDecoding) {
            this.currentPdfFile.openPdfFile(string);
        }
        if (!this.stopDecoding) {
            this.openPdfFile();
        }
        if (this.stopDecoding) {
            this.closePdfFile();
        }
    }

    public final void openPdfFile(String string, String string2) throws PdfException {
        this.displayScaling = null;
        LogWriter.writeMethod("{openPdfFile " + string + '}', 0);
        this.filename = string;
        this.globalResources = null;
        this.pagesReferences.clear();
        this.objectStoreRef.storeFileName(string);
        this.currentPdfFile = new PdfReader(string2);
        if (!this.stopDecoding) {
            this.currentPdfFile.openPdfFile(string);
        }
        if (!this.stopDecoding) {
            this.openPdfFile();
        }
        if (this.stopDecoding) {
            this.closePdfFile();
        }
    }

    public final void openPdfFileFromURL(String string) throws PdfException {
        LogWriter.writeMethod("{openPdfFileFromURL " + string + '}', 0);
        this.displayScaling = null;
        this.globalResources = null;
        this.pagesReferences.clear();
        if (this.download == null) {
            this.download = new JFrame();
            this.p = new JPanel(new GridBagLayout());
            this.pb = new JProgressBar();
            this.downloadMessage = new JLabel();
            this.downloadFile = new JLabel();
            this.saveLocal = new JButton("Save Local");
        }
        try {
            int n;
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            String string2 = uRL.getPath().substring(uRL.getPath().lastIndexOf(47) + 1);
            this.tempURLFile = File.createTempFile(string2.substring(0, string2.lastIndexOf(46)), string2.substring(string2.lastIndexOf(46)));
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempURLFile);
            if (!this.downloadCreated) {
                this.createDownloadWindow();
            }
            int n2 = uRL.openConnection().getContentLength();
            this.pb.setMinimum(0);
            this.pb.setMaximum(n2);
            this.saveLocal.setEnabled(false);
            this.downloadFile.setText("Downloading file " + string2);
            byte[] byArray = new byte[4096];
            int n3 = 0;
            String string3 = "kb";
            int n4 = 1000;
            if (n2 > 1000000) {
                string3 = "mb";
                n4 = 1000000;
            }
            while ((n = inputStream.read(byArray)) != -1) {
                n3 += n;
                this.downloadCount += n;
                if (n2 < 1000000) {
                    this.downloadMessage.setText("Downloaded " + n3 / n4 + "" + string3 + " of " + n2 / n4 + " " + string3);
                } else {
                    this.downloadMessage.setText("Downloaded " + n3 / n4 + "." + n3 % n4 / 10000 + " " + string3 + " of " + n2 / n4 + "." + n2 % n4 / 10000 + " " + string3);
                }
                this.pb.setValue(n3);
                this.download.repaint();
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            inputStream.close();
            fileOutputStream.close();
            this.downloadMessage.setText("Download of " + string2 + " is complete.");
            this.saveLocal.setEnabled(true);
        }
        catch (IOException iOException) {
            LogWriter.writeLog("[PDF] Exception " + iOException + " opening URL " + string);
            iOException.printStackTrace();
        }
        this.currentPdfFile = new PdfReader();
        this.openPdfFile(this.tempURLFile.getAbsolutePath());
        this.objectStoreRef.storeFileName(this.tempURLFile.getName().substring(0, this.tempURLFile.getName().lastIndexOf(46)));
        if (this.stopDecoding) {
            this.closePdfFile();
        }
    }

    private void createDownloadWindow() {
        if (this.download == null) {
            this.download = new JFrame();
            this.p = new JPanel(new GridBagLayout());
            this.pb = new JProgressBar();
            this.downloadMessage = new JLabel();
            this.downloadFile = new JLabel();
            this.saveLocal = new JButton("Save Local");
        }
        this.download.setResizable(false);
        this.download.setTitle("Download");
        this.saveLocal.setEnabled(false);
        this.saveLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileFilterer fileFilterer = new FileFilterer(new String[]{".pdf"}, ".pdf");
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(fileFilterer);
                int n = jFileChooser.showSaveDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (file.exists()) {
                        file.delete();
                    }
                    if (!file.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
                        file = new File(file.getAbsolutePath() + ".pdf");
                    }
                    try {
                        file.createNewFile();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        FileInputStream fileInputStream = new FileInputStream(PdfDecoder.this.tempURLFile);
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        byte[] byArray = new byte[1024];
                        int n2 = 0;
                        while ((n2 = fileInputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n2);
                        }
                        fileInputStream.close();
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        BoxLayout boxLayout = new BoxLayout(this.p, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.downloadFile.setSize(250, this.downloadFile.getHeight());
        this.downloadFile.setMinimumSize(new Dimension(250, 15));
        this.downloadFile.setMaximumSize(new Dimension(250, 15));
        this.downloadFile.setPreferredSize(new Dimension(250, 15));
        this.p.add((Component)this.downloadFile, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.downloadMessage.setSize(250, this.downloadFile.getHeight());
        this.downloadMessage.setMinimumSize(new Dimension(250, 15));
        this.downloadMessage.setMaximumSize(new Dimension(250, 15));
        this.downloadMessage.setPreferredSize(new Dimension(250, 15));
        this.p.add((Component)this.downloadMessage, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.pb.setSize(260, this.downloadFile.getHeight());
        this.pb.setMinimumSize(new Dimension(260, 20));
        this.pb.setMaximumSize(new Dimension(260, 20));
        this.pb.setPreferredSize(new Dimension(260, 20));
        this.p.add((Component)this.pb, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        this.p.add((Component)this.saveLocal, gridBagConstraints);
        this.download.getContentPane().add(this.p);
        this.download.setSize(360, 100);
        this.downloadCreated = true;
    }

    private void openPdfFile() throws PdfException {
        Object object;
        Object object2;
        Object object3;
        this.isOpen = false;
        LogWriter.writeMethod("{openPdfFile}", 0);
        boolean bl = this.stopDecoding;
        this.stopDecoding();
        this.stopDecoding = bl;
        this.pageNumber = 1;
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
        this.annotPage = -1;
        if (this.filename != null && this.filename.toLowerCase().endsWith(".fdf")) {
            int n = this.filename.lastIndexOf(47);
            if (n == -1) {
                n = this.filename.lastIndexOf(92);
            }
            object3 = "";
            if (n != -1) {
                object3 = this.filename.substring(0, n + 1);
            }
            if ((object2 = this.currentPdfFile.getByteTextStringValue((object = this.currentPdfFile.readFDF()).get("F"), this.fdfData)) != null) {
                this.filename = (String)object3 + this.currentPdfFile.getTextString((byte[])object2);
            }
            this.objectStoreRef.storeFileName(this.filename);
            this.currentPdfFile.openPdfFile(this.filename);
            this.fdfData = (Map)object.get("Fields");
        } else {
            this.fdfData = null;
        }
        try {
            this.isDecoding = true;
            this.pages.resetCachedValues();
            if (this.hasViewListener) {
                this.pages.flushPageCaches();
                this.removeComponentListener(this.viewListener);
            }
            if (!this.stopDecoding) {
                this.currentPdfFile.setCacheSize(this.minimumCacheSize);
                this.lastPrintedPage = -1;
                this.currentPrintDecoder = null;
                if (this.javascript != null) {
                    this.javascript.reset();
                }
                if (this.formsAvailable && this.formRenderer != null) {
                    this.formRenderer.getCompData().setRootDisplayComponent(this);
                    this.formRenderer.removeDisplayComponentsFromScreen();
                }
            }
            if (!this.stopDecoding) {
                this.pageData = new PdfPageData();
                this.pdfVersion = this.currentPdfFile.getType();
                LogWriter.writeLog("Pdf version : " + this.pdfVersion);
                if (this.pdfVersion == null) {
                    this.currentPdfFile = null;
                    this.isDecoding = false;
                    throw new PdfException("No version on first line ");
                }
                if (this.pdfVersion.indexOf("1.5") != -1) {
                    LogWriter.writeLog("Please note Pdf version 1.5  some features not fully supported ");
                } else if (this.pdfVersion.indexOf("1.6") != -1) {
                    LogWriter.writeLog("Please note Pdf version 1.6  new features not fully supported ");
                }
                LogWriter.writeMethod("{about to read ref table}", 0);
            }
            String string = null;
            if (!this.stopDecoding) {
                string = this.currentPdfFile.readReferenceTable();
            }
            object3 = null;
            if (!this.stopDecoding) {
                LogWriter.writeMethod("{about to read catalog}", 0);
                if (string != null) {
                    object3 = this.currentPdfFile.readObject(new PdfObject(string), string, false, null);
                }
            }
            if (!(this.stopDecoding || this.isEncrypted() && !this.isPasswordSupplied())) {
                this.XMLObject = (String)object3.get("Metadata");
                object = (String)object3.get("Pages");
                LogWriter.writeMethod("{about to read pages} " + (String)object, 0);
                if (object == null && (object2 = (Object)object3.get("Type")) != null && object2.equals("/Page")) {
                    object = string;
                }
                if (this.stopDecoding) {
                    return;
                }
                if (object != null) {
                    LogWriter.writeLog("Pages being read " + (String)object);
                    this.pageNumber = 1;
                    this.pageLookup = new PageLookup();
                    if (this.formRenderer != null) {
                        this.formRenderer.resetAnnotData(null, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
                    }
                    this.readAllPageReferences((String)object, new HashMap(), new HashMap());
                    this.pageCount = this.pageNumber - 1;
                    this.pageNumber = 0;
                    if (this.pageCount == 0) {
                        LogWriter.writeLog("No pages found");
                    }
                }
                this.setJavascript();
                if (!this.stopDecoding) {
                    object2 = null;
                    try {
                        object2 = object3.get("Names");
                        if (object2 != null) {
                            this.currentPdfFile.readNames(object2, this.javascript);
                        }
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception reading Names object " + object2 + ' ' + this.objectStoreRef.fullFileName);
                    }
                }
                if (!this.stopDecoding) {
                    this.isXFA = false;
                    this.outlineObject = object3.get("Outlines");
                    this.outlineData = null;
                    this.hasOutline = this.outlineObject != null;
                    object2 = object3.get("AcroForm");
                    if (object2 != null) {
                        this.readAcroForm(object2);
                        this.isForm = true;
                    } else {
                        this.isForm = false;
                        this.currentAcroFormData = null;
                    }
                    Object v = object3.get("StructTreeRoot");
                    Map map = null;
                    Map map2 = null;
                    if (v != null) {
                        map2 = v instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)v), (String)v, false, null) : (Map)v;
                    }
                    if ((v = object3.get("MarkInfo")) != null) {
                        map = v instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)v), (String)v, false, null) : (Map)v;
                    }
                    this.content.setRootValues(map2, map);
                    if (this.formsAvailable && this.formRenderer != null) {
                        this.formRenderer.openFile(this.pageCount);
                        this.formRenderer.resetFormData(this.currentAcroFormData, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
                    }
                }
            }
            this.currentOffset = null;
            this.pages.disableScreen();
            if (!this.stopDecoding) {
                this.pages.stopGeneratingPage();
            }
            this.displayView = this.pageCount < 2 ? 1 : this.pageMode;
            this.setDisplayView(this.displayView, this.alignment);
            this.isOpen = true;
        }
        catch (PdfException pdfException) {
            this.isDecoding = false;
            throw new PdfException(pdfException.getMessage() + " opening file");
        }
        this.isDecoding = false;
    }

    public void setPageMode(int n) {
        this.pageMode = n;
    }

    public Javascript getJavascript() {
        return this.javascript;
    }

    private void setJavascript() {
        if (this.javascript == null && this.useJavascript) {
            this.javascript = new Javascript();
        }
        if (this.javascript != null) {
            this.javascript.setUserExpressionEngine((ExpressionEngine)this.userExpressionEngine);
        }
        this.formRenderer.setJavaScriptObject(this.javascript, this.userExpressionEngine);
        this.javascript.setRenderer(this.formRenderer);
        if (this.currentPdfFile != null) {
            this.currentPdfFile.setJavaScriptObject(this.javascript);
        }
    }

    private void readAllPageReferences(String string, Map map, Map map2) {
        Object object;
        LogWriter.writeMethod("{readAllPageReferences " + string + '}', 0);
        int n = 0;
        PdfPageObject pdfPageObject = new PdfPageObject(string);
        this.currentPdfFile.readObject(pdfPageObject, string, false, null);
        int n2 = ((PdfObject)pdfPageObject).getParameterConstant(608780341);
        if (n2 == -1) {
            n2 = 825701731;
        }
        int n3 = ((PdfObject)pdfPageObject).getInt(1144088180);
        String string2 = pdfPageObject.getStringKey(1110793845);
        if (n3 == -1) {
            while (string2 != null && n3 == -1) {
                if (string2 != null && (object = map.get(string2)) != null) {
                    n3 = (Integer)object;
                }
                if (n3 != -1) continue;
                string2 = (String)map2.get(string2);
            }
            if (n3 != -1) {
                map.put(string, new Integer(n3));
                map2.put(string, string2);
            }
        } else {
            map.put(string, new Integer(n3));
            map2.put(string, string2);
        }
        if (n3 != -1) {
            n = n3;
        }
        this.pageData.setPageRotation(n, this.pageNumber);
        object = ((PdfObject)pdfPageObject).getFloatArray(1313305473);
        float[] fArray = ((PdfObject)pdfPageObject).getFloatArray(1076199815);
        if (object != null) {
            this.pageData.setMediaBox((float[])object);
        }
        if (fArray != null) {
            this.pageData.setCropBox(fArray);
        }
        if (this.stopDecoding) {
            return;
        }
        if (n2 == 825701731) {
            this.globalResources = ((PdfObject)pdfPageObject).getDictionary(2004251818);
            byte[][] byArray = ((PdfObject)pdfPageObject).getKeyArray(456733763);
            int n4 = 0;
            if (byArray != null) {
                n4 = byArray.length;
            }
            if (n4 > 0) {
                for (int i = 0; i < n4; ++i) {
                    this.readAllPageReferences(new String(byArray[i]), map, map2);
                }
            }
        } else if (n2 == 540096309) {
            byte[][] byArray;
            this.pagesReferences.put(new Integer(this.pageNumber), string);
            this.pageLookup.put(string, this.pageNumber);
            this.pageData.checkSizeSet(this.pageNumber);
            if (this.formRenderer != null && this.pageNumber < 101 && (byArray = ((PdfObject)pdfPageObject).getKeyArray(1044338049)) != null) {
                PdfAnnots pdfAnnots = null;
                try {
                    if (byArray != null) {
                        pdfAnnots = new PdfAnnots(this.currentPdfFile, "" + this.pageNumber);
                        pdfAnnots.readAnnots(byArray);
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("[PDF] " + exception + " with annotation");
                }
                if (this.formsAvailable && this.showAnnotations && pdfAnnots != null) {
                    this.formRenderer.resetAnnotData(pdfAnnots, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
                }
            }
            ++this.pageNumber;
        }
    }

    private static ArrayList getDirectoryMatches(String string) throws IOException {
        string = string.replaceAll("\\.", "/");
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        ArrayList<String> arrayList = new ArrayList<String>(0);
        String string2 = uRL.toString();
        System.out.println("scanning " + string2);
        if (string2.startsWith("jar:") && string2.endsWith(string)) {
            int n = string2.lastIndexOf(string);
            string2 = string2.substring(0, n);
            System.out.println("entry= " + string2);
            URL uRL2 = new URL(string2);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!(!jarEntry.isDirectory() & jarEntry.getName().startsWith(string))) continue;
                String string3 = jarEntry.getName();
                int n2 = string3.lastIndexOf(47);
                string3 = string3.substring(n2 + 1);
                arrayList.add(string3);
            }
        } else {
            LogWriter.writeLog("Path: " + string2);
        }
        return arrayList;
    }

    private static ArrayList readIndirectValues(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>(0);
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList;
    }

    public boolean addSubstituteFonts(String string, boolean bl) {
        boolean bl2 = false;
        try {
            String[] stringArray = new String[]{"tt", "t1c", "t1"};
            String[] stringArray2 = new String[]{"/TrueType", "/Type1C", "/Type1"};
            enforceFontSubstitution = bl;
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string);
            LogWriter.writeLog("Looking for root " + string);
            if (inputStream != null) {
                LogWriter.writeLog("Adding fonts fonts found in  tt,t1c,t1 sub-directories of " + string);
                bl2 = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2;
                    if (!string.endsWith("/")) {
                        string = string + '/';
                    }
                    if ((inputStream = classLoader.getResourceAsStream(string2 = string + stringArray[i] + '/')) == null) continue;
                    System.out.println("Found  " + string2 + ' ' + inputStream);
                    try {
                        String string3;
                        ArrayList arrayList = inputStream instanceof ByteArrayInputStream ? PdfDecoder.readIndirectValues(inputStream) : PdfDecoder.getDirectoryMatches(string2);
                        int n = arrayList.size();
                        for (int j = 0; j < n && (string3 = (String)arrayList.get(j)) != null; ++j) {
                            int n2 = string3.indexOf(46);
                            String string4 = n2 == -1 ? string3 : string3.substring(0, n2);
                            FontMappings.fontSubstitutionTable.put(string4.toLowerCase(), stringArray2[i]);
                            FontMappings.fontSubstitutionLocation.put(string4.toLowerCase(), string2 + string3);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " reading substitute fonts");
                        System.out.println("Exception " + exception + " reading substitute fonts");
                    }
                }
            } else {
                LogWriter.writeLog("No fonts found at " + string);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception adding substitute fonts " + exception.getMessage());
        }
        return bl2;
    }

    public Map getUserIconsForAnnotations() {
        return this.userAnnotIcons;
    }

    public void addUserIconsForAnnotations(int n, String string, Image[] imageArray) {
        if (this.userAnnotIcons == null) {
            this.userAnnotIcons = new Hashtable();
        }
        this.userAnnotIcons.put(n + "-" + string, imageArray);
        if (this.displayHotspots == null) {
            this.displayHotspots = new Hotspots();
            this.printHotspots = new Hotspots();
        }
        this.displayHotspots.checkType(string);
        this.printHotspots.checkType(string);
    }

    public void createPageHostspots(String[] stringArray, String string) {
        this.displayHotspots = new Hotspots(stringArray, string);
        this.printHotspots = new Hotspots(stringArray, string);
    }

    public void setThumbnailsDrawing(boolean bl) {
        this.thumbnailsBeingDrawn = bl;
        this.pages.setThumbnailsDrawing(bl);
    }

    public void showImageableArea() {
        this.showImageable = true;
    }

    public int getNumberOfPages() {
        if (this.range != null) {
            int n = 0;
            for (int i = 1; i < this.pageCount + 1; ++i) {
                if (!this.range.contains(i) || this.oddPagesOnly && (i & 1) != 1 || this.evenPagesOnly && (i & 1) != 0) continue;
                ++n;
            }
            return n;
        }
        int n = 1;
        if (this.end != -1 && (n = this.end - this.start + 1) < 0) {
            n = 2 - n;
        }
        if (this.oddPagesOnly || this.evenPagesOnly) {
            return (n + 1) / 2;
        }
        return n;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        int n2 = this.end == -1 ? n + 1 : (this.end > this.start ? this.start + n : this.start - n);
        Object v = this.pageFormats.get(new Integer(n2));
        if (debugPrint) {
            System.out.println("======================================================\nspecific for page=" + v + " Get page format for page p=" + n + " start=" + this.start + " pf=" + this.pageFormats + ' ' + this.pageFormats.keySet());
        }
        if (v == null) {
            v = this.pageFormats.get("standard");
        }
        PageFormat pageFormat = new PageFormat();
        if (v != null) {
            pageFormat = (PageFormat)v;
        }
        if (this.usePDFPaperSize) {
            int n3 = this.pageData.getCropBoxWidth(n2);
            int n4 = this.pageData.getCropBoxHeight(n2);
            this.createCustomPaper(pageFormat, n3, n4);
        }
        if (!this.isPrintAutoRotateAndCenter) {
            pageFormat.setOrientation(1);
        }
        if (debugPrint) {
            System.out.println("Page format used=" + pageFormat);
            System.out.println("Orientation=" + pageFormat.getOrientation());
            System.out.println("Width=" + pageFormat.getWidth() + " imageableW=" + pageFormat.getImageableWidth());
            System.out.println("Height=" + pageFormat.getHeight() + " imageableH=" + pageFormat.getImageableHeight());
        }
        return pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public void setPageFormat(int n, PageFormat pageFormat) {
        if (debugPrint) {
            System.out.println("Set page format for page " + n);
        }
        this.pageFormats.put(new Integer(n), pageFormat);
    }

    public void setPageFormat(PageFormat pageFormat) {
        if (debugPrint) {
            System.out.println("Set page format Standard for page");
            System.out.println("---------------------------------");
            System.out.println("Page format used=" + pageFormat);
            System.out.println("Orientation=" + pageFormat.getOrientation());
            System.out.println("Width=" + pageFormat.getWidth() + " imageableW=" + pageFormat.getImageableWidth());
            System.out.println("Height=" + pageFormat.getHeight() + " imageableH=" + pageFormat.getImageableHeight());
            System.out.println("---------------------------------");
        }
        this.pageFormats.put("standard", pageFormat);
    }

    public static boolean isXMLExtraction() {
        return isXMLExtraction;
    }

    public static void useTextExtraction() {
        isXMLExtraction = false;
    }

    public static void useXMLExtraction() {
        isXMLExtraction = true;
    }

    public void clearScreen() {
        this.currentDisplay.flush();
        this.pages.refreshDisplay();
    }

    public void setStreamCacheSize(int n) {
        this.minimumCacheSize = n;
    }

    public void addImage(BufferedImage bufferedImage) {
        this.currentDisplay.drawImage(bufferedImage);
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public Map resolveFormReference(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("T", "x");
        hashMap.put("TM", "x");
        hashMap.put("TU", "x");
        hashMap.put("CA", "x");
        hashMap.put("R", "x");
        hashMap.put("V", "x");
        hashMap.put("RC", "x");
        hashMap.put("DA", "x");
        hashMap.put("DV", "x");
        return this.currentPdfFile.readObject(new PdfObject(string), string, false, hashMap);
    }

    public final boolean PDFContainsEmbeddedFonts() throws Exception {
        boolean bl = false;
        for (int i = 1; i < this.pageCount + 1; ++i) {
            String string = (String)this.pagesReferences.get(new Integer(i));
            if (string == null) continue;
            PdfPageObject pdfPageObject = new PdfPageObject(string);
            Map map = this.currentPdfFile.readObject(pdfPageObject, string, false, null);
            PdfObject pdfObject = ((PdfObject)pdfPageObject).getDictionary(2004251818);
            String string2 = (String)map.get("Contents");
            if (string2 == null) continue;
            PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder();
            pdfStreamDecoder.setExternalImageRender(this.customImageHandler);
            pdfStreamDecoder.init(true, this.renderPage, renderMode, extractionMode, this.pageData, i, this.currentDisplay, this.currentPdfFile);
            if (this.globalResources != null) {
                pdfStreamDecoder.readResources(this.globalResources, true);
            }
            if (pdfObject != null) {
                pdfStreamDecoder.readResources(pdfObject, true);
            }
            if (!(bl = pdfStreamDecoder.hasEmbeddedFonts())) continue;
            i = this.pageCount;
        }
        return bl;
    }

    public String getFontsInFile() {
        if (this.fontsInFile == null) {
            return "No fonts defined";
        }
        return this.fontsInFile;
    }

    public void includeImagesInStream() {
        this.includeImages = true;
    }

    public PageLines getPageLines() {
        return this.pageLines;
    }

    public void setEnableLegacyJPEGConversion(boolean bl) {
        use13jPEGConversion = bl;
    }

    public AcroRenderer getFormRenderer() {
        if (!this.formsAvailable) {
            return null;
        }
        return this.formRenderer;
    }

    public boolean isPageSuccessful() {
        return this.operationSuccessful;
    }

    public String getPageDecodeReport() {
        return this.decodeStatus;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public BufferedImage getSelectedRectangleOnscreen(float f, float f2, float f3, float f4, float f5) {
        int n = this.pageData.getMediaBoxHeight(this.pageNumber);
        int n2 = this.pageData.getCropBoxWidth(this.pageNumber);
        int n3 = this.pageData.getCropBoxHeight(this.pageNumber);
        int n4 = this.pageData.getCropBoxX(this.pageNumber);
        int n5 = this.pageData.getCropBoxY(this.pageNumber);
        if (f4 < (float)n5) {
            f4 = n5;
        }
        if (f < (float)n4) {
            f = n4;
        }
        if (f2 > (float)(n3 + n5)) {
            f2 = n3 + n5;
        }
        if (f3 > (float)(n4 + n2)) {
            f3 = n4 + n2;
        }
        if (f3 - f < 1.0f || f2 - f4 < 1.0f) {
            return null;
        }
        float f6 = f5 / 100.0f;
        float f7 = f3 - f;
        float f8 = f2 - f4;
        BufferedImage bufferedImage = new BufferedImage((int)(f7 * f6), (int)(f8 * f6), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (n5 > 0) {
            n5 = n - n3 - n5;
        }
        AffineTransform affineTransform = this.getScalingForImage(this.pageNumber, 0, f6);
        int n6 = -n4;
        int n7 = -n5;
        affineTransform.translate(n6, -n7);
        affineTransform.translate(-(f - (float)n4), (float)n - f2 - (float)n5);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        graphics2D.transform(affineTransform);
        if (this.currentDisplay.addBackground()) {
            graphics2D.setColor(this.currentDisplay.getBackgroundColor());
            graphics2D.fill(new Rectangle(n4, n5, n2, n3));
        }
        this.currentDisplay.setOptimsePainting(true);
        this.currentDisplay.paint(graphics2D, null, null, null, false, false);
        if (this.formsAvailable && this.formRenderer != null) {
            this.formRenderer.getCompData().renderFormsOntoG2(graphics2D, this.pageNumber, f5, 0, this.displayRotation);
            this.formRenderer.getCompData().resetScaledLocation(this.oldScaling, this.displayRotation, 0);
        }
        if (!this.showAnnotations && this.annotsData != null && this.displayHotspots != null) {
            this.displayHotspots.setHotspots(this.annotsData);
        }
        graphics2D.setTransform(affineTransform2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStoreRef = objectStore;
    }

    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        PdfData pdfData = this.getPdfData();
        if (pdfData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(pdfData);
    }

    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        PdfData pdfData = this.pdfBackgroundData;
        if (pdfData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(pdfData);
    }

    public final String getPDFVersion() {
        return this.pdfVersion;
    }

    public Map resolveToMapOrString(String string, Object object) {
        Map map = null;
        if (object instanceof Map) {
            map = (Map)((Map)object).get(string);
        }
        if (map == null) {
            return (Map)this.currentPdfFile.resolveToMapOrString(string, object);
        }
        return map;
    }

    public void resetForNonPDFPage() {
        this.displayScaling = null;
        this.currentDisplay.setHiResImageForDisplayMode(false);
        this.fontsInFile = "";
        this.pageCount = 1;
        this.hasOutline = false;
        if (this.formsAvailable && this.formRenderer != null) {
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
        this.pageData = new PdfPageData();
    }

    public static void setDebugPrint(boolean bl) {
        debugPrint = bl;
    }

    public void setDisplayView(int n, int n2) {
        boolean bl;
        this.alignment = n2;
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        boolean bl2 = bl = n != 1 || this.displayView != 1;
        if (bl && (this.displayView == 3 || n == 3)) {
            bl = false;
        }
        if (n != 1) {
            bl = true;
        }
        boolean bl3 = n != this.displayView;
        this.displayView = n;
        if (n == 1) {
            this.pages = new SingleDisplay(this.pageNumber, this.pageCount, this.currentDisplay);
        } else {
            this.currentHighlightedObject = null;
            if (bl) {
                this.setPageRotation(this.displayRotation);
                this.pages = new MultiDisplay(this.pageNumber, this.pageCount, null, n, this.customSwingHandle);
            } else {
                this.pages = new MultiDisplay(this.pageNumber, this.pageCount, this.currentDisplay, n, this.customSwingHandle);
            }
        }
        if (this.hasViewListener) {
            this.hasViewListener = false;
            this.removeComponentListener(this.viewListener);
        }
        if (this.currentOffset == null) {
            this.currentOffset = new PageOffsets(this.pageCount, this.pageData);
        }
        this.pages.setup(this.useAcceleration, this.currentOffset, this);
        this.pages.init(this.scaling, this.pageCount, this.displayRotation, this.pageNumber, this.currentDisplay, true, this.pageData, this.insetW, this.insetH);
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
        this.pages.refreshDisplay();
        this.updateUI();
        if (!this.hasViewListener) {
            this.hasViewListener = true;
            this.addComponentListener(this.viewListener);
        }
        if (this.pageNumber > 0) {
            if (bl3 && n == 1) {
                try {
                    this.unsetScaling();
                    this.setPageParameters(this.scaling, this.pageNumber, this.displayRotation);
                    this.invalidate();
                    this.updateUI();
                    this.decodePage(this.pageNumber);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (n != 1) {
                int n3 = this.getYCordForPage(this.pageNumber, -2.0f);
                Rectangle rectangle = this.getVisibleRect();
                this.scrollRectToVisible(new Rectangle(0, n3, (int)rectangle.getWidth() - 1, (int)rectangle.getHeight() - 1));
                this.scrollRectToVisible(new Rectangle(0, n3, (int)rectangle.getWidth() - 1, (int)rectangle.getHeight() - 1));
            }
        }
    }

    public boolean isXFAForm() {
        return this.isXFA;
    }

    public boolean hasJavascript() {
        return this.javascript != null && this.javascript.hasJavascript();
    }

    public int getCurrentPrintPage() {
        return this.currentPrintPage;
    }

    public void resetCurrentPrintPage() {
        this.currentPrintPage = 0;
    }

    public boolean hasAllImages() {
        return this.imagesProcessedFully;
    }

    public void setPrintAutoRotateAndCenter(boolean bl) {
        this.isPrintAutoRotateAndCenter = bl;
    }

    public void setPrintCurrentView(boolean bl) {
        this.printOnlyVisible = bl;
    }

    public void addExternalHandler(Object object, int n) {
        switch (n) {
            case 1: {
                this.customImageHandler = (ImageHandler)object;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (!this.formsAvailable) break;
                this.formRenderer.setFormFactory((FormFactory)object);
                break;
            }
            case 4: {
                this.customSwingHandle = object;
                break;
            }
            case 6: {
                this.userExpressionEngine = object;
                this.setJavascript();
                break;
            }
            case 7: {
                if (this.formRenderer == null) break;
                this.formRenderer.resetHandler(object, this, 7);
                break;
            }
            case 5: {
                if (this.formRenderer == null) break;
                this.formRenderer.resetHandler(object, this, 5);
                break;
            }
            case 8: {
                this.pages.setThumbnailPanel((GUIThumbnailPanel)object);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type");
            }
        }
    }

    public int getYCordForPage(int n, float f) {
        if (f == -2.0f || f != -1.0f && f != this.oldScaling) {
            this.oldScaling = f;
            this.pages.setPageOffsets(this.pageCount, n);
        }
        return this.pages.getYCordForPage(n);
    }

    public void unsetScaling() {
        this.displayScaling = null;
    }

    public Object getFormDataForField(String string) {
        Object object = null;
        if (this.formRenderer != null) {
            object = this.formRenderer.getFormDataAsObject(string);
        }
        return object;
    }

    public Set getNamesForAllFields() throws PdfException {
        if (this.formRenderer == null) {
            System.out.println("================No DATA=====================");
            return new HashSet();
        }
        HashSet hashSet = new HashSet();
        List list = this.formRenderer.getComponentNameList();
        if (list != null) {
            hashSet.addAll(list);
        }
        return hashSet;
    }

    public Integer getFormComponentType(String string) {
        Integer n = FormFactory.UNKNOWN;
        if (this.formRenderer != null) {
            n = this.formRenderer.getCompData().getTypeValueByName(string);
        }
        return n;
    }

    public PdfObjectReader getIO() {
        return this.currentPdfFile;
    }

    public boolean isThumbnailsDrawing() {
        return this.thumbnailsBeingDrawn;
    }

    public void setPageCount(int n) {
        this.pageCount = n;
    }

    public boolean isPDF() {
        return this.isPDf;
    }

    public void setPDF(boolean bl) {
        this.isPDf = bl;
    }

    public boolean isMultiPageTiff() {
        return this.isMultiPageTiff;
    }

    public void setMultiPageTiff(boolean bl) {
        this.isMultiPageTiff = bl;
    }

    public String getFileName() {
        return this.filename;
    }

    static {
        try {
            String string = System.getProperty("os.name");
            if (string.equals("Mac OS X")) {
                isRunningOnMac = true;
            } else if (string.startsWith("Windows")) {
                isRunningOnWindows = true;
            } else if (string.equals("Linux")) {
                isRunningOnLinux = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        showErrorMessages = false;
        samplingUsed = -1;
        extAtBestQuality = false;
    }

    private class ProgressListener
    implements ActionListener {
        private ProgressListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PdfDecoder.this.statusBar.setProgress((int)((PdfDecoder)PdfDecoder.this).statusBar.percentageDone);
        }
    }

    private class RefreshLayout
    extends ComponentAdapter {
        Timer t = null;
        java.util.Timer t2 = null;

        private RefreshLayout() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.startTimer();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.startTimer();
        }

        private void startTimer() {
            if (this.t2 != null) {
                this.t2.cancel();
            }
            PageListener pageListener = new PageListener();
            this.t2 = new java.util.Timer();
            this.t2.schedule((TimerTask)pageListener, 500L);
        }

        class PageListener
        extends TimerTask {
            PageListener() {
            }

            public void run() {
                ((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pages.decodeOtherPages(((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pageNumber, ((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pageCount);
            }
        }
    }
}

