/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.decompression;

import java.util.BitSet;
import org.jpedal.decompression.CurLine;
import org.jpedal.decompression.RefLine;
import org.jpedal.objects.raw.PdfObject;

public class CCITT2D {
    private int EOL = -1;
    private BitSet outSet = new BitSet();
    private int outSetPtr = 0;
    private int outSetL = 0;
    private long[][] white = new long[][]{{1222L, 2L, 0L}, {2111L, 3L, 0L}, {2122L, 4L, 0L}, {2211L, 5L, 0L}, {2221L, 6L, 0L}, {2222L, 7L, 0L}, {21122L, 8L, 0L}, {21211L, 9L, 0L}, {11222L, 10L, 0L}, {12111L, 11L, 0L}, {22122L, 64L, 1L}, {21121L, 128L, 1L}, {111222L, 1L, 0L}, {112111L, 12L, 0L}, {111122L, 13L, 0L}, {221211L, 14L, 0L}, {221212L, 15L, 0L}, {212121L, 16L, 0L}, {212122L, 17L, 0L}, {121222L, 192L, 1L}, {122111L, 1664L, 1L}, {1211222L, 18L, 0L}, {1112211L, 19L, 0L}, {1112111L, 20L, 0L}, {1121222L, 21L, 0L}, {1111122L, 22L, 0L}, {1111211L, 23L, 0L}, {1212111L, 24L, 0L}, {1212122L, 25L, 0L}, {1121122L, 26L, 0L}, {1211211L, 27L, 0L}, {0x111F3FL, 28L, 0L}, {1221222L, 256L, 1L}, {11221212L, 0L, 0L}, {11111121L, 29L, 0L}, {11111122L, 30L, 0L}, {11122121L, 31L, 0L}, {11122122L, 32L, 0L}, {11121121L, 33L, 0L}, {11121122L, 34L, 0L}, {11121211L, 35L, 0L}, {11121212L, 36L, 0L}, {11121221L, 37L, 0L}, {11121222L, 38L, 0L}, {11212111L, 39L, 0L}, {11212112L, 40L, 0L}, {11212121L, 41L, 0L}, {11212122L, 42L, 0L}, {11212211L, 43L, 0L}, {11212212L, 44L, 0L}, {11111211L, 45L, 0L}, {11111212L, 46L, 0L}, {11112121L, 47L, 0L}, {11112122L, 48L, 0L}, {12121121L, 49L, 0L}, {12121122L, 50L, 0L}, {12121211L, 51L, 0L}, {12121212L, 52L, 0L}, {11211211L, 53L, 0L}, {11211212L, 54L, 0L}, {12122111L, 55L, 0L}, {12122112L, 56L, 0L}, {12122121L, 57L, 0L}, {12122122L, 58L, 0L}, {12112121L, 59L, 0L}, {12112122L, 60L, 0L}, {11221121L, 61L, 0L}, {11221122L, 62L, 0L}, {11221211L, 63L, 0L}, {11221221L, 320L, 1L}, {11221222L, 384L, 1L}, {12211211L, 448L, 1L}, {12211212L, 512L, 1L}, {12212111L, 576L, 1L}, {12211222L, 640L, 1L}, {122112211L, 704L, 1L}, {122112212L, 768L, 1L}, {122121121L, 832L, 1L}, {122121122L, 896L, 1L}, {122121211L, 960L, 1L}, {122121212L, 1024L, 1L}, {122121221L, 1088L, 1L}, {122121222L, 1152L, 1L}, {122122111L, 1216L, 1L}, {122122112L, 1280L, 1L}, {122122121L, 1344L, 1L}, {122122122L, 1408L, 1L}, {121122111L, 1472L, 1L}, {121122112L, 1536L, 1L}, {121122121L, 1600L, 1L}, {121122122L, 1728L, 1L}, {11111112111L, 1792L, 1L}, {11111112211L, 1856L, 1L}, {11111112212L, 1920L, 1L}, {111111111112L, this.EOL, 1L}, {111111121121L, 1984L, 1L}, {111111121122L, 2048L, 1L}, {111111121211L, 2112L, 1L}, {111111121212L, 2176L, 1L}, {111111121221L, 2240L, 1L}, {111111121222L, 2304L, 1L}, {111111122211L, 2368L, 1L}, {111111122212L, 2432L, 1L}, {111111122221L, 2496L, 1L}, {111111122222L, 2560L, 1L}};
    private long[][] black = new long[][]{{22L, 2L, 0L}, {21L, 3L, 0L}, {121L, 1L, 0L}, {122L, 4L, 0L}, {1122L, 5L, 0L}, {1121L, 6L, 0L}, {11122L, 7L, 0L}, {111212L, 8L, 0L}, {111211L, 9L, 0L}, {1111211L, 10L, 0L}, {1111212L, 11L, 0L}, {1111222L, 12L, 0L}, {11111211L, 13L, 0L}, {11111222L, 14L, 0L}, {111122111L, 15L, 0L}, {1111221222L, 0L, 0L}, {1111121222L, 16L, 0L}, {1111122111L, 17L, 0L}, {1111112111L, 18L, 0L}, {1111112222L, 64L, 1L}, {11112211222L, 19L, 0L}, {11112212111L, 20L, 0L}, {11112212211L, 21L, 0L}, {11111221222L, 22L, 0L}, {11111212111L, 23L, 0L}, {11111121222L, 24L, 0L}, {11111122111L, 25L, 0L}, {11111112111L, 1792L, 1L}, {11111112211L, 1856L, 1L}, {11111112212L, 1920L, 1L}, {111122112121L, 26L, 0L}, {111122112122L, 27L, 0L}, {111122112211L, 28L, 0L}, {111122112212L, 29L, 0L}, {111112212111L, 30L, 0L}, {111112212112L, 31L, 0L}, {111112212121L, 32L, 0L}, {111112212122L, 33L, 0L}, {111122121121L, 34L, 0L}, {111122121122L, 35L, 0L}, {111122121211L, 36L, 0L}, {111122121212L, 37L, 0L}, {111122121221L, 38L, 0L}, {111122121222L, 39L, 0L}, {111112212211L, 40L, 0L}, {111112212212L, 41L, 0L}, {111122122121L, 42L, 0L}, {111122122122L, 43L, 0L}, {111112121211L, 44L, 0L}, {111112121212L, 45L, 0L}, {111112121221L, 46L, 0L}, {111112121222L, 47L, 0L}, {111112211211L, 48L, 0L}, {111112211212L, 49L, 0L}, {111112121121L, 50L, 0L}, {111112121122L, 51L, 0L}, {111111211211L, 52L, 0L}, {111111221222L, 53L, 0L}, {111111222111L, 54L, 0L}, {111111211222L, 55L, 0L}, {111111212111L, 56L, 0L}, {111112122111L, 57L, 0L}, {111112122112L, 58L, 0L}, {111111212122L, 59L, 0L}, {111111212211L, 60L, 0L}, {111112122121L, 61L, 0L}, {111112211221L, 62L, 0L}, {111112211222L, 63L, 0L}, {111122112111L, 128L, 1L}, {111122112112L, 192L, 1L}, {111112122122L, 256L, 1L}, {111111221122L, 320L, 1L}, {111111221211L, 384L, 1L}, {111111221212L, 448L, 1L}, {111111111112L, this.EOL, 1L}, {111111121121L, 1984L, 1L}, {111111121122L, 2048L, 1L}, {111111121211L, 2112L, 1L}, {111111121212L, 2176L, 1L}, {111111121221L, 2240L, 1L}, {111111121222L, 2304L, 1L}, {111111122211L, 2368L, 1L}, {111111122212L, 2432L, 1L}, {111111122221L, 2496L, 1L}, {111111122222L, 2560L, 1L}, {1111112212211L, 512L, 1L}, {1111112212212L, 576L, 1L}, {1111112112121L, 640L, 1L}, {1111112112122L, 704L, 1L}, {1111112112211L, 768L, 1L}, {1111112112212L, 832L, 1L}, {1111112221121L, 896L, 1L}, {1111112221122L, 960L, 1L}, {1111112221211L, 1024L, 1L}, {1111112221212L, 1088L, 1L}, {1111112221221L, 1152L, 1L}, {1111112221222L, 1216L, 1L}, {1111112121121L, 1280L, 1L}, {1111112121122L, 1344L, 1L}, {1111112121211L, 1408L, 1L}, {1111112121212L, 1472L, 1L}, {1111112122121L, 1536L, 1L}, {1111112122122L, 1600L, 1L}, {1111112211211L, 1664L, 1L}, {1111112211212L, 1728L, 1L}};
    private int[][] modes = new int[][]{{2, 1}, {122, 2}, {121, 3}, {112, 4}, {1112, 5}, {111122, 6}, {111121, 7}, {1111122, 8}, {1111121, 9}};
    private int width = 0;
    private int height = 0;
    private int topPointer = 0;
    private int oMode = 0;
    private byte[] data = null;
    private byte tmp = 0;
    private byte[] output;
    private boolean isWhite = true;
    private boolean isTerminating = false;
    private boolean EOS = false;
    private boolean EOEL = false;
    private boolean color = false;
    private RefLine ref;
    private CurLine cur;

    public CCITT2D(byte[] byArray, int n, int n2, PdfObject pdfObject) {
        byArray = this.clean(byArray);
        this.data = byArray;
        this.width = n;
        this.height = n2;
        System.out.println("stream data: width=" + this.width + " height=" + this.height);
    }

    public byte[] decode() {
        this.ref = new RefLine(new BitSet(), this.width);
        this.cur = new CurLine(this.width);
        while (!this.EOS) {
            if (!this.isTerminating && !this.color) {
                this.selectMode();
            }
            this.actMode();
        }
        byte[] byArray = new byte[(this.width + 7) / 8 * this.height];
        int n = 0;
        int n2 = 7;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.outSetL; ++i) {
            if (this.outSet.get(i)) {
                switch (n2) {
                    case 0: {
                        n3 = 1;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                    case 2: {
                        n3 = 4;
                        break;
                    }
                    case 3: {
                        n3 = 8;
                        break;
                    }
                    case 4: {
                        n3 = 16;
                        break;
                    }
                    case 5: {
                        n3 = 32;
                        break;
                    }
                    case 6: {
                        n3 = 64;
                        break;
                    }
                    case 7: {
                        n3 = 128;
                    }
                }
                n4 = (byte)(n4 | n3);
                --n2;
            } else {
                --n2;
            }
            if (n2 >= 0) continue;
            byArray[n] = n4;
            ++n;
            n2 = 7;
            n4 = 0;
        }
        System.out.println("\n\nLAST LINE TO BE PRINTED!!!!\n\n");
        return byArray;
    }

    private void selectMode() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            n = this.getEl();
            n2 = i == 0 ? n : n2 * 10 + n;
            for (int j = 0; j < this.modes.length; ++j) {
                if (n2 != this.modes[j][0]) continue;
                this.oMode = this.modes[j][1];
                if (this.oMode == 4) {
                    this.color = false;
                }
                return;
            }
        }
    }

    private int getEl() {
        for (int i = this.topPointer / 8; i < this.data.length; ++i) {
            this.tmp = this.data[i];
            int n = this.topPointer % 8;
            if (n >= 8) continue;
            int n2 = (this.tmp & 1 << 7 - n) / (1 << 7 - n);
            ++this.topPointer;
            if (n2 == 0) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    private int getRun() {
        int n = 0;
        int n2 = -111;
        long l = 0L;
        for (int i = 0; i < 13; ++i) {
            n = this.getEl();
            if (n == -1) {
                this.EOS = true;
            }
            if ((n2 = this.findMatch(l = i == 0 ? (long)n : l * 10L + (long)n)) == -111) continue;
            System.out.println("res=" + n2);
            return n2;
        }
        return n2;
    }

    private int findMatch(long l) {
        boolean bl = false;
        if (this.isWhite) {
            for (int i = 0; i < this.white.length && !bl; ++i) {
                if (l != this.white[i][0]) continue;
                bl = true;
                int n = (int)this.white[i][1];
                if (n > 63) {
                    this.isTerminating = true;
                } else if (n == -1) {
                    this.isWhite = true;
                    this.isTerminating = true;
                } else {
                    this.isWhite = !this.isWhite;
                    this.color = !this.color;
                    this.isTerminating = false;
                }
                return n;
            }
        } else {
            for (int i = 0; i < this.black.length && !bl; ++i) {
                if (l != this.black[i][0]) continue;
                bl = true;
                int n = (int)this.black[i][1];
                if (n > 63) {
                    this.isTerminating = true;
                } else if (n == -1) {
                    this.isWhite = true;
                    this.isTerminating = true;
                } else {
                    this.isWhite = !this.isWhite;
                    this.color = !this.color;
                    this.isTerminating = false;
                }
                return n;
            }
        }
        return -111;
    }

    private void actMode() {
        int n;
        int n2;
        switch (this.oMode) {
            case 1: {
                System.out.println("mode = V0");
                this.cur.parsePicElementV0(this.ref.getNextChangingPicElement());
                break;
            }
            case 2: {
                System.out.println("mode = VR1");
                this.cur.parsePicElementVR1(this.ref.getNextChangingPicElement());
                break;
            }
            case 3: {
                System.out.println("mode = VL1");
                this.cur.parsePicElementVL1(this.ref.getNextChangingPicElement());
                break;
            }
            case 4: {
                System.out.println("mode = Horiz");
                n2 = this.getRun();
                n = 0;
                if (!this.isWhite) {
                    n = 1;
                }
                if (n2 == -111) break;
                this.cur.parseRun(n2, n);
                break;
            }
            case 5: {
                System.out.println("mode = Pass");
                this.cur.parsePicElementPass(this.ref.getNextChangingPicElement());
                break;
            }
            case 6: {
                System.out.println("mode = VR2");
                this.cur.parsePicElementVR2(this.ref.getNextChangingPicElement());
                break;
            }
            case 7: {
                System.out.println("mode = VL2");
                this.cur.parsePicElementVL2(this.ref.getNextChangingPicElement());
                break;
            }
            case 8: {
                System.out.println("mode = VR3");
                this.cur.parsePicElementVR3(this.ref.getNextChangingPicElement());
                break;
            }
            case 9: {
                System.out.println("mode = VL3");
                this.cur.parsePicElementVL3(this.ref.getNextChangingPicElement());
            }
        }
        this.EOEL = this.cur.getEOEL();
        if (this.EOEL) {
            System.out.println("\n-------------------------------------\n");
            this.EOEL = false;
            this.isWhite = true;
            this.isTerminating = false;
            this.color = false;
            n2 = 0;
            n = 0;
            n2 = this.outSetPtr;
            while (n2 < this.ref.getL() + this.outSetPtr) {
                this.outSet.set(n2, this.ref.getBitSet().get(n));
                ++n2;
                ++n;
            }
            this.ref = new RefLine(this.cur.getBitSet(), this.cur.getL());
            this.cur = new CurLine(this.width);
        }
    }

    private byte[] clean(byte[] byArray) {
        byte[] byArray2 = null;
        int n = 0;
        if (byArray[0] == 32 || byArray[0] == 10 || byArray[0] == 0) {
            n = 1;
        }
        if (byArray[1] == 32 || byArray[1] == 10 || byArray[1] == 1) {
            n = 2;
        }
        byArray2 = new byte[byArray.length - n];
        int n2 = n;
        int n3 = 0;
        while (n2 < byArray.length) {
            byArray2[n3] = byArray[n2];
            ++n2;
            ++n3;
        }
        return byArray2;
    }
}

