/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.BaseTransferHandler;
import org.jpedal.examples.simpleviewer.gui.MultiViewTransferHandler;
import org.jpedal.examples.simpleviewer.gui.SingleViewTransferHandler;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.popups.Preferences;
import org.jpedal.examples.simpleviewer.gui.popups.TipOfTheDay;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseHandler;
import org.jpedal.examples.simpleviewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.simpleviewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.io.JAIHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Node;

public class SimpleViewer {
    protected Values commonValues = new Values();
    protected Printer currentPrinter = new Printer();
    protected final PdfDecoder decode_pdf = new PdfDecoder(true);
    protected GUIThumbnailPanel thumbnails = new SwingThumbnailPanel(this.commonValues, this.decode_pdf);
    private PropertiesFile properties = new PropertiesFile();
    private Preferences p = new Preferences();
    public SwingGUI currentGUI = new SwingGUI(this.decode_pdf, this.commonValues, this.thumbnails, this.properties, this.p);
    private GUISearchWindow searchFrame = new SwingSearchWindow(this.currentGUI);
    protected Commands currentCommands = new Commands(this.commonValues, this.currentGUI, this.decode_pdf, this.thumbnails, this.properties, this.searchFrame, this.currentPrinter);
    protected GUIMouseHandler mouseHandler = new SwingMouseHandler(this.decode_pdf, this.currentGUI, this.commonValues, this.currentCommands);
    protected String[] scalingValues;
    private boolean openingDefaultFile;
    private Object[] restrictedMenus;
    public static boolean exitOnClose = true;

    public void setupViewer(String string) {
        this.openingDefaultFile = true;
        this.setupViewer();
        this.openDefaultFile(string);
    }

    public SwingGUI getSwingGUI() {
        return this.currentGUI;
    }

    private void openDefaultFile(String string) {
        String string2;
        String string3 = System.getProperty("org.jpedal.hires");
        if (PdfDecoder.hires || string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (string != null) {
            File file = new File(string);
            boolean bl = false;
            if (string.startsWith("http:")) {
                LogWriter.writeLog("Opening http connection");
                bl = true;
            }
            if (!bl && !file.exists()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!bl && file.isDirectory()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setSelectedFile(string);
                this.commonValues.setFileSize(file.length() >> 10);
                this.currentGUI.setViewerTitle(null);
                String string4 = System.getProperty("org.jpedal.page");
                String string5 = System.getProperty("org.jpedal.bookmark");
                if (string4 != null) {
                    try {
                        int n = Integer.parseInt(string4);
                        if (n < 1) {
                            n = -1;
                            System.err.println(string4 + " must be 1 or larger. Opening on page 1");
                            LogWriter.writeLog(string4 + " must be 1 or larger. Opening on page 1");
                        }
                        if (n != -1) {
                            this.openFile(file, n);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(string4 + "is not a valid number for a page number. Opening on page 1");
                        LogWriter.writeLog(string4 + "is not a valid number for a page number. Opening on page 1");
                    }
                } else if (string5 != null) {
                    this.openFile(file, string5);
                } else {
                    try {
                        this.currentCommands.openFile(string);
                    }
                    catch (PdfException pdfException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public SimpleViewer() {
        PdfDecoder.showErrorMessages = true;
    }

    public SimpleViewer(int n) {
        PdfDecoder.showErrorMessages = true;
        this.commonValues.setModeOfOperation(n);
    }

    public void setupViewer() {
        BaseTransferHandler baseTransferHandler;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = this.properties.getValue("searchWindowType");
        if (string6 != null) {
            int n = Integer.parseInt(string6);
            this.searchFrame.setStyle(n);
            this.p.setSearchStyleDefaultValue(n);
        }
        this.currentGUI.setSearchFrame(this.searchFrame);
        String string7 = this.properties.getValue("automaticupdate");
        if (string7 != null) {
            boolean bl = Boolean.valueOf(string7);
            this.p.setUpdateDefaultValue(bl);
        }
        if ((string5 = this.properties.getValue("borderType")) != null) {
            int n = Integer.parseInt(string5);
            this.decode_pdf.setBorderStyle(n);
            this.p.setBorderDefaultValue(n);
        }
        if ((string4 = this.properties.getValue("DPI")) != null) {
            int n = Integer.parseInt(string4);
            this.currentGUI.setDpi(n);
            this.p.setDpiDefaultValue(string4);
        }
        if ((string3 = this.properties.getValue("maxmultiviewers")) != null) {
            this.commonValues.setMaxMiltiViewers(Integer.parseInt(string3));
            this.p.setMaxMultiViewersDefaultValue(string3);
        }
        String string8 = this.properties.getValue("autoScroll");
        boolean bl = false;
        if (string8 != null) {
            if (string8.equals("true")) {
                bl = true;
            }
            this.currentGUI.setAutoScrolling(bl);
            this.p.setAutoScrollDefaultValue(bl);
        }
        if ((string2 = this.properties.getValue("pageMode")) != null) {
            int n = Integer.parseInt(string2);
            if (n < 1 || n > 4) {
                n = 1;
            }
            this.decode_pdf.setPageMode(n);
            this.p.setPageLayoutDefaultValue(n);
        }
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_TABBED_PANE) {
            this.currentGUI.searchInTab(this.searchFrame);
        }
        if ((string = System.getProperty("org.jpedal.thumbnail")) != null) {
            if (string.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(true);
            } else if (string.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(false);
            }
        } else {
            this.thumbnails.setThumbnailsEnabled(true);
        }
        this.init(null);
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.setupButtonsAndMenus();
        this.mouseHandler.setupMouse();
        this.decode_pdf.setMessageFrame(this.currentGUI.getFrame());
        boolean bl2 = this.properties.getValue("showfirsttimepopup").equals("true");
        if (bl2) {
            this.currentGUI.showFirstTimePopup();
            this.properties.setValue("showfirsttimepopup", "false");
        }
        if (JAIHelper.isJAIused() && this.properties != null && this.properties.getValue("showddmessage").equals("true")) {
            JOptionPane.showMessageDialog(this.decode_pdf, Messages.getMessage("PdfViewer.JAIWarning") + Messages.getMessage("PdfViewer.JAIWarning1") + Messages.getMessage("PdfViewer.JAIWarning2") + Messages.getMessage("PdfViewer.JAIWarning3") + Messages.getMessage("PdfViewer.JAIWarning4"));
            this.properties.setValue("showddmessage", "false");
        }
        if (!this.commonValues.isContentExtractor()) {
            boolean bl3 = this.properties.getValue("showitextmessage").equals("true");
            if (!this.commonValues.isItextOnClasspath() && bl3) {
                this.currentGUI.showItextPopup();
                this.properties.setValue("showitextmessage", "false");
            }
        }
        this.searchFrame.setStyle(SwingSearchWindow.SEARCH_EXTERNAL_WINDOW);
        String string9 = this.properties.getValue("searchWindowType");
        if (string9 != null && string9.length() != 0) {
            int n = Integer.parseInt(string9);
            this.searchFrame.setStyle(n);
        }
        if (this.currentGUI.isSingle()) {
            baseTransferHandler = new SingleViewTransferHandler(this.commonValues, this.thumbnails, this.currentGUI, this.currentCommands);
            this.decode_pdf.setTransferHandler(baseTransferHandler);
        } else {
            baseTransferHandler = new MultiViewTransferHandler(this.commonValues, this.thumbnails, this.currentGUI, this.currentCommands);
            this.currentGUI.getMultiViewerFrames().setTransferHandler(baseTransferHandler);
        }
        boolean bl4 = false;
        if (this.properties.getValue("automaticupdate").equals("true")) {
            bl4 = this.currentCommands.checkForUpdates(false);
        }
        if (!this.openingDefaultFile && !bl4 && this.properties.getValue("displaytipsonstartup").equals("true")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TipOfTheDay tipOfTheDay = new TipOfTheDay((Frame)SimpleViewer.this.currentGUI.getFrame(), "/org/jpedal/examples/simpleviewer/res/tips", SimpleViewer.this.properties);
                    tipOfTheDay.setVisible(true);
                }
            });
        }
    }

    protected void init(ResourceBundle resourceBundle) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        if (resourceBundle == null) {
            stringArray3 = null;
            stringArray2 = Messages.class.getClassLoader();
            String string = "org/jpedal/international/messages_" + Locale.getDefault().getLanguage() + ".properties";
            try {
                stringArray3 = new BufferedReader(new InputStreamReader(stringArray2.getResourceAsStream(string)));
                stringArray3.close();
            }
            catch (Exception exception) {
                Locale.setDefault(new Locale("en", "EN"));
                JOptionPane.showMessageDialog(null, "No locale file " + string + " has been defined for this Locale - using English as Default");
            }
            try {
                Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading resource bundle.\n" + "Also check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
            }
        } else {
            Messages.setBundle(resourceBundle);
        }
        this.scalingValues = new String[]{Messages.getMessage("PdfViewerScaleWindow.text"), Messages.getMessage("PdfViewerScaleHeight.text"), Messages.getMessage("PdfViewerScaleWidth.text"), "25", "50", "75", "100", "125", "150", "200", "250", "500", "750", "1000"};
        if (this.commonValues.isContentExtractor()) {
            this.decode_pdf.setDisplayView(1, 1);
        } else {
            this.decode_pdf.setDisplayView(1, 2);
        }
        this.decode_pdf.addExternalHandler(this.currentGUI, 4);
        this.decode_pdf.init(true);
        this.decode_pdf.createPageHostspots(this.currentGUI.getAnnotTypes(), "org/jpedal/examples/simpleviewer/annots/");
        this.decode_pdf.setExtractionMode(0, 72, 1.0f);
        try {
            this.decode_pdf.setDefaultDisplayFont("SansSerif");
        }
        catch (PdfFontException pdfFontException) {
            System.out.println(pdfFontException.getMessage());
            stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            System.out.println(Messages.getMessage("PdfViewerFontsFound.message"));
            System.out.println("=====================\n");
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                stringArray = new Font(stringArray2[i], 1, 10);
                System.out.println(stringArray2[i] + " (" + Messages.getMessage("PdfViewerFontsPostscript.message") + '=' + stringArray.getPSName() + ')');
            }
            System.exit(1);
        }
        stringArray3 = new String[]{"helvetica", "arial"};
        this.decode_pdf.setSubstitutedFontAliases("arial", stringArray3);
        stringArray2 = new String[]{"Helvetica-Bold"};
        this.decode_pdf.setSubstitutedFontAliases("Arial-BoldMT", stringArray2);
        String[] stringArray4 = new String[]{"Times-Bold", "Times-Roman"};
        this.decode_pdf.setSubstitutedFontAliases("timesbd", stringArray4);
        String[] stringArray5 = new String[]{"Courier"};
        this.decode_pdf.setSubstitutedFontAliases("Cour", stringArray5);
        stringArray = new String[]{"Courier-Bold"};
        this.decode_pdf.setSubstitutedFontAliases("courbd", stringArray);
        PdfDecoder.setFontDirs(new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/System/Library/Fonts/", "/Library/Fonts/"});
    }

    private void setupButtonsAndMenus() {
        this.createSwingMenu(true);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarImageOp.text"), Messages.getMessage("PdfViewerToolbarTooltip.imageOp"), 250);
        this.createButtons();
        this.currentGUI.addCursor();
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR) {
            this.currentGUI.searchInMenu(this.searchFrame);
        }
        this.currentGUI.initStatus();
    }

    private void createButtons() {
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.openFile"), "/org/jpedal/examples/simpleviewer/res/open.gif", 10);
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.print"), "/org/jpedal/examples/simpleviewer/res/print.gif", 6);
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_EXTERNAL_WINDOW) {
            this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.search"), "/org/jpedal/examples/simpleviewer/res/find.gif", 12);
        }
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.properties"), "/org/jpedal/examples/simpleviewer/res/properties.gif", 9);
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.about"), "/org/jpedal/examples/simpleviewer/res/about.gif", 1);
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.snapshot"), "/org/jpedal/examples/simpleviewer/res/snapshotX.gif", 13);
    }

    private boolean showMenu(String string) {
        if (this.restrictedMenus != null) {
            for (int i = 0; i != this.restrictedMenus.length; ++i) {
                if (!((String)this.restrictedMenus[i]).toLowerCase().equals(string.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    protected void createSwingMenu(boolean bl) {
        Object object;
        String[] stringArray;
        Object object2;
        Serializable serializable;
        Vector<String> vector = new Vector<String>();
        String string = System.getProperty("org.jpedal.configureViewer");
        if (string != null) {
            try {
                serializable = new File(string);
                if (((File)serializable).exists()) {
                    object2 = new FileReader((File)serializable);
                    stringArray = new BufferedReader((Reader)object2);
                    object = "";
                    while (object != null) {
                        object = stringArray.readLine();
                        if (object == null) continue;
                        vector.add((String)object);
                    }
                    this.restrictedMenus = vector.toArray();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (!this.showMenu("FileMenu")) {
            serializable = new JMenu(Messages.getMessage("PdfViewerFileMenu.text"));
            this.currentGUI.addToMainMenu((JMenu)serializable);
            if (!this.showMenu("OpenMenu")) {
                object2 = new JMenu(Messages.getMessage("PdfViewerFileMenuOpen.text"));
                ((JMenu)serializable).add((JMenuItem)object2);
                if (!this.showMenu("Open")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("PdfViewerFileMenuOpen.text"), Messages.getMessage("PdfViewerFileMenuTooltip.open"), 10);
                }
                if (!this.showMenu("Openurl")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("PdfViewerFileMenuOpenurl.text"), Messages.getMessage("PdfViewerFileMenuTooltip.openurl"), 14);
                }
                ((JMenu)serializable).addSeparator();
            }
            if (!this.showMenu("Save")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerFileMenuSave.text"), Messages.getMessage("PdfViewerFileMenuTooltip.save"), 5);
            }
            if (bl && this.commonValues.isItextOnClasspath() && !this.showMenu("Resaveasforms")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerFileMenuResaveForms.text"), Messages.getMessage("PdfViewerFileMenuTooltip.saveForms"), 500);
            }
            if (!this.showMenu("Find")) {
                this.currentGUI.addMenuItem((JMenu)serializable, "Find", "Search PDF file ..", 12);
            }
            ((JMenu)serializable).addSeparator();
            if (!this.showMenu("Documentproperties")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerFileMenuDocProperties.text"), Messages.getMessage("PdfViewerFileMenuTooltip.props"), 9);
                ((JMenu)serializable).addSeparator();
            }
            if (!this.showMenu("Print")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerFileMenuPrint.text"), Messages.getMessage("PdfViewerFileMenuTooltip.print"), 6);
                ((JMenu)serializable).addSeparator();
            }
            if (!this.showMenu("Recentdocuments")) {
                this.currentCommands.recentDocumentsOption((JMenu)serializable);
                ((JMenu)serializable).addSeparator();
            }
            if (!this.showMenu("Exit")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerFileMenuExit.text"), Messages.getMessage("PdfViewerFileMenuTooltip.exit"), 7);
            }
        }
        if (!this.showMenu("ViewMenu")) {
            serializable = new JMenu(Messages.getMessage("PdfViewerViewMenu.text"));
            this.currentGUI.addToMainMenu((JMenu)serializable);
            if (!this.showMenu("GotoMenu")) {
                object2 = new JMenu(Messages.getMessage("GoToViewMenuGoto.text"));
                ((JMenu)serializable).add((JMenuItem)object2);
                if (!this.showMenu("Firstpage")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("GoToViewMenuGoto.FirstPage"), "", 50);
                }
                if (!this.showMenu("Backpage")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("GoToViewMenuGoto.BackPage"), "", 52);
                }
                if (!this.showMenu("Forwardpage")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("GoToViewMenuGoto.ForwardPage"), "", 53);
                }
                if (!this.showMenu("Lastpage")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("GoToViewMenuGoto.LastPage"), "", 55);
                }
                if (!this.showMenu("Goto")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("GoToViewMenuGoto.GoTo"), "", 56);
                }
                if (!this.showMenu("GotoMenu")) {
                    ((JMenu)object2).addSeparator();
                }
                if (!this.showMenu("PreviousDocument")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("GoToViewMenuGoto.PreviousDoucment"), "", 16);
                }
                if (!this.showMenu("NextDocument")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("GoToViewMenuGoto.NextDoucment"), "", 17);
                }
            }
            if (!this.showMenu("PagelayoutMenu")) {
                object2 = new JMenu(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
                ((JMenu)serializable).add((JMenuItem)object2);
                stringArray = new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing")};
                object = new int[]{1, 2, 3, 4};
                if (this.currentGUI.isSingle()) {
                    this.currentGUI.initLayoutMenus((JMenu)object2, stringArray, (int[])object);
                }
            }
            ((JMenu)serializable).addSeparator();
            if (!this.showMenu("Preferences")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PageLayoutViewMenu.Preferences"), "", 24);
            }
            if (!this.showMenu("Fullscreen")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerViewMenuFullScreenMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.fullScreenMode"), 61);
            }
        }
        if (!this.currentGUI.isSingle() && !this.showMenu("WindowMenu")) {
            serializable = new JMenu(Messages.getMessage("PdfViewerWindowMenu.text"));
            this.currentGUI.addToMainMenu((JMenu)serializable);
            if (!this.showMenu("Cascade")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerWindowMenuCascade.text"), "", 21);
            }
            if (!this.showMenu("Tile")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerWindowMenuTile.text"), "", 22);
            }
        }
        if (!this.showMenu("ExportMenu")) {
            serializable = new JMenu(Messages.getMessage("PdfViewerExportMenu.text"));
            this.currentGUI.addToMainMenu((JMenu)serializable);
            if (this.commonValues.isItextOnClasspath() && !this.showMenu("Pdf")) {
                object2 = new JMenu(Messages.getMessage("PdfViewerExportMenuPDF.text"));
                ((JMenu)serializable).add((JMenuItem)object2);
                if (!this.showMenu("OnePerPage")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("PdfViewerExportMenuOnePerPage.text"), "", 501);
                }
                if (!this.showMenu("Nup")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("PdfViewerExportMenuNUp.text"), "", 510);
                }
                if (!this.showMenu("Handouts")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("PdfViewerExportMenuHandouts.text"), "", 511);
                }
            }
            if (!this.showMenu("Content")) {
                object2 = new JMenu(Messages.getMessage("PdfViewerExportMenuContent.text"));
                ((JMenu)serializable).add((JMenuItem)object2);
                if (!this.showMenu("Images")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("PdfViewerExportMenuImages.text"), "", 3);
                }
                if (!this.showMenu("Text")) {
                    this.currentGUI.addMenuItem((JMenu)object2, Messages.getMessage("PdfViewerExportMenuText.text"), "", 4);
                }
            }
            if (!this.showMenu("Bitmap")) {
                this.currentGUI.addMenuItem((JMenu)serializable, "Bitmap", Messages.getMessage("PdfViewerExportMenuBitmap.text"), 2);
            }
        }
        if (this.commonValues.isItextOnClasspath() && !this.showMenu("PagetoolsMenu")) {
            serializable = new JMenu(Messages.getMessage("PdfViewerPageToolsMenu.text"));
            this.currentGUI.addToMainMenu((JMenu)serializable);
            if (!this.showMenu("Rotatepages")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerPageToolsMenuRotate.text"), "", 502);
            }
            if (!this.showMenu("Deletepages")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerPageToolsMenuDelete.text"), "", 503);
            }
            if (!this.showMenu("Addpage")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerPageToolsMenuAddPage.text"), "", 504);
            }
            if (!this.showMenu("Addheaderfooter")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerPageToolsMenuAddHeaderFooter.text"), "", 506);
            }
            if (!this.showMenu("Stamptext")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerPageToolsMenuStampText.text"), "", 507);
            }
            if (!this.showMenu("StampImage")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerPageToolsMenuStampImage.text"), "", 508);
            }
            if (!this.showMenu("Crop")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerPageToolsMenuSetCrop.text"), "", 509);
            }
        }
        if (!this.showMenu("HelpMenu")) {
            serializable = new JMenu(Messages.getMessage("PdfViewerHelpMenu.text"));
            this.currentGUI.addToMainMenu((JMenu)serializable);
            if (!this.showMenu("Visitwebsite")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerHelpMenu.VisitWebsite"), "", 15);
            }
            if (!this.showMenu("Tipoftheday")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerHelpMenuTip.text"), "", 20);
            }
            if (!this.showMenu("Checkupdates")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerHelpMenuUpdates.text"), "", 23);
            }
            if (!this.showMenu("About")) {
                this.currentGUI.addMenuItem((JMenu)serializable, Messages.getMessage("PdfViewerHelpMenuabout.text"), Messages.getMessage("PdfViewerHelpMenuTooltip.about"), 1);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " setting look and feel");
        }
        SimpleViewer simpleViewer = new SimpleViewer();
        if (stringArray.length > 0) {
            simpleViewer.setupViewer(stringArray[0]);
        } else {
            simpleViewer.setupViewer();
        }
    }

    private void openFile(File file, String string) {
        try {
            boolean bl = this.currentCommands.openUpFile(file.getCanonicalPath());
            Node node = this.decode_pdf.getOutlineAsXML().getFirstChild();
            String string2 = null;
            if (node != null) {
                string2 = this.currentGUI.getBookmark(string);
            }
            if (string2 == null) {
                throw new PdfException("Unknown bookmark " + string);
            }
            int n = Integer.parseInt(string2);
            this.commonValues.setCurrentPage(n);
            if (bl) {
                this.currentCommands.processPage();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            this.commonValues.setProcessing(false);
        }
    }

    private void openFile(File file, int n) {
        try {
            boolean bl = this.currentCommands.openUpFile(file.getCanonicalPath());
            this.commonValues.setCurrentPage(n);
            if (bl) {
                this.currentCommands.processPage();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            this.commonValues.setProcessing(false);
        }
    }
}

