/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class TrueType
extends PdfFont {
    public TrueType() {
    }

    public void readFontData(byte[] byArray, FontData fontData) {
        LogWriter.writeMethod("{readFontData}", 0);
        this.fontTypes = this.glyphs.readEmbeddedFont(this.TTstreamisCID, byArray, fontData);
    }

    protected void substituteFontUsed(String string, String string2) throws PdfFontException {
        InputStream inputStream = null;
        try {
            inputStream = this.loader.getResourceAsStream("org/jpedal/res/fonts/" + string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
            LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
        }
        if (inputStream == null) {
            throw new PdfFontException("Unable to load font " + string);
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65535];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            inputStream.close();
            FontData fontData = null;
            this.readFontData(byteArrayOutputStream.toByteArray(), fontData);
            this.glyphs.setEncodingToUse(this.hasEncoding, this.getFontEncoding(false), true, this.isCIDFont);
            this.isFontEmbedded = true;
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
            LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
        }
    }

    public TrueType(String string) {
        this.glyphs = new TTGlyphs();
        this.init(null);
        this.substituteFont = string;
    }

    public TrueType(PdfObjectReader pdfObjectReader, String string) {
        this.glyphs = new TTGlyphs();
        this.init(pdfObjectReader);
        this.substituteFont = string;
    }

    public void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore) throws Exception {
        LogWriter.writeMethod("{readTrueTypeFont}", 0);
        this.fontTypes = 1217103210;
        this.init(string, bl);
        PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfObject2);
        this.setName(pdfObject, string);
        this.setEncoding(pdfObject, string, pdfObject2);
        if (bl) {
            Object object;
            if (pdfObject2 != null) {
                object = null;
                PdfObject pdfObject3 = pdfObject2.getDictionary(2021292334);
                if (pdfObject3 != null) {
                    object = this.currentPdfFile.readStream(pdfObject3, true, true, false, false, false);
                }
                if (object != null) {
                    this.readEmbeddedFont((byte[])object, null, this.hasEncoding, false);
                }
            }
            if (!this.isFontEmbedded && this.substituteFont != null) {
                if (this.glyphs.remapFont) {
                    this.glyphs.remapFont = false;
                }
                object = new File(this.substituteFont);
                int n = (int)((File)object).length();
                if (FontData.maxSizeAllowedInMemory >= 0 && n > FontData.maxSizeAllowedInMemory) {
                    FontData fontData = new FontData(this.substituteFont);
                    this.readEmbeddedFont(null, fontData, false, true);
                } else {
                    int n2;
                    InputStream inputStream = this.loader.getResourceAsStream(this.substituteFont);
                    BufferedInputStream bufferedInputStream = inputStream == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(inputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[65535];
                    while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    byteArrayOutputStream.close();
                    bufferedInputStream.close();
                    this.readEmbeddedFont(byteArrayOutputStream.toByteArray(), null, false, true);
                }
                this.isFontSubstituted = true;
            }
        }
        this.readWidths(pdfObject, true);
        if (bl) {
            this.setFont(this.glyphs.fontName, 1);
        }
    }

    public void createFont(String string) throws Exception {
        this.fontTypes = 1217103210;
        this.setBaseFontName(string);
        File file = new File(this.substituteFont);
        int n = (int)file.length();
        if (FontData.maxSizeAllowedInMemory >= 0 && n > FontData.maxSizeAllowedInMemory) {
            FontData fontData = new FontData(this.substituteFont);
            this.readEmbeddedFont(null, fontData, false, true);
        } else {
            int n2;
            InputStream inputStream = this.loader.getResourceAsStream(this.substituteFont);
            BufferedInputStream bufferedInputStream = inputStream == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65535];
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.close();
            bufferedInputStream.close();
            this.readEmbeddedFont(byteArrayOutputStream.toByteArray(), null, false, true);
        }
        this.isFontSubstituted = true;
    }

    protected final void readEmbeddedFont(byte[] byArray, FontData fontData, boolean bl, boolean bl2) {
        LogWriter.writeMethod("{readEmbeddedFont}", 0);
        try {
            LogWriter.writeLog("Embedded TrueType font used");
            this.readFontData(byArray, fontData);
            this.isFontEmbedded = true;
            this.glyphs.setFontEmbedded(true);
            this.glyphs.setEncodingToUse(bl, this.getFontEncoding(false), bl2, this.TTstreamisCID);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " processing TrueType font");
            exception.printStackTrace();
        }
    }

    public Rectangle getBoundingBox() {
        if (this.isFontEmbedded && !this.isFontSubstituted) {
            return new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1]));
        }
        return super.getBoundingBox();
    }
}

