/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.glyph.T3Glyphs;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class Type3
extends PdfFont {
    private GraphicsState currentGraphicsState;

    public Type3(PdfObjectReader pdfObjectReader, GraphicsState graphicsState) {
        this.glyphs = new T3Glyphs();
        this.init(pdfObjectReader);
        this.currentGraphicsState = graphicsState;
    }

    public final void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore) throws Exception {
        LogWriter.writeMethod("{readType3Font}", 0);
        this.fontTypes = 1228944679;
        this.init(string, bl);
        PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfObject);
        this.setName(pdfObject, string);
        this.setEncoding(pdfObject, string, pdfObject2);
        this.readWidths(pdfObject, false);
        this.readEmbeddedFont(pdfObject, objectStore);
        if (bl) {
            this.setFont(this.getBaseFontName(), 1);
        }
    }

    private void readEmbeddedFont(PdfObject pdfObject, ObjectStore objectStore) {
        int n = -1;
        PdfObject pdfObject2 = pdfObject.getDictionary(2054190454);
        if (pdfObject2 != null) {
            PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile, true, true);
            pdfStreamDecoder.setStore(objectStore);
            PdfObject pdfObject3 = pdfObject.getDictionary(2004251818);
            if (pdfObject3 != null) {
                try {
                    pdfStreamDecoder.readResources(pdfObject3, false);
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
            }
            PdfKeyPairsIterator pdfKeyPairsIterator = pdfObject2.getKeyPairsIterator();
            while (pdfKeyPairsIterator.hasMorePairs()) {
                Object object;
                String string = pdfKeyPairsIterator.getNextKeyAsString();
                PdfObject pdfObject4 = pdfKeyPairsIterator.getNextValueAsDictionary();
                n = -1;
                Object var11_11 = null;
                if (this.diffLookup != null) {
                    object = StandardFonts.convertNumberToGlyph(string);
                    var11_11 = this.diffLookup.get(object);
                }
                n = var11_11 != null ? ((Integer)var11_11).intValue() : pdfKeyPairsIterator.getNextKeyAsNumber();
                if (pdfObject4 != null && this.renderPage) {
                    object = new DynamicVectorRenderer(0, false, 20, objectStore);
                    ((DynamicVectorRenderer)object).setHiResImageForDisplayMode(true);
                    ((DynamicVectorRenderer)object).setType3Glyph(string);
                    try {
                        pdfStreamDecoder.init(false, true, 7, 0, new PdfPageData(), 0, (DynamicVectorRenderer)object, this.currentPdfFile);
                        pdfStreamDecoder.setDefaultColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                        int n2 = 0;
                        int n3 = 0;
                        T3Size t3Size = pdfStreamDecoder.decodePageContent(pdfObject4, 0, 0, null, null);
                        n2 = t3Size.x;
                        n3 = t3Size.y;
                        this.glyphs.setT3Glyph(n, new T3Glyph((DynamicVectorRenderer)object, n2, n3, pdfStreamDecoder.ignoreColors, string));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                pdfKeyPairsIterator.nextPair();
            }
            this.isFontEmbedded = true;
        }
    }
}

