/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.CFF;
import org.jpedal.fonts.tt.CMAP;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Head;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.Loca;
import org.jpedal.fonts.tt.Mapx;
import org.jpedal.fonts.tt.Name;
import org.jpedal.fonts.tt.Post;
import org.jpedal.fonts.tt.TTGlyph;

public class TTGlyphs
extends PdfJavaGlyphs {
    protected boolean hasGIDtoCID;
    protected int[] CIDToGIDMap;
    float[] FontBBox = new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    private CMAP currentCMAP;
    private Post currentPost;
    private Glyf currentGlyf;
    private Hmtx currentHmtx;
    private FontFile2 currentFontFile;
    private CFF currentCFF;
    int glyphCount = 0;
    private int unitsPerEm;
    private boolean hasCFF;
    private boolean isCID;

    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        PdfGlyph pdfGlyph;
        int n2 = n;
        if (this.hasGIDtoCID) {
            n = this.CIDToGIDMap[n];
        }
        if (this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.cachedShapes = null;
        }
        if ((pdfGlyph = this.getEmbeddedCachedShape(n2)) == null) {
            int n3 = n;
            if (!this.isCID || !this.isIdentity()) {
                n3 = this.currentCMAP.convertIndexToCharacterCode(string, n, this.remapFont, this.isSubsetted);
            }
            if (n3 < 1) {
                n3 = this.currentPost.convertGlyphToCharacterCode(string);
            }
            try {
                if (this.hasCFF) {
                    pdfGlyph = this.currentCFF.getCFFGlyph(glyphFactory, string, fArray, n, string2, f, string3);
                    pdfGlyph.setWidth(this.getUnscaledWidth(string, n, string2, false));
                } else {
                    pdfGlyph = this.getTTGlyph(n3, string, n, string2, f);
                }
            }
            catch (Exception exception) {
                pdfGlyph = null;
            }
            this.setEmbeddedCachedShape(n2, pdfGlyph);
        }
        return pdfGlyph;
    }

    public PdfGlyph getTTGlyph(int n, String string, int n2, String string2, float f) {
        TTGlyph tTGlyph = null;
        try {
            int n3;
            if (n != -1 && (n3 = this.currentGlyf.getCharString(n)) != -1) {
                this.currentFontFile.setPointer(n3);
                tTGlyph = new TTGlyph(string, false, this.currentGlyf, this.currentFontFile, this.currentHmtx, n, (float)this.unitsPerEm / 1000.0f);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return tTGlyph;
    }

    public void setEncodingToUse(boolean bl, int n, boolean bl2, boolean bl3) {
        if (this.currentCMAP != null) {
            this.currentCMAP.setEncodingToUse(bl, n, bl2, bl3);
        }
    }

    public int getConvertedGlyph(int n) {
        if (this.currentCMAP == null) {
            return n;
        }
        return this.currentCMAP.convertIndexToCharacterCode(null, n, false, false);
    }

    public float getTTWidth(String string, int n, String string2, boolean bl) {
        int n2 = n;
        float f = 0.0f;
        try {
            if (!bl) {
                n2 = this.currentCMAP.convertIndexToCharacterCode(string, n, this.remapFont, this.isSubsetted);
            }
            if (n2 < 1) {
                n2 = this.currentPost.convertGlyphToCharacterCode(string);
            }
            f = this.currentHmtx.getWidth(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    private float getUnscaledWidth(String string, int n, String string2, boolean bl) {
        int n2 = n;
        float f = 0.0f;
        try {
            if (!bl) {
                n2 = this.currentCMAP.convertIndexToCharacterCode(string, n, this.remapFont, this.isSubsetted);
            }
            if (n2 < 1) {
                n2 = this.currentPost.convertGlyphToCharacterCode(string);
            }
            f = this.currentHmtx.getUnscaledWidth(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public void setGIDtoCID(int[] nArray) {
        this.hasGIDtoCID = true;
        this.CIDToGIDMap = nArray;
    }

    public String[] readFontNames(FontData fontData, int n) {
        String[] stringArray = new String[]{};
        FontFile2 fontFile2 = new FontFile2(fontData);
        int n2 = fontFile2.getType();
        int n3 = fontFile2.getFontCount();
        stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            fontFile2.setSelectedFontIndex(i);
            Name name = new Name(fontFile2);
            String string = null;
            if (n == 2) {
                string = name.getString(Name.POSTSCRIPT_NAME);
            } else if (n == 3) {
                string = name.getString(Name.FONT_FAMILY_NAME);
            } else if (n == 4) {
                string = name.getString(Name.FULL_FONT_NAME);
            } else {
                throw new RuntimeException("Unsupported mode " + n + ". Unable to resolve font names");
            }
            stringArray[i] = string == null ? null : string.toLowerCase();
        }
        return stringArray;
    }

    public void addStringValues(FontData fontData, Map map) {
        FontFile2 fontFile2 = new FontFile2(fontData);
        int n = fontFile2.getFontCount();
        for (int i = 0; i < n; ++i) {
            fontFile2.setSelectedFontIndex(i);
            Name name = new Name(fontFile2);
            Map map2 = name.getStrings();
            if (map2 == null) continue;
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                int n3 = n2;
                if (n3 >= Name.stringNames.length) continue;
                map.put(Name.stringNames[n2], map2.get(n2));
            }
        }
    }

    public int readEmbeddedFont(boolean bl, byte[] byArray, FontData fontData) {
        Serializable serializable;
        int n = 1217103210;
        this.isCID = bl;
        this.currentFontFile = byArray != null ? new FontFile2(byArray) : new FontFile2(fontData);
        if (FontMappings.fontSubstitutionFontID == null) {
            this.currentFontFile.setPointer(0);
        } else {
            serializable = (Integer)FontMappings.fontSubstitutionFontID.get(this.fontName.toLowerCase());
            if (serializable != null) {
                this.currentFontFile.setPointer((Integer)serializable);
            } else {
                this.currentFontFile.setPointer(0);
            }
        }
        serializable = new Head(this.currentFontFile);
        this.currentPost = new Post(this.currentFontFile);
        Mapx mapx = new Mapx(this.currentFontFile);
        this.glyphCount = mapx.getGlyphCount();
        Loca loca = new Loca(this.currentFontFile, this.glyphCount, ((Head)serializable).getFormat());
        this.currentGlyf = new Glyf(this.currentFontFile, this.glyphCount, loca.getIndices());
        this.currentCFF = new CFF(this.currentFontFile);
        this.hasCFF = this.currentCFF.hasCFFData();
        if (this.hasCFF) {
            n = 6;
        }
        Hhea hhea = new Hhea(this.currentFontFile);
        this.FontBBox = ((Head)serializable).getFontBBox();
        this.currentHmtx = new Hmtx(this.currentFontFile, this.glyphCount, hhea.getNumberOfHMetrics(), (int)this.FontBBox[3]);
        int n2 = this.currentFontFile.selectTable(2);
        if (n2 != 0) {
            this.currentCMAP = new CMAP(this.currentFontFile, n2, this.currentGlyf);
        }
        this.unitsPerEm = ((Head)serializable).getUnitsPerEm();
        return n;
    }

    public float[] getFontBoundingBox() {
        return this.FontBBox;
    }
}

