/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PathSerializer {
    public static void serializePath(ObjectOutput objectOutput, PathIterator pathIterator) throws IOException {
        objectOutput.writeObject(new Integer(pathIterator.getWindingRule()));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            int n = pathIterator.currentSegment(fArray);
            arrayList.add(new Integer(n));
            arrayList.add(fArray);
            pathIterator.next();
        }
        objectOutput.writeObject(arrayList);
    }

    public static GeneralPath deserializePath(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        Integer n = (Integer)objectInput.readObject();
        if (n == null) {
            return null;
        }
        List list = (List)objectInput.readObject();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(n);
        Iterator iterator = list.iterator();
        block7: while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            float[] fArray = (float[])iterator.next();
            switch (n2) {
                case 1: {
                    generalPath.lineTo(fArray[0], fArray[1]);
                    continue block7;
                }
                case 0: {
                    generalPath.moveTo(fArray[0], fArray[1]);
                    continue block7;
                }
                case 2: {
                    generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    continue block7;
                }
                case 3: {
                    generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    continue block7;
                }
                case 4: {
                    generalPath.closePath();
                    continue block7;
                }
            }
            System.out.println("unrecognized general path type");
        }
        return generalPath;
    }
}

