/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.Area;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;

public class GraphicsState {
    public float x;
    public float y;
    private float strokeAlpha = 1.0f;
    private float nonstrokeAlpha = 1.0f;
    PdfObject TR;
    private boolean op = false;
    private boolean OP = false;
    private float OPM = 0.0f;
    PdfPaint nonstrokeColor = new PdfColor(0, 0, 0);
    PdfPaint strokeColor = new PdfColor(0, 0, 0);
    private Area current_clipping_shape = null;
    public float[][] CTM = new float[3][3];
    private int current_line_dash_phase = 0;
    private Area TRmask = null;
    private int fill_type;
    private int mitre_limit = 0;
    private float[] current_line_dash_array = new float[0];
    private int current_line_cap_style = 0;
    private float current_line_width = 1.0f;
    private int current_line_join_style = 0;
    private int text_render_type = 2;
    int minX = 0;
    int minY = 0;
    public static final int STROKE = 1;
    public static final int FILL = 2;
    public static final int FILLSTROKE = 3;
    public static final int INVISIBLE = 4;
    public static final int CLIPTEXT = 7;
    private PdfArrayIterator BM;

    public GraphicsState() {
        this.resetCTM();
    }

    public GraphicsState(int n, int n2) {
        this.minX = -n;
        this.minY = -n2;
        this.resetCTM();
    }

    public float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public float getNonStrokeAlpha() {
        return this.nonstrokeAlpha;
    }

    public boolean getStrokeOP() {
        return this.OP;
    }

    public boolean getNonStrokeOP() {
        return this.op;
    }

    public float getOPM() {
        return this.OPM;
    }

    public PdfObject getTR() {
        return this.TR;
    }

    public final void setTextRenderType(int n) {
        this.text_render_type = n;
        this.TRmask = null;
    }

    public final int getTextRenderType() {
        return this.text_render_type;
    }

    public final void setMitreLimit(int n) {
        this.mitre_limit = n;
    }

    public final float getLineWidth() {
        return this.current_line_width;
    }

    public final void setFillType(int n) {
        this.fill_type = n;
    }

    public final void updateClip(Area area) {
        if (this.current_clipping_shape == null) {
            this.current_clipping_shape = area;
        } else {
            this.current_clipping_shape.intersect(area);
        }
    }

    public final void addClip(Area area) {
        if (this.TRmask == null) {
            this.TRmask = area;
        } else {
            this.TRmask.add(area);
        }
    }

    public final Stroke getStroke() {
        float f = this.current_line_width;
        if (this.CTM[0][0] != 0.0f) {
            f *= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            f *= this.CTM[0][1];
        }
        if (f < 0.0f) {
            f = -f;
        }
        if (this.mitre_limit < 1) {
            this.mitre_limit = 1;
        }
        BasicStroke basicStroke = this.current_line_dash_array.length > 0 ? new BasicStroke(f, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit, this.current_line_dash_array, this.current_line_dash_phase) : new BasicStroke(f, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit);
        return basicStroke;
    }

    public final void setLineWidth(float f) {
        this.current_line_width = f;
    }

    public final Area getClippingShape() {
        if (this.TRmask != null && this.current_clipping_shape != null) {
            this.TRmask.intersect(this.current_clipping_shape);
            return this.TRmask;
        }
        return this.current_clipping_shape;
    }

    public void setMode(PdfObject pdfObject) {
        float f;
        boolean bl;
        this.strokeAlpha = 1.0f;
        this.nonstrokeAlpha = 1.0f;
        this.op = false;
        this.OP = false;
        if (pdfObject == null) {
            return;
        }
        float f2 = pdfObject.getFloatNumber(7207);
        if (f2 != -1.0f) {
            this.current_line_width = f2;
        }
        boolean bl2 = pdfObject.getBoolean(1120547);
        PdfObject pdfObject2 = pdfObject.getDictionary(489767774);
        boolean bl3 = bl = pdfObject2 != null && !bl2 && pdfObject2.getGeneralType(489767774) == 507461173;
        if (!bl) {
            f = pdfObject.getFloatNumber(4881);
            float f3 = pdfObject.getFloatNumber(13105);
            if (f != -1.0f) {
                this.strokeAlpha = f;
            }
            if (f3 != -1.0f) {
                this.nonstrokeAlpha = f3;
            }
        }
        this.OP = pdfObject.getBoolean(7968);
        this.op = pdfObject.getBoolean(16192);
        f = pdfObject.getFloatNumber(2039837);
        this.OPM = f != -1.0f ? f : 0.0f;
        this.TR = pdfObject.getDictionary(9250);
        if (this.TR != null) {
            boolean bl4 = false;
            if (this.TR.getGeneralType(9250) == 1567455623) {
                bl4 = true;
            } else {
                byte[][] byArray = this.TR.getKeyArray(9250);
                if (byArray != null) {
                    int n = byArray.length;
                    if (n == 0) {
                        byArray = null;
                    } else {
                        bl4 = true;
                        for (int i = 0; i < n; ++i) {
                            int n2 = PdfDictionary.getIntKey(1, byArray[i].length - 1, byArray[i]);
                            if (n2 == 1567455623) continue;
                            bl4 = false;
                            break;
                        }
                    }
                }
            }
            if (bl4) {
                this.TR = null;
            }
        }
        this.BM = pdfObject.getArrayIterator(4637);
    }

    public final void setCapStyle(int n) {
        this.current_line_cap_style = n;
    }

    public final void setJoinStyle(int n) {
        this.current_line_join_style = n;
    }

    public final void checkWholePageClip(int n) {
        if (this.current_clipping_shape != null && this.current_clipping_shape.getBounds().getHeight() >= (double)n) {
            this.current_clipping_shape = null;
        }
    }

    public final void setDashArray(float[] fArray) {
        this.current_line_dash_array = fArray;
    }

    public final Object clone() {
        int n;
        int n2;
        PdfPaint pdfPaint;
        PdfPaint pdfPaint2;
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.x = this.x;
        graphicsState.y = this.y;
        if (this.TR != null) {
            graphicsState.TR = (PdfObject)this.TR.clone();
        }
        graphicsState.strokeAlpha = this.strokeAlpha;
        graphicsState.nonstrokeAlpha = this.nonstrokeAlpha;
        graphicsState.op = this.op;
        graphicsState.OP = this.OP;
        graphicsState.OPM = this.OPM;
        graphicsState.nonstrokeColor = pdfPaint2 = this.nonstrokeColor;
        graphicsState.strokeColor = pdfPaint = this.strokeColor;
        if (this.current_clipping_shape != null) {
            graphicsState.current_clipping_shape = (Area)this.current_clipping_shape.clone();
        }
        if (this.CTM != null) {
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    graphicsState.CTM[n2][n] = this.CTM[n2][n];
                }
            }
        }
        graphicsState.current_line_dash_phase = this.current_line_dash_phase;
        if (this.TRmask != null) {
            graphicsState.TRmask = (Area)this.TRmask.clone();
        }
        graphicsState.fill_type = this.fill_type;
        graphicsState.mitre_limit = this.mitre_limit;
        if (this.current_line_dash_array != null) {
            n2 = this.current_line_dash_array.length;
            graphicsState.current_line_dash_array = new float[n2];
            for (n = 0; n < n2; ++n) {
                graphicsState.current_line_dash_array[n] = this.current_line_dash_array[n];
            }
        }
        graphicsState.current_line_cap_style = this.current_line_cap_style;
        graphicsState.current_line_width = this.current_line_width;
        graphicsState.current_line_join_style = this.current_line_join_style;
        graphicsState.text_render_type = this.text_render_type;
        graphicsState.minX = this.minX;
        graphicsState.minY = this.minY;
        return graphicsState;
    }

    public final void resetCTM() {
        this.CTM[0][0] = 1.0f;
        this.CTM[1][0] = 0.0f;
        this.CTM[2][0] = this.minX;
        this.CTM[0][1] = 0.0f;
        this.CTM[1][1] = 1.0f;
        this.CTM[2][1] = this.minY;
        this.CTM[0][2] = 0.0f;
        this.CTM[1][2] = 0.0f;
        this.CTM[2][2] = 1.0f;
    }

    public final void setDashPhase(int n) {
        this.current_line_dash_phase = n;
    }

    public final int getFillType() {
        return this.fill_type;
    }

    public final void setClippingShape(Area area) {
        this.current_clipping_shape = area;
    }

    public PdfPaint getNonstrokeColor() {
        return this.nonstrokeColor;
    }

    public void setNonstrokeColor(PdfPaint pdfPaint) {
        this.nonstrokeColor = pdfPaint;
    }

    public PdfPaint getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(PdfPaint pdfPaint) {
        this.strokeColor = pdfPaint;
    }

    public PdfArrayIterator getBM() {
        return this.BM;
    }
}

