/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class PdfAnnots {
    private int annotNumber = 0;
    PdfObjectReader currentPdfFile = null;
    private Hashtable fields = new Hashtable();
    private final boolean debugAnnot = false;
    private List Annots = new ArrayList();
    private Map annotArea = new Hashtable();
    private Map annotCustomIcon = new HashMap();
    private String pageNumber = null;

    public PdfAnnots(PdfObjectReader pdfObjectReader, String string) {
        this.currentPdfFile = pdfObjectReader;
        this.pageNumber = string;
        this.fields.put("Contents", "x");
        this.fields.put("T", "x");
        this.fields.put("NM", "x");
        this.fields.put("Subj", "x");
        this.fields.put("V", "x");
        this.fields.put("CA", "x");
        this.fields.put("DA", "x");
        this.fields.put("DV", "x");
        this.fields.put("JS", "x");
        this.fields.put("Dest", "x");
    }

    private PdfAnnots() {
    }

    public final void readAnnots(byte[][] byArray) {
        LogWriter.writeMethod("{pdf-readAnnots}", 1);
        if (byArray != null) {
            try {
                int n = byArray.length;
                this.Annots = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    if (byArray[i] == null) continue;
                    this.readAnnot(new String(byArray[i]));
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception processing annots");
            }
        }
    }

    public final int getAnnotCount() {
        return this.Annots.size();
    }

    public final Map getAnnotRawData(int n) {
        return (Map)this.Annots.get(n);
    }

    public final List getAnnotRawDataList() {
        return this.Annots;
    }

    public final boolean hasOwnIcon(int n) {
        return this.annotCustomIcon.get(new Integer(n)) != null;
    }

    public final String getAnnotObjectArea(int n) {
        return (String)this.annotArea.get(new Integer(n));
    }

    public final Color getAnnotColor(int n) {
        String string;
        StringTokenizer stringTokenizer;
        Color color = null;
        Object e = this.Annots.get(n);
        Map map = null;
        map = e instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)e), (String)e, false, null) : (Map)e;
        String string2 = (String)map.get("C");
        if (string2 != null && (stringTokenizer = new StringTokenizer(string = Strip.removeArrayDeleminators(this.currentPdfFile.getValue(string2)))).countTokens() == 3) {
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            color = new Color(f, f2, f3);
        }
        return color;
    }

    public final Stroke getBorderStroke(int n) {
        int n2 = 0;
        Object e = this.Annots.get(n);
        Map map = null;
        map = e instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)e), (String)e, false, null) : (Map)e;
        String string = (String)map.get("Border");
        if (string != null) {
            String string2 = Strip.removeArrayDeleminators(this.currentPdfFile.getValue(string));
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() == 1) {
                n2 = Integer.parseInt(string2);
            } else if (stringTokenizer.countTokens() == 3) {
                for (int i = 0; i < 2; ++i) {
                    stringTokenizer.nextToken();
                }
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        if (n2 == 0) {
            return null;
        }
        return new BasicStroke(n2);
    }

    public final String getAnnotSubType(int n) {
        String string = null;
        Map map = (Map)this.Annots.get(n);
        string = (String)map.get("Subtype");
        if (string != null && string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private final void readAnnot(String string) {
        String[] stringArray;
        Object object;
        Object object2;
        LogWriter.writeMethod("{pdf-readAnnot: " + string + '}', 1);
        Map map = this.currentPdfFile.readObject(new PdfObject(string), string, false, this.fields);
        map.put("obj", string);
        Object object3 = (String)this.currentPdfFile.resolveToMapOrString("T", map.get("T"));
        String string2 = (String)map.get("Parent");
        while (string2 != null && (object2 = (object = this.currentPdfFile.readObject(new PdfObject(string2), string2, false, this.fields)).get("T")) != null) {
            stringArray = (String[])this.currentPdfFile.resolveToMapOrString("T", object2);
            if (stringArray == null) continue;
            object3 = object3 == null ? stringArray : (String)stringArray + '.' + (String)object3;
            string2 = (String)object.get("Parent");
        }
        map.put("T", object3);
        if (this.pageNumber != null) {
            map.put("PageNumber", this.pageNumber);
        }
        if (map.get("AP") != null) {
            this.annotCustomIcon.put(new Integer(this.annotNumber), "x");
        }
        if ((object = (String)map.get("Rect")) != null) {
            object2 = Strip.removeArrayDeleminators(this.currentPdfFile.getValue((String)object));
            this.annotArea.put(new Integer(this.annotNumber), object2);
            stringArray = new String[]{"A", "FS"};
            this.substituteKeyValues(this.currentPdfFile, map, stringArray);
            this.Annots.add(this.annotNumber, map);
            ++this.annotNumber;
        }
    }

    private void substituteKeyValues(PdfObjectReader pdfObjectReader, Map map, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                Object object;
                Object v = map.get(stringArray[i]);
                if (v == null) continue;
                Map map2 = null;
                if (v instanceof String) {
                    map2 = pdfObjectReader.readObject(new PdfObject((String)v), (String)v, false, null);
                    if (map2.containsKey("startStreamOnDisk")) {
                        pdfObjectReader.readStream((String)v, false);
                    }
                    if (map2.containsKey("Stream")) {
                        object = pdfObjectReader.readStream(map2, (String)v, true, false, false, false, false);
                        map2.put("DecodedStream", object);
                    }
                } else {
                    map2 = (Map)v;
                }
                if (map2.containsKey("EF")) {
                    object = (Map)map2.get("EF");
                    String[] stringArray2 = new String[]{"F"};
                    this.substituteKeyValues(pdfObjectReader, (Map)object, stringArray2);
                }
                map.put(stringArray[i], map2);
                continue;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception);
            }
        }
    }

    public String getField(int n, String string) {
        String string2 = null;
        Object e = this.Annots.get(n);
        Map map = (Map)this.currentPdfFile.resolveToMapOrString(string, e);
        byte[] byArray = this.currentPdfFile.getByteTextStringValue(map.get(string), this.fields);
        if (byArray != null) {
            string2 = this.currentPdfFile.getTextString(byArray);
        }
        return string2;
    }

    public Color getBorderColor(int n) {
        String string;
        StringTokenizer stringTokenizer;
        Color color = Color.black;
        Object e = this.Annots.get(n);
        Map map = null;
        map = e instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)e), (String)e, false, null) : (Map)e;
        String string2 = (String)map.get("Border");
        if (string2 != null && (stringTokenizer = new StringTokenizer(string = Strip.removeArrayDeleminators(this.currentPdfFile.getValue(string2)))).countTokens() == 3) {
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            color = new Color(f, f2, f3);
        }
        return color;
    }
}

