/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.rendering;

import com.idrsolutions.pdf.acroforms.xfa.XFAFormStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.external.LinkHandler;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.DefaultActionHandler;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.SwingFormFactory;
import org.jpedal.objects.acroforms.decoding.AnnotStream;
import org.jpedal.objects.acroforms.decoding.FormDecoder;
import org.jpedal.objects.acroforms.decoding.FormStream;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.formData.SwingData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.raw.PdfObject;

public class DefaultAcroRenderer
implements AcroRenderer {
    private static final boolean showFormsDecoded = false;
    private List FacroFormDataList;
    private List AacroFormDataList;
    private static final boolean showMethods = false;
    private static final boolean identifyType = false;
    private static final boolean debug = false;
    private boolean ignoreForms = false;
    private FormFactory formFactory;
    private GUIData compData = new SwingData();
    private Set sigObject = null;
    public static final int ANNOTATION = 1;
    public static final int FORM = 2;
    public static final int XFAFORM = 3;
    private PdfPageData pageData;
    private int AformCount = 0;
    private int FformCount;
    private int AfieldCount = 0;
    private int FfieldCount = 0;
    protected int pageCount = 0;
    private PdfObjectReader currentPdfFile;
    private FormDecoder fDecoder;
    private FormDecoder annotDecoder;
    private ActionHandler formsActionHandler;
    private LinkHandler linkHandler;
    private Javascript javascript;
    private ExpressionEngine userExpressionEngine;
    private int insetH;
    private Map formKids;
    private boolean hasXFA = false;

    public void resetHandler(Object object, PdfDecoder pdfDecoder, int n) {
        if (n == 5) {
            this.formsActionHandler = object != null ? (ActionHandler)object : new DefaultActionHandler();
            this.formsActionHandler.init(pdfDecoder, this.javascript, (AcroRenderer)this);
            if (this.formFactory != null) {
                this.formFactory.reset(this, this.formsActionHandler);
                this.compData.resetDuplicates();
            }
        } else if (n == 7) {
            this.linkHandler = object != null ? (LinkHandler)object : null;
        }
    }

    public void removeDisplayComponentsFromScreen() {
        if (this.compData != null) {
            this.compData.removeAllComponentsFromScreen();
        }
    }

    public void resetFormData(Object object, int n, int n2, PdfPageData pdfPageData, PdfObjectReader pdfObjectReader, Map map) {
        this.insetH = n2;
        this.currentPdfFile = pdfObjectReader;
        this.pageData = pdfPageData;
        this.formKids = map;
        this.sigObject = null;
        this.compData.setPageData(pdfPageData, n, n2);
        if (object == null) {
            this.FacroFormDataList = null;
            this.FformCount = 0;
            this.FfieldCount = 0;
        } else {
            PdfFormData pdfFormData = (PdfFormData)object;
            this.hasXFA = pdfFormData.hasXFAFormData();
            if (this.hasXFA) {
                try {
                    this.fDecoder = new XFAFormStream(pdfFormData.getXFAFormData(2), pdfFormData.getXFAFormData(1), pdfFormData.getXFAFormData(0), pdfObjectReader);
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
            } else {
                this.fDecoder = new FormStream(pdfObjectReader);
            }
            this.FacroFormDataList = pdfFormData.getFormData();
            this.FformCount = pdfFormData.getTotalCount();
            this.FfieldCount = this.FacroFormDataList.size();
        }
        this.resetContainers(true);
    }

    public void resetAnnotData(Object object, int n, int n2, PdfPageData pdfPageData, PdfObjectReader pdfObjectReader, Map map) {
        this.insetH = n2;
        this.currentPdfFile = pdfObjectReader;
        this.pageData = pdfPageData;
        this.formKids = map;
        boolean bl = true;
        this.compData.setPageData(pdfPageData, n, n2);
        if (object == null) {
            this.AacroFormDataList = null;
            this.AformCount = 0;
            this.AfieldCount = 0;
        } else {
            int n3;
            PdfAnnots pdfAnnots = (PdfAnnots)object;
            this.annotDecoder = new AnnotStream(pdfObjectReader);
            if (this.AacroFormDataList == null) {
                this.AacroFormDataList = pdfAnnots.getAnnotRawDataList();
            } else {
                this.AacroFormDataList.addAll(pdfAnnots.getAnnotRawDataList());
            }
            this.AformCount = n3 = this.AacroFormDataList.size();
            this.AfieldCount = n3;
            bl = false;
        }
        this.resetContainers(bl);
    }

    protected void resetContainers(boolean bl) {
        if (bl) {
            if (this.fDecoder != null) {
                this.fDecoder.resetItems();
            }
            if (this.annotDecoder != null) {
                this.annotDecoder.resetItems();
            }
            this.compData.resetComponents(this.AformCount + this.FformCount, this.pageCount, false);
        } else {
            this.compData.resetComponents(this.AformCount + this.FformCount, this.pageCount, true);
        }
        if (this.formFactory == null) {
            this.formFactory = new SwingFormFactory(this, this.formsActionHandler);
        } else {
            this.formFactory.reset(this, this.formsActionHandler);
            this.compData.resetDuplicates();
        }
        this.formsActionHandler.setActionFactory(this.formFactory.getActionFactory());
    }

    public void createDisplayComponentsForPage(int n) {
        int n2 = this.compData.getStartComponentCountForPage(n);
        if (n2 == -1 || n2 == -999) {
            int n3;
            String string;
            Iterator iterator;
            Map map;
            String string2;
            FormObject formObject;
            Object v;
            Map map2;
            int n4;
            this.compData.initParametersForPage(this.pageData, n);
            if (this.formsActionHandler != null) {
                this.formsActionHandler.init(this.currentPdfFile, this.javascript, (AcroRenderer)this);
                this.formsActionHandler.setPageAccess(this.pageData.getMediaBoxHeight(n), this.insetH);
            }
            if (this.fDecoder != null) {
                this.fDecoder.resetItems();
            }
            HashMap hashMap = new HashMap();
            FormObject[] formObjectArray = null;
            FormObject[] formObjectArray2 = new FormObject[this.FfieldCount];
            FormObject[] formObjectArray3 = new FormObject[this.AfieldCount];
            int n5 = 0;
            int n6 = this.FfieldCount;
            for (n4 = this.FfieldCount - 1; n4 > -1; --n4) {
                map2 = (Map)this.FacroFormDataList.get(n4);
                if (n != this.getPageForComponent(n, map2) || hashMap.get(v = map2.get("obj")) != null) continue;
                formObject = new FormObject();
                this.fDecoder.createAppearanceString(formObject, map2, this.currentPdfFile, n);
                if (formObject == null) continue;
                string2 = (String)map2.get("Parent");
                if (string2 != null) {
                    formObject.setParent(string2);
                }
                formObject.setPageNumber(n);
                formObject.setPDFRef((String)v);
                formObjectArray2[n5++] = formObject;
                if (v != null) {
                    hashMap.put(v, "x");
                    map = formObject.getKidData();
                    if (map != null) {
                        iterator = formObject.getKidData().keySet().iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            hashMap.put(string, "x");
                        }
                    }
                }
                this.compData.storeRawData(formObject);
            }
            n5 = 0;
            for (n4 = this.AfieldCount - 1; n4 > -1; --n4) {
                map2 = (Map)this.AacroFormDataList.get(n4);
                v = map2.get("obj");
                if (v != null && hashMap.get(v) != null || n != this.getPageForComponent(n, map2)) continue;
                map2.remove("PageNumber");
                if (hashMap.get(v) != null) continue;
                map2.remove("obj");
                formObject = new FormObject();
                this.annotDecoder.createAppearanceString(formObject, map2, this.currentPdfFile, n);
                if (formObject == null) continue;
                string2 = (String)map2.get("Parent");
                if (string2 != null) {
                    formObject.setParent(string2);
                }
                formObject.setPageNumber(n);
                formObject.setPDFRef((String)v);
                formObjectArray3[n5++] = formObject;
                this.compData.storeRawData(formObject);
                hashMap.put(v, "x");
                map = formObject.getKidData();
                if (map == null) continue;
                iterator = formObject.getKidData().keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    hashMap.put(string, "x");
                }
            }
            if (this.hasXFA) {
                this.fDecoder.resetItems();
                formObjectArray = ((XFAFormStream)this.fDecoder).createAppearanceString(formObjectArray2, this.currentPdfFile);
                if (formObjectArray != null) {
                    n6 = formObjectArray.length;
                }
            }
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            if (formObjectArray != null) {
                for (int i = 0; i < n6; ++i) {
                    formObject = formObjectArray[i];
                    if (formObject == null || n != formObject.getPageNumber()) continue;
                    this.createField(n, formObject, this.compData.getNextFreeField(), false);
                    hashMap2.put(formObject.getPDFRef(), "x");
                }
            }
            for (n3 = 0; n3 < this.FfieldCount; ++n3) {
                formObject = formObjectArray2[n3];
                if (formObject == null || hashMap2.get(formObject.getPDFRef()) != null || n != formObject.getPageNumber()) continue;
                this.createField(n, formObject, this.compData.getNextFreeField(), false);
                hashMap2.put(formObject.getPDFRef(), "x");
            }
            for (n3 = 0; n3 < this.AfieldCount; ++n3) {
                formObject = formObjectArray3[n3];
                if (formObject == null || n != formObject.getPageNumber()) continue;
                this.createField(n, formObject, this.compData.getNextFreeField(), false);
            }
        }
        this.compData.completeFields(n);
    }

    public Object getFormDataAsObject(String string) {
        return this.compData.getRawForm(string);
    }

    private int getPageForComponent(int n, Map map) {
        Object object;
        int n2 = -1;
        Object object2 = this.currentPdfFile.resolveToMapOrString("PageNumber", map.get("PageNumber"));
        if (object2 != null) {
            n2 = Integer.parseInt((String)object2);
        }
        if (n2 == -1 && map.containsKey("Kids") && (object = this.currentPdfFile.resolveToMapOrString("Kids", map.get("Kids"))) instanceof Map) {
            Map map2 = (Map)object;
            Iterator iterator = map2.keySet().iterator();
            int n3 = 0;
            int n4 = -1;
            while (iterator.hasNext()) {
                Object object3;
                String string = (String)iterator.next();
                Object object4 = this.currentPdfFile.resolveToMapOrString(string, map2.get(string));
                if (object4 instanceof Map && (object3 = this.currentPdfFile.resolveToMapOrString("PageNumber", ((Map)object4).get("PageNumber"))) != null) {
                    n4 = Integer.parseInt((String)object3);
                }
                if (n4 == n) {
                    n2 = n4;
                }
                ++n3;
            }
        }
        return n2;
    }

    public void displayComponentsOnscreen(int n, int n2) {
        this.compData.displayComponents(n, ++n2);
    }

    private void createField(int n, FormObject formObject, int n2, boolean bl) {
        if (!bl) {
            this.compData.resetButtonGroup();
        }
        Integer n3 = FormFactory.UNKNOWN;
        Object object = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = formObject.getType();
        if (n4 != -1) {
            bl2 = n4 == 0;
            bl3 = n4 == 2;
            bl4 = n4 == 1;
            boolean bl6 = bl5 = n4 == 3;
        }
        if (bl5) {
            if (this.sigObject == null) {
                this.sigObject = new HashSet();
            }
            this.sigObject.add(formObject);
        }
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null) {
            bl7 = blArray[1];
            bl8 = blArray[2];
            bl9 = blArray[3];
        }
        if (bl2) {
            boolean bl10 = false;
            boolean bl11 = false;
            boolean bl12 = false;
            boolean bl13 = false;
            if (blArray != null) {
                bl10 = blArray[16];
                bl11 = blArray[15];
                bl12 = blArray[14];
                bl13 = blArray[25];
            }
            if (bl10) {
                n3 = FormFactory.PUSHBUTTON;
                object = this.formFactory.pushBut(formObject);
            } else {
                Object object2;
                Object object3;
                n3 = bl11 ? FormFactory.RADIOBUTTON : FormFactory.CHECKBOXBUTTON;
                if (formObject.getKidData() != null) {
                    object3 = formObject.getKidData();
                    object2 = object3.keySet().iterator();
                    while (object2.hasNext()) {
                        String string = (String)object2.next();
                        FormObject formObject2 = (FormObject)object3.get(string);
                        formObject2.setParent(formObject.getParentRef());
                        formObject2.setPDFRef(string);
                        if (n != formObject2.getPageNumber()) continue;
                        this.createField(n, formObject2, ++n2, true);
                        this.compData.storeRawData(formObject2);
                    }
                }
                if ((object3 = formObject.getPDFRef()) != null && (object2 = (String)this.formKids.get(formObject.getPDFRef())) != null) {
                    formObject.setAnnotParent((String)object2);
                }
                object = bl11 ? this.formFactory.radioBut(formObject) : this.formFactory.checkBoxBut(formObject);
            }
        } else if (bl3) {
            boolean bl14 = false;
            boolean bl15 = false;
            boolean bl16 = false;
            boolean bl17 = false;
            boolean bl18 = false;
            boolean bl19 = false;
            if (blArray != null) {
                bl14 = blArray[12];
                bl15 = blArray[13];
                bl16 = blArray[23];
                bl17 = blArray[25];
                bl18 = blArray[20];
                bl19 = blArray[22];
            }
            if (bl14) {
                if (bl15) {
                    n3 = FormFactory.MULTILINEPASSWORD;
                    object = this.formFactory.multiLinePassword(formObject);
                } else {
                    n3 = FormFactory.MULTILINETEXT;
                    object = this.formFactory.multiLineText(formObject);
                }
            } else if (bl15) {
                n3 = FormFactory.SINGLELINEPASSWORD;
                object = this.formFactory.singleLinePassword(formObject);
            } else {
                n3 = FormFactory.SINGLELINETEXT;
                object = this.formFactory.singleLineText(formObject);
            }
        } else if (bl4) {
            boolean bl20 = false;
            boolean bl21 = false;
            boolean bl22 = false;
            boolean bl23 = false;
            boolean bl24 = false;
            boolean bl25 = false;
            if (blArray != null) {
                bl20 = blArray[17];
                bl21 = blArray[21];
                bl22 = blArray[19];
                bl23 = blArray[18];
                bl24 = blArray[22];
                bl25 = blArray[26];
            }
            if (bl20) {
                n3 = FormFactory.COMBOBOX;
                object = this.formFactory.comboBox(formObject);
            } else {
                n3 = FormFactory.LIST;
                object = this.formFactory.listField(formObject);
            }
        } else if (bl5) {
            n3 = FormFactory.SIGNATURE;
            object = this.formFactory.signature(formObject);
        } else {
            n3 = FormFactory.ANNOTATION;
            object = this.formFactory.annotationButton(formObject);
        }
        this.compData.completeField(formObject, n2, bl, n3, object);
    }

    public void reportError(int n, Object[] objectArray) {
        boolean bl = false;
        if (this.userExpressionEngine != null) {
            bl = this.userExpressionEngine.reportError(n, objectArray);
        }
        if (!bl) {
            this.compData.reportError(n, objectArray);
        }
    }

    public void setJavaScriptObject(Javascript javascript, Object object) {
        this.javascript = javascript;
        if (this.compData != null) {
            this.compData.setJavascript(javascript);
        }
        this.userExpressionEngine = (ExpressionEngine)object;
    }

    public Object[] getComponentsByName(String string) {
        for (int i = 1; i < this.pageCount + 1; ++i) {
            this.createDisplayComponentsForPage(i);
        }
        return this.compData.getComponentsByName(string);
    }

    public List getComponentNameList() throws PdfException {
        if (this.AfieldCount == 0 && this.FfieldCount == 0) {
            return null;
        }
        for (int i = 1; i < this.pageCount + 1; ++i) {
            this.createDisplayComponentsForPage(i);
        }
        return this.getComponentNameList(-1);
    }

    public List getComponentNameList(int n) throws PdfException {
        if (this.FfieldCount == 0 && this.AfieldCount == 0) {
            return null;
        }
        return this.compData.getComponentNameList(n);
    }

    public void setFormFactory(FormFactory formFactory) {
        this.formFactory = formFactory;
        this.formsActionHandler.setActionFactory(this.formFactory.getActionFactory());
        this.compData = this.formFactory.getCustomCompData();
        this.compData.setJavascript(this.javascript);
    }

    public void openFile(int n) {
        this.pageCount = n;
        this.compData.reset();
        this.compData.flushFormData();
    }

    public Map getSignatureObject(String string) {
        Map map = this.currentPdfFile.readObject(new PdfObject(string), string, false, null);
        Object v = map.get("V");
        if (v == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Name", "x");
        hashMap.put("Reason", "x");
        hashMap.put("Location", "x");
        hashMap.put("M", "x");
        hashMap.put("Cert", "x");
        map = v instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)v), (String)v, false, hashMap) : (Map)v;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            byte[] byArray = (byte[])map.get(k);
            if (byArray == null || k.equals("Cert")) continue;
            map.put(k, this.currentPdfFile.getTextString(byArray));
        }
        return map;
    }

    public GUIData getCompData() {
        return this.compData;
    }

    public Iterator getSignatureObjects() {
        if (this.sigObject == null) {
            return null;
        }
        return this.sigObject.iterator();
    }

    public ActionHandler getActionHandler() {
        return this.formsActionHandler;
    }

    public FormFactory getFormFactory() {
        return this.formFactory;
    }

    public Map getRawFormData() {
        return this.compData.getRawFormData();
    }

    public void setIgnoreForms(boolean bl) {
        this.ignoreForms = bl;
    }

    public boolean ignoreForms() {
        return this.ignoreForms;
    }
}

