/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.PdfHeightTable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.images.ImageOps;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfArray;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.StoryData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfColorSpaceObject;
import org.jpedal.objects.raw.PdfFunctionObject;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.PdfXObject;
import org.jpedal.objects.structuredtext.StructuredContentHandler;
import org.jpedal.parser.Cmd;
import org.jpedal.parser.FontFactory;
import org.jpedal.parser.StreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Object;

public class PdfStreamDecoder
implements StreamDecoder {
    private boolean showTextAsRotated = false;
    private boolean doNotRotate = false;
    public static boolean useShading = true;
    private boolean TRFlagged = false;
    ImageHandler customImageHandler = null;
    boolean rejectSuperimposedImages = false;
    private int startInlineStream = 0;
    public static boolean showCommands = false;
    protected static boolean showShapes = false;
    protected static boolean pauseOnTJ = false;
    protected static boolean pauseOnShape = false;
    protected static boolean pauseOnImage = false;
    protected int glyphCount = 0;
    private int optionsApplied = 0;
    private boolean generateGlyphOnRender = false;
    static final int[] prefixes = new int[]{60, 40};
    static final int[] suffixes = new int[]{62, 41};
    boolean isMask = true;
    private boolean pageSuccessful = true;
    private String pageErrorMessages = "";
    private StringBuffer textData;
    private StatusBar statusBar = null;
    public static float currentThreshold = 0.6f;
    public static Map currentThresholdValues;
    private int textPrint = 0;
    protected boolean multipleTJs = false;
    private PdfObjectReader currentPdfFile;
    private boolean isClip = false;
    private static final float THOUSAND = 1000.0f;
    private boolean renderText = false;
    private boolean renderImages = false;
    private boolean renderPage = false;
    private boolean rawImagesExtracted = true;
    private boolean finalImagesExtracted = true;
    private boolean xFormMetadata = true;
    private boolean clippedImagesExtracted = true;
    private boolean markedContentExtracted = false;
    private StructuredContentHandler contentHandler;
    private boolean textExtracted = true;
    private boolean textColorExtracted = false;
    private boolean colorExtracted = false;
    private static final String[] hex;
    private PdfData pdfData = new PdfData();
    private String font_as_string = "";
    protected GenericColorSpace strokeColorSpace = new DeviceRGBColorSpace();
    protected GenericColorSpace nonstrokeColorSpace = new DeviceRGBColorSpace();
    private boolean createScaledVersion = true;
    private PdfImageData pdfImages = new PdfImageData();
    private int tokenNumber = 0;
    private boolean isPageContent = true;
    private boolean isStackInitialised = false;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Object clipStack;
    private Vector_Object textStateStack;
    private PageLines pageLines = new PageLines();
    private PdfShape currentDrawShape = new PdfShape();
    private static final int MAXOPS = 50;
    private int currentOp = 0;
    private int operandCount = 0;
    private int imageCount = 0;
    private String[] operand = new String[50];
    private int[] opStart = new int[50];
    private int[] opEnd = new int[50];
    protected int moveCommand = 0;
    private String currentFont = "";
    private String currentImage = "";
    private Map globalXObjects = new Hashtable();
    private Map localXObjects = new Hashtable();
    protected float charSpacing = 0.0f;
    protected GraphicsState gs = new GraphicsState();
    protected TextState currentTextState = new TextState();
    protected PdfFont currentFontData;
    private Map GraphicsStates = new HashMap();
    private Map fonts = new Hashtable();
    private Map colorspaces = new HashMap();
    private Map patterns = new HashMap();
    private Map shadings = new HashMap();
    private int textLength = 0;
    private boolean useHiResImageForDisplay = false;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private PdfPageData pageData = new PdfPageData();
    protected DynamicVectorRenderer current;
    static final double radiansToDegrees = 57.29577951308232;
    public static final int UNSET = 0;
    public static final int PATTERN = 1;
    double rotationAsRadians = 0.0;
    protected GlyphFactory factory = null;
    private int pageNum;
    private static String fontsInFile;
    private String currentColor = "<color C='1' M='1' Y='1' K='1'>";
    private int T3maxWidth;
    private int T3maxHeight;
    private boolean legacyTextMode = false;
    private boolean extractRawCMYK = false;
    protected boolean renderDirectly;
    protected Graphics2D g2;
    private Shape defaultClip;
    private boolean hasEmbeddedFonts = false;
    private boolean includeImagesInData = false;
    protected int lastFontSize = -1;
    public boolean ignoreColors = false;
    private boolean isPrinting;
    private String fileName = "";
    private ObjectStore objectStoreStreamRef;
    private String lastFormID = null;
    private int pageH;
    private int formLevel = 0;
    private boolean requestExit = false;
    private boolean exited = false;
    private boolean imagesProcessedFully;
    private boolean keepRaw = false;
    public static boolean runningStoryPad;
    private static final float[] matches;
    private Map scalings = new HashMap();
    private boolean isType3Font;
    private Map TRPDFfunctionsCache = new HashMap();
    private Map imposedImages;
    public static boolean showInvisibleText;
    public static boolean useTextPrintingForNonEmbeddedFonts;
    private int currentRotation = 0;
    float unRotatedY = -1.0f;
    float lastHeight = -1.0f;
    private float rotatedY;
    public static boolean includeRotation;
    private Map lines = new HashMap();
    private int streamType = 0;
    public static final boolean debugRes = false;
    private static final int[][] intValues;
    private static final float[][] floatValues;

    public void setName(String string) {
        if (string != null) {
            this.fileName = string.toLowerCase();
            int n = this.fileName.lastIndexOf(47);
            if (n != -1) {
                this.fileName = this.fileName.substring(n + 1);
            }
            if ((n = this.fileName.lastIndexOf(92)) != -1) {
                this.fileName = this.fileName.substring(n + 1);
            }
            if ((n = this.fileName.lastIndexOf(46)) != -1) {
                this.fileName = this.fileName.substring(0, n);
            }
        }
    }

    public void setStore(ObjectStore objectStore) {
        this.objectStoreStreamRef = objectStore;
        this.current = new DynamicVectorRenderer(this.pageNum, this.objectStoreStreamRef, this.isPrinting);
        this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
        if (this.customImageHandler != null && this.current != null) {
            this.current.setCustomImageHandler(this.customImageHandler);
        }
    }

    public PdfStreamDecoder(PdfObjectReader pdfObjectReader, boolean bl, boolean bl2) {
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.currentPdfFile = pdfObjectReader;
        this.useHiResImageForDisplay = bl;
        this.isType3Font = bl2;
        String string = System.getProperty("org.jpedal.rejectsuperimposedimages");
        this.rejectSuperimposedImages = string != null && string.toLowerCase().indexOf("true") != -1;
    }

    public PdfStreamDecoder(PdfObjectReader pdfObjectReader) {
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.currentPdfFile = pdfObjectReader;
        String string = System.getProperty("org.jpedal.rejectsuperimposedimages");
        this.rejectSuperimposedImages = string != null && string.toLowerCase().indexOf("true") != -1;
    }

    public PdfStreamDecoder() {
        String string;
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.rejectSuperimposedImages = (string = System.getProperty("org.jpedal.rejectsuperimposedimages")) != null && string.toLowerCase().indexOf("true") != -1;
    }

    public void print(Graphics2D graphics2D, AffineTransform affineTransform, boolean bl, int n) {
        if (bl) {
            this.current.setBackgroundColor(null);
        }
        this.current.setPrintPage(n);
        this.current.paint(graphics2D, null, affineTransform, null, false, false);
    }

    public PdfStreamDecoder(boolean bl) {
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.useHiResImageForDisplay = bl;
        String string = System.getProperty("org.jpedal.rejectsuperimposedimages");
        this.rejectSuperimposedImages = string != null && string.toLowerCase().indexOf("true") != -1;
    }

    public void setDefaultColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.strokeColorSpace.setColor(pdfPaint);
        this.nonstrokeColorSpace.setColor(pdfPaint2);
        this.gs.setStrokeColor(pdfPaint);
        this.gs.setNonstrokeColor(pdfPaint2);
    }

    public void optimiseDisplayForPrinting() {
        this.isPrinting = true;
    }

    public PdfData getText() {
        return this.pdfData;
    }

    public PdfImageData getImages() {
        return this.pdfImages;
    }

    private final BufferedImage processImageXObject(PdfObject pdfObject, String string, boolean bl, byte[] byArray) throws PdfException {
        LogWriter.writeMethod("{processImageXObject}", 0);
        boolean bl2 = false;
        BufferedImage bufferedImage = null;
        string = this.fileName + '-' + string;
        int n = 1;
        int n2 = pdfObject.getInt(959726687);
        int n3 = pdfObject.getInt(959926393);
        int n4 = pdfObject.getInt(-1344207655);
        if (n4 != -1) {
            n = n4;
        }
        bl2 = this.isMask = pdfObject.getBoolean(1516403337);
        PdfObject pdfObject2 = pdfObject.getDictionary(2087749783);
        GenericColorSpace genericColorSpace = new DeviceRGBColorSpace();
        if (pdfObject2 != null) {
            genericColorSpace = ColorspaceFactory.getColorSpaceInstance(this.isPrinting, this.currentPdfFile, pdfObject2);
        }
        String string2 = pdfObject.getStringValue(1144346498);
        genericColorSpace.setIntent(string2);
        LogWriter.writeLog("Processing XObject: " + string + " width=" + n2 + " Height=" + n3 + " Depth=" + n + " colorspace=" + genericColorSpace);
        if (this.customImageHandler != null) {
            bufferedImage = this.customImageHandler.processImageData(this.gs, pdfObject, pdfObject2);
        }
        if (this.customImageHandler == null || bufferedImage == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
            bufferedImage = this.processImage(genericColorSpace, byArray, string, n2, n3, n, bl2, bl, pdfObject);
        }
        return bufferedImage;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final BufferedImage processImage(GenericColorSpace var1_1, byte[] var2_2, String var3_3, int var4_4, int var5_5, int var6_6, boolean var7_7, boolean var8_8, PdfObject var9_9) throws PdfException {
        block127: {
            block129: {
                block128: {
                    block126: {
                        if (LogWriter.debug) {
                            LogWriter.writeMethod("{process_image} imageMask=" + var7_7);
                        }
                        var10_10 = var9_9.getFloatArray(859785322);
                        var11_11 = var9_9.getArrayIterator(1011108731);
                        var12_12 = false;
                        var13_13 = false;
                        var14_14 = -1;
                        if (var11_11 != null && var11_11.hasMoreTokens()) {
                            while (var11_11.hasMoreTokens()) {
                                var14_14 = var11_11.getNextValueAsConstant(true);
                                var12_12 = var14_14 == 1180911742;
                                var13_13 = var14_14 == 1399277700;
                            }
                        } else {
                            var11_11 = null;
                        }
                        var15_15 = false;
                        var16_16 = false;
                        var17_17 = null;
                        var18_18 = "jpg";
                        var19_19 = var1_1.getID();
                        var20_20 = var1_1.getColorSpace().getNumComponents();
                        var21_21 = 0;
                        var22_22 = 0;
                        var23_23 = new byte[4];
                        if (var7_7) {
                            this.getMaskColor(var23_23);
                        }
                        if (this.renderPage && this.streamType != 1) {
                            if (SamplingFactory.downsampleLevel == SamplingFactory.high) {
                                var24_24 = new float[3][3];
                                for (var25_25 = 0; var25_25 < 3; ++var25_25) {
                                    for (var26_27 = 0; var26_27 < 3; ++var26_27) {
                                        var24_24[var25_25][var26_27] = this.gs.CTM[var25_25][var26_27] < 0.0f ? (Object)(-this.gs.CTM[var25_25][var26_27]) : (Object)this.gs.CTM[var25_25][var26_27];
                                    }
                                }
                                var21_21 = var24_24[0][0] == 0.0f || var24_24[0][0] < var24_24[0][1] ? (int)var24_24[0][1] : (int)var24_24[0][0];
                                var22_22 = var24_24[1][1] == 0.0f || var24_24[1][1] < var24_24[1][0] ? (int)var24_24[1][0] : (int)var24_24[1][1];
                                if (var4_4 < 500 || var5_5 < 500) {
                                    var21_21 = 0;
                                    var22_22 = 0;
                                }
                            } else if (SamplingFactory.downsampleLevel == SamplingFactory.medium) {
                                var21_21 = this.pageData.getCropBoxWidth(this.pageNum);
                                var22_22 = this.pageData.getCropBoxHeight(this.pageNum);
                            }
                        }
                        var24_24 = var9_9.getDictionary(1888135062);
                        var25_26 = null;
                        var26_28 = null;
                        var25_26 = var9_9.getDictionary(489767739);
                        var26_28 = var9_9.getDictionary(489767774);
                        var27_29 = false;
                        if (var10_10 != null && !var7_7) {
                            var27_29 = true;
                            var28_30 = var10_10.length;
                            for (var29_38 = 0; var29_38 < var28_30; var29_38 += 2) {
                                if (var10_10[var29_38] == 1.0f && var10_10[var29_38 + 1] == 0.0f) continue;
                                var27_29 = false;
                                var29_38 = var28_30;
                            }
                        }
                        if (!(!this.renderPage || var25_26 != null || var1_1.getID() == 1247168582 || !var27_29 && var10_10 != null && var10_10.length != 0 || var6_6 != 1 && var6_6 != 8 || var21_21 <= 0 || var22_22 <= 0 || !SamplingFactory.isPrintDownsampleEnabled && this.isPrinting)) {
                            var28_30 = var4_4;
                            var29_38 = var5_5;
                            if (var26_28 != null) {
                                var30_46 = var26_28.getInt(959726687);
                                var31_55 = var26_28.getInt(959926393);
                                if (var30_46 < var4_4 || var31_55 < var5_5) {
                                    var4_4 = var30_46;
                                    var5_5 = var31_55;
                                }
                            }
                            var30_46 = 1;
                            var31_55 = var22_22 << 2;
                            var32_62 = var21_21 << 2;
                            while (var28_30 > var32_62 && var29_38 > var31_55) {
                                var30_46 <<= 1;
                                var28_30 >>= 1;
                                var29_38 >>= 1;
                            }
                            var33_64 = var4_4 / var21_21;
                            if (var33_64 < 1) {
                                var33_64 = 1;
                            }
                            if ((var34_70 = var5_5 / var22_22) < 1) {
                                var34_70 = 1;
                            }
                            if ((var30_46 = var33_64) > var34_70) {
                                var30_46 = var34_70;
                            }
                            if (var30_46 > 1 && PdfDecoder.useFullSizeImage) {
                                PdfDecoder.samplingUsed = var30_46;
                                var30_46 = 1;
                            }
                            if (var30_46 > 1) {
                                var16_16 = true;
                                var35_71 /* !! */  = var1_1.getIndexedMap();
                                var28_30 = var4_4 / var30_46;
                                var29_38 = var5_5 / var30_46;
                                if (var6_6 == 1) {
                                    if (!var7_7 && this.useHiResImageForDisplay) {
                                        var36_73 = var2_2.length;
                                        var37_74 = new byte[var36_73];
                                        System.arraycopy(var2_2, 0, var37_74, 0, var36_73);
                                        var37_74 = ImageOps.invertImage(var37_74, var4_4, var5_5, var6_6, 1, null);
                                        var38_77 = new Integer(this.pageNum);
                                        var39_79 = new Integer(this.imageCount);
                                        var40_81 = var38_77.toString() + var39_79.toString();
                                        this.current.getObjectStore();
                                        ObjectStore.saveRawImageData(var40_81, var37_74, var4_4, var5_5, var21_21, var22_22);
                                    }
                                    if (var35_71 /* !! */  != null) {
                                        var35_71 /* !! */  = var1_1.convertIndexToRGB(var35_71 /* !! */ );
                                    }
                                    var36_73 = var28_30 * var29_38;
                                    if (var7_7) {
                                        var36_73 *= 4;
                                        var23_23[3] = -1;
                                    } else if (var35_71 /* !! */  != null) {
                                        var36_73 *= 3;
                                    }
                                    var37_74 = new byte[var36_73];
                                    var38_77 = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
                                    var39_80 = var4_4 + 7 >> 3;
                                    for (var42_84 = 0; var42_84 < var29_38; ++var42_84) {
                                        for (var43_86 = 0; var43_86 < var28_30; ++var43_86) {
                                            var44_87 = 0;
                                            var45_91 = 0;
                                            var46_92 = var30_46;
                                            var47_93 = var30_46;
                                            var48_94 = var4_4 - var43_86;
                                            var49_95 = var5_5 - var42_84;
                                            if (var46_92 > var48_94) {
                                                var46_92 = var48_94;
                                            }
                                            if (var47_93 > var49_95) {
                                                var47_93 = var49_95;
                                            }
                                            for (var50_96 = 0; var50_96 < var47_93; ++var50_96) {
                                                for (var51_97 = 0; var51_97 < var46_92; ++var51_97) {
                                                    var41_85 = var2_2[(var50_96 + var42_84 * var30_46) * var39_80 + (var43_86 * var30_46 + var51_97 >> 3)];
                                                    if (var7_7) {
                                                        var41_85 = (byte)(var41_85 ^ 255);
                                                    }
                                                    if ((var40_82 = var41_85 & var38_77[7 - (var43_86 * var30_46 + var51_97 & 7)]) != 0) {
                                                        ++var44_87;
                                                    }
                                                    ++var45_91;
                                                }
                                            }
                                            var50_96 = var43_86 + var28_30 * var42_84;
                                            if (var45_91 > 0) {
                                                if (var7_7) {
                                                    for (var51_97 = 0; var51_97 < 4; ++var51_97) {
                                                        var37_74[var50_96 * 4 + var51_97] = (byte)((var23_23[var51_97] & 255) * var44_87 / var45_91);
                                                    }
                                                    continue;
                                                }
                                                if (var35_71 /* !! */  != null) {
                                                    for (var51_97 = 0; var51_97 < 3; ++var51_97) {
                                                        var37_74[var50_96 * 3 + var51_97] = (byte)((var35_71 /* !! */ [var51_97] & 255) * var44_87 / var45_91);
                                                    }
                                                    continue;
                                                }
                                                var37_74[var50_96] = (byte)(255 * var44_87 / var45_91);
                                                continue;
                                            }
                                            if (var7_7) {
                                                for (var51_97 = 0; var51_97 < 3; ++var51_97) {
                                                    var37_74[var50_96 * 4 + var51_97] = 0;
                                                }
                                                continue;
                                            }
                                            if (var35_71 /* !! */  != null) {
                                                for (var51_97 = 0; var51_97 < 3; ++var51_97) {
                                                    var37_74[var50_96 * 3 + var51_97] = 0;
                                                }
                                                continue;
                                            }
                                            var37_74[var50_96] = -1;
                                        }
                                    }
                                    var2_2 = var37_74;
                                    if (var35_71 /* !! */  != null) {
                                        var20_20 = 3;
                                    }
                                    var5_5 = var29_38;
                                    var4_4 = var28_30;
                                    var1_1.setIndex(null, 0);
                                    var6_6 = 8;
                                } else if (var6_6 == 8 && (var11_11 == null || !var12_12 && !var13_13)) {
                                    var36_73 = var1_1.getIndexedMap() != null ? 1 : 0;
                                    var37_75 = 0;
                                    var38_78 = 0;
                                    var39_80 = 0;
                                    var40_83 = 0;
                                    var41_85 = 0;
                                    var42_84 = 0;
                                    var43_86 = 0;
                                    try {
                                        var42_84 = var36_73 != 0 ? 1 : var1_1.getColorComponentCount();
                                        if (var4_4 * var5_5 == var2_2.length || var1_1.getID() == 1568372915) {
                                            var42_84 = 1;
                                        }
                                        var44_88 = new byte[var28_30 * var29_38 * var42_84];
                                        var43_86 = var4_4 * var42_84;
                                        for (var38_78 = 0; var38_78 < var29_38; ++var38_78) {
                                            for (var37_75 = 0; var37_75 < var28_30; ++var37_75) {
                                                var45_91 = var30_46;
                                                var46_92 = var30_46;
                                                var47_93 = var4_4 - var37_75;
                                                var48_94 = var5_5 - var38_78;
                                                if (var45_91 > var47_93) {
                                                    var45_91 = var47_93;
                                                }
                                                if (var46_92 > var48_94) {
                                                    var46_92 = var48_94;
                                                }
                                                for (var41_85 = 0; var41_85 < var42_84; ++var41_85) {
                                                    var49_95 = 0;
                                                    var50_96 = 0;
                                                    for (var40_83 = 0; var40_83 < var46_92; ++var40_83) {
                                                        for (var39_80 = 0; var39_80 < var45_91; ++var39_80) {
                                                            var49_95 += var2_2[(var40_83 + var38_78 * var30_46) * var43_86 + (var37_75 * var30_46 * var42_84 + var39_80 * var42_84 + var41_85)] & 255;
                                                            ++var50_96;
                                                        }
                                                    }
                                                    if (var50_96 <= 0) continue;
                                                    var44_88[var41_85 + var37_75 * var42_84 + var28_30 * var38_78 * var42_84] = (byte)(var49_95 / var50_96);
                                                }
                                            }
                                        }
                                        var2_2 = var44_88;
                                        var5_5 = var29_38;
                                        var4_4 = var28_30;
                                    }
                                    catch (Exception var44_89) {}
                                } else if (var12_12 || var13_13 || var35_71 /* !! */  == null) {
                                    // empty if block
                                }
                            }
                        }
                        if (var10_10 != null && var10_10.length != 0 && (var11_11 == null || !var13_13 && !var12_12)) {
                            this.applyDecodeArray(var2_2, var6_6, var10_10, var19_19);
                        }
                        if (!var7_7) break block126;
                        if (var4_4 == 1 && var5_5 == 1 && var2_2[0] != 0) {
                            var28_31 = this.gs.CTM[1][1];
                            if (var28_31 == 0.0f) {
                                var28_31 = this.gs.CTM[1][0];
                            }
                            if (var28_31 < 0.0f) {
                                var28_31 = -var28_31;
                            }
                            if ((var29_39 = this.gs.CTM[0][0]) == 0.0f) {
                                var29_39 = this.gs.CTM[0][1];
                            }
                            if (var29_39 < 0.0f) {
                                var29_39 = -var29_39;
                            }
                            if (var29_39 < 1.0f) {
                                var29_39 = 1.0f;
                            }
                            if (var28_31 < 1.0f) {
                                var28_31 = 1.0f;
                            }
                            var17_17 = new BufferedImage((int)var29_39, (int)var28_31, 2);
                            var30_47 = var17_17.createGraphics();
                            var30_47.setPaint(this.nonstrokeColorSpace.getColor());
                            var30_47.fillRect(0, 0, (int)var29_39, (int)var28_31);
                        } else {
                            var28_30 = (int)this.current.hasObjectsBehind(this.gs.CTM);
                            if (var16_16) {
                                var29_40 = new DataBufferByte(var2_2, var2_2.length);
                                var30_48 = new int[]{0, 1, 2, 3};
                                var17_17 = new BufferedImage(var4_4, var5_5, 2);
                                var31_56 = Raster.createInterleavedRaster((DataBuffer)var29_40, var4_4, var5_5, var4_4 * 4, 4, var30_48, null);
                                var17_17.setData(var31_56);
                            } else if (var23_23[0] == 0 && var23_23[1] == 0 && var23_23[2] == 0 && var28_30 == 0 && !this.isType3Font) {
                                if (var6_6 == 1) {
                                    var29_40 = Raster.createPackedRaster(new DataBufferByte(var2_2, var2_2.length), var4_4, var5_5, 1, null);
                                    var17_17 = new BufferedImage(var4_4, var5_5, 12);
                                    var17_17.setData((Raster)var29_40);
                                } else {
                                    var29_40 = new int[]{0};
                                    var30_49 = Raster.createInterleavedRaster(new DataBufferByte(var2_2, var2_2.length), var4_4, var5_5, var4_4, 1, (int[])var29_40, null);
                                    var17_17 = new BufferedImage(var4_4, var5_5, 10);
                                    var17_17.setData(var30_49);
                                }
                            } else if (var6_6 == 8 && var16_16) {
                                var29_40 = new byte[]{var23_23[0], var23_23[1], var23_23[2], -1, -1, -1};
                                var17_17 = this.convertIndexedToFlat(var1_1.getID(), var6_6, var4_4, var5_5, var2_2, (byte[])var29_40, ((Object)var29_40).length, true, true);
                            } else {
                                var29_40 = new byte[]{var23_23[0], var23_23[1], var23_23[2], -1, -1, -1};
                                var17_17 = this.convertIndexedToFlat(var1_1.getID(), 1, var4_4, var5_5, var2_2, (byte[])var29_40, ((Object)var29_40).length, true, false);
                            }
                        }
                        break block127;
                    }
                    if (var11_11 != null) break block128;
                    LogWriter.writeLog("Image " + var3_3 + ' ' + var4_4 + "W * " + var5_5 + "H with No Compression at BPC " + var6_6);
                    var17_17 = this.makeImage(var1_1, var4_4, var5_5, var6_6, var2_2, var20_20);
                    break block127;
                }
                if (!var12_12) break block129;
                LogWriter.writeLog("JPeg Image " + var3_3 + ' ' + var4_4 + "W * " + var5_5 + 'H');
                if (var19_19 == 1498837125 && this.extractRawCMYK) {
                    LogWriter.writeLog("Raw CMYK image " + var3_3 + " saved.");
                    if (!this.objectStoreStreamRef.saveRawCMYKImage(var2_2, var3_3)) {
                        this.addPageFailureMessage("Problem saving Raw CMYK image " + var3_3);
                    }
                }
                try {
                    var17_17 = var1_1.JPEGToRGBImage(var2_2, var4_4, var5_5, var10_10, var21_21, var22_22);
                    var15_15 = ColorSpaceConvertor.wasRemoved;
                }
                catch (Exception var28_32) {
                    this.addPageFailureMessage("Problem converting " + var3_3 + " to JPEG");
                    var28_32.printStackTrace();
                    var17_17 = null;
                }
                var18_18 = "jpg";
                break block127;
            }
            if (!var13_13) ** GOTO lbl297
            LogWriter.writeLog("JPeg 2000 Image " + var3_3 + ' ' + var4_4 + "W * " + var5_5 + 'H');
            if (JAIHelper.isJAIused()) {
                var17_17 = var1_1.JPEG2000ToRGBImage(var2_2, var21_21, var22_22);
                var18_18 = "jpg";
            } else {
                LogWriter.writeLog("JPeg 2000 Image needs JAI on classpath and enabled in JPedal");
                throw new RuntimeException("JPeg 2000 Images need both JAI (imageio.jar) on classpath, and the VM parameter -Dorg.jpedal.jai=true switch turned on");
lbl297:
                // 1 sources

                LogWriter.writeLog(var3_3 + ' ' + var4_4 + "W * " + var5_5 + "H BPC=" + var6_6);
                var17_17 = this.makeImage(var1_1, var4_4, var5_5, var6_6, var2_2, var20_20);
                if (var6_6 == 8 || this.nonstrokeColorSpace.getID() == 1785221209 || this.nonstrokeColorSpace.getID() == 1247168582) {
                    var18_18 = "jpg";
                }
            }
        }
        if (var17_17 != null) {
            if (var26_28 != null) {
                var28_33 = null;
                var29_41 = this.currentPdfFile.readStream(var26_28, true, true, this.keepRaw, false, false);
                if (var29_41 != null) {
                    if (var24_24 == null) {
                        var24_24 = var26_28.getDictionary(1888135062);
                    }
                    v0 = var30_50 = var24_24 != null && var24_24.getInt(1010783618) != -1 && var24_24.getInt(1970893723) != 15;
                    if (!var30_50) {
                        var31_57 = this.optionsApplied;
                        if (this.optionsApplied == 0) {
                            this.doNotRotate = true;
                        }
                        var28_33 = this.processImageXObject(var26_28, var3_3, false, var29_41);
                        this.doNotRotate = false;
                        this.optionsApplied = var31_57;
                        var17_17 = this.applySmask(var17_17, var28_33, var26_28);
                    }
                }
            } else if (var25_26 != null) {
                var28_34 = var25_26.getIntArray(489767739);
                if (var28_34 != null) {
                    var29_42 = var1_1.getColorComponentCount();
                    var30_51 = var1_1.getIndexedMap();
                    if (var30_51 != null) {
                        var31_58 = var28_34.length;
                        var33_65 = new int[var29_42 * var31_58];
                        for (var34_70 = 0; var34_70 < var31_58; ++var34_70) {
                            var32_62 = var28_34[var34_70];
                            for (var35_72 = 0; var35_72 < var29_42; ++var35_72) {
                                var33_65[var35_72 + var34_70 * var29_42] = var30_51[var32_62 * var29_42 + var35_72] & 255;
                            }
                        }
                        var28_34 = var33_65;
                    }
                    var31_59 = var28_34.length;
                    var32_62 = var31_59 / var29_42;
                    var33_66 = 0;
                    var35_71 /* !! */  = (byte[])new int[var32_62][var29_42];
                    for (var36_73 = 0; var36_73 < var32_62; ++var36_73) {
                        for (var37_76 = 0; var37_76 < var29_42; ++var37_76) {
                            var34_70 = var28_34[var33_66];
                            ++var33_66;
                            if (var29_42 == 1) {
                                var35_71 /* !! */ [var36_73][0] = var34_70;
                                var35_71 /* !! */ [var36_73][1] = var34_70;
                                var35_71 /* !! */ [var36_73][2] = var34_70;
                                continue;
                            }
                            if (var29_42 != 3) continue;
                            var35_71 /* !! */ [var36_73][var37_76] = var34_70;
                        }
                    }
                    var17_17 = this.convertPixelsToTransparent(var17_17, var29_42, var32_62, (int[][])var35_71 /* !! */ );
                } else {
                    var29_43 = this.currentPdfFile.readStream(var25_26, true, true, this.keepRaw, false, false);
                    var30_52 = var25_26.getInt(959726687);
                    var31_60 = var25_26.getInt(959926393);
                    var32_62 = 3;
                    if ((this.optionsApplied & var32_62) == var32_62) {
                        var33_67 = ImageOps.rotateImage(var29_43, var30_52, var31_60, 1, 1, null);
                        if (var33_67 != null && (var33_67 = ImageOps.rotateImage(var33_67, var30_52 = (var34_70 = var31_60), var31_60 = var30_52, var6_6, 1, null)) != null) {
                            var34_70 = var31_60;
                            var31_60 = var30_52;
                            var30_52 = var34_70;
                        }
                        var29_43 = var33_67;
                    } else if ((this.optionsApplied & 1) == 1) {
                        var33_68 = ImageOps.invertImage(var29_43, var30_52, var31_60, 1, 1, null);
                        var29_43 = var33_68;
                    }
                    if ((this.optionsApplied & 2) == 2) {
                        var33_69 = ImageOps.rotateImage(var29_43, var30_52, var31_60, var6_6, 1, null);
                        var29_43 = var33_69;
                    }
                    if (var29_43 != null) {
                        var17_17 = this.overlayImage(var17_17, var29_43, var25_26);
                    }
                }
            }
            if (var19_19 == 1498837125 && this.gs.getOPM() == 1.0f) {
                var28_35 = this.current.hasObjectsBehind(this.gs.CTM);
                var29_44 = false;
                if (var28_35) {
                    var29_44 = true;
                    for (var30_53 = 0; var30_53 < var2_2.length; ++var30_53) {
                        if (var2_2[var30_53] == 0) continue;
                        var30_53 = var2_2.length;
                        var29_44 = false;
                    }
                }
                if (var29_44) {
                    var17_17 = null;
                } else if (this.gs.getNonStrokeOP()) {
                    var17_17 = this.simulateOP(var17_17);
                }
                if (var17_17 == null) {
                    return null;
                }
            }
            var2_2 = null;
            if (var17_17.getSampleModel().getNumBands() == 1) {
                var18_18 = "tif";
            }
            if (this.isPageContent && (this.clippedImagesExtracted || this.finalImagesExtracted || this.rawImagesExtracted)) {
                if (this.currentPdfFile.isExtractionAllowed()) {
                    if (!PdfStreamDecoder.runningStoryPad) {
                        this.objectStoreStreamRef.saveStoredImage(var3_3, this.addBackgroundToMask(var17_17), false, var8_8, var18_18);
                    }
                } else if (PdfDecoder.dpi != 72) {
                    var28_36 = var17_17.getType();
                    if (var28_36 == 0) {
                        var28_36 = 1;
                    }
                    var29_45 = new BufferedImage(var17_17.getWidth(), var17_17.getHeight(), var28_36);
                    var29_45.createGraphics().drawImage(var17_17, null, null);
                    var30_54 = (float)PdfDecoder.dpi / 72.0f;
                    var31_61 = new AffineTransform();
                    var31_61.scale(var30_54, var30_54);
                    var32_63 = new AffineTransformOp(var31_61, ColorSpaces.hints);
                    var29_45 = var32_63.filter(var29_45, null);
                    this.objectStoreStreamRef.saveStoredImage(var3_3, this.addBackgroundToMask(var29_45), false, var8_8, var18_18);
                } else {
                    this.objectStoreStreamRef.saveStoredImage(var3_3, this.addBackgroundToMask(var17_17), false, var8_8, var18_18);
                }
            }
        }
        if (var17_17 == null && !var15_15) {
            this.imagesProcessedFully = false;
        }
        if ((var28_37 = this.gs.getTR()) != null) {
            var17_17 = this.applyTR(var17_17, var28_37);
        }
        if (var24_24 != null && var24_24.getInt(1010122310) != -1 && this.current.hasObjectsBehind(this.gs.CTM)) {
            var17_17 = this.makeBlackandWhiteTransparent(var17_17);
        }
        if (PdfStreamDecoder.pauseOnImage) {
            ShowGUIMessage.showGUIMessage("x", var17_17, "y");
        }
        return var17_17;
    }

    private BufferedImage overlayImage(BufferedImage bufferedImage, byte[] byArray, PdfObject pdfObject) {
        bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = pdfObject.getInt(959726687);
        int n2 = pdfObject.getInt(959926393);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        boolean bl = n3 != n || n4 != n2;
        float f = 0.0f;
        if (bl) {
            float f2 = (float)n3 / (float)n;
            float f3 = (float)n4 / (float)n2;
            f = f2 > f3 ? f2 : f3;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n5 = n;
        if ((n5 & 7) != 0) {
            n5 += 8;
        }
        n5 >>= 3;
        int n6 = 0;
        int[] nArray = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
        for (int i = 0; i < n2; ++i) {
            int n7;
            if (bl) {
                n7 = (int)(f * (float)i);
                if (n7 > n4) {
                    n7 = n4;
                }
            } else {
                n7 = i;
            }
            for (int j = 0; j < n; ++j) {
                int n8;
                byte by;
                boolean bl2;
                int n9;
                if (bl) {
                    n9 = (int)(f * (float)j);
                    if (n9 > n3) {
                        n9 = n4;
                    }
                } else {
                    n9 = j;
                }
                boolean bl3 = bl2 = ((by = byArray[n6 + (n8 = j >> 3)]) & nArray[j & 7]) != 0;
                if (bl2) continue;
                int[] nArray2 = new int[3];
                nArray2 = writableRaster.getPixel(n9, n7, nArray2);
                writableRaster2.setPixel(j, i, new int[]{nArray2[0], nArray2[1], nArray2[2], 255});
            }
            n6 += n5;
        }
        return bufferedImage2;
    }

    private BufferedImage convertPixelsToTransparent(BufferedImage bufferedImage, int n, int n2, int[][] nArray) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        int[] nArray2 = new int[]{255, 0, 0, 0};
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int[] nArray3 = new int[4];
                writableRaster.getPixel(j, i, nArray3);
                boolean bl = true;
                for (int k = 0; k < n2; ++k) {
                    bl = false;
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (nArray[k][i2] == nArray3[i2]) continue;
                        i2 = n;
                        bl = true;
                    }
                    if (bl) continue;
                    bufferedImage.getRaster().setPixel(j, i, nArray2);
                    k = n2;
                }
            }
        }
        return bufferedImage;
    }

    private BufferedImage simulateOP(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        boolean bl = false;
        int[] nArray = new int[]{255, 0, 0, 0};
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                boolean bl2;
                int[] nArray2 = new int[4];
                writableRaster.getPixel(j, i, nArray2);
                boolean bl3 = bl2 = nArray2[1] < 3 && nArray2[2] < 3 && nArray2[3] < 3;
                if (bl2) {
                    bufferedImage.getRaster().setPixel(j, i, nArray);
                    continue;
                }
                bl = true;
            }
        }
        if (bl) {
            return bufferedImage;
        }
        return null;
    }

    private BufferedImage makeBlackandWhiteTransparent(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        boolean bl = false;
        int[] nArray = new int[]{255, 0, 0, 0};
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                boolean bl2;
                int[] nArray2 = new int[3];
                writableRaster.getPixel(j, i, nArray2);
                boolean bl3 = nArray2[0] > 245 && nArray2[1] > 245 && nArray2[2] > 245;
                boolean bl4 = bl2 = nArray2[0] < 10 && nArray2[1] < 10 && nArray2[2] < 10;
                if (bl3 || bl2) {
                    bufferedImage2.getRaster().setPixel(j, i, nArray);
                    continue;
                }
                bl = true;
                int[] nArray3 = new int[4];
                nArray3[3] = 255;
                nArray3[0] = nArray2[0];
                nArray3[1] = nArray2[1];
                nArray3[2] = nArray2[2];
                bufferedImage2.getRaster().setPixel(j, i, nArray3);
            }
        }
        if (bl) {
            return bufferedImage2;
        }
        return null;
    }

    private BufferedImage applyTR(BufferedImage bufferedImage, PdfObject pdfObject) {
        Object object;
        int n;
        PDFFunction[] pDFFunctionArray;
        Object var4_3 = null;
        if (var4_3 != null) {
            pDFFunctionArray = var4_3;
        } else {
            pDFFunctionArray = new PDFFunction[4];
            int n2 = 0;
            byte[][] byArray = pdfObject.getKeyArray(9250);
            if (byArray != null) {
                n2 = byArray.length;
            }
            for (n = 0; n < n2; ++n) {
                object = new String(byArray[n]);
                PdfFunctionObject pdfFunctionObject = new PdfFunctionObject((String)object);
                this.currentPdfFile.readObject(pdfFunctionObject, (String)object, false, null);
                if (pdfFunctionObject == null) continue;
                pDFFunctionArray[n] = FunctionFactory.getFunction(pdfFunctionObject, this.currentPdfFile);
            }
            this.TRPDFfunctionsCache.put(pdfObject, pDFFunctionArray);
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (n = 0; n < bufferedImage.getWidth(); ++n) {
                object = new int[4];
                writableRaster.getPixel(n, i, (int[])object);
                for (int j = 0; j < 3; ++j) {
                    float[] fArray = new float[]{(float)object[j] / 255.0f};
                    float[] fArray2 = pDFFunctionArray[j].compute(fArray);
                    object[j] = (int)(255.0f * fArray2[0]);
                }
                bufferedImage.getRaster().setPixel(n, i, (int[])object);
            }
        }
        return bufferedImage;
    }

    private BufferedImage applySmask(BufferedImage bufferedImage, BufferedImage bufferedImage2, PdfObject pdfObject) {
        boolean bl;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        int[] nArray3 = new int[]{0, 0, 0, 0};
        PdfObject pdfObject2 = pdfObject.getDictionary(2087749783);
        boolean bl2 = bl = pdfObject2 != null && pdfObject2.getParameterConstant(2087749783) == 1568372915;
        if (bl) {
            bufferedImage2 = ColorSpaceConvertor.convertColorspace(bufferedImage2, 10);
            nArray2 = nArray;
        }
        WritableRaster writableRaster = bufferedImage2.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        float f = 0.0f;
        if (n != n3 || n2 != n4) {
            float f2 = (float)n / (float)n3;
            float f3 = (float)n2 / (float)n4;
            f = f2 > f3 ? f2 : f3;
        }
        int n5 = bufferedImage2.getColorModel().getNumComponents();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int[] nArray4 = new int[n5];
                try {
                    if (f == 0.0f) {
                        writableRaster.getPixel(j, i, nArray4);
                    } else {
                        writableRaster.getPixel((int)((float)j / f), (int)((float)i / f), nArray4);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                boolean bl3 = true;
                bl3 = false;
                if (n5 == 1) {
                    if (nArray4[0] > 127) {
                        bl3 = true;
                    }
                } else {
                    for (int k = 0; k < n5; ++k) {
                        if (nArray4[k] == nArray2[k]) continue;
                        k = n5;
                        bl3 = true;
                    }
                }
                if (bl3) continue;
                bufferedImage.getRaster().setPixel(j, i, nArray3);
            }
        }
        return bufferedImage;
    }

    private void getMaskColor(byte[] byArray) {
        int n = this.nonstrokeColorSpace.getColor().getRGB();
        byArray[0] = (byte)(n >> 16 & 0xFF);
        byArray[1] = (byte)(n >> 8 & 0xFF);
        byArray[2] = (byte)(n & 0xFF);
    }

    private void applyDecodeArray(byte[] byArray, int n, float[] fArray, int n2) {
        int n3;
        int n4;
        int n5 = fArray.length;
        int n6 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            if (!((float)n6 < fArray[n4])) continue;
            n6 = (int)fArray[n4];
        }
        n4 = 1;
        int n7 = fArray.length;
        for (n3 = 0; n3 < n7; n3 += 2) {
            if (fArray[n3] == 0.0f && (fArray[n3 + 1] == 1.0f || fArray[n3 + 1] == 255.0f)) continue;
            n4 = 0;
            n3 = n7;
        }
        if (n4 != 0) {
            return;
        }
        if (n == 1) {
            n3 = byArray.length;
            for (int i = 0; i < n3; ++i) {
                byArray[i] = ~byArray[i];
            }
        } else if (n == 8 && n6 > 1 && (n2 == 1785221209 || n2 == 1008872003 || n2 == 1498837125)) {
            n3 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n8 = byArray[i] & 0xFF;
                if ((float)n8 < fArray[n3]) {
                    n8 = (int)fArray[n3];
                } else if ((float)n8 > fArray[n3 + 1]) {
                    n8 = (int)fArray[n3 + 1];
                }
                if ((n3 += 2) == fArray.length) {
                    n3 = 0;
                }
                byArray[i] = (byte)n8;
            }
        } else {
            n6 = n << 1;
            n3 = n6 - 1;
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 1;
                for (int j = 7; j > -1; --j) {
                    int n13 = by >> j & 1;
                    if ((n13 = (int)(fArray[n11] + (float)n13 * ((fArray[n12] - fArray[n11]) / (float)n3))) > n6) {
                        n13 = n6;
                    }
                    if (n13 < 0) {
                        n13 = 0;
                    }
                    n13 = (n13 & 1) << j;
                    n10 += n13;
                    if ((n9 += 2) == n5) {
                        n9 = 0;
                        n11 = 0;
                        n12 = 1;
                        continue;
                    }
                    n11 += 2;
                    n12 += 2;
                }
                byArray[i] = (byte)n10;
            }
        }
    }

    public void init(boolean bl, boolean bl2, int n, int n2, PdfPageData pdfPageData, int n3, DynamicVectorRenderer dynamicVectorRenderer, PdfObjectReader pdfObjectReader) throws PdfException {
        if (dynamicVectorRenderer != null) {
            this.current = dynamicVectorRenderer;
        }
        this.pageNum = n3;
        this.pageData = pdfPageData;
        this.isPageContent = bl;
        this.currentPdfFile = pdfObjectReader;
        if (this.customImageHandler != null && dynamicVectorRenderer != null) {
            dynamicVectorRenderer.setCustomImageHandler(this.customImageHandler);
        }
        this.pageH = this.pageData.getMediaBoxHeight(n3);
        this.pageLines.setMaxWidth(this.pageData.getCropBoxWidth(n3) - this.pageData.getCropBoxX(n3), this.pageData.getCropBoxHeight(n3) - this.pageData.getCropBoxY(n3));
        this.textExtracted = (n2 & 1) == 1;
        this.renderPage = bl2;
        this.renderText = bl2 && (n & 1) == 1;
        this.renderImages = bl2 && (n & 2) == 2;
        this.clippedImagesExtracted = (n2 & 0x80) == 128;
        this.extractRawCMYK = this.clippedImagesExtracted;
        this.rawImagesExtracted = (n2 & 2) == 2;
        this.clippedImagesExtracted = (n2 & 0x20) == 32;
        this.finalImagesExtracted = (n2 & 4) == 4;
        this.xFormMetadata = (n2 & 0x100) == 256;
        this.textColorExtracted = (n2 & 0x40) == 64;
        boolean bl3 = this.colorExtracted = (n2 & 0x200) == 512;
        if (this.legacyTextMode && this.textExtracted && PdfDecoder.currentHeightLookupData == null) {
            PdfDecoder.currentHeightLookupData = new PdfHeightTable();
        }
        if (this.textColorExtracted) {
            this.pdfData.enableTextColorDataExtraction();
        }
        this.createScaledVersion = this.finalImagesExtracted | this.renderImages;
        this.currentFontData = new PdfFont(pdfObjectReader);
        this.strokeColorSpace = new DeviceRGBColorSpace();
        this.nonstrokeColorSpace = new DeviceRGBColorSpace();
    }

    private final BufferedImage makeImage(GenericColorSpace genericColorSpace, int n, int n2, int n3, byte[] byArray, int n4) {
        int n5;
        Object object;
        boolean bl;
        LogWriter.writeMethod("{makeImage}", 0);
        int n6 = byArray.length;
        byte[] byArray2 = new byte[n6];
        System.arraycopy(byArray, 0, byArray2, 0, n6);
        ColorSpace colorSpace = genericColorSpace.getColorSpace();
        int n7 = genericColorSpace.getID();
        BufferedImage bufferedImage = null;
        byte[] byArray3 = genericColorSpace.getIndexedMap();
        this.optionsApplied = 0;
        boolean bl2 = !this.doNotRotate && (this.renderDirectly || this.useHiResImageForDisplay) && DynamicVectorRenderer.isInverted(this.gs.CTM);
        boolean bl3 = bl = !this.doNotRotate && (this.renderDirectly || this.useHiResImageForDisplay) && DynamicVectorRenderer.isRotated(this.gs.CTM);
        if (this.renderDirectly) {
            bl2 = false;
            bl = false;
        }
        if (bl2 && bl) {
            object = ImageOps.rotateImage(byArray2, n, n2, n3, n4, byArray3);
            if (object != null && (object = ImageOps.rotateImage(object, n = (n5 = n2), n2 = n, n3, n4, byArray3)) != null) {
                n5 = n2;
                n2 = n;
                n = n5;
            }
            if (object != null) {
                byArray2 = object;
                ++this.optionsApplied;
            }
        } else if (bl2 && (object = ImageOps.invertImage(byArray2, n, n2, n3, n4, byArray3)) != null) {
            byArray2 = object;
            ++this.optionsApplied;
        }
        if (bl && (object = ImageOps.rotateImage(byArray2, n, n2, n3, n4, byArray3)) != null) {
            byArray2 = object;
            this.optionsApplied += 2;
            n5 = n2;
            n2 = n;
            n = n5;
        }
        if (byArray3 != null) {
            if (n4 == 4) {
                n4 = 3;
            }
            byArray3 = genericColorSpace.convertIndexToRGB(byArray3);
            int n8 = genericColorSpace.getIndexSize() + 1;
            if (n3 == 4 && n8 > 16) {
                n8 = 16;
            }
            bufferedImage = this.convertIndexedToFlat(genericColorSpace.getID(), n3, n, n2, byArray2, byArray3, n8, false, false);
        } else if (n3 == 1) {
            object = new DataBufferByte(byArray2, byArray2.length);
            WritableRaster writableRaster = Raster.createPackedRaster((DataBuffer)object, n, n2, n3, null);
            bufferedImage = new BufferedImage(n, n2, 12);
            bufferedImage.setData(writableRaster);
        } else if (n7 == -2073385820 | n7 == 960981604) {
            LogWriter.writeLog("Converting Separation/DeviceN colorspace to sRGB ");
            bufferedImage = genericColorSpace.dataToRGB(byArray2, n, n2);
        } else if (n7 == 6) {
            LogWriter.writeLog("Converting lab colorspace to sRGB ");
            bufferedImage = genericColorSpace.dataToRGB(byArray2, n, n2);
        } else if (n4 == 4) {
            bufferedImage = n7 == 3 ? ColorSpaceConvertor.algorithmicConvertCMYKImageToRGB(byArray2, n, n2) : ColorSpaceConvertor.convertFromICCCMYK(n, n2, byArray2, colorSpace);
        } else if (n4 == 3) {
            if (n * n2 == byArray2.length) {
                if (n3 == 8 && byArray3 != null) {
                    bufferedImage = this.convertIndexedToFlat(genericColorSpace.getID(), n3, n, n2, byArray2, byArray3, byArray3.length, false, false);
                } else {
                    object = new DataBufferByte(byArray2, byArray2.length);
                    int[] nArray = new int[]{0};
                    bufferedImage = new BufferedImage(n, n2, 10);
                    WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object, n, n2, n, 1, nArray, null);
                    bufferedImage.setData(writableRaster);
                }
            } else {
                object = new DataBufferByte(byArray2, byArray2.length);
                int[] nArray = new int[]{0, 1, 2};
                bufferedImage = new BufferedImage(n, n2, 1);
                WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object, n, n2, n * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
        } else if (n4 == 1 && (n3 == 8 || n3 == 4)) {
            Object object2;
            if (n3 == 4) {
                int n9 = byArray2.length;
                n5 = n * n2;
                object2 = new byte[n5];
                int n10 = 0;
                int n11 = 0;
                boolean bl4 = (n & 1) == 1;
                for (int i = 0; i < n9; ++i) {
                    byte by = byArray2[i];
                    object2[n10] = (byte)(by & 0xF0);
                    ++n10;
                    if (bl4 && (n11 += 2) > n) {
                        n11 = 0;
                    } else {
                        object2[n10] = (byte)((by & 0xF) << 4);
                        ++n10;
                    }
                    if (n10 != n5) continue;
                    i = n9;
                }
                byArray2 = object2;
            }
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            bufferedImage = new BufferedImage(n, n2, 10);
            int[] nArray = new int[]{0};
            object2 = Raster.createInterleavedRaster(dataBufferByte, n, n2, n, 1, nArray, null);
            bufferedImage.setData((Raster)object2);
        } else {
            LogWriter.writeLog("Image " + colorSpace.getType() + " not currently supported with components " + n4);
        }
        return bufferedImage;
    }

    private BufferedImage convertIndexedToFlat(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, int n5, boolean bl, boolean bl2) {
        int[] nArray;
        int[] nArray2 = new int[]{0, 1, 2};
        int[] nArray3 = new int[]{0, 1, 2, 3};
        int n6 = 3;
        int n7 = 0;
        if (bl) {
            nArray = nArray3;
            n6 = 4;
        } else {
            nArray = nArray2;
        }
        int n8 = n3 * n4 * n6;
        byte[] byArray3 = new byte[n8];
        int n9 = 0;
        float f = 0.0f;
        if (n2 == 8) {
            for (int i = 0; i < byArray.length - 1; ++i) {
                if (bl2) {
                    f = (float)(byArray[i] & 0xFF) / 255.0f;
                } else {
                    n9 = (byArray[i] & 0xFF) * 3;
                }
                if (n7 < n8) {
                    if (bl2) {
                        if (f > 0.0f) {
                            byArray3[n7++] = (byte)((float)(255 - byArray2[0]) * f);
                            byArray3[n7++] = (byte)((float)(255 - byArray2[1]) * f);
                            byArray3[n7++] = (byte)((float)(255 - byArray2[2]) * f);
                        } else {
                            n7 += 3;
                        }
                    } else {
                        byArray3[n7++] = byArray2[n9];
                        byArray3[n7++] = byArray2[n9 + 1];
                        byArray3[n7++] = byArray2[n9 + 2];
                    }
                    if (!bl) continue;
                    byArray3[n7++] = n9 == 0 && f == 0.0f ? -1 : 0;
                    continue;
                }
                break;
            }
        } else if (n2 == 4) {
            int[] nArray4 = new int[]{4, 0};
            int n10 = 0;
            block1: for (int i = 0; i < byArray.length; ++i) {
                for (int j = 0; j < 2; ++j) {
                    int n11 = (byArray[i] >> nArray4[j] & 0xF) * 3;
                    if (n7 >= n8) continue block1;
                    byArray3[n7++] = byArray2[n11];
                    byArray3[n7++] = byArray2[n11 + 1];
                    byArray3[n7++] = byArray2[n11 + 2];
                    if (bl) {
                        byArray3[n7++] = n11 == 0 ? (byte)0 : 0;
                    }
                    if (++n10 != n3) continue;
                    n10 = 0;
                    j = 8;
                }
            }
        } else if (n2 == 2) {
            int[] nArray5 = new int[]{6, 4, 2, 0};
            int n12 = 0;
            block3: for (int i = 0; i < byArray.length; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int n13 = (byArray[i] >> nArray5[j] & 3) * 3;
                    if (n7 >= n8) continue block3;
                    byArray3[n7++] = byArray2[n13];
                    byArray3[n7++] = byArray2[n13 + 1];
                    byArray3[n7++] = byArray2[n13 + 2];
                    if (bl) {
                        byArray3[n7++] = n13 == 0 ? (byte)0 : 0;
                    }
                    if (++n12 != n3) continue;
                    n12 = 0;
                    j = 8;
                }
            }
        } else if (n2 == 1) {
            int n14 = 0;
            block5: for (int i = 0; i < byArray.length - 1; ++i) {
                for (int j = 0; j < 8; ++j) {
                    n9 = (byArray[i] >> 7 - j & 1) * 3;
                    if (n7 >= n8) continue block5;
                    if (bl) {
                        if (n9 == 0) {
                            byArray3[n7++] = byArray2[n9];
                            byArray3[n7++] = byArray2[n9 + 1];
                            byArray3[n7++] = byArray2[n9 + 2];
                            byArray3[n7++] = -1;
                        } else {
                            byArray3[n7++] = byArray2[n9];
                            byArray3[n7++] = byArray2[n9 + 1];
                            byArray3[n7++] = byArray2[n9 + 2];
                            byArray3[n7++] = 0;
                        }
                    } else {
                        byArray3[n7++] = byArray2[n9];
                        byArray3[n7++] = byArray2[n9 + 1];
                        byArray3[n7++] = byArray2[n9 + 2];
                    }
                    if (++n14 != n3) continue;
                    n14 = 0;
                    j = 8;
                }
            }
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray3, byArray3.length);
        BufferedImage bufferedImage = bl ? new BufferedImage(n3, n4, 2) : new BufferedImage(n3, n4, 1);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n3, n4, n3 * n6, n6, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private final void readArrayPairs(PdfObject pdfObject, boolean bl, int n) throws PdfException {
        PdfObject pdfObject2;
        LogWriter.writeMethod("{readArrayPairs}", 0);
        String string = "";
        if (bl && n == 373243460) {
            fontsInFile = "";
        }
        if (pdfObject != null && (pdfObject2 = pdfObject.getDictionary(n)) != null) {
            PdfKeyPairsIterator pdfKeyPairsIterator = pdfObject2.getKeyPairsIterator();
            while (pdfKeyPairsIterator.hasMorePairs()) {
                string = pdfKeyPairsIterator.getNextKeyAsString();
                PdfObject pdfObject3 = pdfKeyPairsIterator.getNextValueAsDictionary();
                switch (n) {
                    case 2087749783: {
                        this.colorspaces.put(string, pdfObject3);
                        break;
                    }
                    case -1938465939: {
                        this.GraphicsStates.put(string, pdfObject3);
                        break;
                    }
                    case 373243460: {
                        PdfFont pdfFont = this.createFont(pdfObject3, string);
                        if (pdfFont == null) break;
                        this.fonts.put(string, pdfFont);
                        break;
                    }
                    case 1146450818: {
                        this.patterns.put(string, pdfObject3);
                        break;
                    }
                    case 878474856: {
                        this.shadings.put(string, pdfObject3);
                        break;
                    }
                    case 979194486: {
                        if (bl) {
                            this.globalXObjects.put(string, pdfObject3);
                            break;
                        }
                        this.localXObjects.put(string, pdfObject3);
                    }
                }
                pdfKeyPairsIterator.nextPair();
            }
        }
    }

    private PdfFont createFont(PdfObject pdfObject, String string) throws PdfException {
        byte[] byArray;
        Object object;
        Object object2;
        LogWriter.writeMethod("{createFont}", 0);
        int n = pdfObject.getParameterConstant(608780341);
        if (n != 373243460) {
            return null;
        }
        String string2 = null;
        int n2 = -1;
        int n3 = -1;
        PdfObject pdfObject2 = pdfObject.getDictionary(-1547306032);
        if (FontMappings.fontSubstitutionTable != null && !this.isFontEmbedded(pdfObject) && pdfObject2 == null && pdfObject.getParameterConstant(1147962727) != 1228944679) {
            int n4;
            object2 = null;
            object2 = pdfObject2 == null ? pdfObject.getStringValue(678461817) : pdfObject2.getStringValue(678461817);
            if (object2 == null) {
                object2 = pdfObject.getStringValue(506543413);
            }
            if (object2 == null) {
                object2 = string;
            }
            if (((String)(object = ((String)object2).toLowerCase())).startsWith("/")) {
                object = ((String)object).substring(1);
            }
            if ((n4 = ((String)object).indexOf(43)) == 6) {
                object = ((String)object).substring(7);
            }
            String string3 = ((String)object).toLowerCase();
            String string4 = null;
            Object var13_15 = null;
            String string5 = (String)FontMappings.fontSubstitutionTable.get(string3);
            if (PdfDecoder.isRunningOnMac && string3.equals("zapfdingbats")) {
                string3 = "No match found";
            }
            if (string5 == null) {
                String string6;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while ((string6 = (String)FontMappings.fontSubstitutionAliasTable.get(string3)) != null) {
                    string3 = string6;
                    string4 = (String)FontMappings.fontSubstitutionTable.get(string3);
                    if (string4 != null) {
                        string5 = string4;
                        string2 = (String)FontMappings.fontSubstitutionLocation.get(string3);
                    }
                    if (hashMap.containsKey(string3)) {
                        StringBuffer stringBuffer = new StringBuffer("[PDF] Circular font mapping for fonts");
                        Iterator iterator = hashMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            stringBuffer.append(' ');
                            stringBuffer.append(iterator.next());
                        }
                        throw new PdfException(stringBuffer.toString());
                    }
                    hashMap.put(string6, "x");
                }
            }
            if (string5 != null) {
                if (string5.equals("/Type1") || string5.equals("/Type1C") || string5.equals("/MMType1")) {
                    n2 = 1228944677;
                } else if (string5.equals("/TrueType")) {
                    n2 = 1217103210;
                } else if (string5.equals("/Type3")) {
                    n2 = 1228944679;
                } else {
                    throw new RuntimeException("Unknown font type " + string5 + " used for font substitution");
                }
                n3 = pdfObject.getParameterConstant(1147962727);
            } else if (PdfDecoder.enforceFontSubstitution) {
                LogWriter.writeLog("baseFont=" + (String)object + " fonts added= " + FontMappings.fontSubstitutionTable);
                throw new PdfFontException("No substitute Font found for " + (String)object);
            }
        }
        if (n2 == -1 && (n2 = pdfObject.getParameterConstant(1147962727)) == 1228944676) {
            object2 = pdfObject.getDictionary(-1547306032);
            n2 = ((PdfObject)object2).getParameterConstant(1147962727);
        }
        if (n2 == -1) {
            LogWriter.writeLog("Font type not supported");
            this.currentFontData = new PdfFont(this.currentPdfFile);
        }
        if (n2 == 1228944677 && (object2 = pdfObject.getDictionary(-1044665361)) != null && (object = ((PdfObject)object2).getDictionary(2021292335)) != null && (byArray = this.currentPdfFile.readStream((PdfObject)object, true, true, false, false, false)) != null && byArray.length > 3 && byArray[0] == 79 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 79) {
            n2 = 1217103210;
        }
        try {
            this.currentFontData = FontFactory.createFont(this.gs, n2, this.currentPdfFile, string2);
            if (PdfDecoder.defaultFont != null) {
                this.currentFontData.setDefaultDisplayFont(PdfDecoder.defaultFont);
            }
            this.currentFontData.createFont(pdfObject, string, this.renderPage, this.objectStoreStreamRef);
        }
        catch (Exception exception) {
            LogWriter.writeLog("[PDF] Problem " + exception + " reading Font  type " + StandardFonts.getFontypeAsString(n2) + " in " + this.fileName);
            this.addPageFailureMessage("Problem " + exception + " reading Font type " + StandardFonts.getFontypeAsString(n2) + " in " + this.fileName);
        }
        if (this.currentFontData.isFontSubstituted()) {
            object2 = string + "  " + this.currentFontData.getFontName() + "  " + StandardFonts.getFontypeAsString(n3) + "  Substituted (" + string2 + ' ' + StandardFonts.getFontypeAsString(n2) + ")";
        } else if (this.currentFontData.isFontEmbedded) {
            this.hasEmbeddedFonts = true;
            object2 = this.currentFontData.is1C() && pdfObject2 == null ? string + "  " + this.currentFontData.getFontName() + " Type1C  Embedded" : string + "  " + this.currentFontData.getFontName() + "  " + StandardFonts.getFontypeAsString(n2) + "  Embedded";
        } else {
            object2 = string + "  " + this.currentFontData.getFontName() + "  " + StandardFonts.getFontypeAsString(n2);
        }
        fontsInFile = fontsInFile == null ? object2 : (String)object2 + '\n' + fontsInFile;
        return this.currentFontData;
    }

    private boolean isFontEmbedded(PdfObject pdfObject) {
        PdfObject pdfObject2;
        int n = pdfObject.getParameterConstant(1147962727);
        if (n == 1228944676) {
            pdfObject = pdfObject.getDictionary(-1547306032);
        }
        if ((pdfObject2 = pdfObject.getDictionary(-1044665361)) == null) {
            return false;
        }
        return pdfObject2.hasStream();
    }

    public final void readResources(PdfObject pdfObject, boolean bl) throws PdfException {
        LogWriter.writeMethod("{readResources}", 0);
        String[] stringArray = new String[]{"ColorSpace", "ExtGState", "Font", "Pattern", "Shading", "XObject"};
        int[] nArray = new int[]{2087749783, -1938465939, 373243460, 1146450818, 878474856, 979194486};
        for (int i = 0; i < stringArray.length; ++i) {
            if (nArray[i] == 373243460 || nArray[i] == 979194486) {
                this.readArrayPairs(pdfObject, bl, nArray[i]);
                continue;
            }
            this.readArrayPairs(pdfObject, false, nArray[i]);
        }
    }

    public final T3Size decodePageContent(PdfObject pdfObject, int n, int n2, GraphicsState graphicsState, byte[] byArray) throws PdfException {
        LogWriter.writeMethod("{decodePageContent}", 0);
        this.requestExit = false;
        this.exited = false;
        this.imagesProcessedFully = true;
        this.imageCount = 0;
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
        }
        this.gs = graphicsState != null ? graphicsState : new GraphicsState(n, n2);
        if (this.renderPage) {
            if (this.current == null) {
                throw new PdfException("DynamicVectorRenderer not setup PdfStreamDecoder setStore(...) should be called");
            }
            if (this.renderDirectly) {
                this.current.renderClip(this.gs.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.gs);
            }
        }
        byte[] byArray2 = null;
        this.currentTextState = new TextState();
        byte[][] byArray3 = null;
        if (pdfObject != null) {
            byArray3 = pdfObject.getKeyArray(1216184967);
        }
        if ((byArray2 = pdfObject != null && byArray3 == null ? this.currentPdfFile.readStream(pdfObject, true, true, false, false, false) : (byArray != null ? byArray : this.readPageIntoStream(pdfObject))) != null && byArray2.length > 0) {
            this.decodeStreamIntoObjects(byArray2);
        }
        if (this.requestExit) {
            this.current.flush();
            this.exited = true;
        }
        T3Size t3Size = new T3Size();
        t3Size.x = this.T3maxWidth;
        t3Size.y = this.T3maxHeight;
        return t3Size;
    }

    public final void decodeStreamIntoObjects(byte[] byArray) {
        int n;
        LogWriter.writeMethod("{decodeStreamIntoObjects}", 0);
        int n2 = prefixes.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = byArray.length;
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        if (this.requestExit) {
            this.exited = true;
            return;
        }
        int n6 = n = byArray.length;
        int n7 = 0;
        int n8 = 0;
        if (n == 0) {
            return;
        }
        int n9 = 0;
        int n10 = byArray[0];
        int n11 = -1;
        do {
            int n12;
            int n13;
            int n14;
            if (!this.renderDirectly && this.statusBar != null) {
                this.statusBar.percentageDone = 100 * n7 / n;
            }
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            n9 = n10;
            if (n9 == 13 || n9 == 10 || n9 == 32 || n9 == 9) {
                ++n7;
                while (n7 != n6 && ((n9 = byArray[n7]) == 13 || n9 == 10 || n9 == 32)) {
                    ++n7;
                }
            }
            if (n7 == n6) break;
            boolean bl = false;
            int n15 = 0;
            n15 = n9 == 60 && byArray[n7 + 1] == 60 ? 1 : (n9 == 91 ? 2 : (n9 >= 97 && n9 <= 122 ? 3 : (n9 >= 65 && n9 <= 90 ? 3 : (n9 == 39 || n9 == 34 ? 3 : (n9 == 32 ? 4 : 0)))));
            if (n15 == 3) {
                n3 = n7;
                while (++n7 != n5 && (n9 = byArray[n7]) != 13 && n9 != 10 && n9 != 32 && n9 != 40 && n9 != 47 && n9 != 91 && n9 != 60) {
                }
                n4 = n7 - 1;
                n14 = byArray[n4];
                if (n14 == 47 || n14 == 91 || n14 == 60) {
                    --n4;
                }
                n11 = -1;
                if (n4 - n3 < 3) {
                    n13 = 0;
                    n12 = 0;
                    for (int i = n4; i > n3 - 1; --i) {
                        n13 += byArray[i] << n12;
                        n12 += 8;
                    }
                    n11 = Cmd.getCommandID(n13);
                }
                if (n11 == -1) {
                    this.opStart[this.currentOp] = n3;
                    this.opEnd[this.currentOp] = n4;
                    if (showCommands) {
                        System.out.println(this.generateOpAsString(this.currentOp, byArray, false) + " (value) " + this.tokenNumber);
                    }
                    ++this.currentOp;
                    if (this.currentOp == 50) {
                        this.currentOp = 0;
                    }
                    ++this.operandCount;
                } else {
                    if (showCommands) {
                        System.out.println(Cmd.getCommandAsString(n11) + " (Command) " + this.tokenNumber);
                    }
                    if (this.requestExit) {
                        this.exited = true;
                        return;
                    }
                    try {
                        n8 = n7 = this.processToken(n11, byArray, n8, n7);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] " + exception);
                        LogWriter.writeLog("Processing token >" + Cmd.getCommandAsString(n11) + "<>" + this.fileName + " <" + this.pageNum);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.addPageFailureMessage("Memory error decoding token stream");
                        LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                    }
                    this.currentOp = 0;
                    this.operandCount = 0;
                }
            } else if (n15 != 4) {
                n3 = n7;
                if (n15 == 1 || n15 == 2) {
                    n14 = 0;
                    bl = true;
                    n13 = 32;
                    do {
                        n13 = n13 == 92 && n9 == 92 ? 120 : n9;
                        if (++n7 == n5) break;
                        n9 = byArray[n7];
                        if (n9 == 13 || n9 == 10) {
                            n9 = 32;
                        }
                        n12 = 0;
                        if (n9 == 62 && n13 == 62 && n15 == 1) {
                            n12 = 1;
                        }
                        if (n15 != 2) continue;
                        if (n9 == 40 && n13 != 92) {
                            n14 = 1;
                        } else if (n9 == 41 && n13 != 92) {
                            n14 = 0;
                        }
                        if (n14 != 0 || n9 != 93 || n13 == 92) continue;
                        n12 = 1;
                    } while (n12 == 0);
                    n4 = n7;
                }
                if (!bl) {
                    n14 = 32;
                    for (n13 = 0; n13 < n2; ++n13) {
                        if (n9 != prefixes[n13]) continue;
                        bl = true;
                        n3 = n7;
                        n12 = 0;
                        while (true) {
                            n14 = n14 == 92 && n9 == 92 ? 120 : n9;
                            if (++n7 == n5) break;
                            n9 = byArray[n7];
                            if (n9 == 13 | n9 == 10) {
                                n9 = 32;
                            }
                            if (n9 == prefixes[n13] && n14 != 92) {
                                ++n12;
                            }
                            if (n9 != suffixes[n13] || n14 == 92) continue;
                            if (n12 == 0) break;
                            --n12;
                        }
                        n13 = n2;
                    }
                    n4 = n7;
                }
                if (!bl) {
                    n3 = n7;
                    n14 = byArray[n3];
                    while (++n7 != n5 && (n9 = byArray[n7]) != 13 && n9 != 10 && n9 != 32 && n9 != 40 && n9 != 47 && n9 != 91 && (n14 != 47 || n9 != 60)) {
                    }
                    n4 = n7;
                }
                if (n4 >= byArray.length || (n14 = byArray[n4]) == 47 || n14 == 91) {
                    // empty if block
                }
                this.opStart[this.currentOp] = n3;
                this.opEnd[this.currentOp] = --n4;
                if (showCommands) {
                    System.out.println(this.generateOpAsString(this.currentOp, byArray, false) + "<<----");
                }
                ++this.currentOp;
                if (this.currentOp == 50) {
                    this.currentOp = 0;
                }
                ++this.operandCount;
            }
            if (n7 >= n6 || (n10 = byArray[n7]) == 47 || n10 == 40 || n10 == 91 || n10 == 60 || ++n7 >= n6) continue;
            n10 = byArray[n7];
        } while (n6 > n7);
    }

    private final void d1(float f, float f2, float f3, float f4, float f5, float f6) {
        this.ignoreColors = true;
        this.T3maxWidth = (int)f3;
        this.T3maxWidth = f3 == 0.0f ? (int)(f2 - f) : (int)f3;
        this.T3maxHeight = (int)f6;
        this.T3maxHeight = f6 == 0.0f ? (int)(f4 - f5) : (int)f6;
    }

    private final void d0(int n, int n2) {
        this.ignoreColors = false;
        this.T3maxWidth = n;
        this.T3maxHeight = n2;
    }

    private final void TD(boolean bl, float f, float f2) {
        this.relativeMove(f, f2);
        if (!bl) {
            float f3 = -f2;
            this.currentTextState.setLeading(f3);
        }
        this.multipleTJs = false;
    }

    private final byte[] readPageIntoStream(PdfObject pdfObject) {
        LogWriter.writeMethod("{readPageIntoStream}", 0);
        byte[][] byArray = pdfObject.getKeyArray(1216184967);
        byte[] byArray2 = new byte[]{};
        if (byArray == null || byArray != null && byArray[0] == null) {
            return byArray2;
        }
        if (byArray != null) {
            int n = byArray.length;
            byte[] byArray3 = null;
            for (int i = 0; i < n; ++i) {
                this.currentPdfFile.resetCache();
                byArray3 = this.currentPdfFile.readStream(new String(byArray[i]), true);
                byArray2 = i == 0 && byArray3 != null ? byArray3 : this.appendData(byArray2, byArray3);
            }
        }
        return byArray2;
    }

    private byte[] appendData(byte[] byArray, byte[] byArray2) {
        if (byArray2 != null) {
            int n = byArray.length + 1;
            int n2 = byArray2.length;
            if (n2 > 0) {
                while (byArray2[n2 - 1] == 0) {
                    --n2;
                }
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, 0, byArray3, 0, n - 1);
                byArray3[n - 1] = 32;
                byArray = new byte[n + n2];
                System.arraycopy(byArray3, 0, byArray, 0, n);
                System.arraycopy(byArray2, 0, byArray, n, n2);
            }
        }
        return byArray;
    }

    private String generateOpAsString(int n, byte[] byArray, boolean bl) {
        String string = "";
        int n2 = this.opStart[n];
        if (bl && byArray[n2] == 47) {
            ++n2;
        }
        int n3 = this.opEnd[n];
        while (byArray[n3] == 32 || byArray[n3] == 13 || byArray[n3] == 10) {
            --n3;
        }
        int n4 = n3 - n2 + 1;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            if (i <= 0 || byArray[n2 + i] != 32 && byArray[n2 + i] != 13 && byArray[n2 + i] != 10 || byArray[n2 + i - 1] != 32 && byArray[n2 + i - 1] != 13 && byArray[n2 + i - 1] != 10) continue;
            ++n5;
        }
        char[] cArray = new char[n4 - n5];
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            if (i > 0 && (byArray[n2 + i] == 32 || byArray[n2 + i] == 13 || byArray[n2 + i] == 10) && (byArray[n2 + i - 1] == 32 || byArray[n2 + i - 1] == 13 || byArray[n2 + i - 1] == 10)) continue;
            cArray[n6] = byArray[n2 + i] == 10 || byArray[n2 + i] == 13 ? 32 : (char)byArray[n2 + i];
            ++n6;
        }
        string = String.copyValueOf(cArray);
        return string;
    }

    private final void BT() {
        this.currentTextState.resetTm();
        this.currentTextState.setTMAtLineStart();
        this.currentFont = this.currentTextState.getFontName();
        this.currentTextState.setCurrentFontSize(0);
        this.lastFontSize = -1;
        if (this.renderPage) {
            if (this.renderDirectly) {
                this.current.renderClip(this.gs.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.gs);
                this.current.drawTR(2);
            }
        }
    }

    private final void restoreGraphicsState() {
        if (!this.isStackInitialised) {
            LogWriter.writeLog("No GraphicsState saved to retrieve");
        } else {
            this.gs = (GraphicsState)this.graphicsStateStack.pull();
            this.currentTextState = (TextState)this.textStateStack.pull();
            this.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            this.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            Object object = this.clipStack.pull();
            if (object == null) {
                this.gs.setClippingShape(null);
            } else {
                this.gs.setClippingShape((Area)object);
            }
            if (this.renderPage) {
                if (this.renderDirectly) {
                    this.current.renderClip(this.gs.getClippingShape(), null, this.defaultClip, this.g2);
                } else {
                    this.current.drawClip(this.gs);
                    this.current.resetOnColorspaceChange();
                    this.current.drawFillColor(this.gs.getNonstrokeColor());
                    this.current.drawStrokeColor(this.gs.getStrokeColor());
                    this.current.setGraphicsState(2, this.gs.getNonStrokeAlpha());
                    this.current.setGraphicsState(1, this.gs.getStrokeAlpha());
                }
            }
        }
    }

    private final void L(float f, float f2) {
        this.currentDrawShape.lineTo(f, f2);
    }

    private final void F(boolean bl) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.currentDrawShape.closeShape();
        Shape shape = this.currentDrawShape.generateShapeFromPath(this.gs.getClippingShape(), this.gs.CTM, this.isClip, this.pageLines, true, this.nonstrokeColorSpace.getColor(), this.gs.getLineWidth(), this.pageData.getCropBoxWidth(1));
        if (this.nonstrokeColorSpace.getID() == 1498837125 && this.gs.getOPM() == 1.0f) {
            boolean bl2;
            float[] fArray;
            PdfArrayIterator pdfArrayIterator = this.gs.getBM();
            int n = -1;
            if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                n = pdfArrayIterator.getNextValueAsConstant(false);
            }
            if (n == 1451587725 && (fArray = this.nonstrokeColorSpace.getRawValues()) != null && fArray[3] == 1.0f && (bl2 = this.current.hasObjectsBehind(this.gs.CTM))) {
                shape = null;
            }
        }
        if (this.renderPage && shape != null) {
            this.gs.setStrokeColor(this.strokeColorSpace.getColor());
            this.gs.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.gs.setFillType(2);
            if (this.renderDirectly) {
                this.current.renderShape(null, this.gs.getFillType(), this.gs.getStrokeColor(), this.gs.getNonstrokeColor(), this.gs.getStroke(), shape, this.g2, this.gs.getStrokeAlpha(), this.gs.getNonStrokeAlpha());
            } else {
                this.current.drawShape(shape, this.gs);
            }
        }
        if (pauseOnShape) {
            JOptionPane.showMessageDialog(null, "Stopped after F");
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void TC(float f) {
        this.currentTextState.setCharacterSpacing(f);
    }

    private final void CM(float[][] fArray) {
        this.gs.CTM = Matrix.multiply(fArray, this.gs.CTM);
        this.multipleTJs = false;
    }

    protected final void relativeMove(float f, float f2) {
        float[][] fArray = new float[3][3];
        this.currentTextState.Tm = this.currentTextState.getTMAtLineStart();
        fArray[0][0] = 1.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[1][0] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[1][2] = 0.0f;
        fArray[2][0] = f;
        fArray[2][1] = f2;
        fArray[2][2] = 1.0f;
        this.currentTextState.Tm = Matrix.multiply(fArray, this.currentTextState.Tm);
        this.currentTextState.setTMAtLineStart();
        if (this.currentRotation != 0) {
            float[][] fArray2 = new float[3][3];
            this.currentTextState.TmNoRotation = this.currentTextState.getTMAtLineStartNoRotation();
            fArray2[0][0] = 1.0f;
            fArray2[0][1] = 0.0f;
            fArray2[0][2] = 0.0f;
            fArray2[1][0] = 0.0f;
            fArray2[1][1] = 1.0f;
            fArray2[1][2] = 0.0f;
            fArray2[2][0] = f;
            fArray2[2][1] = f2;
            fArray2[2][2] = 1.0f;
            this.currentTextState.TmNoRotation = Matrix.multiply(fArray2, this.currentTextState.TmNoRotation);
            float f3 = f;
            float f4 = f2;
            if (f3 < 0.0f) {
                f3 = -f;
            }
            if (f4 < 0.0f) {
                f4 = -f2;
            }
            if (f3 > this.currentTextState.Tm[0][0] && f4 > this.currentTextState.Tm[1][1]) {
                this.convertToUnrotated(this.currentTextState.Tm);
            }
            this.currentTextState.setTMAtLineStartNoRotation();
        }
        this.moveCommand = 2;
    }

    private void convertToUnrotated(float[][] fArray) {
        if (fArray[0][1] == 0.0f || fArray[1][0] == 0.0f) {
            return;
        }
        this.rotationAsRadians = -Math.asin(fArray[1][0] / fArray[0][0]);
        float[][] fArray2 = new float[3][3];
        fArray2[0][0] = (float)Math.cos(-this.rotationAsRadians);
        fArray2[0][1] = (float)Math.sin(-this.rotationAsRadians);
        fArray2[0][2] = 0.0f;
        fArray2[1][0] = (float)(-Math.sin(-this.rotationAsRadians));
        fArray2[1][1] = (float)Math.cos(-this.rotationAsRadians);
        fArray2[1][2] = 0.0f;
        fArray2[2][0] = 0.0f;
        fArray2[2][1] = 0.0f;
        fArray2[2][2] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!((double)fArray2[j][i] > 0.99 & fArray2[j][i] < 1.0f)) continue;
                fArray2[j][i] = 1.0f;
            }
        }
        float[][] fArray3 = new float[3][3];
        fArray3[0][0] = fArray[2][0];
        fArray3[1][1] = fArray[2][1];
        fArray3[2][2] = 1.0f;
        fArray3 = Matrix.multiply(fArray2, fArray3);
        float[][] fArray4 = Matrix.multiply(fArray2, fArray);
        float f = fArray3[1][0];
        float f2 = fArray3[1][1] - f;
        float f3 = this.currentTextState.Tm[2][1];
        Integer n = new Integer((int)((double)f2 + 0.5));
        Float f4 = (Float)this.lines.get(n);
        if (f4 == null) {
            f4 = (Float)this.lines.get(new Integer((int)(f2 + 1.0f)));
        }
        if (f4 == null) {
            this.lines.put(n, new Float(this.currentTextState.Tm[2][1]));
        } else {
            f3 = f4.floatValue();
        }
        fArray4[2][1] = f3;
        this.currentTextState.TmNoRotation = fArray4;
        if (this.unRotatedY == -1.0f) {
            this.unRotatedY = this.currentTextState.TmNoRotation[2][1];
            this.rotatedY = this.currentTextState.Tm[2][1];
        }
        this.lastHeight = this.currentTextState.TmNoRotation[1][1];
        this.currentTextState.TmNoRotation[0][1] = 0.0f;
        this.currentTextState.TmNoRotation[1][0] = 0.0f;
    }

    private final void S(boolean bl) {
        Shape shape;
        if (bl) {
            this.currentDrawShape.closeShape();
        }
        if ((shape = this.currentDrawShape.generateShapeFromPath(null, this.gs.CTM, this.isClip, this.pageLines, false, null, this.gs.getLineWidth(), this.pageData.getCropBoxWidth(1))) != null) {
            if (shape.getBounds().getWidth() <= 1.0) {
                shape = shape.getBounds2D();
            }
            if (this.renderPage) {
                this.gs.setStrokeColor(this.strokeColorSpace.getColor());
                this.gs.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
                this.gs.setFillType(1);
                if (this.renderDirectly) {
                    this.current.renderShape(null, this.gs.getFillType(), this.gs.getStrokeColor(), this.gs.getNonstrokeColor(), this.gs.getStroke(), shape, this.g2, this.gs.getStrokeAlpha(), this.gs.getNonStrokeAlpha());
                } else {
                    this.current.drawShape(shape, this.gs);
                }
            }
            if (pauseOnShape) {
                JOptionPane.showMessageDialog(null, "Stopped after S");
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void I() {
    }

    private final void D(byte[] byArray) {
        String string = "";
        int n = this.operandCount;
        if (n == 1) {
            string = this.generateOpAsString(0, byArray, false);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n - 1; i > -1; --i) {
                stringBuffer.append(this.generateOpAsString(i, byArray, false));
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
        }
        if (string.equals("[ ] 0 ") || string.equals("[]0") || string.equals("[] 0 ")) {
            this.gs.setDashPhase(0);
            this.gs.setDashArray(new float[0]);
        } else {
            int n2 = string.indexOf(93);
            String string2 = string.substring(0, n2);
            int n3 = (int)Float.parseFloat(string.substring(n2 + 1, string.length()).trim());
            float[] fArray = PdfArray.convertToFloatArray(string2);
            this.gs.setDashArray(fArray);
            this.gs.setDashPhase(n3);
        }
    }

    private final void SCN(boolean bl, byte[] byArray) {
        float[] fArray = null;
        if (bl) {
            if (this.nonstrokeColorSpace.getID() == 1146450818) {
                this.nonstrokeColorSpace.setColor(this.getValuesAsString(this.operandCount, byArray), this.operandCount);
            } else {
                fArray = this.getValuesAsFloat(this.operandCount, byArray);
                float[] fArray2 = new float[this.operandCount];
                for (int i = 0; i < this.operandCount; ++i) {
                    fArray2[this.operandCount - i - 1] = fArray[i];
                }
                fArray = fArray2;
                this.nonstrokeColorSpace.setColor(fArray, this.operandCount);
            }
        } else if (this.strokeColorSpace.getID() == 1146450818) {
            this.strokeColorSpace.setColor(this.getValuesAsString(this.operandCount, byArray), this.operandCount);
        } else {
            fArray = this.getValuesAsFloat(this.operandCount, byArray);
            float[] fArray3 = new float[this.operandCount];
            for (int i = 0; i < this.operandCount; ++i) {
                fArray3[this.operandCount - i - 1] = fArray[i];
            }
            fArray = fArray3;
            this.strokeColorSpace.setColor(fArray, this.operandCount);
        }
    }

    private final void B(boolean bl, boolean bl2) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        if (bl2) {
            this.currentDrawShape.closeShape();
        }
        Shape shape = this.currentDrawShape.generateShapeFromPath(null, this.gs.CTM, this.isClip, this.pageLines, false, null, this.gs.getLineWidth(), this.pageData.getCropBoxWidth(1));
        if (this.renderPage && shape != null) {
            this.gs.setStrokeColor(this.strokeColorSpace.getColor());
            this.gs.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.gs.setFillType(3);
            if (this.renderDirectly) {
                this.current.renderShape(null, this.gs.getFillType(), this.gs.getStrokeColor(), this.gs.getNonstrokeColor(), this.gs.getStroke(), shape, this.g2, this.gs.getStrokeAlpha(), this.gs.getNonStrokeAlpha());
            } else {
                this.current.drawShape(shape, this.gs);
            }
        }
        if (pauseOnShape) {
            JOptionPane.showMessageDialog(null, "Stopped after B");
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void mm(int n) {
        this.gs.setMitreLimit(n);
    }

    private final void M(float f, float f2) {
        this.currentDrawShape.moveTo(f, f2);
    }

    private final void J(boolean bl, int n) {
        int n2 = 0;
        if (!bl) {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.gs.setJoinStyle(n2);
        } else {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.gs.setCapStyle(n2);
        }
    }

    private final void RG(boolean bl, byte[] byArray) {
        this.current.resetOnColorspaceChange();
        boolean bl2 = !bl;
        float[] fArray = this.getValuesAsFloat(this.operandCount, byArray);
        float[] fArray2 = new float[this.operandCount];
        for (int i = 0; i < this.operandCount; ++i) {
            fArray2[this.operandCount - i - 1] = fArray[i];
        }
        fArray = fArray2;
        if (bl2) {
            if (this.strokeColorSpace.getID() != 1785221209) {
                this.strokeColorSpace = new DeviceRGBColorSpace();
            }
            this.strokeColorSpace.setColor(fArray, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 1785221209) {
                this.nonstrokeColorSpace = new DeviceRGBColorSpace();
            }
            this.nonstrokeColorSpace.setColor(fArray, this.operandCount);
        }
    }

    private final void Y(float f, float f2, float f3, float f4) {
        this.currentDrawShape.addBezierCurveY(f3, f4, f, f2);
    }

    private final void TZ(float f) {
        this.currentTextState.setHorizontalScaling(f / 100.0f);
    }

    private final void RE(float f, float f2, float f3, float f4) {
        this.currentDrawShape.appendRectangle(f, f2, f3, f4);
    }

    private final void ET() {
        this.current.resetOnColorspaceChange();
    }

    private final void pushGraphicsState() {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
            this.clipStack = new Vector_Object(20);
        }
        this.graphicsStateStack.push(this.gs.clone());
        Area area = this.gs.getClippingShape();
        if (area == null) {
            this.clipStack.push(null);
        } else {
            this.clipStack.push(area.clone());
        }
        this.textStateStack.push(this.currentTextState.clone());
        this.nonstrokeColorStateStack.push(this.nonstrokeColorSpace.clone());
        this.strokeColorStateStack.push(this.strokeColorSpace.clone());
        this.current.resetOnColorspaceChange();
    }

    private final void MP() {
        if (this.markedContentExtracted) {
            this.contentHandler.MP();
        }
    }

    private final void DP(int n, int n2, byte[] byArray, String string) {
        if (this.markedContentExtracted) {
            Map map = new HashMap();
            if (string.endsWith(" R")) {
                map = this.currentPdfFile.readObject(new PdfObject(string), string, false, null);
            } else {
                this.currentPdfFile.readDictionary("", 0, map, n - 1, byArray, false, new HashMap(), n2);
            }
            this.contentHandler.DP(map);
        }
    }

    private final void EMC() {
        if (this.markedContentExtracted) {
            this.contentHandler.EMC();
        }
    }

    private final void TJ(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = this.processTextArray(byArray, n, n2);
        if (stringBuffer != null && this.isPageContent) {
            if (!this.markedContentExtracted) {
                if (this.textColorExtracted) {
                    this.currentColor = (this.gs.getTextRenderType() & 2) == 2 ? this.nonstrokeColorSpace.getXMLColorToken() : this.strokeColorSpace.getXMLColorToken();
                }
                if (this.textExtracted) {
                    this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, this.currentTextState.writingMode, this.font_as_string, this.currentFontData.getCurrentFontSpaceWidth(), this.currentTextState, this.x1, this.y1, this.x2, this.y2, this.moveCommand, stringBuffer, this.tokenNumber, this.textLength, this.currentColor, this.currentRotation);
                }
            } else {
                this.contentHandler.setText(stringBuffer, this.x1, this.y1, this.x2, this.y2);
            }
        }
        this.moveCommand = -1;
    }

    private final void G(boolean bl, byte[] byArray) {
        this.current.resetOnColorspaceChange();
        boolean bl2 = !bl;
        float[] fArray = this.getValuesAsFloat(1, byArray);
        if (bl2) {
            if (this.strokeColorSpace.getID() != 1568372915) {
                this.strokeColorSpace = new DeviceGrayColorSpace();
            }
            this.strokeColorSpace.setColor(fArray, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 1568372915) {
                this.nonstrokeColorSpace = new DeviceGrayColorSpace();
            }
            this.nonstrokeColorSpace.setColor(fArray, this.operandCount);
        }
    }

    private void TL(float f) {
        this.currentTextState.setLeading(f);
    }

    private void BDC(int n, int n2, byte[] byArray, String string) {
        if (this.markedContentExtracted) {
            Map map = new HashMap();
            if (string.endsWith(" R")) {
                map = this.currentPdfFile.readObject(new PdfObject(string), string, false, null);
            } else {
                this.currentPdfFile.readDictionary("", 0, map, n - 1, byArray, false, new HashMap(), n2);
            }
            this.contentHandler.BDC(map);
        }
    }

    private void BMC(String string) {
        if (this.markedContentExtracted) {
            this.contentHandler.BMC(string);
        }
    }

    final float parseFloat(int n, byte[] byArray) {
        int n2;
        int n3;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n4 = this.opStart[n];
        int n5 = n3 = this.opEnd[n] - n4;
        int n6 = 0;
        boolean bl = false;
        for (n2 = n3 - 1; n2 > -1; --n2) {
            if (byArray[n4 + n2] != 46) continue;
            n5 = n2;
            break;
        }
        n2 = n5;
        if (byArray[n4] == 43) {
            --n2;
            ++n6;
        } else if (byArray[n4] == 45) {
            ++n6;
            bl = true;
        }
        int n7 = n2 - n6;
        int n8 = n3 - n5;
        if (n7 > 3) {
            bl = false;
            f = Float.parseFloat(this.generateOpAsString(n, byArray, false));
        } else {
            int n9;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            if (n7 > 2) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f6 = 100.0f;
                        break;
                    }
                    case 2: {
                        f6 = 200.0f;
                        break;
                    }
                    case 3: {
                        f6 = 300.0f;
                        break;
                    }
                    case 4: {
                        f6 = 400.0f;
                        break;
                    }
                    case 5: {
                        f6 = 500.0f;
                        break;
                    }
                    case 6: {
                        f6 = 600.0f;
                        break;
                    }
                    case 7: {
                        f6 = 700.0f;
                        break;
                    }
                    case 8: {
                        f6 = 800.0f;
                        break;
                    }
                    case 9: {
                        f6 = 900.0f;
                    }
                }
                ++n6;
            }
            if (n7 > 1) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f5 = 10.0f;
                        break;
                    }
                    case 2: {
                        f5 = 20.0f;
                        break;
                    }
                    case 3: {
                        f5 = 30.0f;
                        break;
                    }
                    case 4: {
                        f5 = 40.0f;
                        break;
                    }
                    case 5: {
                        f5 = 50.0f;
                        break;
                    }
                    case 6: {
                        f5 = 60.0f;
                        break;
                    }
                    case 7: {
                        f5 = 70.0f;
                        break;
                    }
                    case 8: {
                        f5 = 80.0f;
                        break;
                    }
                    case 9: {
                        f5 = 90.0f;
                    }
                }
                ++n6;
            }
            if (n7 > 0) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f4 = 1.0f;
                        break;
                    }
                    case 2: {
                        f4 = 2.0f;
                        break;
                    }
                    case 3: {
                        f4 = 3.0f;
                        break;
                    }
                    case 4: {
                        f4 = 4.0f;
                        break;
                    }
                    case 5: {
                        f4 = 5.0f;
                        break;
                    }
                    case 6: {
                        f4 = 6.0f;
                        break;
                    }
                    case 7: {
                        f4 = 7.0f;
                        break;
                    }
                    case 8: {
                        f4 = 8.0f;
                        break;
                    }
                    case 9: {
                        f4 = 9.0f;
                    }
                }
            }
            if (n8 > 1) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f7 = 0.1f;
                        break;
                    }
                    case 2: {
                        f7 = 0.2f;
                        break;
                    }
                    case 3: {
                        f7 = 0.3f;
                        break;
                    }
                    case 4: {
                        f7 = 0.4f;
                        break;
                    }
                    case 5: {
                        f7 = 0.5f;
                        break;
                    }
                    case 6: {
                        f7 = 0.6f;
                        break;
                    }
                    case 7: {
                        f7 = 0.7f;
                        break;
                    }
                    case 8: {
                        f7 = 0.8f;
                        break;
                    }
                    case 9: {
                        f7 = 0.9f;
                    }
                }
            }
            if (n8 > 2) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f8 = 0.01f;
                        break;
                    }
                    case 2: {
                        f8 = 0.02f;
                        break;
                    }
                    case 3: {
                        f8 = 0.03f;
                        break;
                    }
                    case 4: {
                        f8 = 0.04f;
                        break;
                    }
                    case 5: {
                        f8 = 0.05f;
                        break;
                    }
                    case 6: {
                        f8 = 0.06f;
                        break;
                    }
                    case 7: {
                        f8 = 0.07f;
                        break;
                    }
                    case 8: {
                        f8 = 0.08f;
                        break;
                    }
                    case 9: {
                        f8 = 0.09f;
                    }
                }
            }
            if (n8 > 3) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f9 = 0.001f;
                        break;
                    }
                    case 2: {
                        f9 = 0.002f;
                        break;
                    }
                    case 3: {
                        f9 = 0.003f;
                        break;
                    }
                    case 4: {
                        f9 = 0.004f;
                        break;
                    }
                    case 5: {
                        f9 = 0.005f;
                        break;
                    }
                    case 6: {
                        f9 = 0.006f;
                        break;
                    }
                    case 7: {
                        f9 = 0.007f;
                        break;
                    }
                    case 8: {
                        f9 = 0.008f;
                        break;
                    }
                    case 9: {
                        f9 = 0.009f;
                    }
                }
            }
            if (n8 > 4) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f10 = 1.0E-4f;
                        break;
                    }
                    case 2: {
                        f10 = 2.0E-4f;
                        break;
                    }
                    case 3: {
                        f10 = 3.0E-4f;
                        break;
                    }
                    case 4: {
                        f10 = 4.0E-4f;
                        break;
                    }
                    case 5: {
                        f10 = 5.0E-4f;
                        break;
                    }
                    case 6: {
                        f10 = 6.0E-4f;
                        break;
                    }
                    case 7: {
                        f10 = 7.0E-4f;
                        break;
                    }
                    case 8: {
                        f10 = 8.0E-4f;
                        break;
                    }
                    case 9: {
                        f10 = 9.0E-4f;
                    }
                }
            }
            if (n8 > 5) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f11 = 1.0E-5f;
                        break;
                    }
                    case 2: {
                        f11 = 2.0E-5f;
                        break;
                    }
                    case 3: {
                        f11 = 3.0E-5f;
                        break;
                    }
                    case 4: {
                        f11 = 4.0E-5f;
                        break;
                    }
                    case 5: {
                        f11 = 5.0E-5f;
                        break;
                    }
                    case 6: {
                        f11 = 6.0E-5f;
                        break;
                    }
                    case 7: {
                        f11 = 7.0E-5f;
                        break;
                    }
                    case 8: {
                        f11 = 8.0E-5f;
                        break;
                    }
                    case 9: {
                        f11 = 9.0E-5f;
                    }
                }
            }
            f2 = f7 + f8 + f9 + f10 + f11;
            f3 = f6 + f5 + f4;
            f = f3 + f2;
        }
        if (bl) {
            return -f;
        }
        return f;
    }

    final int parseInt(int n, byte[] byArray) {
        int n2 = 0;
        int n3 = this.opStart[n];
        int n4 = this.opEnd[n] - n3;
        int n5 = 0;
        boolean bl = false;
        int n6 = n4;
        if (byArray[n3] == 43) {
            --n6;
            ++n5;
        } else if (byArray[n3] == 45) {
            ++n5;
            bl = true;
        }
        int n7 = n6 - n5;
        if (n7 > 6) {
            bl = false;
            n2 = Integer.parseInt(this.generateOpAsString(n, byArray, false));
        } else {
            for (int i = 5; i > -1; --i) {
                if (n7 <= i) continue;
                int n8 = byArray[n3 + n5] - 48;
                n2 += intValues[5 - i][n8];
                ++n5;
            }
        }
        if (bl) {
            return -n2;
        }
        return n2;
    }

    private final void TM() {
        if (includeRotation) {
            float[][] fArray = this.currentTextState.Tm;
            if (fArray[1][0] == 0.0f && fArray[0][1] == 0.0f) {
                this.currentRotation = 0;
                this.unRotatedY = -1.0f;
            } else if (fArray[0][1] == 0.0f || fArray[1][0] == 0.0f) {
                this.currentRotation = 0;
                this.unRotatedY = -1.0f;
            } else {
                this.rotationAsRadians = -Math.asin(fArray[1][0] / fArray[0][0]);
                int n = (int)(this.rotationAsRadians * 57.29577951308232);
                if (n == 0) {
                    this.currentRotation = 0;
                    this.unRotatedY = -1.0f;
                } else {
                    this.currentRotation = n;
                    this.convertToUnrotated(fArray);
                }
            }
        }
        this.currentTextState.setTMAtLineStart();
        this.currentTextState.setTMAtLineStartNoRotation();
        this.multipleTJs = false;
        this.moveCommand = 1;
    }

    private final void H() {
        this.currentDrawShape.closeShape();
    }

    private final void TR(int n) {
        if (n == 0) {
            n = 2;
        } else if (n == 1) {
            n = 1;
        } else if (n == 2) {
            n = 3;
        } else if (n == 3) {
            n = 4;
            if (showInvisibleText) {
                n = 2;
            }
        } else if (n == 7) {
            n = 7;
        }
        this.gs.setTextRenderType(n);
        if (this.renderPage && !this.renderDirectly) {
            this.current.drawTR(n);
        }
    }

    private final void Q(boolean bl) {
        if (bl) {
            this.pushGraphicsState();
        } else {
            this.restoreGraphicsState();
            String string = this.currentTextState.getFontID();
            Object v = this.fonts.get(string);
            if (v != null) {
                this.currentFontData = (PdfFont)v;
                this.current.drawFontBounds(this.currentFontData.getBoundingBox());
            }
        }
    }

    private final int ID(byte[] byArray, int n, int n2) throws Exception {
        PdfXObject pdfXObject = new PdfXObject(1);
        this.currentPdfFile.readDictionaryAsObject(pdfXObject, "", n, byArray, n2 - 2, "", true);
        this.isMask = false;
        BufferedImage bufferedImage = null;
        boolean bl = false;
        int n3 = n2 + 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n3;
        int n8 = byArray.length;
        while ((n8 - n7 <= 3 || byArray[n7] != 32 && byArray[n7] != 10 && byArray[n7] != 13 || byArray[n7 + 1] != 69 || byArray[n7 + 2] != 73 || byArray[n7 + 3] != 32 && byArray[n7 + 3] != 10 && byArray[n7 + 3] != 13) && ++n7 != n8) {
        }
        if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
            Cloneable cloneable;
            Object v;
            Object object;
            String string = this.fileName + "-IN-" + this.tokenNumber;
            byte[] byArray2 = new byte[n7 - n3];
            System.arraycopy(byArray, n3, byArray2, 0, n7 - n3);
            pdfXObject.setStream(byArray2);
            PdfObject pdfObject = ((PdfObject)pdfXObject).getDictionary(2087749783);
            if (pdfObject != null && (object = pdfObject.getGeneralStringValue()) != null && (v = this.colorspaces.get(object)) != null) {
                pdfObject = (PdfObject)v;
            }
            if (pdfObject != null && pdfObject.getParameterConstant(2087749783) == -1) {
                pdfObject = null;
            }
            if (this.customImageHandler != null) {
                bufferedImage = this.customImageHandler.processImageData(this.gs, pdfXObject, pdfObject);
            }
            object = ((PdfObject)pdfXObject).getArrayIterator(1011108731);
            int n9 = -1;
            boolean bl2 = false;
            if (object != null && ((PdfArrayIterator)object).hasMoreTokens()) {
                n9 = ((PdfArrayIterator)object).getNextValueAsConstant(false);
                bl2 = n9 != 1399277700 && n9 != 1180911742;
            }
            n4 = ((PdfObject)pdfXObject).getInt(959726687);
            n5 = ((PdfObject)pdfXObject).getInt(959926393);
            n6 = ((PdfObject)pdfXObject).getInt(-1344207655);
            bl = ((PdfObject)pdfXObject).getBoolean(1516403337);
            if (bl2) {
                PdfObject pdfObject2;
                cloneable = ((PdfObject)pdfXObject).getDictionary(1888135062);
                byte[] byArray3 = null;
                if (cloneable != null && (pdfObject2 = ((PdfObject)cloneable).getDictionary(1314558361)) != null) {
                    byArray3 = this.currentPdfFile.readStream(pdfObject2, true, true, false, false, false);
                }
                byArray2 = this.currentPdfFile.decodeFilters((PdfObject)cloneable, byArray2, (PdfArrayIterator)object, n4, n5, true, byArray3, null);
            }
            cloneable = new DeviceRGBColorSpace();
            if (pdfObject != null) {
                cloneable = ColorspaceFactory.getColorSpaceInstance(this.isPrinting, this.currentPdfFile, pdfObject);
            }
            if (byArray2 != null) {
                boolean bl3 = !this.isType3Font && this.useHiResImageForDisplay && this.current.isImageCached(this.pageNum);
                this.optionsApplied = 0;
                if (!bl3 && (this.customImageHandler == null || bufferedImage == null && !this.customImageHandler.alwaysIgnoreGenericHandler())) {
                    bufferedImage = this.processImage((GenericColorSpace)cloneable, byArray2, string, n4, n5, n6, bl, this.createScaledVersion, pdfXObject);
                }
                this.currentImage = string;
                if (bufferedImage != null || bl3) {
                    if (this.renderDirectly || this.useHiResImageForDisplay) {
                        this.gs.x = this.gs.CTM[2][0];
                        this.gs.y = this.gs.CTM[2][1];
                        if (this.renderDirectly) {
                            this.current.renderImage(null, bufferedImage, this.gs.getNonStrokeAlpha(), this.gs, this.g2, this.gs.x, this.gs.y, this.optionsApplied);
                        } else {
                            this.current.drawImage(this.pageNum, bufferedImage, this.gs, bl3, string, this.optionsApplied);
                        }
                    } else if (this.clippedImagesExtracted) {
                        this.generateTransformedImage(bufferedImage, string);
                    } else {
                        this.generateTransformedImageSingle(bufferedImage, string);
                    }
                    if (bufferedImage != null) {
                        bufferedImage.flush();
                    }
                }
            }
        }
        n2 = n7 + 3;
        return n2;
    }

    private final void TS(float f) {
        this.currentTextState.setTextRise(f);
    }

    private final void double_quote(byte[] byArray, int n, int n2, float f, float f2) {
        this.currentTextState.setCharacterSpacing(f);
        this.currentTextState.setWordSpacing(f2);
        this.TSTAR();
        this.TJ(byArray, n, n2);
    }

    private void TSTAR() {
        this.relativeMove(0.0f, -this.currentTextState.getLeading());
        this.moveCommand = 0;
        this.multipleTJs = false;
    }

    private final void K(boolean bl, byte[] byArray) {
        boolean bl2;
        this.current.resetOnColorspaceChange();
        boolean bl3 = bl2 = !bl;
        if (this.operandCount > 3) {
            float[] fArray = this.getValuesAsFloat(this.operandCount, byArray);
            float[] fArray2 = new float[this.operandCount];
            for (int i = 0; i < this.operandCount; ++i) {
                fArray2[this.operandCount - i - 1] = fArray[i];
            }
            fArray = fArray2;
            if (bl2) {
                if (this.strokeColorSpace.getID() != 1498837125) {
                    this.strokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.strokeColorSpace.setColor(fArray, this.operandCount);
            } else {
                if (this.nonstrokeColorSpace.getID() != 1498837125) {
                    this.nonstrokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.nonstrokeColorSpace.setColor(fArray, this.operandCount);
            }
        }
    }

    private String[] getValuesAsString(int n, byte[] byArray) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.generateOpAsString(i, byArray, true);
        }
        return stringArray;
    }

    private float[] getValuesAsFloat(int n, byte[] byArray) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.parseFloat(i, byArray);
        }
        return fArray;
    }

    private final void W(boolean bl) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.isClip = true;
    }

    private final void width(float f) {
        this.gs.setLineWidth(f);
    }

    private final void one_quote(byte[] byArray, int n, int n2) {
        this.TSTAR();
        this.TJ(byArray, n, n2);
    }

    private void N() {
        if (this.isClip) {
            this.currentDrawShape.closeShape();
            this.gs.updateClip(new Area(this.currentDrawShape.generateShapeFromPath(null, this.gs.CTM, false, null, false, null, 0.0f, 0.0f)));
            this.gs.checkWholePageClip(this.pageData.getMediaBoxHeight(this.pageNum) + this.pageData.getMediaBoxY(this.pageNum));
            this.isClip = false;
            if (this.renderPage) {
                if (this.renderDirectly) {
                    this.current.renderClip(this.gs.getClippingShape(), null, this.defaultClip, this.g2);
                } else {
                    this.current.drawClip(this.gs);
                }
            }
        }
        this.currentDrawShape.resetPath();
    }

    private final void sh(String string) {
        if (useShading && this.renderPage) {
            PdfObject pdfObject = (PdfObject)this.shadings.get(string);
            Shape shape = this.gs.getClippingShape();
            if (shape == null) {
                shape = new Rectangle(this.pageData.getMediaBoxX(this.pageNum), this.pageData.getMediaBoxY(this.pageNum), this.pageData.getMediaBoxWidth(this.pageNum), this.pageData.getMediaBoxHeight(this.pageNum));
            }
            try {
                PdfObject pdfObject2 = pdfObject.getDictionary(2087749783);
                GenericColorSpace genericColorSpace = ColorspaceFactory.getColorSpaceInstance(this.isPrinting, this.currentPdfFile, pdfObject2);
                PdfPaint pdfPaint = ShadingFactory.createShading(pdfObject, this.isPrinting, this.pageH, genericColorSpace, this.currentPdfFile, this.gs.CTM, this.pageH, false);
                if (pdfPaint != null) {
                    this.gs.setFillType(2);
                    this.gs.setNonstrokeColor(pdfPaint);
                    if (this.renderDirectly) {
                        this.current.renderShape(null, this.gs.getFillType(), this.gs.getStrokeColor(), this.gs.getNonstrokeColor(), this.gs.getStroke(), shape, this.g2, this.gs.getStrokeAlpha(), this.gs.getNonStrokeAlpha());
                    } else {
                        this.current.drawShape(shape, this.gs);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void TW(float f) {
        this.currentTextState.setWordSpacing(f);
    }

    private final void CS(boolean bl, String string) {
        GenericColorSpace genericColorSpace;
        this.current.resetOnColorspaceChange();
        boolean bl2 = !bl;
        PdfObject pdfObject = (PdfObject)this.colorspaces.get(string);
        if (pdfObject == null) {
            pdfObject = new PdfColorSpaceObject(string.getBytes());
        }
        if ((genericColorSpace = ColorspaceFactory.getColorSpaceInstance(this.isPrinting, this.currentPdfFile, pdfObject)).getID() == 1146450818) {
            genericColorSpace.setPattern(this.patterns, this.pageH, this.gs.CTM);
            genericColorSpace.setGS(this.gs);
        }
        if (bl2) {
            this.strokeColorSpace = genericColorSpace;
        } else {
            this.nonstrokeColorSpace = genericColorSpace;
        }
    }

    private final void V(float f, float f2, float f3, float f4) {
        this.currentDrawShape.addBezierCurveV(f3, f4, f, f2);
    }

    private final void TF(float f, String string) {
        this.currentTextState.setFontTfs(f);
        Object v = this.fonts.get(string);
        if (v != null) {
            this.currentFontData = (PdfFont)v;
            this.current.drawFontBounds(this.currentFontData.getBoundingBox());
        }
        this.currentFont = this.currentFontData.getFontName();
        this.currentTextState.setFont(this.currentFont, string);
        this.font_as_string = Fonts.createFontToken(this.currentFont, this.currentTextState.getCurrentFontSize());
    }

    private final int processToken(int n, byte[] byArray, int n2, int n3) throws Exception {
        if (this.operandCount > 0) {
            int n4;
            int[] nArray = new int[50];
            int[] nArray2 = new int[50];
            int n5 = 0;
            for (n4 = this.currentOp - 1; n4 > -1; --n4) {
                nArray[n5] = this.opStart[n4];
                nArray2[n5] = this.opEnd[n4];
                if (n5 == this.operandCount) {
                    n4 = -1;
                }
                ++n5;
            }
            if (n5 == this.operandCount) {
                --this.currentOp;
                for (n4 = 50 - 1; n4 > this.currentOp; --n4) {
                    nArray[n5] = this.opStart[n4];
                    nArray2[n5] = this.opEnd[n4];
                    if (n5 == this.operandCount) {
                        n4 = this.currentOp;
                    }
                    ++n5;
                }
                ++this.currentOp;
            }
            this.opStart = nArray;
            this.opEnd = nArray2;
        }
        boolean bl = true;
        if (this.renderText || this.textExtracted) {
            bl = false;
            switch (n) {
                case 21603: {
                    this.TC(this.parseFloat(0, byArray));
                    break;
                }
                case 21623: {
                    this.TW(this.parseFloat(0, byArray));
                    break;
                }
                case 21626: {
                    this.TZ(this.parseFloat(0, byArray));
                    break;
                }
                case 21580: {
                    this.TL(this.parseFloat(0, byArray));
                    break;
                }
                case 21606: {
                    this.TF(this.parseFloat(0, byArray), this.generateOpAsString(1, byArray, true));
                    break;
                }
                case 21618: {
                    this.TR(this.parseInt(0, byArray));
                    break;
                }
                case 21619: {
                    this.TS(this.parseFloat(0, byArray));
                    break;
                }
                case 21572: {
                    this.TD(false, this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 21604: {
                    this.TD(true, this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 21613: {
                    this.currentTextState.Tm[0][0] = this.parseFloat(5, byArray);
                    this.currentTextState.Tm[0][1] = this.parseFloat(4, byArray);
                    this.currentTextState.Tm[0][2] = 0.0f;
                    this.currentTextState.Tm[1][0] = this.parseFloat(3, byArray);
                    this.currentTextState.Tm[1][1] = this.parseFloat(2, byArray);
                    this.currentTextState.Tm[1][2] = 0.0f;
                    this.currentTextState.Tm[2][0] = this.parseFloat(1, byArray);
                    this.currentTextState.Tm[2][1] = this.parseFloat(0, byArray);
                    this.currentTextState.Tm[2][2] = 1.0f;
                    this.currentTextState.TmNoRotation[0][0] = this.currentTextState.Tm[0][0];
                    this.currentTextState.TmNoRotation[0][1] = this.currentTextState.Tm[0][1];
                    this.currentTextState.TmNoRotation[0][2] = 0.0f;
                    this.currentTextState.TmNoRotation[1][0] = this.currentTextState.Tm[1][0];
                    this.currentTextState.TmNoRotation[1][1] = this.currentTextState.Tm[1][1];
                    this.currentTextState.TmNoRotation[1][2] = 0.0f;
                    this.currentTextState.TmNoRotation[2][0] = this.currentTextState.Tm[2][0];
                    this.currentTextState.TmNoRotation[2][1] = this.currentTextState.Tm[2][1];
                    this.currentTextState.TmNoRotation[2][2] = 1.0f;
                    this.TM();
                    break;
                }
                case 21546: {
                    this.TSTAR();
                    break;
                }
                case 21610: {
                    this.TJ(byArray, n2, n3);
                    break;
                }
                case 21578: {
                    this.TJ(byArray, n2, n3);
                    break;
                }
                case 39: {
                    this.one_quote(byArray, n2, n3);
                    break;
                }
                case 34: {
                    this.double_quote(byArray, n2, n3, this.parseFloat(1, byArray), this.parseFloat(2, byArray));
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (this.renderPage || this.textColorExtracted || this.colorExtracted) {
            bl = false;
            switch (n) {
                case 29287: {
                    this.RG(true, byArray);
                    break;
                }
                case 21063: {
                    this.RG(false, byArray);
                    break;
                }
                case 5456718: {
                    this.SCN(false, byArray);
                    break;
                }
                case 7562094: {
                    this.SCN(true, byArray);
                    break;
                }
                case 21315: {
                    this.SCN(false, byArray);
                    break;
                }
                case 29539: {
                    this.SCN(true, byArray);
                    break;
                }
                case 25459: {
                    this.CS(true, this.generateOpAsString(0, byArray, true));
                    break;
                }
                case 17235: {
                    this.CS(false, this.generateOpAsString(0, byArray, true));
                    break;
                }
                case 103: {
                    this.G(true, byArray);
                    break;
                }
                case 71: {
                    this.G(false, byArray);
                    break;
                }
                case 107: {
                    this.K(true, byArray);
                    break;
                }
                case 75: {
                    this.K(false, byArray);
                    break;
                }
                case 29544: {
                    this.sh(this.generateOpAsString(0, byArray, true));
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (bl) {
            switch (n) {
                case 16969: {
                    this.startInlineStream = n3;
                    break;
                }
                case 18756: {
                    n3 = this.ID(byArray, this.startInlineStream, n3);
                    break;
                }
                case 66: {
                    this.B(false, false);
                    break;
                }
                case 98: {
                    this.B(false, true);
                    break;
                }
                case 25130: {
                    this.B(true, true);
                    break;
                }
                case 16938: {
                    this.B(true, false);
                    break;
                }
                case 99: {
                    float f = this.parseFloat(1, byArray);
                    float f2 = this.parseFloat(0, byArray);
                    float f3 = this.parseFloat(3, byArray);
                    float f4 = this.parseFloat(2, byArray);
                    float f5 = this.parseFloat(5, byArray);
                    float f6 = this.parseFloat(4, byArray);
                    this.currentDrawShape.addBezierCurveC(f5, f6, f3, f4, f, f2);
                    break;
                }
                case 100: {
                    this.D(byArray);
                    break;
                }
                case 70: {
                    this.F(false);
                    break;
                }
                case 102: {
                    this.F(false);
                    break;
                }
                case 17962: {
                    this.F(true);
                    break;
                }
                case 26154: {
                    this.F(true);
                    break;
                }
                case 104: {
                    this.H();
                    break;
                }
                case 108: {
                    this.L(this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 109: {
                    this.M(this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 110: {
                    this.N();
                    break;
                }
                case 83: {
                    this.S(false);
                    break;
                }
                case 115: {
                    this.S(true);
                    break;
                }
                case 118: {
                    this.V(this.parseFloat(1, byArray), this.parseFloat(0, byArray), this.parseFloat(3, byArray), this.parseFloat(2, byArray));
                    break;
                }
                case 22314: {
                    this.W(true);
                    break;
                }
                case 87: {
                    this.W(false);
                    break;
                }
                case 121: {
                    this.Y(this.parseFloat(1, byArray), this.parseFloat(0, byArray), this.parseFloat(3, byArray), this.parseFloat(2, byArray));
                    break;
                }
                case 29285: {
                    this.RE(this.parseFloat(3, byArray), this.parseFloat(2, byArray), this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 25453: {
                    float[][] fArray = new float[3][3];
                    fArray[0][0] = this.parseFloat(5, byArray);
                    fArray[0][1] = this.parseFloat(4, byArray);
                    fArray[0][2] = 0.0f;
                    fArray[1][0] = this.parseFloat(3, byArray);
                    fArray[1][1] = this.parseFloat(2, byArray);
                    fArray[1][2] = 0.0f;
                    fArray[2][0] = this.parseFloat(1, byArray);
                    fArray[2][1] = this.parseFloat(0, byArray);
                    fArray[2][2] = 1.0f;
                    this.CM(fArray);
                    break;
                }
                case 26483: {
                    this.gs(this.generateOpAsString(0, byArray, true));
                    break;
                }
                case 105: {
                    this.I();
                    break;
                }
                case 74: {
                    this.J(false, this.parseInt(0, byArray));
                    break;
                }
                case 106: {
                    this.J(true, this.parseInt(0, byArray));
                    break;
                }
                case 113: {
                    this.Q(true);
                    break;
                }
                case 81: {
                    this.Q(false);
                    break;
                }
                case 19792: {
                    this.MP();
                    break;
                }
                case 17488: {
                    this.DP(n2, n3, byArray, this.generateOpAsString(0, byArray, false));
                    break;
                }
                case 0x424443: {
                    this.BDC(n2, n3, byArray, this.generateOpAsString(0, byArray, false));
                    break;
                }
                case 4345155: {
                    this.BMC(this.generateOpAsString(0, byArray, false));
                    break;
                }
                case 25648: {
                    this.d0((int)this.parseFloat(0, byArray), (int)this.parseFloat(1, byArray));
                    break;
                }
                case 25649: {
                    this.d1(this.parseFloat(1, byArray), this.parseFloat(3, byArray), this.parseFloat(5, byArray), this.parseFloat(0, byArray), this.parseFloat(2, byArray), this.parseFloat(4, byArray));
                    break;
                }
                case 4541763: {
                    this.EMC();
                    break;
                }
                case 16980: {
                    this.BT();
                    break;
                }
                case 17748: {
                    this.ET();
                    break;
                }
                case 17519: {
                    this.DO(this.generateOpAsString(0, byArray, true));
                    break;
                }
                case 77: {
                    this.mm((int)this.parseFloat(0, byArray));
                    break;
                }
                case 119: {
                    this.width(this.parseFloat(0, byArray));
                }
            }
        }
        this.currentOp = 0;
        this.operandCount = 0;
        ++this.tokenNumber;
        return n3;
    }

    private void gs(Object object) {
        PdfObject pdfObject = (PdfObject)this.GraphicsStates.get(object);
        this.gs.setMode(pdfObject);
        this.current.setGraphicsState(2, this.gs.getNonStrokeAlpha());
        this.current.setGraphicsState(1, this.gs.getStrokeAlpha());
    }

    private final void DO(String string) throws PdfException {
        block29: {
            Object object;
            if (this.rejectSuperimposedImages) {
                if (this.imposedImages == null) {
                    this.imposedImages = new HashMap();
                }
                if (this.imposedImages.get(object = (int)this.gs.CTM[2][0] + "-" + (int)this.gs.CTM[2][1] + '-' + (int)this.gs.CTM[0][0] + '-' + (int)this.gs.CTM[1][1] + '-' + (int)this.gs.CTM[0][1] + '-' + (int)this.gs.CTM[1][0]) == null) {
                    this.imposedImages.put(object, "x");
                } else {
                    return;
                }
            }
            this.currentImage = this.fileName + '-' + string;
            object = (PdfObject)this.localXObjects.get(string);
            if (object == null) {
                object = (PdfObject)this.globalXObjects.get(string);
            }
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            try {
                if (object == null) break block29;
                int n = ((PdfObject)object).getParameterConstant(1147962727);
                if (n == 373244477) {
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(true);
                    }
                    this.currentOp = 0;
                    this.operandCount = 0;
                    byte[] byArray = this.currentPdfFile.readStream((PdfObject)object, true, true, this.keepRaw, false, false);
                    if (byArray != null) {
                        this.processXForm((PdfObject)object, byArray);
                    }
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(false);
                    }
                    this.lastFormID = null;
                    break block29;
                }
                if (n == 1026635598) {
                    byte[] byArray;
                    if (!this.markedContentExtracted && this.contentHandler != null) {
                        this.contentHandler.setImageName(string);
                    }
                    if (!this.renderImages && !this.clippedImagesExtracted && !this.finalImagesExtracted && !this.rawImagesExtracted || (byArray = this.currentPdfFile.readStream((PdfObject)object, true, true, false, false, false)) == null) break block29;
                    boolean bl = false;
                    BufferedImage bufferedImage = null;
                    this.optionsApplied = 0;
                    if (!bl || PdfDecoder.extAtBestQuality) {
                        bufferedImage = this.processImageXObject((PdfObject)object, string, this.createScaledVersion, byArray);
                    }
                    if (this.requestExit) {
                        this.exited = true;
                        return;
                    }
                    if (bufferedImage == null && !bl) break block29;
                    if (this.renderDirectly || this.useHiResImageForDisplay) {
                        if (PdfDecoder.clipOnMac && PdfDecoder.isRunningOnMac && !bl) {
                            bufferedImage = this.clipForMac(bufferedImage);
                        }
                        if (this.requestExit) {
                            this.exited = true;
                            return;
                        }
                        this.gs.x = this.gs.CTM[2][0];
                        this.gs.y = this.gs.CTM[2][1];
                        if (this.renderDirectly) {
                            this.current.renderImage(null, bufferedImage, this.gs.getNonStrokeAlpha(), this.gs, this.g2, this.gs.x, this.gs.y, this.optionsApplied);
                        } else if (bufferedImage != null || bl) {
                            this.current.drawImage(this.pageNum, bufferedImage, this.gs, bl, string, this.optionsApplied);
                        }
                    } else if (this.clippedImagesExtracted) {
                        this.generateTransformedImage(bufferedImage, string);
                    } else {
                        try {
                            this.generateTransformedImageSingle(bufferedImage, string);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception " + exception + " on tansforming image in file");
                        }
                    }
                    if (bufferedImage != null) {
                        bufferedImage.flush();
                    }
                    break block29;
                }
                LogWriter.writeLog("[PDF]  not supported");
            }
            catch (Error error) {
                error.printStackTrace();
                this.imagesProcessedFully = false;
                this.addPageFailureMessage("Error " + error + " in DO with image isPrinting=" + this.isPrinting + " useHiResImageForDisplay=" + this.useHiResImageForDisplay);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.imagesProcessedFully = false;
                this.addPageFailureMessage("Error " + exception + " in DO with image isPrinting=" + this.isPrinting + " useHiResImageForDisplay=" + this.useHiResImageForDisplay);
            }
        }
    }

    private void processXForm(PdfObject pdfObject, byte[] byArray) throws PdfException {
        Object object;
        Object object2;
        Object object3;
        float[] fArray = new float[6];
        boolean bl = true;
        float[] fArray2 = pdfObject.getFloatArray(1145198201);
        if (fArray2 != null) {
            fArray = fArray2;
            for (int i = 0; i < 6; ++i) {
                if (fArray2[i] == matches[i]) continue;
                bl = false;
                break;
            }
        }
        float[][] fArray3 = null;
        if (fArray2 != null && !bl) {
            object3 = new float[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    object3[i][j] = this.gs.CTM[i][j];
                }
            }
            this.scalings.put(new Integer(this.formLevel), object3);
            fArray3 = this.gs.CTM;
            object2 = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {fArray[4], fArray[5], 1.0f}};
            object2 = Matrix.multiply((float[][])object2, fArray3);
            this.gs.CTM = (float[][])object2;
        }
        ++this.formLevel;
        object3 = (GenericColorSpace)this.strokeColorSpace.clone();
        object2 = (GenericColorSpace)this.nonstrokeColorSpace.clone();
        Map map = this.GraphicsStates;
        this.GraphicsStates = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.GraphicsStates.put(object, map.get(object));
        }
        object = this.fonts;
        this.fonts = new HashMap();
        PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
        this.readResources(pdfObject2, false);
        if (byArray.length > 0) {
            this.decodeStreamIntoObjects(byArray);
        }
        --this.formLevel;
        fArray3 = (float[][])this.scalings.get(new Integer(this.formLevel));
        if (fArray3 != null) {
            this.gs.CTM = fArray3;
        }
        if (this.formLevel == 0) {
            this.localXObjects.clear();
        }
        this.strokeColorSpace = object3;
        this.nonstrokeColorSpace = object2;
        this.fonts = object;
        this.GraphicsStates = map;
    }

    private final void generateTransformedImageSingle(BufferedImage bufferedImage, String string) {
        LogWriter.writeMethod("{generateTransformedImageSingle}", 0);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (bufferedImage != null) {
            boolean bl;
            Area area = this.gs.getClippingShape();
            ImageTransformer imageTransformer = new ImageTransformer(PdfDecoder.dpi, this.gs, bufferedImage, true, PdfDecoder.isDraft);
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            f = imageTransformer.getImageX();
            f2 = imageTransformer.getImageY();
            f3 = imageTransformer.getImageW();
            f4 = imageTransformer.getImageH();
            bufferedImage = imageTransformer.getImage();
            if (bufferedImage != null && area != null && area.getBounds().getWidth() > 1.0 && area.getBounds().getHeight() > 1.0 && this.customImageHandler != null && !this.customImageHandler.imageHasBeenScaled() && !(bl = area.contains(f, f2, f3, f4))) {
                imageTransformer.clipImage(area);
                f = imageTransformer.getImageX();
                f2 = imageTransformer.getImageY();
                f3 = imageTransformer.getImageW();
                f4 = imageTransformer.getImageH();
            }
            bufferedImage = imageTransformer.getImage();
            imageTransformer = null;
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            if (bufferedImage != null) {
                if (this.finalImagesExtracted | this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.pageNum, f, f2, f3, f4, this.lastFormID);
                    if (this.includeImagesInData) {
                        float f5 = f;
                        float f6 = f2;
                        if (area != null) {
                            int n = (int)area.getBounds().getMinX();
                            int n2 = (int)area.getBounds().getMaxX();
                            int n3 = (int)area.getBounds().getMinY();
                            int n4 = (int)area.getBounds().getMaxY();
                            if (f5 > 0.0f && f5 < (float)n || f5 < 0.0f) {
                                f5 = n;
                            }
                            float f7 = f5 + f3;
                            if (f5 < 0.0f) {
                                f7 = f3;
                            }
                            if ((float)n2 < f7) {
                                f3 = (float)n2 - f5;
                            }
                            if (f6 > 0.0f && f6 < (float)n3) {
                                f6 = n3;
                            }
                            if ((float)n4 < f6 + f4) {
                                f4 = (float)n4 - f6;
                            }
                        }
                        this.pdfData.addImageElement(f5, f6, f3, f4, this.currentImage);
                    }
                }
                if ((this.renderImages || !this.isPageContent) && bufferedImage != null) {
                    this.gs.x = f;
                    this.gs.y = f2;
                    if (this.renderDirectly) {
                        this.current.renderImage(null, bufferedImage, this.gs.getNonStrokeAlpha(), this.gs, this.g2, this.gs.x, this.gs.y, this.optionsApplied);
                    } else {
                        this.current.drawImage(this.pageNum, bufferedImage, this.gs, false, string, this.optionsApplied);
                    }
                }
                if (this.isPageContent && this.finalImagesExtracted && this.currentPdfFile.isExtractionAllowed() && !runningStoryPad) {
                    String string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, this.addBackgroundToMask(bufferedImage), false, false, string2);
                }
            }
        } else {
            LogWriter.writeLog("NO image written");
        }
    }

    private BufferedImage addBackgroundToMask(BufferedImage bufferedImage) {
        if (this.isMask) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    private final BufferedImage clipForMac(BufferedImage bufferedImage) {
        LogWriter.writeMethod("{clipForMac}", 0);
        if (bufferedImage != null) {
            ImageTransformerDouble imageTransformerDouble = new ImageTransformerDouble(PdfDecoder.dpi, this.gs, bufferedImage, this.createScaledVersion, false);
            if (this.requestExit) {
                this.exited = true;
                return null;
            }
            imageTransformerDouble.doubleScaleTransformShear(true);
            if (this.requestExit) {
                this.exited = true;
                return null;
            }
            bufferedImage = imageTransformerDouble.getImage();
        }
        return bufferedImage;
    }

    private final void generateTransformedImage(BufferedImage bufferedImage, String string) {
        LogWriter.writeMethod("{generateTransformedImage}", 0);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (bufferedImage != null) {
            ImageTransformerDouble imageTransformerDouble = new ImageTransformerDouble(PdfDecoder.dpi, this.gs, bufferedImage, this.createScaledVersion, true);
            imageTransformerDouble.doubleScaleTransformShear(false);
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            bufferedImage = imageTransformerDouble.getImage();
            String string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
            if (string2 == null) {
                string2 = "tif";
            }
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            if (this.objectStoreStreamRef.saveStoredImage("CLIP_" + this.currentImage, this.addBackgroundToMask(bufferedImage), false, false, string2)) {
                this.addPageFailureMessage("Problem saving " + bufferedImage);
            }
            if (this.finalImagesExtracted | this.renderImages) {
                imageTransformerDouble.doubleScaleTransformScale();
            }
            imageTransformerDouble.completeImage();
            f = imageTransformerDouble.getImageX();
            f2 = imageTransformerDouble.getImageY();
            f3 = imageTransformerDouble.getImageW();
            f4 = imageTransformerDouble.getImageH();
            bufferedImage = imageTransformerDouble.getImage();
            imageTransformerDouble = null;
            if (bufferedImage != null) {
                if (this.finalImagesExtracted | this.clippedImagesExtracted | this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.pageNum, f, f2, f3, f4, this.lastFormID);
                    if (this.includeImagesInData) {
                        this.pdfData.addImageElement(f, f2, f3, f4, this.currentImage);
                    }
                }
                if ((this.renderImages || !this.isPageContent) && bufferedImage != null) {
                    this.gs.x = f;
                    this.gs.y = f2;
                    if (this.renderDirectly) {
                        this.current.renderImage(null, bufferedImage, this.gs.getNonStrokeAlpha(), this.gs, this.g2, this.gs.x, this.gs.y, this.optionsApplied);
                    } else {
                        this.current.drawImage(this.pageNum, bufferedImage, this.gs, false, string, this.optionsApplied);
                    }
                }
                if (!this.renderDirectly && this.isPageContent && this.finalImagesExtracted && this.currentPdfFile.isExtractionAllowed()) {
                    string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, this.addBackgroundToMask(bufferedImage), false, false, string2);
                }
            }
        } else {
            LogWriter.writeLog("NO image written");
        }
    }

    private final StringBuffer processTextArray(byte[] byArray, int n, int n2) {
        float f;
        float f2;
        float f3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        while (byArray[n] == 91 || byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            if (byArray[n] == 91) {
                bl2 = true;
            }
            ++n;
        }
        float f4 = currentThreshold;
        if (f4 < 0.0f) {
            Float f5 = (Float)currentThresholdValues.get(this.currentFontData.getFontName());
            f4 = f5 == null ? -f4 : f5.floatValue();
        }
        this.textLength = 0;
        int n3 = this.gs.getTextRenderType();
        int n4 = 0;
        boolean bl4 = true;
        boolean bl5 = false;
        float[][] fArray = new float[3][3];
        float[][] fArray2 = new float[3][3];
        float[][] fArray3 = new float[3][3];
        float[][] fArray4 = new float[3][3];
        float[][] fArray5 = new float[3][3];
        int n5 = 32;
        int n6 = 32;
        int n7 = 32;
        int n8 = 120;
        int n9 = 0;
        int n10 = 0;
        float f6 = 0.0f;
        float f7 = 1.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        String string = "";
        float f11 = f3 = this.currentTextState.getTfs();
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        int n11 = this.currentFontData.getFontType();
        float f12 = this.currentFontData.getCurrentFontSpaceWidth();
        String string2 = "";
        this.textData = new StringBuffer(50);
        float f13 = 0.0f;
        boolean bl6 = this.currentFontData.isCIDFont();
        if (this.renderText && n3 != 4) {
            this.gs.setStrokeColor(this.strokeColorSpace.getColor());
            this.gs.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            if (this.showTextAsRotated && this.currentRotation != 0) {
                this.gs.setStrokeColor(new PdfColor(0, 0, 255));
                this.gs.setNonstrokeColor(new PdfColor(0, 0, 255));
            }
        }
        int n12 = 2;
        if (bl6) {
            n12 = 4;
        }
        fArray2 = Matrix.multiply(this.currentTextState.Tm, this.gs.CTM);
        if (this.currentRotation != 0) {
            fArray = Matrix.multiply(this.currentTextState.TmNoRotation, this.gs.CTM);
        }
        if (f11 < 0.0f) {
            fArray2[2][0] = fArray2[2][0] - fArray2[0][0] / 2.0f;
            fArray2[2][1] = fArray2[2][1] - fArray2[1][1] / 2.0f;
            if (this.currentRotation != 0) {
                fArray[2][0] = fArray[2][0] - fArray[0][0] / 2.0f;
                fArray[2][1] = fArray2[2][1] - fArray[1][1] / 2.0f;
            }
        }
        this.charSpacing = this.currentTextState.getCharacterSpacing() / f3;
        float f14 = this.currentTextState.getWordSpacing() / f3;
        if (this.multipleTJs) {
            fArray2[2][0] = this.currentTextState.Tm[2][0];
            fArray2[2][1] = this.currentTextState.Tm[2][1];
            if (this.currentRotation != 0) {
                fArray[2][0] = this.currentTextState.TmNoRotation[2][0];
                fArray[2][1] = this.currentTextState.TmNoRotation[2][1];
            }
        }
        fArray3[0][0] = f11 * this.currentTextState.getHorizontalScaling();
        fArray3[1][1] = f11;
        fArray3[2][1] = this.currentTextState.getTextRise();
        fArray3[2][2] = 1.0f;
        fArray2 = Matrix.multiply(fArray3, fArray2);
        if (this.currentRotation != 0) {
            fArray = Matrix.multiply(fArray3, fArray);
        }
        if (bl2 && byArray[n] != 60 && byArray[n] != 40 && byArray[n] != 93) {
            float f15 = 0.0f;
            while (byArray[n] != 40) {
                StringBuffer stringBuffer = new StringBuffer();
                while (byArray[n] != 40 && byArray[n] != 32) {
                    stringBuffer.append((char)byArray[n]);
                    ++n;
                }
                f15 += Float.parseFloat(stringBuffer.toString());
                while (byArray[n] == 32) {
                    ++n;
                }
            }
            f15 = fArray2[0][0] * f15 / 1000.0f;
            fArray2[2][0] = fArray2[2][0] - f15;
            if (this.currentRotation != 0) {
                fArray[2][0] = fArray[2][0] - f15;
            }
        }
        this.multipleTJs = true;
        if (fArray2[1][1] != 0.0f) {
            bl4 = true;
            n4 = 0;
            n9 = Math.round(fArray2[1][1]);
            if (n9 == 0) {
                n9 = Math.round(fArray2[0][1]);
            }
            f7 = fArray2[0][0];
        } else {
            bl4 = false;
            n9 = Math.round(fArray2[1][0]);
            if (n9 == 0) {
                n9 = Math.round(fArray2[0][0]);
            }
            if (n9 < 0) {
                n9 = -n9;
                n4 = 3;
            } else {
                n4 = 2;
            }
            f7 = fArray2[0][1];
        }
        if (n9 == 0) {
            n9 = 1;
        }
        Font font = null;
        if ((useTextPrintingForNonEmbeddedFonts || this.textPrint != 0) && this.isPrinting) {
            font = this.currentFontData.getJavaFontX(n9);
        }
        if (this.currentRotation == 0) {
            f2 = fArray2[2][0];
            f = fArray2[2][1];
        } else {
            f2 = fArray[2][0];
            f = fArray[2][1];
        }
        float f16 = n9;
        if (n11 == 1228944679 && n9 > 10) {
            f16 = 10.0f;
        }
        if (bl6) {
            f16 = fArray2[1][1];
        }
        int n13 = 0;
        for (int i = n; i < n2; ++i) {
            int n14;
            while (true) {
                n6 = n6 == 92 && n5 == 92 ? 120 : n5;
                n10 = byArray[i];
                if (n10 < 0) {
                    n10 = 256 + n10;
                }
                if ((n5 = (int)((char)n10)) == 92 && byArray[i + 1] == 13 | byArray[i + 1] == 10) {
                    if ((n10 = byArray[++i]) < 0) {
                        n10 = 256 + n10;
                    }
                    n5 = (char)n10;
                }
                if (n5 != 10 & n5 != 13) break;
                ++i;
            }
            if (bl5) {
                if (n6 != 92 && (n5 == 40 || n5 == 41)) {
                    if (n5 == 40) {
                        ++n13;
                    } else if (n5 == 41) {
                        if (n13 <= 0) {
                            bl5 = false;
                        } else {
                            --n13;
                        }
                    }
                } else if (n7 == 60 && n5 == 62) {
                    bl5 = false;
                }
            }
            if (bl5) {
                float f17;
                block214: {
                    int n15;
                    Serializable serializable;
                    n8 = n5;
                    if (n7 == 60) {
                        serializable = new StringBuffer(4);
                        ((StringBuffer)serializable).append((char)n5);
                        for (n15 = 1; n15 < n12; ++n15) {
                            n14 = byArray[i + n15];
                            if (n14 == 62) {
                                n15 = 4;
                                n12 = 2;
                                continue;
                            }
                            if (n14 == 10 | n14 == 13) {
                                ++i;
                                --n15;
                                continue;
                            }
                            if (n14 < 0) {
                                n14 = 256 + n14;
                            }
                            n5 = (char)n14;
                            ((StringBuffer)serializable).append((char)n5);
                        }
                        i = i + n12 - 1;
                        n10 = Integer.parseInt(((StringBuffer)serializable).toString(), 16);
                        n5 = (char)n10;
                        string = this.currentFontData.getGlyphValue(n10);
                        if (this.textExtracted) {
                            string2 = this.currentFontData.getUnicodeValue(string, n10);
                        }
                    } else if (bl6 && this.currentFontData.isDoubleByte()) {
                        int n16;
                        if (n5 == 92) {
                            while (true) {
                                if ((n10 = byArray[i]) < 0) {
                                    n10 = 256 + n10;
                                }
                                n5 = (char)n10;
                                if (n10 < 0) {
                                    n10 = 256 + n10;
                                }
                                n5 = (char)n10;
                                if (n10 == 92) {
                                    if ((n5 = (char)(n10 = byArray[++i])) == 110) {
                                        n10 = 10;
                                    } else if (n5 == 98) {
                                        n10 = 8;
                                    } else if (n5 == 116) {
                                        n10 = 9;
                                    } else if (n5 == 114) {
                                        n10 = 13;
                                    } else if (n5 == 102) {
                                        n10 = 12;
                                    } else if (byArray.length > i + 2 && Character.isDigit((char)byArray[i])) {
                                        int n17 = 1;
                                        if (Character.isDigit((char)byArray[i + 1])) {
                                            ++n17;
                                            if (Character.isDigit((char)byArray[i + 2])) {
                                                ++n17;
                                            }
                                        }
                                        n10 = this.readEscapeValue(i, n17, 8, byArray);
                                        i = i + n17 - 1;
                                    }
                                }
                                if (n5 != 10 && n5 != 13) break;
                                ++i;
                            }
                        }
                        if ((n16 = byArray[++i]) < 0) {
                            n16 = 256 + n16;
                        }
                        if (n16 == 92) {
                            if ((n5 = (int)((char)(n16 = byArray[++i]))) == 110) {
                                n16 = 10;
                            } else if (n5 == 98) {
                                n16 = 8;
                            } else if (n5 == 116) {
                                n16 = 9;
                            } else if (n5 == 114) {
                                n16 = 13;
                            } else if (n5 == 102) {
                                n16 = 12;
                            } else if (byArray.length > i + 2 && Character.isDigit((char)byArray[i])) {
                                int n18 = 1;
                                if (Character.isDigit((char)byArray[i + 1])) {
                                    ++n18;
                                    if (Character.isDigit((char)byArray[i + 2])) {
                                        ++n18;
                                    }
                                }
                                n16 = this.readEscapeValue(i, n18, 8, byArray);
                                i = i + n18 - 1;
                            }
                        }
                        n10 = n10 * 256 + n16;
                        n5 = (char)n10;
                        string = String.valueOf((char)n5);
                        string2 = this.currentFontData.getUnicodeValue(string, n10);
                        if (n5 == 92) {
                            n5 = 120;
                        }
                    } else if (n5 == 92) {
                        n6 = n5;
                        n10 = byArray[++i];
                        n5 = (char)n10;
                        if (byArray.length > i + 2 && Character.isDigit((char)byArray[i])) {
                            int n19 = 1;
                            if (Character.isDigit((char)byArray[i + 1])) {
                                ++n19;
                                if (Character.isDigit((char)byArray[i + 2])) {
                                    ++n19;
                                }
                            }
                            n10 = this.readEscapeValue(i, n19, 8, byArray);
                            i = i + n19 - 1;
                            if (n10 > 255) {
                                n10 -= 256;
                            }
                            string = this.currentFontData.getGlyphValue(n10);
                            if (this.textExtracted) {
                                string2 = this.currentFontData.getUnicodeValue(string, n10);
                            }
                            if ((n5 = (int)((char)n10)) == 92) {
                                n5 = 120;
                            }
                        } else {
                            n10 = byArray[i];
                            n5 = (char)n10;
                            if (n5 == 117) {
                                n10 = this.readEscapeValue(i + 1, 4, 16, byArray);
                                i += 4;
                                string = this.currentFontData.getGlyphValue(n10);
                                if (this.textExtracted) {
                                    string2 = this.currentFontData.getUnicodeValue(string, n10);
                                }
                            } else {
                                if (n5 == 110) {
                                    n10 = 10;
                                    n5 = 10;
                                } else if (n5 == 98) {
                                    n10 = 8;
                                    n5 = 8;
                                } else if (n5 == 116) {
                                    n10 = 9;
                                    n5 = 9;
                                } else if (n5 == 114) {
                                    n10 = 13;
                                    n5 = 13;
                                } else if (n5 == 102) {
                                    n10 = 12;
                                    n5 = 12;
                                }
                                string = this.currentFontData.getGlyphValue(n10);
                                if (this.textExtracted) {
                                    string2 = this.currentFontData.getUnicodeValue(string, n10);
                                }
                                if (string.length() > 0) {
                                    n5 = string.charAt(0);
                                }
                            }
                        }
                    } else if (bl6) {
                        string2 = string = String.valueOf((char)n5);
                    } else {
                        string = this.currentFontData.getGlyphValue(n10);
                        if (this.textExtracted) {
                            string2 = this.currentFontData.getUnicodeValue(string, n10);
                        }
                    }
                    fArray3[0][0] = 1.0f;
                    fArray3[0][1] = 0.0f;
                    fArray3[0][2] = 0.0f;
                    fArray3[1][0] = 0.0f;
                    fArray3[1][1] = 1.0f;
                    fArray3[1][2] = 0.0f;
                    fArray3[2][0] = f9 + f10;
                    fArray3[2][1] = 0.0f;
                    fArray3[2][2] = 1.0f;
                    fArray2 = Matrix.multiply(fArray3, fArray2);
                    if (this.currentRotation != 0) {
                        fArray = Matrix.multiply(fArray3, fArray);
                    }
                    if (n5 == 32 && n6 != 32) {
                        fArray4 = fArray2;
                        if (this.currentRotation != 0) {
                            fArray5 = fArray;
                        }
                    }
                    f10 = 0.0f;
                    serializable = this.currentFontData.getGlyphData();
                    n15 = n10;
                    if (this.currentFontData.isCIDFont() && !((PdfJavaGlyphs)serializable).isIdentity() && (n14 = ((PdfJavaGlyphs)serializable).getConvertedGlyph(n10)) != -1) {
                        n15 = n14;
                    }
                    f9 = this.currentFontData.getWidth(n15);
                    if (this.renderText && n3 != 4) {
                        float[][] fArray6 = fArray2;
                        if (this.showTextAsRotated && this.currentRotation != 0) {
                            fArray6 = fArray;
                        }
                        if (this.isPrinting && font != null && (this.textPrint == 2 || useTextPrintingForNonEmbeddedFonts && (!this.currentFontData.isFontEmbedded || this.currentFontData.isFontSubstituted()))) {
                            boolean bl7;
                            Area area;
                            if (n3 == 7 && (area = ((PdfJavaGlyphs)serializable).getStandardGlyph(fArray6, n10, string, f9, bl7 = PdfDecoder.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName()), null)) != null) {
                                this.gs.addClip(area);
                            }
                            if (string != null && !string.startsWith("&#")) {
                                this.current.drawText(fArray2, string, this.gs, fArray6[2][0], -fArray6[2][1], font);
                            }
                        } else if (this.textPrint == 1 && font != null || !this.currentFontData.isFontEmbedded || !this.currentFontData.isFontSubstituted() || n10 != 10 && n10 != 13) {
                            if ((this.textPrint != 1 || font == null) && this.currentFontData.isFontEmbedded) {
                                String string3 = "notdef";
                                try {
                                    Area area;
                                    float f18;
                                    if (!this.currentFontData.isCIDFont()) {
                                        string3 = this.currentFontData.getMappedChar(n10, false);
                                    }
                                    PdfGlyph pdfGlyph = null;
                                    pdfGlyph = ((PdfJavaGlyphs)serializable).getEmbeddedGlyph(this.factory, string3, fArray6, n10, string, f9, this.currentFontData.getEmbeddedChar(n10));
                                    if (n11 == 1228944679) {
                                        if (pdfGlyph != null && pdfGlyph.getmaxWidth() == 0.0f) {
                                            pdfGlyph = null;
                                        } else if (pdfGlyph != null && pdfGlyph.ignoreColors()) {
                                            pdfGlyph.lockColors(this.gs.getNonstrokeColor(), this.gs.getNonstrokeColor());
                                        }
                                    }
                                    if (pdfGlyph == null) break block214;
                                    Object object = new float[][]{{fArray6[0][0], fArray6[0][1], 0.0f}, {fArray6[1][0], fArray6[1][1], 0.0f}, {fArray6[2][0], fArray6[2][1], 1.0f}};
                                    float[][] fArrayArray = new float[][]{{(float)this.currentFontData.FontMatrix[0], (float)this.currentFontData.FontMatrix[1], 0.0f}, {(float)this.currentFontData.FontMatrix[2], (float)this.currentFontData.FontMatrix[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                                    object = Matrix.multiply(object, fArrayArray);
                                    object[2][0] = fArray6[2][0];
                                    object[2][1] = fArray6[2][1];
                                    if (object[1][0] < 0.0f && object[0][1] < 0.0f) {
                                        object[1][0] = -object[1][0];
                                        object[0][1] = -object[0][1];
                                    }
                                    if (n11 == 1228944679) {
                                        f18 = 0.0f;
                                        if (object[1][1] != 0.0f) {
                                            f18 = (float)n9 * object[1][1];
                                        } else if (object[0][0] != 0.0f) {
                                            f18 = (float)n9 * object[0][0];
                                        } else if (object[1][0] != 0.0f) {
                                            f18 = (float)n9 * object[1][0];
                                        }
                                        if (f18 < 0.0f) {
                                            f18 = -f18;
                                        }
                                        if (f18 > f16) {
                                            f16 = f18;
                                        }
                                    }
                                    if (!((f18 = 0.0f) > 0.0f)) {
                                        f18 = 0.0f;
                                    }
                                    AffineTransform affineTransform = new AffineTransform(object[0][0], object[0][1], object[1][0], object[1][1], object[2][0], object[2][1]);
                                    int n20 = n11;
                                    if (n11 == 6) {
                                        n20 = 5;
                                        float f19 = 1000.0f / pdfGlyph.getmaxWidth();
                                        affineTransform.scale(f9 * f19, 1.0);
                                    } else {
                                        n20 = n11 == 1217103210 || n11 == -1684566724 || this.currentFontData.isFontSubstituted() ? 4 : (n11 == 1228944679 ? 6 : 5);
                                    }
                                    if (this.generateGlyphOnRender) {
                                        n20 = -n20;
                                    }
                                    if (n3 == 7 && (area = (Area)pdfGlyph.getShape().clone()) != null) {
                                        area.transform(affineTransform);
                                        this.gs.addClip(area);
                                    }
                                    if (this.renderDirectly) {
                                        PdfPaint pdfPaint = null;
                                        PdfPaint pdfPaint2 = null;
                                        int n21 = this.gs.getTextRenderType();
                                        if ((n21 & 2) == 2) {
                                            pdfPaint2 = this.gs.getNonstrokeColor();
                                        }
                                        if ((n21 & 1) == 1) {
                                            pdfPaint = this.gs.getStrokeColor();
                                        }
                                        Stroke stroke = this.gs.getStroke();
                                        Stroke stroke2 = this.g2.getStroke();
                                        if (n21 == 1) {
                                            this.g2.setStroke(stroke);
                                        }
                                        this.current.renderEmbeddedText(this.gs, n21, pdfGlyph, n20, this.g2, affineTransform, null, pdfPaint, pdfPaint2, this.gs.getStrokeAlpha(), this.gs.getNonStrokeAlpha(), null, (int)f18);
                                        this.g2.setStroke(stroke2);
                                        break block214;
                                    }
                                    this.current.drawEmbeddedText(fArray6, n9, pdfGlyph, n20, this.gs, affineTransform, f18);
                                }
                                catch (Exception exception) {
                                    this.addPageFailureMessage("Exception " + exception + " on embedded font renderer");
                                }
                            } else if (string.length() > 0 && !string.startsWith("&#")) {
                                Area area = null;
                                boolean bl8 = PdfDecoder.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName());
                                Object object = ((PdfJavaGlyphs)serializable).getStandardGlyph(fArray6, n10, string, f9, bl8, null);
                                if (object != null) {
                                    if (n3 == 7) {
                                        Area area2 = (Area)((Area)object).clone();
                                        AffineTransform affineTransform = AffineTransform.getTranslateInstance(fArray6[2][0], fArray6[2][1]);
                                        area2.transform(affineTransform);
                                        this.gs.addClip(area2);
                                    }
                                    if (!DynamicVectorRenderer.marksNewCode) {
                                        AffineTransform affineTransform = AffineTransform.getTranslateInstance(fArray6[2][0], fArray6[2][1]);
                                        ((Area)object).transform(affineTransform);
                                    }
                                }
                                if ((area = object) != null) {
                                    if (this.renderDirectly) {
                                        PdfPaint pdfPaint = null;
                                        object = null;
                                        int n22 = this.gs.getTextRenderType();
                                        if ((n22 & 2) == 2) {
                                            object = this.gs.getNonstrokeColor();
                                        }
                                        if ((n22 & 1) == 1) {
                                            pdfPaint = this.gs.getStrokeColor();
                                        }
                                        Stroke stroke = this.gs.getStroke();
                                        this.g2.setStroke(stroke);
                                        this.current.renderText(f2, f, n22, area, this.g2, null, pdfPaint, (PdfPaint)object, this.gs.getStrokeAlpha(), this.gs.getNonStrokeAlpha());
                                    } else {
                                        this.current.drawText(fArray6, n9, area, this.gs);
                                    }
                                }
                            }
                        }
                    }
                }
                if (pauseOnTJ) {
                    Matrix.show(fArray2);
                    System.out.println(this.glyphCount + "====>>" + this.currentFontData.getFontName() + ' ' + this.currentFontData + ' ' + this.currentFontData.getFontType());
                    Object[] objectArray = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, null, "glpyhCount=" + this.glyphCount + ' ' + this.currentFontData.getFontName(), 0, 1, null, objectArray, objectArray[0]);
                }
                if (this.legacyTextMode && this.textExtracted && !bl6 && f16 < (f17 = PdfDecoder.currentHeightLookupData.getCharHeight(n5, n9))) {
                    f16 = f17;
                }
                f9 += this.charSpacing;
                int n23 = n14 = runningStoryPad && this.charSpacing / f12 > 1.0f ? 1 : 0;
                if (n5 == 32) {
                    f9 += f14;
                }
                f13 = f6 + this.charSpacing - f8;
                String string4 = "";
                if (f13 > 0.0f & f8 > 0.0f) {
                    float f20 = f13 * f7;
                    if (runningStoryPad && f20 > 160.0f && n9 > 11) {
                        if (this.currentRotation == 0) {
                            this.calcCoordinates(f2, fArray2, bl4, f16, n9, f);
                        } else {
                            this.calcCoordinates(f2, fArray, bl4, f16, n9, f);
                        }
                        if (bl4) {
                            this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, this.currentTextState.writingMode, this.font_as_string, this.currentFontData.getCurrentFontSpaceWidth(), this.currentTextState, this.x1, this.y1, this.x2 - f20, this.y2, this.moveCommand, this.textData, this.tokenNumber, this.textLength, this.currentColor, this.currentRotation);
                        }
                        this.textData = new StringBuffer();
                        this.textLength = -1;
                        f6 = 0.0f;
                        f2 = this.x2;
                    } else {
                        string4 = this.getSpaces(f13, f12, f4);
                    }
                }
                ++this.textLength;
                f8 = f6 += f9;
                if (this.textExtracted && string2.length() > 0) {
                    if (PdfDecoder.embedWidthData) {
                        float f21 = fArray2[2][0];
                        float f22 = fArray2[2][1];
                        if (this.currentRotation != 0) {
                            f21 = fArray[2][0];
                            f22 = fArray[2][1];
                        }
                        if (n14 != 0 && string4.length() > 0) {
                            this.textData.append(StoryData.marker);
                            if (bl4 | PdfGroupingAlgorithms.oldTextExtraction) {
                                this.textData.append(f21 - this.charSpacing * f7);
                            } else {
                                this.textData.append(f22 - this.charSpacing * f7);
                            }
                            this.textData.append(StoryData.marker);
                            this.textData.append(this.charSpacing * f7);
                            this.textData.append(StoryData.marker);
                        }
                        this.textData.append(string4);
                        if (bl4 | PdfGroupingAlgorithms.oldTextExtraction) {
                            this.textData.append(StoryData.marker);
                            this.textData.append(f21);
                            this.textData.append(StoryData.marker);
                        } else {
                            this.textData.append(StoryData.marker);
                            this.textData.append(f22);
                            this.textData.append(StoryData.marker);
                        }
                        if (n14 != 0) {
                            this.textData.append((f9 - this.charSpacing) * f7);
                        } else {
                            this.textData.append(f9 * f7);
                        }
                        this.textData.append(StoryData.marker);
                    } else {
                        this.textData.append(string4);
                    }
                    String string5 = string2;
                    int n24 = string5.length();
                    for (int j = 0; j < n24; ++j) {
                        char c = string5.charAt(j);
                        if (!runningStoryPad || c != ' ' && c != '\n' && c != '\r') {
                            bl = true;
                        }
                        if (PdfDecoder.isXMLExtraction() && c == '<') {
                            this.textData.append("&lt;");
                            continue;
                        }
                        if (PdfDecoder.isXMLExtraction() && c == '>') {
                            this.textData.append("&gt;");
                            continue;
                        }
                        if (c > '\u001f') {
                            this.textData.append(c);
                            continue;
                        }
                        this.textData.append(hex[c]);
                    }
                    continue;
                }
                this.textData.append(string4);
                continue;
            }
            if (n5 == 40 | n5 == 60) {
                bl5 = true;
                n7 = n5;
                continue;
            }
            if (n5 != 41 && (n5 != 62 || n7 != 60) && (bl5 || n5 != 45 && (n5 < 48 || n5 > 57))) continue;
            float f23 = 0.0f;
            ++i;
            while (byArray[i] == 32) {
                ++i;
            }
            char c = (char)byArray[i];
            if (c == '(' || c == '<') {
                --i;
            } else if (c != '\'' && c != '\"' && c != '(' && c != ']' && c != '<') {
                StringBuffer stringBuffer = new StringBuffer(6);
                n14 = i;
                boolean bl9 = false;
                boolean bl10 = false;
                while (!bl9) {
                    n5 = c;
                    if (n5 != 10 && n5 != 13) {
                        stringBuffer.append((char)n5);
                    }
                    if ((c = (char)byArray[i + 1]) == ' ') {
                        bl10 = true;
                    }
                    if (c == '(' || c == '<' || c == ']') break;
                    if (c != '-' && c != '.' && c != ' ' && (c < '0' || c > '9')) {
                        bl9 = true;
                    }
                    ++i;
                }
                if (bl9) {
                    i = n14;
                } else if (bl10) {
                    StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString());
                    f23 = 0.0f;
                    while (stringTokenizer.hasMoreTokens()) {
                        f23 += Float.parseFloat(stringTokenizer.nextToken());
                    }
                    f23 = -f23 / 1000.0f;
                } else if (stringBuffer.length() > 0) {
                    f23 = -Float.parseFloat(stringBuffer.toString()) / 1000.0f;
                }
            }
            f6 += f23;
            f10 += f23;
        }
        fArray3[0][0] = 1.0f;
        fArray3[0][1] = 0.0f;
        fArray3[0][2] = 0.0f;
        fArray3[1][0] = 0.0f;
        fArray3[1][1] = 1.0f;
        fArray3[1][2] = 0.0f;
        fArray3[2][0] = f9 + f10;
        fArray3[2][1] = 0.0f;
        fArray3[2][2] = 1.0f;
        fArray2 = Matrix.multiply(fArray3, fArray2);
        this.currentTextState.Tm[2][0] = fArray2[2][0];
        this.currentTextState.Tm[2][1] = fArray2[2][1];
        if (this.currentRotation != 0) {
            fArray = Matrix.multiply(fArray3, fArray);
            this.currentTextState.TmNoRotation[2][0] = fArray[2][0];
            this.currentTextState.TmNoRotation[2][1] = fArray[2][1];
        }
        if (pauseOnTJ) {
            Matrix.show(fArray2);
            System.out.println(this.glyphCount + "==============" + this.currentFontData.getFontName() + ' ' + this.currentFontData + ' ' + this.currentFontData.getFontType());
            Object[] objectArray = new Object[]{"OK"};
            JOptionPane.showOptionDialog(null, null, "glpyhCount=" + this.glyphCount + ' ' + this.currentFontData.getFontName(), 0, 1, null, objectArray, objectArray[0]);
        }
        if (this.textExtracted) {
            f6 -= this.charSpacing;
            if (n8 == 32) {
                fArray2 = fArray4;
                if (this.currentRotation != 0) {
                    fArray = fArray5;
                }
            }
            if (this.currentRotation == 0) {
                this.calcCoordinates(f2, fArray2, bl4, f16, n9, f);
            } else {
                this.calcCoordinates(f2, fArray, bl4, f16, n9, f);
            }
            if (this.textData.length() == 0 || !bl) {
                this.textData = null;
            }
            this.currentTextState.writingMode = n4;
            if (n9 != this.lastFontSize || this.font_as_string == null) {
                this.currentTextState.setCurrentFontSize(Math.abs(n9));
                this.font_as_string = Fonts.createFontToken(this.currentFont, this.currentTextState.getCurrentFontSize());
                this.lastFontSize = n9;
            }
            if (showCommands) {
                if (this.textData == null) {
                    System.out.println("no data-------------");
                } else {
                    System.out.println(this.tokenNumber + " data=" + this.x1 + ' ' + this.y1 + ',' + this.x2 + ' ' + this.y2 + ' ' + PdfGroupingAlgorithms.removeHiddenMarkers(this.textData.toString() + "<<"));
                }
            }
            if (runningStoryPad && !bl4) {
                this.textData = null;
            }
            return this.textData;
        }
        return null;
    }

    private void calcCoordinates(float f, float[][] fArray, boolean bl, float f2, int n, float f3) {
        float[][] fArray2 = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(fArray[i], 0, fArray2[i], 0, 3);
        }
        this.x1 = f;
        this.x2 = fArray2[2][0] - this.charSpacing * fArray2[0][0];
        if (bl) {
            if (fArray2[1][0] < 0.0f) {
                this.x1 = f + fArray2[1][0] - this.charSpacing * fArray2[0][0];
                this.x2 = fArray2[2][0];
            } else if (fArray2[1][0] > 0.0f) {
                this.x1 = f;
                this.x2 = fArray2[2][0];
            }
        } else if (fArray2[1][0] > 0.0f) {
            this.x1 = fArray2[2][0];
            this.x2 = f + fArray2[1][0] - this.charSpacing * fArray2[0][0];
        } else if (fArray2[1][0] < 0.0f) {
            this.x2 = fArray2[2][0];
            this.x1 = f + fArray2[1][0] - this.charSpacing * fArray2[0][0];
        }
        if (bl) {
            float f4 = 1.0f;
            if (this.legacyTextMode || this.currentFontData.getFontType() == 1228944679) {
                f4 = f2 / (float)n;
            }
            if (fArray2[0][1] != 0.0f) {
                this.y1 = fArray2[2][1] - fArray2[0][1] + (fArray2[0][1] + fArray2[1][1]) * f4;
                this.y2 = f3;
            } else {
                this.y1 = f3 + fArray2[1][1] * f4;
                this.y2 = fArray2[2][1];
            }
        } else if (fArray2[0][1] <= 0.0f) {
            this.y2 = fArray2[2][1];
            this.y1 = f3;
        } else if (fArray2[0][1] > 0.0f) {
            this.y1 = fArray2[2][1];
            this.y2 = f3;
        }
    }

    private final String getSpaces(float f, float f2, float f3) {
        String string = "";
        if (f2 > 0.0f) {
            if (f > f2) {
                while (f >= f2) {
                    string = ' ' + string;
                    f -= f2;
                }
            } else if (f > f2 * f3) {
                string = string + ' ';
            }
        }
        return string;
    }

    private final int readEscapeValue(int n, int n2, int n3, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append((char)byArray[n + i]);
        }
        return Integer.parseInt(stringBuffer.toString(), n3);
    }

    public static String getFontsInFile() {
        return fontsInFile;
    }

    public void setDirectRendering(Graphics2D graphics2D) {
        this.renderDirectly = true;
        this.g2 = graphics2D;
        this.defaultClip = graphics2D.getClip();
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public void includeImages() {
        this.includeImagesInData = true;
    }

    public PageLines getPageLines() {
        this.pageLines.lookForCompositeLines();
        return this.pageLines;
    }

    public boolean isPageSuccessful() {
        return this.pageSuccessful;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public void addPageFailureMessage(String string) {
        this.pageSuccessful = false;
        this.pageErrorMessages = this.pageErrorMessages + string + '\n';
    }

    public Map getFontMap() {
        return this.fonts;
    }

    public StringBuffer getlastTextStreamDecoded() {
        return this.textData;
    }

    public DynamicVectorRenderer getRenderer() {
        return this.current;
    }

    public void setTextPrint(int n) {
        this.textPrint = n;
    }

    public boolean exitedDecoding() {
        return this.exited;
    }

    public void terminateDecoding() {
        this.exited = false;
    }

    public static boolean isFormSupportAvailable() {
        return true;
    }

    public boolean hasAllImages() {
        return this.imagesProcessedFully;
    }

    public void setExternalImageRender(ImageHandler imageHandler) {
        this.customImageHandler = imageHandler;
        if (this.customImageHandler != null) {
            this.keepRaw = true;
        }
        if (imageHandler != null && this.current != null) {
            this.current.setCustomImageHandler(imageHandler);
        }
    }

    public boolean hasStructuredContent() {
        if (this.contentHandler == null) {
            return false;
        }
        return this.contentHandler.hasContent();
    }

    public void setMapForMarkedContent(Object object) {
        this.markedContentExtracted = true;
        this.contentHandler = new StructuredContentHandler(object);
    }

    public void setStreamType(int n) {
        this.streamType = n;
    }

    static {
        hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
        runningStoryPad = false;
        matches = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        showInvisibleText = false;
        useTextPrintingForNonEmbeddedFonts = false;
        includeRotation = false;
        SamplingFactory.setDownsampleMode(null);
        intValues = new int[][]{{0, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000}, {0, 10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000}, {0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000}, {0, 100, 200, 300, 400, 500, 600, 700, 800, 900}, {0, 10, 20, 30, 40, 50, 60, 70, 80, 90}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}};
        floatValues = new float[][]{{0.0f, 100000.0f, 200000.0f, 300000.0f, 400000.0f, 500000.0f, 600000.0f, 700000.0f, 800000.0f, 900000.0f}, {0.0f, 10000.0f, 20000.0f, 30000.0f, 40000.0f, 50000.0f, 60000.0f, 70000.0f, 80000.0f, 90000.0f}, {0.0f, 1000.0f, 2000.0f, 3000.0f, 4000.0f, 5000.0f, 6000.0f, 7000.0f, 8000.0f, 9000.0f}, {0.0f, 100.0f, 200.0f, 300.0f, 400.0f, 500.0f, 600.0f, 700.0f, 800.0f, 900.0f}, {0.0f, 10.0f, 20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f, 80.0f, 90.0f}, {0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f}};
    }
}

