/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ImageHandler;
import org.jpedal.external.JPedalCustomDrawObject;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.images.ImageOps;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.FontFactory;
import org.jpedal.render.TextObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;

public final class DynamicVectorRenderer {
    private int pageNumber = 0;
    public boolean optimisedTurnCode = true;
    private int lastItemPainted = -1;
    private boolean extraRot = false;
    private boolean optimsePainting = false;
    private String rawKey = null;
    private final boolean samplingDebug = false;
    private PdfPaint fillCol = null;
    private PdfPaint strokeCol = null;
    private static boolean flagException = false;
    private int pageX1 = 9999;
    private int pageX2 = -9999;
    private int pageY1 = -9999;
    private int pageY2 = 9999;
    private boolean highlightsNeedToBeGenerated = false;
    private ImageHandler customImageHandler = null;
    BufferedImage singleImage = null;
    int imageCount = 0;
    int defaultSize = 5000;
    int endItem = -1;
    public static boolean debugPaint = false;
    private boolean useHiResImageForDisplay = false;
    private static RenderingHints hints = null;
    private ObjectStore objectStoreRef;
    private boolean isPrinting;
    private static Map cachedWidths = new HashMap();
    private static Map cachedHeights = new HashMap();
    private Map fonts = new HashMap();
    private Map fontsUsed = new HashMap();
    protected GlyphFactory factory = null;
    private PdfGlyphs glyphs;
    private int displayMode = 1;
    private boolean isType3Font = false;
    private Map imageID = new HashMap();
    private Map imageIDtoName = new HashMap();
    private String currentImageFile = null;
    private int[] textHighlightsX;
    private int[] textHighlightsY;
    private int[] textHighlightsWidth;
    private int[] textHighlightsHeight;
    private int printPage = -1;
    private int w = 0;
    private int h = 0;
    private Color backgroundColor = Color.white;
    private float[] x_coord;
    private float[] y_coord;
    private Map largeImages = new WeakHashMap();
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    private Vector_Object pageObjects;
    private Vector_Int shapeType;
    private Vector_Rectangle areas;
    private Vector_Rectangle fontBounds;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int imageOptions;
    private Vector_Int TRvalues;
    private Vector_Int fs;
    private Vector_Int lw;
    private Vector_Shape clips;
    private Vector_Int objectType;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float opacity;
    private static final int TEXT = 1;
    private static final int SHAPE = 2;
    private static final int IMAGE = 3;
    public static final int TRUETYPE = 4;
    public static final int TYPE1C = 5;
    public static final int TYPE3 = 6;
    public static final int CLIP = 7;
    public static final int COLOR = 8;
    public static final int AF = 9;
    public static final int TEXTCOLOR = 10;
    public static final int FILLCOLOR = 11;
    public static final int STROKECOLOR = 12;
    public static final int STROKE = 14;
    public static final int TR = 15;
    public static final int STRING = 16;
    public static final int STROKEOPACITY = 17;
    public static final int FILLOPACITY = 18;
    public static final int STROKEDSHAPE = 19;
    public static final int FILLEDSHAPE = 20;
    public static final int FONTSIZE = 21;
    public static final int LINEWIDTH = 22;
    public static final int CUSTOM = 23;
    public static final int fontBB = 24;
    public static final int MARKER = 200;
    public static final boolean debugStreams = false;
    private boolean addBackground = true;
    private int currentItem = 0;
    private int lastFillTextCol;
    private int lastFillCol;
    private int lastStrokeCol;
    private Stroke lastStroke = null;
    private double[] lastAf = new double[4];
    private int lastTR = 2;
    private int lastFS = -1;
    private int lastLW = -1;
    private boolean resetTextColors = true;
    private boolean fillSet = false;
    private boolean strokeSet = false;
    public static boolean marksNewCode;
    int xx = 0;
    int yy = 0;
    private double minX = -1.0;
    private double minY = -1.0;
    private double maxX = -1.0;
    private double maxY = -1.0;
    private AffineTransform aff = new AffineTransform();
    private int rotation = 0;
    private boolean colorsLocked;
    private boolean optimiseDrawing;
    private boolean renderFailed;
    private JFrame frame = null;
    private static boolean userAlerted;
    private int paintThreadCount = 0;
    private int paintThreadID = 0;
    boolean hasClips = false;
    Area lastClip = null;
    private double cropX;
    private double cropH;
    private float scaling;
    private float lastScaling;
    public boolean needsHorizontalInvert = false;
    public boolean needsVerticalInvert = false;

    public DynamicVectorRenderer(int n, boolean bl, int n2, ObjectStore objectStore) {
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.setupArrays(n2);
    }

    private void setupArrays(int n) {
        this.x_coord = new float[n];
        this.y_coord = new float[n];
        this.text_color = new Vector_Object(n);
        this.textFillType = new Vector_Int(n);
        this.stroke_color = new Vector_Object(n);
        this.fill_color = new Vector_Object(n);
        this.stroke = new Vector_Object(n);
        this.pageObjects = new Vector_Object(n);
        this.javaObjects = new Vector_Object(n);
        this.shapeType = new Vector_Int(n);
        this.areas = new Vector_Rectangle(n);
        this.af1 = new Vector_Double(n);
        this.af2 = new Vector_Double(n);
        this.af3 = new Vector_Double(n);
        this.af4 = new Vector_Double(n);
        this.fontBounds = new Vector_Rectangle(n);
        this.clips = new Vector_Shape(n);
        this.objectType = new Vector_Int(n);
    }

    public DynamicVectorRenderer(int n, ObjectStore objectStore, boolean bl) {
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.isPrinting = bl;
        this.setupArrays(this.defaultSize);
    }

    public void setOptimsePainting(boolean bl) {
        this.optimsePainting = bl;
        this.lastItemPainted = -1;
    }

    public void setDisplayView(int n) {
        this.displayMode = n;
    }

    public final void renderText(float f, float f2, int n, Area area, Graphics2D graphics2D, Rectangle rectangle, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f3, float f4) {
        Paint paint = graphics2D.getPaint();
        AffineTransform affineTransform = graphics2D.getTransform();
        if (marksNewCode) {
            graphics2D.translate(f, f2);
        }
        if (rectangle != null) {
            Color color = Color.BLACK;
            if ((n & 1) == 1 && pdfPaint instanceof Color) {
                color = (Color)((Object)pdfPaint);
            } else if ((n & 2) == 2 && pdfPaint2 instanceof Color) {
                color = (Color)((Object)pdfPaint2);
            }
            graphics2D.setPaint(PdfDecoder.highlightColor);
            graphics2D.fill(rectangle);
            if (PdfDecoder.backgroundColor == null) {
                graphics2D.setPaint(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
            } else {
                graphics2D.setPaint(PdfDecoder.backgroundColor);
            }
            graphics2D.fill(area);
        } else {
            Composite composite = graphics2D.getComposite();
            if ((n & 2) == 2) {
                if (pdfPaint2 != null) {
                    pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
                }
                graphics2D.setPaint(pdfPaint2);
                if (f4 != 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f4));
                }
                graphics2D.fill(area);
                graphics2D.setComposite(composite);
            }
            if ((n & 1) == 1) {
                if (pdfPaint != null) {
                    pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
                }
                graphics2D.setPaint(pdfPaint);
                if (f3 != 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f3));
                }
                graphics2D.draw(area);
                graphics2D.setComposite(composite);
            }
        }
        graphics2D.setPaint(paint);
        if (marksNewCode) {
            graphics2D.setTransform(affineTransform);
        }
    }

    public final void renderEmbeddedText(GraphicsState graphicsState, int n, Object object, int n2, Graphics2D graphics2D, AffineTransform affineTransform, Rectangle rectangle, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f, float f2, Rectangle rectangle2, int n3) {
        boolean bl = graphicsState != null;
        PdfGlyph pdfGlyph = FontFactory.chooseGlyph(n2, object);
        if (bl) {
            int n4 = (int)graphicsState.CTM[1][1];
            if (n4 < 0) {
                n4 = -n4;
            }
            if (n4 == 0) {
                n4 = (int)graphicsState.CTM[0][1];
            }
            if (n4 < 0) {
                n4 = -n4;
            }
            this.areas.addElement(new Rectangle((int)graphicsState.CTM[2][0], (int)graphicsState.CTM[2][1], n4, n4));
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        if (pdfGlyph != null) {
            Stroke stroke = graphics2D.getStroke();
            if (n3 != 0) {
                graphics2D.setStroke(new BasicStroke(n3));
            }
            Color color = null;
            if (pdfPaint != null && pdfPaint instanceof Color) {
                color = (Color)((Object)pdfPaint);
            } else if (pdfPaint == null && pdfPaint2 instanceof Color) {
                color = (Color)((Object)pdfPaint2);
            }
            Object var20_21 = null;
            graphics2D.transform(affineTransform);
            Composite composite = graphics2D.getComposite();
            Color color2 = null;
            if (rectangle != null) {
                color2 = (n & 2) == 2 && pdfPaint2 instanceof Color ? (Color)((Object)pdfPaint2) : (pdfPaint instanceof Color ? (Color)((Object)pdfPaint) : PdfDecoder.highlightColor);
                graphics2D.setPaint(PdfDecoder.highlightColor);
                graphics2D.fill(rectangle);
                if (PdfDecoder.backgroundColor == null) {
                    graphics2D.setPaint(new Color(255 - color2.getRed(), 255 - color2.getGreen(), 255 - color2.getBlue()));
                } else {
                    graphics2D.setPaint(PdfDecoder.backgroundColor);
                }
            }
            if ((n & 2) == 2) {
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
                if (rectangle == null) {
                    graphics2D.setPaint(pdfPaint2);
                }
                if (f2 != 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(2, f2));
                }
                pdfGlyph.render(2, graphics2D, this.scaling);
                graphics2D.setComposite(composite);
            }
            if ((n & 1) == 1) {
                if (pdfPaint != null) {
                    pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
                }
                if (rectangle == null) {
                    graphics2D.setPaint(pdfPaint);
                }
                if (f != 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                }
                try {
                    pdfGlyph.render(1, graphics2D, this.scaling);
                }
                catch (Exception exception) {
                    System.out.println("Exception " + exception + " rendering glyph");
                    exception.printStackTrace();
                }
                graphics2D.setComposite(composite);
            }
            graphics2D.setTransform(affineTransform2);
            if (rectangle != null) {
                graphics2D.setPaint(color2);
            }
            if (n3 != 0) {
                graphics2D.setStroke(stroke);
            }
        }
    }

    public final void renderImage(AffineTransform affineTransform, BufferedImage bufferedImage, float f, GraphicsState graphicsState, Graphics2D graphics2D, float f2, float f3, int n) {
        Object object;
        Object object2;
        float f4;
        Object object3;
        int n2;
        boolean bl;
        boolean bl2 = bl = graphicsState != null;
        if (bufferedImage == null) {
            return;
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (bl) {
            int n5 = (int)graphicsState.CTM[0][0];
            if (n5 < 0) {
                n5 = -n5;
            }
            if (n5 == 0) {
                n5 = (int)graphicsState.CTM[0][1];
            }
            if (n5 < 0) {
                n5 = -n5;
            }
            if ((n2 = (int)graphicsState.CTM[1][1]) < 0) {
                n2 = -n2;
            }
            if (n2 == 0) {
                n2 = (int)graphicsState.CTM[1][0];
            }
            if (n2 < 0) {
                n2 = -n2;
            }
            this.areas.addElement(new Rectangle((int)graphicsState.CTM[2][0], (int)graphicsState.CTM[2][1], n5, n2));
        }
        AffineTransform affineTransform2 = new AffineTransform();
        n2 = 0;
        float[][] fArray = new float[3][3];
        if (graphicsState != null) {
            fArray = graphicsState.CTM;
        }
        AffineTransform affineTransform3 = graphics2D.getTransform();
        boolean bl3 = false;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (bl || this.useHiResImageForDisplay) {
            if (bl) {
                affineTransform2 = null;
                if ((n & 1) != 1) {
                    Object object4;
                    if (!this.optimisedTurnCode) {
                        bufferedImage = this.invertImage(fArray, bufferedImage);
                    } else if (fArray[0][1] < 0.0f || fArray[1][0] < 0.0f) {
                        object4 = new float[][]{{1.0f / (float)n3, 0.0f, 0.0f}, {0.0f, -1.0f / (float)n4, 0.0f}, {0.0f, 1.0f / (float)n4, 1.0f}};
                        object3 = new float[][]{{fArray[0][0], fArray[0][1], 0.0f}, {fArray[1][0], fArray[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                        object4 = Matrix.multiply(object4, (float[][])object3);
                        affineTransform2 = new AffineTransform(object4[0][0], object4[1][0], object4[0][1], object4[1][1], object4[2][0], object4[2][1]);
                        f5 = fArray[2][0] - (float)bufferedImage.getHeight() * object4[0][1];
                        f6 = fArray[2][1];
                        if (fArray[1][1] != 0.0f) {
                            f6 += fArray[1][1];
                        }
                    } else if (fArray[0][0] * fArray[0][1] == 0.0f && fArray[1][1] * fArray[1][0] == 0.0f && fArray[0][1] > 0.0f && fArray[1][0] > 0.0f) {
                        object4 = new float[][]{{-1.0f / (float)n3, 0.0f, 0.0f}, {0.0f, 1.0f / (float)n4, 0.0f}, {1.0f / (float)n3, 0.0f, 1.0f}};
                        object3 = new float[][]{{fArray[0][0], fArray[0][1], 0.0f}, {fArray[1][0], fArray[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                        object4 = Matrix.multiply(object4, (float[][])object3);
                        affineTransform2 = new AffineTransform(object4[0][0], object4[1][0], object4[0][1], object4[1][1], object4[2][0], object4[2][1]);
                        f5 = fArray[2][0] - (float)bufferedImage.getHeight() * object4[0][1];
                        f6 = fArray[2][1];
                    } else if (fArray[1][1] != 0.0f) {
                        bl3 = true;
                    }
                }
                if (affineTransform2 == null) {
                    affineTransform2 = new AffineTransform(fArray[0][0] / (float)n3, fArray[0][1] / (float)n3, fArray[1][0] / (float)n4, fArray[1][1] / (float)n4, fArray[2][0], fArray[2][1]);
                }
            } else {
                affineTransform2 = affineTransform;
                bl3 = (n & 4) == 4;
            }
            n2 = 1;
        } else if (n4 > 1 && (f4 = (float)PdfDecoder.dpi) != 72.0f) {
            affineTransform2.scale(72.0f / f4, 72.0f / f4);
            affineTransform2.translate(0.0, (float)n4 * (f4 / 72.0f - 1.0f));
            n2 = 1;
        }
        Composite composite = graphics2D.getComposite();
        object3 = graphics2D.getClip();
        if (this.colorsLocked) {
            object2 = new int[4];
            int n6 = this.fillCol.getRGB();
            object2[0] = n6 >> 16 & 0xFF;
            object2[1] = n6 >> 8 & 0xFF;
            object2[2] = n6 & 0xFF;
            object2[3] = 255;
            if (object2[0] != 0 || object2[1] != 0 || object2[2] != 0) {
                object = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
                WritableRaster writableRaster = bufferedImage.getRaster();
                WritableRaster writableRaster2 = ((BufferedImage)object).getRaster();
                for (int i = 0; i < bufferedImage.getHeight(); ++i) {
                    for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                        int[] nArray = new int[4];
                        writableRaster.getPixel(j, i, nArray);
                        if (nArray[3] <= 2) continue;
                        writableRaster2.setPixel(j, i, (int[])object2);
                    }
                }
                bufferedImage = object;
            }
        }
        if (bl || this.useHiResImageForDisplay) {
            try {
                boolean bl4;
                if (this.optimisedTurnCode && bl3 && (n & 1) != 1) {
                    object2 = new double[6];
                    affineTransform2.getMatrix((double[])object2);
                    f5 = object2[4];
                    f6 = object2[5] + (double)bufferedImage.getHeight() * object2[3];
                    object2[3] = -object2[3];
                    object2[4] = (int)0.0;
                    object2[5] = (int)0.0;
                    affineTransform2 = new AffineTransform((double[])object2);
                }
                boolean bl5 = bl4 = this.customImageHandler != null;
                if (bl4) {
                    bl4 = this.customImageHandler.drawImageOnscreen(bufferedImage, n, affineTransform2, this.currentImageFile, graphics2D, bl, this.objectStoreRef, this.isPrinting);
                }
                if (bl4) {
                    graphics2D.setComposite(composite);
                    return;
                }
                graphics2D.translate(f5, f6);
                graphics2D.drawImage(bufferedImage, affineTransform2, null);
            }
            catch (Exception exception) {}
        } else {
            try {
                if (n2 != 0) {
                    object2 = new AffineTransformOp(affineTransform2, ColorSpaces.hints);
                    bufferedImage = ((AffineTransformOp)object2).filter(bufferedImage, null);
                }
                graphics2D.translate(f2, f3);
                if (this.optimisedTurnCode && (n & 4) == 4) {
                    object2 = new AffineTransform();
                    float[] fArray2 = new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, bufferedImage.getHeight()};
                    object = new AffineTransform(fArray2);
                    if (this.rotation == 0) {
                        object2 = new AffineTransform(fArray2);
                    } else if (this.rotation == 90) {
                        object2 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object2).rotate(Math.PI, 0.0, 0.0);
                        } else {
                            ((AffineTransform)object2).rotate(1.5707963267948966, 0.0, 0.0);
                        }
                        ((AffineTransform)object2).translate(-bufferedImage.getWidth(), -bufferedImage.getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, bufferedImage.getWidth(), 0.0f};
                        object = new AffineTransform(fArray2);
                        ((AffineTransform)object2).concatenate((AffineTransform)object);
                    } else if (this.rotation == 180) {
                        object2 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object2).rotate(Math.PI, 0.0, 0.0);
                        }
                        ((AffineTransform)object2).translate(-bufferedImage.getWidth(), -bufferedImage.getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, bufferedImage.getWidth(), 0.0f};
                        object = new AffineTransform(fArray2);
                        ((AffineTransform)object2).concatenate((AffineTransform)object);
                    } else {
                        object2 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object2).rotate(Math.PI, 0.0, 0.0);
                        } else {
                            ((AffineTransform)object2).rotate(4.71238898038469, 0.0, 0.0);
                        }
                        ((AffineTransform)object2).translate(-bufferedImage.getWidth(), -bufferedImage.getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, bufferedImage.getWidth(), 0.0f};
                        object = new AffineTransform(fArray2);
                        ((AffineTransform)object2).concatenate((AffineTransform)object);
                    }
                    graphics2D.drawImage(bufferedImage, (AffineTransform)object2, null);
                } else {
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                }
                graphics2D.translate(-f2, -f3);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                error.printStackTrace();
                System.gc();
            }
        }
        graphics2D.setTransform(affineTransform3);
        if (PdfDecoder.isRunningOnMac && object3 != null) {
            graphics2D.setClip((Shape)object3);
        }
        graphics2D.setComposite(composite);
    }

    public final void renderShape(Shape shape, int n, PdfPaint pdfPaint, PdfPaint pdfPaint2, Stroke stroke, Shape shape2, Graphics2D graphics2D, float f, float f2) {
        Composite composite = graphics2D.getComposite();
        if (n == 2 || n == 3) {
            pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
            graphics2D.setPaint(pdfPaint2);
            if (f2 != 1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
            }
            graphics2D.fill(shape2);
            graphics2D.setComposite(composite);
        }
        if (n == 1 || n == 3) {
            Shape shape3;
            Stroke stroke2 = graphics2D.getStroke();
            if (shape2.getBounds2D().getWidth() < 1.0 && ((BasicStroke)stroke).getLineWidth() > 10.0f) {
                graphics2D.setStroke(new BasicStroke(1.0f));
            } else {
                graphics2D.setStroke(stroke);
            }
            pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
            graphics2D.setPaint(pdfPaint);
            if (f != 1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            if ((shape3 = graphics2D.getClip()) != null && (shape3.getBounds2D().getHeight() < 1.0 || shape3.getBounds2D().getWidth() < 1.0)) {
                graphics2D.setClip(shape);
            }
            graphics2D.draw(shape2);
            graphics2D.setClip(shape3);
            graphics2D.setStroke(stroke2);
            graphics2D.setComposite(composite);
        }
    }

    public void flush() {
        this.singleImage = null;
        this.imageCount = 0;
        this.lastFS = -1;
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[this.defaultSize];
            this.y_coord = new float[this.defaultSize];
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            if (this.TRvalues != null) {
                this.TRvalues.clear();
            }
            if (this.imageOptions != null) {
                this.imageOptions.clear();
            }
            if (this.fs != null) {
                this.fs.clear();
            }
            if (this.lw != null) {
                this.lw.clear();
            }
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            this.fontBounds.clear();
            if (this.opacity != null) {
                this.opacity.clear();
            }
            if (this.isPrinting) {
                this.largeImages.clear();
            }
            this.endItem = -1;
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.fillSet = false;
        this.strokeSet = false;
        this.fonts.clear();
        this.fontsUsed.clear();
        this.imageID.clear();
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.lastScaling = 0.0f;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            this.addBackground = false;
        } else {
            this.backgroundColor = color;
        }
    }

    public void paint(Graphics2D graphics2D, Rectangle[] rectangleArray, int n, int n2) {
        this.xx = n < 0 ? n : 0;
        this.yy = n2 < 0 ? n2 : 0;
        this.paint(graphics2D, rectangleArray, null, null, false, false);
    }

    public void setInset(int n, int n2) {
        this.xx = n;
        this.yy = n2;
    }

    public Rectangle paint(Graphics2D graphics2D, Rectangle[] rectangleArray, AffineTransform affineTransform, Rectangle rectangle, boolean bl, boolean bl2) {
        Shape shape;
        int n = ++this.paintThreadID;
        if (bl2) {
            ++this.paintThreadCount;
        }
        if (bl2 && this.paintThreadCount > 1) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (n != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
        }
        int n2 = 0;
        String string = "";
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Rectangle rectangle2 = null;
        int[] nArray = this.objectType.get();
        int[] nArray2 = this.textFillType.get();
        int n3 = this.currentItem;
        Area[] areaArray = this.clips.get();
        double[] dArray = this.af1.get();
        int[] nArray3 = null;
        if (this.fs != null) {
            nArray3 = this.fs.get();
        }
        Rectangle[] rectangleArray2 = this.fontBounds.get();
        int[] nArray4 = null;
        if (this.lw != null) {
            nArray4 = this.lw.get();
        }
        double[] dArray2 = this.af2.get();
        double[] dArray3 = this.af3.get();
        double[] dArray4 = this.af4.get();
        Object[] objectArray = this.text_color.get();
        Object[] objectArray2 = this.fill_color.get();
        Object[] objectArray3 = this.stroke_color.get();
        Object[] objectArray4 = this.pageObjects.get();
        Object[] objectArray5 = this.javaObjects.get();
        Object[] objectArray6 = this.stroke.get();
        int[] nArray5 = this.shapeType.get();
        float[] fArray = null;
        if (this.opacity != null) {
            fArray = this.opacity.get();
        }
        int[] nArray6 = null;
        if (this.TRvalues != null) {
            nArray6 = this.TRvalues.get();
        }
        int[] nArray7 = null;
        if (this.imageOptions != null) {
            nArray7 = this.imageOptions.get();
        }
        if ((shape = graphics2D.getClip()) != null) {
            rectangle2 = shape.getBounds();
        }
        boolean bl3 = false;
        Shape shape2 = graphics2D.getClip();
        Area area = null;
        boolean bl4 = false;
        if (!bl && this.lastItemPainted == -1) {
            this.paintBackground(graphics2D, rectangle2);
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
            shape2 = graphics2D.getClip();
        }
        this.minX = -1.0;
        this.minY = -1.0;
        this.maxX = -1.0;
        this.maxY = -1.0;
        Object object = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        int n7 = 0;
        float f5 = 1.0f;
        float f6 = 1.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = -1;
        int n12 = 0;
        int n13 = -1;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        PdfPaint pdfPaint = null;
        PdfPaint pdfPaint2 = null;
        PdfPaint pdfPaint3 = null;
        PdfPaint pdfPaint4 = null;
        Stroke stroke = null;
        if (this.colorsLocked) {
            pdfPaint4 = this.strokeCol;
            pdfPaint3 = this.fillCol;
        }
        if (this.highlightsNeedToBeGenerated && this.areas != null && rectangleArray != null) {
            this.generateHighlights(graphics2D, n3, nArray, objectArray4, f, f2, f3, f4, dArray, dArray2, dArray3, dArray4, nArray3, rectangleArray2);
        }
        block39: for (int i = 0; i < n3; ++i) {
            int n21;
            boolean bl5 = false;
            n4 = nArray[i];
            Rectangle rectangle3 = null;
            if (bl2 && n != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
            if (n4 <= 0) continue;
            f7 = this.x_coord[i];
            f8 = this.y_coord[i];
            object = objectArray4[i];
            if (rectangle3 == null) {
                if (dArray != null && n4 == 3) {
                    BufferedImage bufferedImage = (BufferedImage)objectArray4[i];
                    if (bufferedImage != null) {
                        rectangle3 = new Rectangle((int)f7, (int)f8, bufferedImage.getWidth(), bufferedImage.getHeight());
                    }
                } else if (dArray != null && n4 == 2) {
                    rectangle3 = ((Shape)objectArray4[i]).getBounds();
                } else if (n4 == 1 && n13 > -1) {
                    int n22 = ((Area)object).getBounds().x;
                    n21 = ((Area)object).getBounds().y;
                    rectangle3 = this.getAreaForGlyph(new float[][]{{(float)dArray[n13], (float)dArray2[n13], 0.0f}, {(float)dArray3[n13], (float)dArray4[n13], 0.0f}, {n22, n21, 1.0f}});
                } else if (n11 != -1 && dArray != null) {
                    rectangle3 = new Rectangle((int)f7, (int)f8, nArray3[n11], nArray3[n11]);
                }
            }
            bl5 = false;
            if (n4 < 7 && rectangle != null && rectangle3 != null && !rectangle.intersects(rectangle3)) {
                bl5 = true;
            } else if (this.optimiseDrawing && this.rotation == 0 && rectangle2 != null && n4 != 17 && n4 != 18 && n4 != 7 && rectangle3 != null && !rectangle2.intersects(rectangle3)) {
                bl5 = true;
            }
            if (bl5 || this.lastItemPainted != -1 && i < this.lastItemPainted) {
                switch (n4) {
                    case 2: {
                        ++n10;
                        break;
                    }
                    case 3: {
                        ++n8;
                        break;
                    }
                    case 7: {
                        ++n9;
                        break;
                    }
                    case 21: {
                        ++n11;
                        break;
                    }
                    case 22: {
                        ++n12;
                        break;
                    }
                    case 10: {
                        ++n14;
                        break;
                    }
                    case 11: {
                        ++n16;
                        break;
                    }
                    case 12: {
                        ++n17;
                        break;
                    }
                    case 14: {
                        ++n15;
                        break;
                    }
                    case 15: {
                        ++n18;
                    }
                }
                continue;
            }
            if (!bl3) {
                graphics2D.setRenderingHints(hints);
                bl3 = true;
            }
            ++n2;
            switch (n4) {
                case 2: {
                    if (!bl) {
                        if (bl4) {
                            this.renderClip(area, rectangle2, shape2, graphics2D);
                            bl4 = false;
                        }
                        this.renderShape(shape2, nArray5[n10], pdfPaint4, pdfPaint3, stroke, (Shape)object, graphics2D, f6, f5);
                    }
                    ++n10;
                    continue block39;
                }
                case 1: {
                    if (bl4) {
                        this.renderClip(area, rectangle2, shape2, graphics2D);
                        bl4 = false;
                    }
                    if (bl && this.textHighlightsX == null) continue block39;
                    this.renderText(f7, f8, n6, (Area)object, graphics2D, this.setHighlightForGlyph(rectangle3, nArray, rectangleArray, i), pdfPaint, pdfPaint2, f6, f5);
                    continue block39;
                }
                case 4: {
                    if (bl4) {
                        this.renderClip(area, rectangle2, shape2, graphics2D);
                        bl4 = false;
                    }
                    this.aff = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f7, (double)f8);
                    if (bl && this.textHighlightsX == null) continue block39;
                    this.renderEmbeddedText(null, n6, object, 4, graphics2D, this.aff, this.setHighlightForGlyph(rectangle3, nArray, rectangleArray, i), pdfPaint, pdfPaint2, f6, f5, rectangle3, n7);
                    continue block39;
                }
                case 5: {
                    if (bl4) {
                        this.renderClip(area, rectangle2, shape2, graphics2D);
                        bl4 = false;
                    }
                    this.aff = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f7, (double)f8);
                    if (bl && this.textHighlightsX == null) continue block39;
                    this.renderEmbeddedText(null, n6, object, 5, graphics2D, this.aff, this.setHighlightForGlyph(rectangle3, nArray, rectangleArray, i), pdfPaint, pdfPaint2, f6, f5, rectangle3, n7);
                    continue block39;
                }
                case 6: {
                    if (bl4) {
                        this.renderClip(area, rectangle2, shape2, graphics2D);
                        bl4 = false;
                    }
                    this.aff = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f7, (double)f8);
                    if (bl && this.textHighlightsX == null) continue block39;
                    this.renderEmbeddedText(null, n6, object, 6, graphics2D, this.aff, this.setHighlightForGlyph(rectangle3, nArray, rectangleArray, i), pdfPaint, pdfPaint2, f6, f5, rectangle3, n7);
                    continue block39;
                }
                case 3: {
                    int n23 = 1;
                    n21 = 0;
                    if (nArray7 != null) {
                        n21 = nArray7[n8];
                    }
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = 0;
                    int n27 = 0;
                    int n28 = 1;
                    Integer n29 = new Integer(this.pageNumber);
                    Integer n30 = new Integer(n8);
                    String string2 = n29.toString() + n30.toString();
                    if (!this.isType3Font) {
                        if (ObjectStore.isRawImageDataSaved(string2) && this.useHiResImageForDisplay) {
                            float f9 = this.scaling;
                            if (this.useHiResImageForDisplay && this.scaling < 1.0f) {
                                f9 = 1.0f;
                            }
                            int n31 = (Integer)this.getObjectStore().getRawImageDataParameter(string2, ObjectStore.IMAGE_pX);
                            n26 = (int)((float)n31 * f9);
                            int n32 = (Integer)this.getObjectStore().getRawImageDataParameter(string2, ObjectStore.IMAGE_pY);
                            n27 = (int)((float)n32 * f9);
                            n24 = (Integer)this.getObjectStore().getRawImageDataParameter(string2, ObjectStore.IMAGE_WIDTH);
                            n25 = (Integer)this.getObjectStore().getRawImageDataParameter(string2, ObjectStore.IMAGE_HEIGHT);
                            if (n26 > 0) {
                                int n33;
                                int n34;
                                int n35;
                                int n36 = n24;
                                int n37 = n27 << 2;
                                int n38 = n26 << 2;
                                for (n35 = n25; n36 > n38 && n35 > n37; n36 >>= 1, n35 >>= 1) {
                                    n23 <<= 1;
                                }
                                int n39 = n24 / n26;
                                if (n39 < 1) {
                                    n39 = 1;
                                }
                                if ((n34 = n25 / n27) < 1) {
                                    n34 = 1;
                                }
                                if ((n23 = n39) > n34) {
                                    n23 = n34;
                                }
                                int n40 = n24;
                                int n41 = n27 << 2;
                                int n42 = n26 << 2;
                                for (int j = n25; n40 > n42 && j > n41; n40 >>= 1, j >>= 1) {
                                    n28 <<= 1;
                                }
                                int n43 = n24 / n31;
                                if (n43 < 1) {
                                    n43 = 1;
                                }
                                if ((n33 = n25 / n32) < 1) {
                                    n33 = 1;
                                }
                                if ((n28 = n43) > n33) {
                                    n28 = n33;
                                }
                                if ((this.scaling > 1.0f || this.lastScaling > 1.0f) && n23 >= 1 && this.lastScaling != this.scaling) {
                                    n36 = n24 / n23;
                                    n35 = n25 / n23;
                                    this.getObjectStore();
                                    byte[] byArray = ObjectStore.getRawImageData(string2);
                                    byte[] byArray2 = null;
                                    int n44 = n36 * n35;
                                    byte[] byArray3 = new byte[n44];
                                    int[] nArray8 = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
                                    int n45 = n24 + 7 >> 3;
                                    if (!this.useHiResImageForDisplay) {
                                        byArray = ImageOps.invertImage(byArray, n24, n25, 1, 1, byArray2);
                                    }
                                    for (int j = 0; j < n35; ++j) {
                                        for (int k = 0; k < n36; ++k) {
                                            int n46 = 0;
                                            int n47 = 0;
                                            int n48 = n23;
                                            int n49 = n23;
                                            int n50 = n24 - k;
                                            int n51 = n25 - j;
                                            if (n48 > n50) {
                                                n48 = n50;
                                            }
                                            if (n49 > n51) {
                                                n49 = n51;
                                            }
                                            for (int i2 = 0; i2 < n49; ++i2) {
                                                for (int i3 = 0; i3 < n48; ++i3) {
                                                    byte by = byArray[(i2 + j * n23) * n45 + (k * n23 + i3 >> 3)];
                                                    int n52 = by & nArray8[7 - (k * n23 + i3 & 7)];
                                                    if (n52 != 0) {
                                                        ++n46;
                                                    }
                                                    ++n47;
                                                }
                                            }
                                            if (n47 > 0) {
                                                if (byArray2 == null) {
                                                    byArray3[k + n36 * j] = (byte)(255 * n46 / n47);
                                                    continue;
                                                }
                                                byArray3[k + n36 * j] = (byte)((byArray2[1] & 0xFF) * n46 / n47);
                                                continue;
                                            }
                                            byArray3[k + n36 * j] = byArray2 == null ? -1 : byArray2[0];
                                        }
                                    }
                                    int[] nArray9 = new int[]{0};
                                    WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray3, byArray3.length), n36, n35, n36, 1, nArray9, null);
                                    BufferedImage bufferedImage = new BufferedImage(n36, n35, 10);
                                    bufferedImage.setData(writableRaster);
                                    if (this.singleImage != null) {
                                        this.singleImage = bufferedImage;
                                    }
                                    objectArray4[i] = bufferedImage;
                                    object = bufferedImage;
                                }
                            }
                        }
                    }
                    if (!bl) {
                        if (bl4) {
                            this.renderClip(area, rectangle2, shape2, graphics2D);
                            bl4 = false;
                        }
                        if (this.useHiResImageForDisplay) {
                            AffineTransform affineTransform3 = null;
                            if (n23 >= 1 && this.scaling > 1.0f && n24 > 0) {
                                double d = (float)n23 / (float)n28;
                                affineTransform3 = this.aff = new AffineTransform(dArray[n13] * d, dArray2[n13] * d, dArray3[n13] * d, dArray4[n13] * d, (double)f7, (double)f8);
                            } else {
                                affineTransform3 = this.aff = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f7, (double)f8);
                            }
                            BufferedImage bufferedImage = null;
                            if (object != null) {
                                bufferedImage = (BufferedImage)object;
                            }
                            if (object == null) {
                                try {
                                    object = this.singleImage != null ? this.singleImage.getSubimage(0, 0, this.singleImage.getWidth(), this.singleImage.getHeight()) : (this.rawKey == null ? this.largeImages.get("HIRES_" + i) : this.largeImages.get("HIRES_" + i + '_' + this.rawKey));
                                    if (object == null) {
                                        object = this.rawKey == null ? this.objectStoreRef.loadStoredImage(this.pageNumber + "_HIRES_" + i) : this.objectStoreRef.loadStoredImage(this.pageNumber + "_HIRES_" + i + '_' + this.rawKey);
                                        if (object == null) {
                                            this.renderFailed = true;
                                        }
                                        if (!this.isPrinting && this.displayMode == 1) {
                                            if (this.rawKey == null) {
                                                this.largeImages.put("HIRES_" + i, object);
                                            } else {
                                                this.largeImages.put("HIRES_" + i, object + "_" + this.rawKey);
                                            }
                                        }
                                    }
                                    bufferedImage = (BufferedImage)object;
                                    if (PdfDecoder.isRunningOnMac && bufferedImage != null && bufferedImage.getType() == 0) {
                                        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            if (bufferedImage != null) {
                                this.renderImage(affineTransform3, bufferedImage, f5, null, graphics2D, f7, f8, n21);
                            }
                        } else {
                            AffineTransform affineTransform4 = graphics2D.getTransform();
                            this.extraRot = false;
                            if (n27 > 0) {
                                double d;
                                double[] dArray5 = new double[6];
                                graphics2D.getTransform().getMatrix(dArray5);
                                dArray5[0] = d = (double)((float)n27 / (float)((BufferedImage)object).getHeight());
                                dArray5[1] = 0.0;
                                dArray5[2] = 0.0;
                                dArray5[3] = -d;
                                graphics2D.scale(1.0f / this.scaling, 1.0f / this.scaling);
                                graphics2D.setTransform(new AffineTransform(dArray5));
                            } else {
                                this.extraRot = true;
                            }
                            this.renderImage(null, (BufferedImage)object, f5, null, graphics2D, f7, f8, n21);
                            graphics2D.setTransform(affineTransform4);
                        }
                    }
                    ++n8;
                    continue block39;
                }
                case 7: {
                    area = areaArray[n9];
                    bl4 = true;
                    ++n9;
                    continue block39;
                }
                case 9: {
                    ++n13;
                    continue block39;
                }
                case 21: {
                    ++n11;
                    continue block39;
                }
                case 22: {
                    n7 = nArray4[n12];
                    ++n12;
                    continue block39;
                }
                case 10: {
                    n5 = nArray2[n14];
                    if (n5 == 1) {
                        pdfPaint = (PdfPaint)objectArray[n14];
                    } else {
                        pdfPaint2 = (PdfPaint)objectArray[n14];
                    }
                    ++n14;
                    continue block39;
                }
                case 11: {
                    if (!this.colorsLocked) {
                        pdfPaint3 = (PdfPaint)objectArray2[n16];
                    }
                    ++n16;
                    continue block39;
                }
                case 12: {
                    if (!this.colorsLocked && (pdfPaint4 = (PdfPaint)objectArray3[n17]) != null) {
                        pdfPaint4.setScaling(this.cropX, this.cropH, this.scaling);
                    }
                    ++n17;
                    continue block39;
                }
                case 14: {
                    stroke = (Stroke)objectArray6[n15];
                    ++n15;
                    continue block39;
                }
                case 15: {
                    n6 = nArray6[n18];
                    ++n18;
                    continue block39;
                }
                case 17: {
                    f6 = fArray[n19];
                    ++n19;
                    continue block39;
                }
                case 18: {
                    f5 = fArray[n19];
                    ++n19;
                    continue block39;
                }
                case 16: {
                    if (bl) continue block39;
                    try {
                        Shape shape3 = graphics2D.getClip();
                        graphics2D.setClip(shape2);
                        AffineTransform affineTransform5 = graphics2D.getTransform();
                        String string3 = (String)object;
                        double[] dArray6 = new double[6];
                        graphics2D.getTransform().getMatrix(dArray6);
                        if (dArray6[2] != 0.0) {
                            dArray6[2] = -dArray6[2];
                        }
                        if (dArray6[3] != 0.0) {
                            dArray6[3] = -dArray6[3];
                        }
                        graphics2D.setTransform(new AffineTransform(dArray6));
                        Font font = (Font)objectArray5[n20];
                        graphics2D.setFont(font);
                        if ((n6 & 2) == 2) {
                            if (pdfPaint2 != null) {
                                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling);
                            }
                            graphics2D.setPaint(pdfPaint2);
                        }
                        if ((n6 & 1) == 1) {
                            if (pdfPaint != null) {
                                pdfPaint.setScaling(this.cropX, this.cropH, this.scaling);
                            }
                            graphics2D.setPaint(pdfPaint);
                        }
                        graphics2D.drawString(string3, f7, f8);
                        graphics2D.setClip(null);
                        graphics2D.setTransform(affineTransform5);
                        ++n20;
                    }
                    catch (Exception exception) {
                        System.err.println(object + "<>" + i);
                        exception.printStackTrace();
                        System.exit(1);
                    }
                    continue block39;
                }
                case 23: {
                    Shape shape4 = graphics2D.getClip();
                    graphics2D.setClip(shape2);
                    AffineTransform affineTransform6 = graphics2D.getTransform();
                    JPedalCustomDrawObject jPedalCustomDrawObject = (JPedalCustomDrawObject)object;
                    if (this.isPrinting) {
                        jPedalCustomDrawObject.print(graphics2D, this.printPage);
                    } else {
                        jPedalCustomDrawObject.paint(graphics2D);
                    }
                    graphics2D.setTransform(affineTransform6);
                    graphics2D.setClip(null);
                }
            }
        }
        graphics2D.setClip(shape2);
        graphics2D.setTransform(affineTransform2);
        if (debugPaint) {
            System.err.println("Painted " + n2);
        }
        if (this.frame != null && this.renderFailed && !userAlerted) {
            userAlerted = true;
            if (PdfDecoder.showErrorMessages) {
                String string4 = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                JOptionPane.showMessageDialog(this.frame, string4);
                this.frame.invalidate();
                this.frame.repaint();
            }
        }
        if (bl2) {
            --this.paintThreadCount;
        }
        this.lastItemPainted = this.optimsePainting ? n3 : -1;
        this.lastScaling = this.scaling;
        if (this.minX == -1.0) {
            return null;
        }
        return new Rectangle((int)this.minX, (int)this.minY, (int)(this.maxX - this.minX), (int)(this.maxY - this.minY));
    }

    private Rectangle getAreaForGlyph(float[][] fArray) {
        int n = (int)Math.sqrt(fArray[0][0] * fArray[0][0] + fArray[1][0] * fArray[1][0]);
        int n2 = (int)Math.sqrt(fArray[1][1] * fArray[1][1] + fArray[0][1] * fArray[0][1]);
        return new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n2);
    }

    public void setMessageFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void paintBackground(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.addBackground) {
            graphics2D.setColor(this.backgroundColor);
            if (rectangle == null) {
                graphics2D.fill(new Rectangle(this.xx, this.yy, (int)((float)this.w * this.scaling), (int)((float)this.h * this.scaling)));
            } else {
                graphics2D.fill(rectangle);
            }
        }
    }

    public void renderClip(Area area, Rectangle rectangle, Shape shape, Graphics2D graphics2D) {
        if (area != null) {
            graphics2D.setClip(area);
            if (rectangle != null) {
                graphics2D.clip(rectangle);
            }
        } else {
            graphics2D.setClip(shape);
        }
    }

    private Rectangle setHighlightForGlyph(Rectangle rectangle, int[] nArray, Rectangle[] rectangleArray, int n) {
        boolean bl = false;
        if (rectangleArray == null || this.textHighlightsX == null) {
            return null;
        }
        int n2 = rectangleArray.length;
        int n3 = nArray[n];
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = n3 == 1;
            if (rectangle == null || !bl2 && n3 != 4 && n3 != 5 && n3 != 6 || rectangleArray[i] == null) continue;
            Rectangle rectangle2 = rectangleArray[i].intersection(rectangle);
            boolean bl4 = false;
            if (bl2 && rectangleArray[i].getMinX() <= rectangle.getMinX() + (double)rectangle.width / 3.0 && rectangleArray[i].getMinY() <= rectangle.getMinY() + (double)rectangle.height / 3.0) {
                bl4 = true;
            } else if (rectangleArray[i].getMinX() <= rectangle.getMinX() && rectangleArray[i].getMinY() <= rectangle.getMinY()) {
                bl4 = true;
            }
            if (!bl4 || !((double)rectangle2.height >= (double)rectangle.height / 2.0) || rectangle2.width < 1) continue;
            i = n2;
            bl = true;
            Rectangle2D rectangle2D = rectangle.getBounds2D();
            if (this.minX == -1.0) {
                this.minX = rectangle2D.getMinX();
                this.minY = rectangle2D.getMinY();
                this.maxX = rectangle2D.getMaxX();
                this.maxY = rectangle2D.getMaxY();
                continue;
            }
            double d = rectangle2D.getMinX();
            if (d < this.minX) {
                this.minX = d;
            }
            if ((d = rectangle2D.getMinY()) < this.minY) {
                this.minY = d;
            }
            if ((d = rectangle2D.getMaxX()) > this.maxX) {
                this.maxX = d;
            }
            if (!((d = rectangle2D.getMaxY()) > this.maxY)) continue;
            this.maxY = d;
        }
        if (bl) {
            return new Rectangle(this.textHighlightsX[n], this.textHighlightsY[n], this.textHighlightsWidth[n], this.textHighlightsHeight[n]);
        }
        return null;
    }

    public final void drawText(float[][] fArray, int n, Object object, GraphicsState graphicsState) {
        int n2;
        int n3;
        double[] dArray;
        PdfPaint pdfPaint = null;
        if (fArray != null && (this.lastAf[0] != (dArray = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3])) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        if (((n3 = graphicsState.getTextRenderType()) & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n2 = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n2) {
                    this.lastFillTextCol = n2;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n3 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n2 = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n2) {
                    this.lastStrokeCol = n2;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        if (object instanceof Area) {
            this.drawFontSize(n);
            this.pageObjects.addElement(object);
            this.areas.addElement(((Area)object).getBounds());
            this.checkWidth(((Area)object).getBounds());
            this.objectType.addElement(1);
        } else {
            this.pageObjects.addElement(object);
            this.areas.addElement(null);
            this.objectType.addElement(-1);
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = fArray[2][0];
        this.y_coord[this.currentItem] = fArray[2][1];
        ++this.currentItem;
        this.resetTextColors = false;
    }

    public final void drawText(float[][] fArray, String string, GraphicsState graphicsState, float f, float f2, Font font) {
        int n;
        int n2;
        double[] dArray;
        PdfPaint pdfPaint = null;
        if (fArray != null && (this.lastAf[0] != (dArray = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3])) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        if (((n2 = graphicsState.getTextRenderType()) & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n) {
                    this.lastFillTextCol = n;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n2 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.pageObjects.addElement(string);
        this.javaObjects.addElement(font);
        this.objectType.addElement(16);
        this.areas.addElement(null);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    private float[] checkSize(float[] fArray, int n) {
        int n2 = fArray.length;
        if (n2 <= n) {
            int n3 = n2 * 2;
            float[] fArray2 = new float[n3];
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            fArray = fArray2;
        }
        return fArray;
    }

    public Rectangle getCombinedAreas(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = null;
        if (this.areas != null) {
            Rectangle rectangle3 = rectangle.getBounds();
            int n = rectangle3.x;
            int n2 = rectangle3.y;
            int n3 = n + rectangle3.width;
            int n4 = n2 + rectangle3.height;
            boolean bl2 = false;
            Rectangle[] rectangleArray = this.areas.get();
            int n5 = rectangleArray.length;
            for (int i = 0; i < n5; ++i) {
                int n6;
                if (rectangleArray[i] == null || !rectangle.contains(rectangleArray[i])) continue;
                bl2 = true;
                int n7 = rectangleArray[i].x;
                if (n3 > n7) {
                    n3 = n7;
                }
                if (n < (n7 = rectangleArray[i].x + rectangleArray[i].width)) {
                    n = n7;
                }
                if (n4 > (n6 = rectangleArray[i].y)) {
                    n4 = n6;
                }
                if (n2 >= (n6 = rectangleArray[i].y + rectangleArray[i].height)) continue;
                n2 = n6;
            }
            if (bl2) {
                rectangle2 = new Rectangle(n3 - 1, n4 + 1, n - n3 + 2, n2 - n4 + 2);
            }
        }
        return rectangle2;
    }

    public final void init(int n, int n2, int n3) {
        this.w = n;
        this.h = n2;
        this.rotation = n3;
    }

    public final BufferedImage getPageAsImage(float f, int n, int n2, int n3, int n4, int n5, AffineTransform affineTransform, int n6) {
        if (n3 < 0) {
            n3 = this.w;
            n4 = this.h;
        } else {
            n3 = (int)((float)n3 * f);
            n4 = (int)((float)n4 * f);
        }
        this.lastItemPainted = -1;
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (n6 == 1) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n3, n4);
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        this.paint(graphics2D, null, n, n2);
        graphics2D.setTransform(affineTransform2);
        return bufferedImage;
    }

    public static final boolean isRotated(float[][] fArray) {
        return fArray[0][0] == 0.0f && fArray[1][1] == 0.0f;
    }

    public final void drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2) {
        int n3;
        this.pageNumber = n;
        float[][] fArray = graphicsState.CTM;
        float f = graphicsState.x;
        float f2 = graphicsState.y;
        String string2 = this.rawKey == null ? n + "_" + (this.currentItem + 1) : this.rawKey + '_' + (this.currentItem + 1);
        if (this.imageOptions == null) {
            this.imageOptions = new Vector_Int(this.defaultSize);
        }
        if (!bl && bufferedImage.getHeight() > 1 && (n2 & 1) != 1) {
            int n4 = n3 = this.optimisedTurnCode && fArray[0][0] * fArray[0][1] == 0.0f && fArray[1][1] * fArray[1][0] == 0.0f && !DynamicVectorRenderer.isRotated(fArray) ? 1 : 0;
            if (!this.optimisedTurnCode || n3 == 0) {
                bufferedImage = this.invertImage(fArray, bufferedImage);
            }
            if (n3 != 0) {
                n2 += 4;
            }
        }
        this.imageOptions.addElement(n2);
        if (this.useHiResImageForDisplay) {
            int n5;
            if (!bl || cachedWidths.get(string2) == null) {
                n3 = bufferedImage.getWidth();
                n5 = bufferedImage.getHeight();
            } else {
                n3 = (Integer)cachedWidths.get(string2);
                n5 = (Integer)cachedHeights.get(string2);
            }
            if (fArray[0][0] == 0.0f && fArray[1][1] == 0.0f) {
                Object object;
                boolean bl2 = DynamicVectorRenderer.isRotated(fArray);
                if (bl2 && (n2 & 2) != 2) {
                    Object object2;
                    object = new AffineTransform();
                    ((AffineTransform)object).rotate(1.5707963267948966, n3 / 2, n5 / 2);
                    ((AffineTransform)object).translate(-((double)n5 - ((AffineTransform)object).getTranslateX()), -((AffineTransform)object).getTranslateY());
                    double[] dArray = new double[6];
                    ((AffineTransform)object).getMatrix(dArray);
                    if (dArray[4] < 1.0) {
                        dArray[4] = 1.0;
                        object = new AffineTransform(dArray);
                    }
                    AffineTransformOp affineTransformOp = new AffineTransformOp((AffineTransform)object, 2);
                    if (bufferedImage != null) {
                        bufferedImage = affineTransformOp.filter(bufferedImage, null);
                        object2 = new AffineTransform();
                        ((AffineTransform)object2).scale(-1.0, 1.0);
                        ((AffineTransform)object2).translate(-bufferedImage.getWidth(), 0.0);
                        AffineTransformOp affineTransformOp2 = new AffineTransformOp((AffineTransform)object2, ColorSpaces.hints);
                        if (bufferedImage.getType() == 12) {
                            BufferedImage bufferedImage2 = bufferedImage;
                            bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                            affineTransformOp2.filter(bufferedImage2, bufferedImage);
                        } else {
                            bufferedImage = affineTransformOp2.filter(bufferedImage, null);
                        }
                    }
                    object2 = new float[][]{{0.0f, 1.0f / (float)n5, 0.0f}, {1.0f / (float)n3, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
                    fArray = Matrix.multiply((float[][])object2, fArray);
                } else {
                    object = new float[][]{{0.0f, 1.0f / (float)n3, 0.0f}, {1.0f / (float)n5, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
                    fArray = Matrix.multiply((float[][])object, fArray);
                }
            } else {
                float[][] fArrayArray = new float[][]{{1.0f / (float)n3, 0.0f, 0.0f}, {0.0f, 1.0f / (float)n5, 0.0f}, {0.0f, 0.0f, 1.0f}};
                fArray = Matrix.multiply(fArrayArray, fArray);
            }
            AffineTransform affineTransform = null;
            affineTransform = new AffineTransform(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], 0.0f, 0.0f);
            if (PdfDecoder.clipOnMac && PdfDecoder.isRunningOnMac) {
                float f3;
                float f4 = fArray[0][0];
                if (f4 == 0.0f) {
                    f4 = 1.0f;
                }
                if ((f3 = fArray[1][1]) == 0.0f) {
                    f3 = 1.0f;
                }
                affineTransform = new AffineTransform(f4, 0.0f, 0.0f, f3, 0.0f, 0.0f);
                if (fArray[0][1] > 0.0f && fArray[1][0] < 0.0f) {
                    f -= (float)n3;
                } else if (fArray[0][1] < 0.0f && fArray[1][0] > 0.0f) {
                    f2 -= (float)n5;
                }
            }
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
            if (!bl) {
                if (!this.isPrinting && this.displayMode == 1) {
                    if (this.rawKey == null) {
                        this.largeImages.put("HIRES_" + this.currentItem, bufferedImage);
                    } else {
                        this.largeImages.put("HIRES_" + this.currentItem + '_' + this.rawKey, bufferedImage);
                    }
                    if (this.imageCount == 0) {
                        this.singleImage = bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                        ++this.imageCount;
                    } else {
                        this.singleImage = null;
                    }
                }
                if (this.rawKey == null) {
                    this.objectStoreRef.saveStoredImage(n + "_HIRES_" + this.currentItem, bufferedImage, false, false, "tif");
                    this.imageIDtoName.put(new Integer(this.currentItem), n + "_HIRES_" + this.currentItem);
                } else {
                    this.objectStoreRef.saveStoredImage(n + "_HIRES_" + this.currentItem + '_' + this.rawKey, bufferedImage, false, false, "tif");
                    this.imageIDtoName.put(new Integer(this.currentItem), n + "_HIRES_" + this.currentItem + '_' + this.rawKey);
                }
                string2 = this.rawKey == null ? n + "_" + this.currentItem : this.rawKey + '_' + this.currentItem;
                cachedWidths.put(string2, new Integer(n3));
                cachedHeights.put(string2, new Integer(n5));
            }
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        this.objectType.addElement(3);
        float f5 = 1.0f;
        float f6 = 1.0f;
        if (this.useHiResImageForDisplay) {
            if (!bl) {
                f5 = bufferedImage.getWidth();
                f6 = bufferedImage.getHeight();
            } else {
                f5 = ((Integer)cachedWidths.get(string2)).intValue();
                f6 = ((Integer)cachedHeights.get(string2)).intValue();
            }
        }
        this.w = (int)(fArray[0][0] * f5);
        if (this.w == 0) {
            this.w = (int)(fArray[0][1] * f5);
        }
        this.h = (int)(fArray[1][1] * f6);
        if (this.h == 0) {
            this.h = (int)(fArray[1][0] * f6);
        }
        if (this.h < 0 && !this.useHiResImageForDisplay) {
            this.h = -this.h;
        }
        this.areas.addElement(new Rectangle((int)graphicsState.x, (int)graphicsState.y, this.w, this.h));
        this.checkWidth(new Rectangle((int)graphicsState.x, (int)graphicsState.y, this.w, this.h));
        if (this.useHiResImageForDisplay) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        this.imageID.put(string, new Integer(this.currentItem));
        ++this.currentItem;
    }

    public static boolean isInverted(float[][] fArray) {
        return fArray[0][0] > 0.0f && fArray[1][1] > 0.0f || fArray[0][0] < 0.0f && fArray[1][1] < 0.0f || fArray[0][0] * fArray[1][1] < 0.0f || fArray[0][1] * fArray[1][0] != 0.0f && fArray[2][1] >= 0.0f;
    }

    private BufferedImage invertImage(float[][] fArray, BufferedImage bufferedImage) {
        boolean bl = false;
        bl = fArray == null ? true : DynamicVectorRenderer.isInverted(fArray);
        if (bl) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -bufferedImage.getHeight());
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
            boolean bl2 = false;
            if (JAIHelper.isJAIused()) {
                bl2 = true;
                try {
                    bufferedImage = JAI.create((String)"affine", (RenderedImage)bufferedImage, (Object)affineTransform, (Object)new InterpolationNearest()).getAsBufferedImage();
                }
                catch (Exception exception) {
                    bl2 = false;
                    exception.printStackTrace();
                }
                catch (Error error) {
                    bl2 = false;
                    error.printStackTrace();
                }
                if (!bl2) {
                    LogWriter.writeLog("Unable to use JAI for image inversion");
                }
            }
            if (!bl2) {
                if (bufferedImage.getType() == 12) {
                    BufferedImage bufferedImage2 = bufferedImage;
                    bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                    affineTransformOp.filter(bufferedImage2, bufferedImage);
                } else {
                    boolean bl3 = false;
                    try {
                        bufferedImage = affineTransformOp.filter(bufferedImage, null);
                    }
                    catch (Exception exception) {
                        bl3 = true;
                    }
                    if (bl3) {
                        try {
                            affineTransformOp = new AffineTransformOp(affineTransform, null);
                            bufferedImage = affineTransformOp.filter(bufferedImage, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return bufferedImage;
    }

    private BufferedImage invertImageBeforeSave(BufferedImage bufferedImage, boolean bl) {
        AffineTransform affineTransform = new AffineTransform();
        if (bl) {
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-bufferedImage.getWidth(), 0.0);
        } else {
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -bufferedImage.getHeight());
        }
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
        boolean bl2 = false;
        if (JAIHelper.isJAIused()) {
            bl2 = true;
            try {
                bufferedImage = JAI.create((String)"affine", (RenderedImage)bufferedImage, (Object)affineTransform, (Object)new InterpolationNearest()).getAsBufferedImage();
            }
            catch (Exception exception) {
                bl2 = false;
                exception.printStackTrace();
            }
            catch (Error error) {
                bl2 = false;
                error.printStackTrace();
            }
            if (!bl2) {
                LogWriter.writeLog("Unable to use JAI for image inversion");
            }
        }
        if (!bl2) {
            if (bufferedImage.getType() == 12) {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                affineTransformOp.filter(bufferedImage2, bufferedImage);
            } else {
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
            }
        }
        return bufferedImage;
    }

    public final void drawImage(BufferedImage bufferedImage) {
        Object object;
        int n = bufferedImage.getHeight();
        if (n > 1) {
            object = new AffineTransform();
            ((AffineTransform)object).translate(0.0, n);
            ((AffineTransform)object).scale(1.0, -1.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp((AffineTransform)object, ColorSpaces.hints);
            bufferedImage = affineTransformOp.filter(bufferedImage, null);
        }
        if (this.useHiResImageForDisplay) {
            object = new double[6];
            this.drawAffine((double[])object);
            this.lastAf[0] = (double)object[0];
            this.lastAf[1] = (double)object[1];
            this.lastAf[2] = (double)object[2];
            this.lastAf[3] = (double)object[3];
            if (this.rawKey == null) {
                this.objectStoreRef.saveStoredImage(this.pageNumber + "_HIRES_" + this.currentItem, bufferedImage, false, false, "tif");
            } else {
                this.objectStoreRef.saveStoredImage(this.pageNumber + "_HIRES_" + this.currentItem + '_' + this.rawKey, bufferedImage, false, false, "tif");
            }
            if (!this.isPrinting && this.displayMode == 1) {
                if (this.rawKey == null) {
                    this.largeImages.put("HIRES_" + this.currentItem, bufferedImage);
                } else {
                    this.largeImages.put("HIRES_" + this.currentItem + '_' + this.rawKey, bufferedImage);
                }
            }
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        this.objectType.addElement(3);
        this.areas.addElement(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        if (this.useHiResImageForDisplay) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        ++this.currentItem;
    }

    private void checkWidth(Rectangle rectangle) {
        int n = rectangle.getBounds().x;
        int n2 = rectangle.getBounds().y;
        int n3 = n2 + rectangle.getBounds().height;
        int n4 = n + rectangle.getBounds().width;
        if (n < this.pageX1) {
            this.pageX1 = n;
        }
        if (n4 > this.pageX2) {
            this.pageX2 = n4;
        }
        if (n3 > this.pageY1) {
            this.pageY1 = n3;
        }
        if (n2 < this.pageY2) {
            this.pageY2 = n2;
        }
    }

    public Rectangle getOccupiedArea() {
        return new Rectangle(this.pageX1, this.pageY1, this.pageX2 - this.pageY1, this.pageY1 - this.pageY2);
    }

    public final void drawShape(Shape shape, GraphicsState graphicsState) {
        int n;
        PdfPaint pdfPaint;
        int n2 = graphicsState.getFillType();
        if (shape.getBounds().getWidth() == 1.0 && shape.getBounds().getHeight() == 1.0) {
            shape = new Rectangle(0, 0, 1, 1);
        }
        if (n2 == 2 | n2 == 3) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawFillColor(pdfPaint);
                this.fillSet = true;
            } else {
                n = pdfPaint.getRGB();
                if (!this.fillSet || this.lastFillCol != n) {
                    this.lastFillCol = n;
                    this.drawFillColor(pdfPaint);
                    this.fillSet = true;
                }
            }
        }
        if (n2 == 1 || n2 == 3) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint instanceof Color) {
                n = pdfPaint.getRGB();
                if (!this.strokeSet || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawStrokeColor(pdfPaint);
                    this.strokeSet = true;
                }
            } else {
                this.drawStrokeColor(pdfPaint);
                this.strokeSet = true;
            }
        }
        Stroke stroke = graphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(stroke)) {
            this.lastStroke = stroke;
            this.drawStroke(stroke);
        }
        this.pageObjects.addElement(shape);
        this.objectType.addElement(2);
        this.areas.addElement(shape.getBounds());
        this.checkWidth(shape.getBounds());
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = graphicsState.x;
        this.y_coord[this.currentItem] = graphicsState.y;
        this.shapeType.addElement(n2);
        ++this.currentItem;
        this.resetTextColors = true;
    }

    public final void drawColor(PdfPaint pdfPaint, int n) {
        this.areas.addElement(null);
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(n);
        this.text_color.addElement(pdfPaint);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
    }

    public void resetOnColorspaceChange() {
        this.fillSet = false;
        this.strokeSet = false;
    }

    public final void drawFillColor(PdfPaint pdfPaint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(pdfPaint);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = pdfPaint.getRGB();
    }

    public final void setGraphicsState(int n, float f) {
        if (f != 1.0f || this.opacity != null) {
            if (this.opacity == null) {
                this.opacity = new Vector_Float(this.defaultSize);
            }
            this.pageObjects.addElement(null);
            if (n == 1) {
                this.objectType.addElement(17);
            } else {
                this.objectType.addElement(18);
            }
            this.opacity.addElement(f);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    public final void drawAdditionalObjectsOverPage(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        if (objectArray == null) {
            return;
        }
        if (this.endItem == -1) {
            this.endItem = this.currentItem;
            this.objectType.setCheckpoint();
            this.shapeType.setCheckpoint();
            this.pageObjects.setCheckpoint();
            this.areas.setCheckpoint();
            this.clips.setCheckpoint();
            this.textFillType.setCheckpoint();
            this.text_color.setCheckpoint();
            this.fill_color.setCheckpoint();
            this.stroke_color.setCheckpoint();
            this.stroke.setCheckpoint();
            if (this.imageOptions != null) {
                this.imageOptions.setCheckpoint();
            }
            if (this.TRvalues != null) {
                this.TRvalues.setCheckpoint();
            }
            if (this.fs != null) {
                this.fs.setCheckpoint();
            }
            if (this.lw != null) {
                this.lw.setCheckpoint();
            }
            this.af1.setCheckpoint();
            this.af2.setCheckpoint();
            this.af3.setCheckpoint();
            this.af4.setCheckpoint();
            this.fontBounds.setCheckpoint();
            if (this.opacity != null) {
                this.opacity.setCheckpoint();
            }
        }
        int n = nArray.length;
        block8: for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            switch (n2) {
                case 18: {
                    this.setGraphicsState(2, ((Float)objectArray[i]).floatValue());
                    continue block8;
                }
                case 17: {
                    this.setGraphicsState(1, ((Float)objectArray[i]).floatValue());
                    continue block8;
                }
                case 19: {
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.setFillType(1);
                    graphicsState.setStrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawShape((Shape)objectArray[i], graphicsState);
                    continue block8;
                }
                case 20: {
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.setFillType(2);
                    graphicsState.setNonstrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawShape((Shape)objectArray[i], graphicsState);
                    continue block8;
                }
                case 23: {
                    this.drawCustom(objectArray[i]);
                    continue block8;
                }
                case 16: {
                    TextObject textObject = (TextObject)objectArray[i];
                    GraphicsState graphicsState = new GraphicsState();
                    float f = textObject.font.getSize();
                    double[] dArray = new double[]{f, 0.0, 0.0, f, 0.0, 0.0};
                    this.drawAffine(dArray);
                    this.drawTR(2);
                    graphicsState.setTextRenderType(2);
                    graphicsState.setNonstrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawText(null, textObject.text, graphicsState, textObject.x, -textObject.y, textObject.font);
                    continue block8;
                }
                default: {
                    throw new PdfException("Unrecognised type " + n2);
                }
            }
        }
    }

    public final void flushAdditionalObjOnPage() {
        if (this.endItem != -1) {
            this.currentItem = this.endItem;
        }
        this.endItem = -1;
        this.objectType.resetToCheckpoint();
        this.shapeType.resetToCheckpoint();
        this.pageObjects.resetToCheckpoint();
        this.areas.resetToCheckpoint();
        this.clips.resetToCheckpoint();
        this.textFillType.resetToCheckpoint();
        this.text_color.resetToCheckpoint();
        this.fill_color.resetToCheckpoint();
        this.stroke_color.resetToCheckpoint();
        this.stroke.resetToCheckpoint();
        if (this.imageOptions != null) {
            this.imageOptions.resetToCheckpoint();
        }
        if (this.TRvalues != null) {
            this.TRvalues.resetToCheckpoint();
        }
        if (this.fs != null) {
            this.fs.resetToCheckpoint();
        }
        if (this.lw != null) {
            this.lw.resetToCheckpoint();
        }
        this.af1.resetToCheckpoint();
        this.af2.resetToCheckpoint();
        this.af3.resetToCheckpoint();
        this.af4.resetToCheckpoint();
        this.fontBounds.resetToCheckpoint();
        if (this.opacity != null) {
            this.opacity.resetToCheckpoint();
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.fillSet = false;
        this.strokeSet = false;
    }

    public final void drawStrokeColor(Paint paint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(paint);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
        this.resetTextColors = true;
    }

    public final void drawCustom(Object object) {
        this.pageObjects.addElement(object);
        this.objectType.addElement(23);
        this.areas.addElement(null);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public final void drawTR(int n) {
        if (n != this.lastTR) {
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(this.defaultSize);
            }
            this.lastTR = n;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.areas.addElement(null);
            this.TRvalues.addElement(n);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    public final void drawStroke(Stroke stroke) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(stroke);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public final void drawClip(GraphicsState graphicsState) {
        Area area = graphicsState.getClippingShape();
        if (!this.hasClips || this.lastClip != null || area != null) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = area;
            if (area == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement((Area)area.clone());
            }
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = graphicsState.x;
            this.y_coord[this.currentItem] = graphicsState.y;
            ++this.currentItem;
        }
        this.hasClips = true;
    }

    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, int n2, GraphicsState graphicsState, AffineTransform affineTransform, float f) {
        int n3;
        PdfPaint pdfPaint;
        int n4 = graphicsState.getTextRenderType();
        if ((n4 & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
            } else {
                n3 = pdfPaint.getRGB();
                if (this.lastFillTextCol != n3) {
                    this.lastFillTextCol = n3;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n4 & 1) == 1 && this.lastStrokeCol != (n3 = (pdfPaint = graphicsState.getStrokeColor()).getRGB())) {
            this.lastStrokeCol = n3;
            this.drawColor(pdfPaint, 1);
        }
        this.drawFontSize(n);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (this.lastAf[0] != dArray[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3]) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        this.pageObjects.addElement(pdfGlyph);
        this.objectType.addElement(n2);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)affineTransform.getTranslateX();
        this.y_coord[this.currentItem] = (float)affineTransform.getTranslateY();
        Rectangle rectangle = new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n);
        this.areas.addElement(rectangle);
        this.checkWidth(rectangle);
        ++this.currentItem;
    }

    public void drawFontBounds(Rectangle rectangle) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(24);
        this.areas.addElement(null);
        this.fontBounds.addElement(rectangle);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public void drawAffine(double[] dArray) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(dArray[0]);
        this.af2.addElement(dArray[1]);
        this.af3.addElement(dArray[2]);
        this.af4.addElement(dArray[3]);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)dArray[4];
        this.y_coord[this.currentItem] = (float)dArray[5];
        ++this.currentItem;
    }

    public void drawFontSize(int n) {
        if (n != this.lastFS) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(21);
            this.areas.addElement(null);
            if (this.fs == null) {
                this.fs = new Vector_Int(this.defaultSize);
            }
            this.fs.addElement(n);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastFS = n;
        }
    }

    public void setLineWidth(int n) {
        if (n == this.lastLW) {
            // empty if block
        }
        this.pageObjects.addElement(null);
        this.objectType.addElement(22);
        if (this.lw == null) {
            this.lw = new Vector_Int(this.defaultSize);
        }
        this.lw.addElement(n);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastLW = n;
    }

    public void renderAffine(AffineTransform affineTransform) {
        this.aff = affineTransform;
    }

    public boolean addBackground() {
        return this.addBackground;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void lockColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.colorsLocked = true;
        Color color = Color.white;
        Color color2 = Color.white;
        if (!pdfPaint.isPattern()) {
            color = (Color)((Object)pdfPaint);
        }
        this.strokeCol = new PdfColor(color.getRed(), color.getGreen(), color.getBlue());
        if (!pdfPaint2.isPattern()) {
            color2 = (Color)((Object)pdfPaint2);
        }
        this.fillCol = new PdfColor(color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    public void setHiResImageForDisplayMode(boolean bl) {
        this.useHiResImageForDisplay = bl;
    }

    public void setOptimiseDrawing(boolean bl) {
        this.optimiseDrawing = bl;
    }

    public void setScalingValues(double d, double d2, float f) {
        this.cropX = d;
        this.cropH = d2;
        this.scaling = f;
    }

    public boolean isImageCached(int n) {
        if (this.rawKey == null) {
            return this.objectStoreRef.isImageCached(n + "_HIRES_" + (this.currentItem + 1));
        }
        return this.objectStoreRef.isImageCached(n + "_HIRES_" + (this.currentItem + 1) + '_' + this.rawKey);
    }

    public DynamicVectorRenderer(byte[] byArray, Map map) {
        try {
            Object object;
            int n;
            this.fonts = map;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n2 = byteArrayInputStream.read();
            if (n2 != 1) {
                throw new PdfException("Unknown version in serialised object " + n2);
            }
            int n3 = byteArrayInputStream.read();
            this.useHiResImageForDisplay = n3 == 1;
            this.pageNumber = byteArrayInputStream.read();
            this.x_coord = (float[])this.restoreFromStream(byteArrayInputStream);
            this.y_coord = (float[])this.restoreFromStream(byteArrayInputStream);
            this.text_color = (Vector_Object)this.restoreFromStream(byteArrayInputStream);
            this.textFillType = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.stroke_color = new Vector_Object();
            this.stroke_color.restoreFromStream(byteArrayInputStream);
            this.fill_color = new Vector_Object();
            this.fill_color.restoreFromStream(byteArrayInputStream);
            this.stroke = new Vector_Object();
            this.stroke.restoreFromStream(byteArrayInputStream);
            this.pageObjects = new Vector_Object();
            this.pageObjects.restoreFromStream(byteArrayInputStream);
            this.javaObjects = (Vector_Object)this.restoreFromStream(byteArrayInputStream);
            this.shapeType = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.af1 = (Vector_Double)this.restoreFromStream(byteArrayInputStream);
            this.af2 = (Vector_Double)this.restoreFromStream(byteArrayInputStream);
            this.af3 = (Vector_Double)this.restoreFromStream(byteArrayInputStream);
            this.af4 = (Vector_Double)this.restoreFromStream(byteArrayInputStream);
            this.fontBounds = new Vector_Rectangle();
            this.fontBounds.restoreFromStream(byteArrayInputStream);
            this.clips = new Vector_Shape();
            this.clips.restoreFromStream(byteArrayInputStream);
            this.objectType = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.opacity = (Vector_Float)this.restoreFromStream(byteArrayInputStream);
            this.imageOptions = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.TRvalues = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.fs = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            this.lw = (Vector_Int)this.restoreFromStream(byteArrayInputStream);
            int n4 = (Integer)this.restoreFromStream(byteArrayInputStream);
            for (n = 0; n < n4; ++n) {
                Object object2 = this.restoreFromStream(byteArrayInputStream);
                object = this.restoreFromStream(byteArrayInputStream);
                map.put(object2, object);
            }
            n = (Integer)this.restoreFromStream(byteArrayInputStream);
            for (int i = 0; i < n; ++i) {
                object = this.restoreFromStream(byteArrayInputStream);
                PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)map.get(object);
                pdfJavaGlyphs.setDisplayValues((Map)this.restoreFromStream(byteArrayInputStream));
                pdfJavaGlyphs.setCharGlyphs((Map)this.restoreFromStream(byteArrayInputStream));
                pdfJavaGlyphs.setEmbeddedEncs((Map)this.restoreFromStream(byteArrayInputStream));
            }
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.currentItem = this.pageObjects.get().length;
    }

    public byte[] serializeToByteArray(Set set) throws IOException {
        Object k;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(1);
        if (this.useHiResImageForDisplay) {
            byteArrayOutputStream.write(1);
        } else {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.write(this.pageNumber);
        this.text_color.trim();
        this.stroke_color.trim();
        this.fill_color.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.shapeType.trim();
        this.af1.trim();
        this.af2.trim();
        this.af3.trim();
        this.af4.trim();
        this.fontBounds.trim();
        this.clips.trim();
        this.objectType.trim();
        if (this.opacity != null) {
            this.opacity.trim();
        }
        if (this.imageOptions != null) {
            this.imageOptions.trim();
        }
        if (this.TRvalues != null) {
            this.TRvalues.trim();
        }
        if (this.fs != null) {
            this.fs.trim();
        }
        if (this.lw != null) {
            this.lw.trim();
        }
        this.writeToStream(byteArrayOutputStream, this.x_coord, "x_coord");
        this.writeToStream(byteArrayOutputStream, this.y_coord, "y_coord");
        this.writeToStream(byteArrayOutputStream, this.text_color, "text_color");
        this.writeToStream(byteArrayOutputStream, this.textFillType, "textFillType");
        this.stroke_color.writeToStream(byteArrayOutputStream);
        this.fill_color.writeToStream(byteArrayOutputStream);
        int n2 = byteArrayOutputStream.size();
        this.stroke.writeToStream(byteArrayOutputStream);
        n2 = n = byteArrayOutputStream.size();
        this.pageObjects.writeToStream(byteArrayOutputStream);
        n = byteArrayOutputStream.size();
        this.writeToStream(byteArrayOutputStream, this.javaObjects, "javaObjects");
        this.writeToStream(byteArrayOutputStream, this.shapeType, "shapeType");
        this.writeToStream(byteArrayOutputStream, this.af1, "af1");
        this.writeToStream(byteArrayOutputStream, this.af2, "af2");
        this.writeToStream(byteArrayOutputStream, this.af3, "af3");
        this.writeToStream(byteArrayOutputStream, this.af4, "af4");
        this.fontBounds.writeToStream(byteArrayOutputStream);
        n2 = byteArrayOutputStream.size();
        this.clips.writeToStream(byteArrayOutputStream);
        n = byteArrayOutputStream.size();
        this.writeToStream(byteArrayOutputStream, this.objectType, "objectType");
        this.writeToStream(byteArrayOutputStream, this.opacity, "opacity");
        this.writeToStream(byteArrayOutputStream, this.imageOptions, "imageOptions");
        this.writeToStream(byteArrayOutputStream, this.TRvalues, "TRvalues");
        this.writeToStream(byteArrayOutputStream, this.fs, "fs");
        this.writeToStream(byteArrayOutputStream, this.lw, "lw");
        int n3 = 0;
        int n4 = 0;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Iterator iterator = this.fontsUsed.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            if (!set.contains(k)) {
                ++n3;
                hashMap2.put(k, "x");
                continue;
            }
            ++n4;
            hashMap.put(k, "x");
        }
        this.writeToStream(byteArrayOutputStream, new Integer(n3), "new Integer(fontCount)");
        iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            this.writeToStream(byteArrayOutputStream, k, "key");
            this.writeToStream(byteArrayOutputStream, this.fonts.get(k), "font");
            set.add(k);
        }
        this.writeToStream(byteArrayOutputStream, new Integer(n4), "new Integer(existingfontCount)");
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            this.writeToStream(byteArrayOutputStream, k, "key");
            PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)this.fonts.get(k);
            this.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getDisplayValues(), "display");
            this.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getCharGlyphs(), "char");
            this.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getEmbeddedEncs(), "emb");
        }
        byteArrayOutputStream.close();
        this.fontsUsed.clear();
        return byteArrayOutputStream.toByteArray();
    }

    public Object restoreFromStream(ByteArrayInputStream byteArrayInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public void writeToStream(ByteArrayOutputStream byteArrayOutputStream, Object object, String string) throws IOException {
        int n = byteArrayOutputStream.size();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        int n2 = byteArrayOutputStream.size();
        objectOutputStream.close();
    }

    public void checkFontSaved(Object object, String string, PdfFont pdfFont) {
        this.pageObjects.addElement(object);
        this.objectType.addElement(200);
        ++this.currentItem;
        if (this.fontsUsed.get(string) == null || pdfFont.isFontSubsetted()) {
            this.fonts.put(string, pdfFont.getGlyphData());
            this.fontsUsed.put(string, "x");
        }
    }

    public boolean hasObjectsBehind(float[][] fArray) {
        double d;
        boolean bl = false;
        double d2 = fArray[2][0];
        double d3 = fArray[2][1];
        double d4 = fArray[0][0];
        if (d4 == 0.0) {
            d4 = fArray[0][1];
        }
        if ((d = (double)fArray[1][1]) == 0.0) {
            d = fArray[1][0];
        }
        Rectangle[] rectangleArray = this.areas.get();
        int n = rectangleArray.length;
        for (int i = 0; i < n; ++i) {
            if (rectangleArray[i] == null) continue;
            if (d < 0.0) {
                d = (d3 += d) - d;
            }
            if (d4 < 0.0) {
                d4 = (d2 += d4) - d4;
            }
            Rectangle rectangle = rectangleArray[i];
            Rectangle rectangle2 = new Rectangle((int)d2, (int)d3, (int)d4, (int)d);
            if (d4 * d > (double)(rectangleArray[i].width * rectangleArray[i].height)) {
                rectangle = new Rectangle((int)d2, (int)d3, (int)d4, (int)d);
                rectangle2 = rectangleArray[i];
            }
            if (!rectangle2.intersects(rectangle) && !rectangle.contains(rectangle2)) continue;
            i = n;
            bl = true;
        }
        return bl;
    }

    public Rectangle getArea(int n) {
        return this.areas.elementAt(n);
    }

    public boolean rectangleContains(Rectangle rectangle, int n, int n2, int n3) {
        int n4;
        int n5 = rectangle.x;
        int n6 = rectangle.x + rectangle.width;
        int n7 = rectangle.y;
        int n8 = rectangle.y + rectangle.height;
        boolean bl = false;
        if (n5 > n6) {
            n4 = n5;
            n5 = n6;
            n6 = n4;
        }
        if (n7 > n8) {
            n4 = n7;
            n7 = n8;
            n8 = n4;
        }
        if (n7 < n2 && n2 < n8 && n5 < n && n < n6) {
            bl = true;
        }
        return bl;
    }

    public int isInsideImage(int n, int n2) {
        int n3 = -1;
        Rectangle[] rectangleArray = this.areas.get();
        Rectangle rectangle = null;
        int n4 = rectangleArray.length;
        int[] nArray = this.objectType.get();
        for (int i = 0; i < n4; ++i) {
            if (rectangleArray[i] == null || !this.rectangleContains(rectangleArray[i], n, n2, i) || nArray[i] != 3) continue;
            if (rectangle != null) {
                int n5 = rectangleArray[i].height * rectangleArray[i].width;
                int n6 = rectangle.height * rectangle.width;
                if (n5 < n6) {
                    rectangle = rectangleArray[i];
                }
                n3 = i;
                continue;
            }
            rectangle = rectangleArray[i];
            n3 = i;
        }
        return n3;
    }

    public void setObjectStoreRef(ObjectStore objectStore) {
        this.objectStoreRef = objectStore;
    }

    public void setType3Glyph(String string) {
        this.rawKey = string;
        this.isType3Font = true;
    }

    public BufferedImage getLoresImage(String string) {
        Object v;
        this.lastItemPainted = -1;
        int n = string.indexOf(45);
        if (n != -1) {
            string = string.substring(n + 1, string.length());
        }
        if ((v = this.imageID.get(string)) == null) {
            return null;
        }
        BufferedImage bufferedImage = (BufferedImage)this.pageObjects.elementAt((Integer)v);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(0.0, -bufferedImage.getHeight());
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public void saveImage(int n, String string, String string2) {
        String string3 = (String)this.imageIDtoName.get(new Integer(n));
        BufferedImage bufferedImage = null;
        bufferedImage = this.useHiResImageForDisplay ? this.objectStoreRef.loadStoredImage(string3) : (BufferedImage)this.pageObjects.elementAt(n);
        if (bufferedImage != null) {
            if (!this.optimisedTurnCode) {
                bufferedImage = this.invertImage(null, bufferedImage);
            }
            if ((bufferedImage.getType() == 0 || string2.equals("jpg") && bufferedImage.getType() == 2) && (bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage)).getType() == 0) {
                JOptionPane.showMessageDialog(null, "This is a custom Image, Java's standard libraries may not be able to save the image as a jpg correctly.\nEnabling JAI will ensure correct output. \n\nFor information on how to do this please go to http://www.jpedal.org/flags.php");
            }
            if (this.needsHorizontalInvert) {
                bufferedImage = this.invertImageBeforeSave(bufferedImage, true);
            }
            if (this.needsVerticalInvert) {
                bufferedImage = this.invertImageBeforeSave(bufferedImage, false);
            }
            if (JAIHelper.isJAIused() && string2.toLowerCase().startsWith("tif")) {
                JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)string, (Object)string2);
            } else if (string2.toLowerCase().startsWith("tif")) {
                JOptionPane.showMessageDialog(null, "Please setup JAI library for Tiffs");
            } else {
                try {
                    ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void setCustomImageHandler(ImageHandler imageHandler) {
        this.customImageHandler = imageHandler;
    }

    public void flagDecodingFinished() {
        this.highlightsNeedToBeGenerated = true;
    }

    private void generateHighlights(Graphics2D graphics2D, int n, int[] nArray, Object[] objectArray, float f, float f2, float f3, float f4, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int[] nArray2, Rectangle[] rectangleArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.highlightsNeedToBeGenerated = false;
        int[] nArray3 = new int[n];
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        Rectangle rectangle = null;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        boolean[] blArray = new boolean[n];
        int[] nArray4 = new int[n];
        float[] fArray5 = new float[n];
        this.textHighlightsX = new int[n];
        this.textHighlightsY = new int[n];
        this.textHighlightsWidth = new int[n];
        this.textHighlightsHeight = new int[n];
        int n10 = 0;
        int n11 = 0;
        int n12 = 1000;
        int n13 = 1000;
        int n14 = 1;
        double[] dArray5 = new double[6];
        graphics2D.getTransform().getMatrix(dArray5);
        int n15 = 0;
        if (dArray5[1] < 0.0 && dArray5[2] < 0.0) {
            n15 = 270;
        }
        for (n6 = 0; n6 < n; ++n6) {
            int n16 = nArray[n6];
            if (n16 <= 0) continue;
            float f5 = this.x_coord[n6];
            float f6 = this.y_coord[n6];
            Object object = null;
            object = objectArray[n6];
            if (n16 == 24) {
                rectangle = rectangleArray[n9];
                n12 = rectangle.height;
                n10 = rectangle.x;
                n11 = rectangle.y;
                n13 = rectangle.width;
                ++n9;
                continue;
            }
            if (n16 == 21) {
                n14 = nArray2[++n7];
                continue;
            }
            if (n16 != 4 && n16 != 5 && n16 != 1) continue;
            float f7 = 1.0f;
            if (n16 == 4 || n16 == 5) {
                PdfGlyph pdfGlyph = (PdfGlyph)object;
                f7 = (float)n14 / 1000.0f;
                n5 = pdfGlyph.getFontBB(1);
                n4 = n11;
                n3 = pdfGlyph.getFontBB(3);
                n2 = n12;
                this.textHighlightsX[n6] = n5;
                this.textHighlightsY[n6] = n4;
                this.textHighlightsWidth[n6] = n3;
                this.textHighlightsHeight[n6] = n2;
                blArray[n6] = true;
                if (n15 == 90) {
                    fArray2[n6] = -((float)this.textHighlightsY[n6] * f7) + f5;
                    fArray3[n6] = (float)this.textHighlightsX[n6] * f7 + f6;
                } else if (n15 == 270) {
                    fArray2[n6] = (float)this.textHighlightsY[n6] * f7 + f5;
                    fArray3[n6] = -((float)this.textHighlightsX[n6] * f7 + f6);
                } else {
                    fArray2[n6] = (float)this.textHighlightsY[n6] * f7 + f6;
                    fArray3[n6] = (float)this.textHighlightsX[n6] * f7 + f5;
                }
                fArray[n6] = fArray2[n6] + (float)this.textHighlightsHeight[n6] * f7;
                fArray4[n6] = fArray3[n6] + (float)this.textHighlightsWidth[n6] * f7;
                fArray5[n6] = 10.0f;
                nArray4[n6] = n14;
            } else {
                f7 = 1.0f;
                float f8 = 1000.0f / (float)n14;
                this.textHighlightsX[n6] = (int)f5;
                this.textHighlightsY[n6] = (int)(f6 + (float)n11 / f8);
                this.textHighlightsWidth[n6] = (int)((float)n13 / f8);
                this.textHighlightsHeight[n6] = (int)((float)(n12 - n11) / f8);
                if (n15 == 90) {
                    fArray2[n6] = -this.textHighlightsY[n6];
                    fArray3[n6] = this.textHighlightsX[n6];
                } else if (n15 == 270) {
                    fArray2[n6] = this.textHighlightsY[n6];
                    fArray3[n6] = -this.textHighlightsX[n6];
                } else {
                    fArray2[n6] = this.textHighlightsY[n6];
                    fArray3[n6] = this.textHighlightsX[n6];
                }
                fArray[n6] = fArray2[n6] + (float)this.textHighlightsHeight[n6];
                fArray4[n6] = fArray3[n6] + (float)this.textHighlightsWidth[n6];
                fArray5[n6] = ((Area)object).getBounds().width;
                nArray4[n6] = n14;
            }
            nArray3[n6] = n6;
        }
        n6 = -31;
        for (int i = 0; i < n - 1; ++i) {
            int n17 = nArray3[i];
            if (n17 == n6) {
                System.out.println("*" + n17 + " = " + " left=" + fArray3[n17] + " bottom=" + fArray2[n17] + " right=" + fArray4[n17] + " top=" + fArray[n17]);
            }
            int n18 = 0;
            for (n5 = i + 1; n5 < n; ++n5) {
                boolean bl;
                n4 = nArray3[n5];
                if (blArray[n4] != blArray[n17] || fArray5[n4] < 1.0f) continue;
                if (n17 == n6) {
                    System.out.println("compare with=" + n4 + " left=" + fArray3[n4] + " right=" + fArray4[n4] + " " + (fArray3[n4] > fArray3[n17] && fArray3[n4] < fArray4[n17]));
                }
                if (!(fArray3[n4] > fArray3[n17] && fArray3[n4] < fArray4[n17]) && (!(fArray3[n4] > (fArray3[n17] + fArray4[n17]) / 2.0f) || !(fArray4[n17] < fArray4[n4]))) continue;
                n3 = this.textHighlightsWidth[n17];
                n2 = this.textHighlightsHeight[n17];
                int n19 = this.textHighlightsX[n17];
                int n20 = this.textHighlightsY[n17];
                if (blArray[n4]) {
                    float f9 = fArray3[n4] - fArray4[n17];
                    f9 = f9 > 0.0f ? (f9 += 0.5f) : (f9 += 0.5f);
                    n18 = (int)(f9 * 1000.0f / (float)nArray4[n17]);
                    if (this.textHighlightsX[n4] > 0) {
                        n18 += this.textHighlightsX[n4];
                    }
                } else {
                    n18 = (int)(fArray3[n4] - fArray4[n17]);
                }
                if (n17 == n6) {
                    System.out.println(fArray3[n4] - fArray4[n17] + " gap=" + n18 + " " + (fArray3[n4] - fArray4[n17]) * 1000.0f / (float)nArray4[n17] + " currentX=" + n19 + " scaling=" + this.scaling + " " + n13);
                }
                boolean bl2 = bl = n18 > 0 || n18 < 0 && fArray3[n17] < fArray3[n4] && fArray4[n17] > fArray3[n4] && fArray4[n17] < fArray4[n4] && fArray3[n17] < fArray4[n17] && (-n18 < nArray4[n17] && !blArray[n17] || -n18 < n13 && blArray[n17]);
                if (!(fArray2[n17] < fArray[n4]) || !(fArray2[n4] < fArray[n17]) || n18 <= 0 && !bl) continue;
                if (bl && (!blArray[n17] && n18 < nArray4[n17] && n3 + n18 < nArray4[n17] || blArray[n17] && n18 < n13)) {
                    if (n17 == n6) {
                        System.out.println(n4 + " = " + " left=" + fArray3[n4] + " bottom=" + fArray2[n4] + " right=" + fArray4[n4] + " top=" + fArray[n4]);
                    }
                    this.textHighlightsWidth[n17] = blArray[n17] ? (n18 > 0 ? n3 + n18 : n3 - n18) : (n18 > 0 ? n18 : n3 + n18);
                    if (n17 == n6) {
                        System.out.println("new=" + this.textHighlightsWidth[n17]);
                        System.exit(1);
                    }
                    n5 = n;
                    continue;
                }
                if (n18 <= n13) continue;
            }
        }
    }

    public void setPrintPage(int n) {
        this.printPage = n;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    public void setOptimisedRotation(boolean bl) {
        this.optimisedTurnCode = bl;
    }

    static {
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        marksNewCode = false;
        userAlerted = false;
    }
}

