/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.calc.magScalingRelations.magScalingRelImpl;

import org.opensha.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.util.FaultUtils;

public class WC1994_MagAreaRelationship
extends MagAreaRelationship {
    static final String C = "WC1994_MagAreaRelationship";
    public static final String NAME = "W&C 1994 Mag-Area Rel.";

    public WC1994_MagAreaRelationship() {
        this.rake = Double.NaN;
    }

    public double getMedianMag(double area) {
        if (Double.isNaN(this.rake)) {
            return 4.07 + 0.98 * Math.log(area) * 0.434294;
        }
        if (this.rake <= 45.0 && this.rake >= -45.0 || this.rake >= 135.0 && this.rake <= -135.0) {
            return 3.98 + 1.02 * Math.log(area) * 0.434294;
        }
        if (this.rake > 0.0) {
            return 4.33 + 0.9 * Math.log(area) * 0.434294;
        }
        return 3.93 + 1.02 * Math.log(area) * 0.434294;
    }

    public double getMagStdDev() {
        if (Double.isNaN(this.rake)) {
            return 0.24;
        }
        if (this.rake <= 45.0 && this.rake >= -45.0 || this.rake >= 135.0 && this.rake <= -135.0) {
            return 0.23;
        }
        if (this.rake > 0.0) {
            return 0.25;
        }
        return 0.25;
    }

    public double getMedianArea(double mag) {
        if (Double.isNaN(this.rake)) {
            return Math.pow(10.0, -3.49 + 0.91 * mag);
        }
        if (this.rake <= 45.0 && this.rake >= -45.0 || this.rake >= 135.0 && this.rake <= -135.0) {
            return Math.pow(10.0, -3.42 + 0.9 * mag);
        }
        if (this.rake > 0.0) {
            return Math.pow(10.0, -3.99 + 0.98 * mag);
        }
        return Math.pow(10.0, -2.87 + 0.82 * mag);
    }

    public double getAreaStdDev() {
        if (Double.isNaN(this.rake)) {
            return 0.24;
        }
        if (this.rake <= 45.0 && this.rake >= -45.0 || this.rake >= 135.0 && this.rake <= -135.0) {
            return 0.22;
        }
        if (this.rake > 0.0) {
            return 0.26;
        }
        return 0.22;
    }

    public void setRake(double rake) {
        if (!Double.isNaN(rake)) {
            FaultUtils.assertValidRake(rake);
        }
        this.rake = rake;
    }

    public String getName() {
        return NAME;
    }
}

