/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data;

import java.io.Serializable;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.opensha.data.Container2DAPI;
import org.opensha.data.NamedObjectAPI;
import org.opensha.exceptions.InvalidArrayShapeException;

public class Container2D
implements Container2DAPI,
Serializable,
NamedObjectAPI {
    protected static final String C = "Container2D";
    protected static final boolean D = false;
    protected Object[] data;
    protected int numRows = 0;
    protected int numCols = 0;
    protected long size = 0L;
    protected String name;
    protected static final char TAB = '\t';

    public Container2D() {
        String S = "Container2D: Constructor(): ";
        int numRows = 100;
        int numCols = 100;
        this.size = (long)numRows * (long)numCols;
        this.data = new Object[numRows * numCols];
    }

    public Container2D(int numRows, int numCols) throws InvalidArrayShapeException, OutOfMemoryError {
        String S = "Container2D: Constructor(rows, cols): ";
        if (numRows < 0) {
            throw new InvalidArrayShapeException(S + "Number of rows cannot be negative");
        }
        if (numCols < 0) {
            throw new InvalidArrayShapeException(S + "Number of columns cannot be negative");
        }
        this.size = (long)numRows * (long)numCols;
        if (this.size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError(S + "Number of rows * columns cannot be greater than " + Integer.MAX_VALUE);
        }
        this.numRows = numRows;
        this.numCols = numCols;
        this.data = new Object[numRows * numCols];
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void set(int row, int column, Object obj) throws ArrayIndexOutOfBoundsException {
        String S = "Container2D: set(): ";
        this.checkBounds(row, column, S);
        this.data[row * this.numCols + column] = obj;
    }

    protected void setNumRowsAndNumCols(int numRows, int numCols) {
        this.numCols = numCols;
        this.numRows = numRows;
        this.size = (long)numRows * (long)numCols;
        this.data = new Object[numRows * numCols];
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public Object get(int row, int column) {
        String S = "Container2D: get(): ";
        this.checkBounds(row, column, S);
        return this.data[row * this.numCols + column];
    }

    public ListIterator getColumnIterator(int row) throws ArrayIndexOutOfBoundsException {
        String S = "Container2D: getColumnIterator(): ";
        if (row >= this.numRows) {
            throw new ArrayIndexOutOfBoundsException(S + "Row cannot be greater than max index");
        }
        ColumnIterator it = new ColumnIterator(row);
        return it;
    }

    public ListIterator getRowIterator(int column) throws ArrayIndexOutOfBoundsException {
        String S = "Container2D: getRowIterator(): ";
        if (column >= this.numCols) {
            throw new ArrayIndexOutOfBoundsException(S + "Column cannot be greater than max index");
        }
        RowIterator it = new RowIterator(column);
        return it;
    }

    public ListIterator getAllByColumnsIterator() {
        AllByColumnsIterator it = new AllByColumnsIterator();
        return it;
    }

    public ListIterator getAllByRowsIterator() {
        AllByRowsIterator it = new AllByRowsIterator();
        return it;
    }

    protected void checkBounds(int row, int column, String preffix) throws ArrayIndexOutOfBoundsException {
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException(preffix + "Row cannot be less than zero");
        }
        if (column < 0) {
            throw new ArrayIndexOutOfBoundsException(preffix + "Column cannot be less than zero");
        }
        if (row >= this.numRows) {
            throw new ArrayIndexOutOfBoundsException(preffix + "Row cannot be greater than max index: " + this.numRows);
        }
        if (column >= this.numCols) {
            throw new ArrayIndexOutOfBoundsException(preffix + "Column cannot be greater than max index: " + this.numCols);
        }
    }

    public void clear() {
        this.data = null;
        this.numRows = 0;
        this.numCols = 0;
        this.size = 0L;
    }

    public void delete(int row, int column) {
        String S = "Container2D: delete(): ";
        this.checkBounds(row, column, S);
        this.data[row * this.numCols + column] = null;
    }

    public boolean exist(int row, int column) {
        String S = "Container2D: exist(): ";
        this.checkBounds(row, column, S);
        return this.data[row * this.numCols + column] != null;
    }

    public long size() {
        return this.size;
    }

    public ListIterator listIterator() {
        AllByRowsIterator it = new AllByRowsIterator();
        return it;
    }

    public Object[][] toJava2D() {
        Object[][] d = new Object[this.numRows][this.numCols];
        for (int j = 0; j < this.numRows; ++j) {
            for (int i = 0; i < this.numCols; ++i) {
                d[i][j] = this.data[i * this.numCols + j];
            }
        }
        return d;
    }

    public static void main(String[] args) {
        String S = "Container2D: Main(): ";
        System.out.println(S + "Starting");
        int xsize = 5;
        int ysize = 10;
        Container2D con = new Container2D(xsize, ysize);
        for (int x = 0; x < xsize; ++x) {
            for (int y = 0; y < ysize; ++y) {
                con.set(x, y, "" + x + ", " + y);
            }
        }
        System.out.println(S + "(1,1) = " + con.get(1, 1));
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getRowIterator");
        ListIterator it = con.getRowIterator(2);
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getColumnIterator");
        it = con.getColumnIterator(2);
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getAllByColumnsIterator");
        it = con.getAllByColumnsIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getAllByRowsIterator");
        it = con.getAllByRowsIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "List Iterator");
        it = con.listIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S + "Ending");
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append('\n');
        int counter = 0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                b.append("" + i + '\t' + j + '\t');
                Object obj = this.get(i, j);
                if (obj != null) {
                    b.append(obj.toString());
                    ++counter;
                } else {
                    b.append("NULL");
                }
                b.append('\n');
            }
        }
        b.append("\nNumber of Rows = " + this.numRows + '\n');
        b.append("Number of Columns = " + this.numCols + '\n');
        b.append("Size = " + this.size + '\n');
        b.append("Number of non-null objects = " + counter + '\n');
        return b.toString();
    }

    class AllByRowsIterator
    extends Container2DListIterator
    implements ListIterator {
        public AllByRowsIterator() {
            this.lastIndex = Container2D.this.numCols * Container2D.this.numRows;
        }

        public Object next() throws NoSuchElementException {
            try {
                Object object = Container2D.this.data[this.cursor];
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element." + e.toString());
            }
        }
    }

    class AllByColumnsIterator
    extends Container2DListIterator
    implements ListIterator {
        int currentColumn = 0;
        int currentRow = 0;

        public AllByColumnsIterator() {
            this.lastIndex = Container2D.this.numCols * Container2D.this.numRows;
        }

        public Object next() throws NoSuchElementException {
            try {
                Object object = Container2D.this.data[this.currentRow * Container2D.this.numCols + this.currentColumn];
                ++this.currentRow;
                if (this.currentRow == Container2D.this.numRows) {
                    this.currentRow = 0;
                    ++this.currentColumn;
                }
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element. " + e.toString());
            }
        }
    }

    class RowIterator
    extends Container2DListIterator
    implements ListIterator {
        int pinnedColumn;

        public RowIterator(int column) {
            this.pinnedColumn = column;
            this.lastIndex = Container2D.this.numRows;
        }

        public Object next() throws NoSuchElementException {
            try {
                Object object = Container2D.this.data[this.cursor * Container2D.this.numCols + this.pinnedColumn];
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element." + e.toString());
            }
        }
    }

    class ColumnIterator
    extends Container2DListIterator
    implements ListIterator {
        int pinnedRow;

        public ColumnIterator(int row) {
            this.pinnedRow = row;
            this.lastIndex = Container2D.this.numCols;
        }

        public Object next() throws NoSuchElementException {
            try {
                Object object = Container2D.this.data[this.pinnedRow * Container2D.this.numCols + this.cursor];
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element." + e.toString());
            }
        }
    }

    abstract class Container2DListIterator
    implements ListIterator {
        int cursor = 0;
        int lastRet = -1;
        int lastIndex = 0;

        public void set(Object obj) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("set(Object obj) Not implemented.");
        }

        public boolean hasNext() {
            return this.cursor != this.lastIndex;
        }

        public int nextIndex() {
            return this.cursor;
        }

        public abstract Object next() throws NoSuchElementException;

        public Object previous() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("hasPrevious() Not implemented.");
        }

        public int previousIndex() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("hasPrevious() Not implemented.");
        }

        public boolean hasPrevious() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("hasPrevious() Not implemented.");
        }

        public void add(Object obj) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("add(Object obj) Not implemented.");
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove() Not implemented.");
        }
    }
}

