/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data;

import java.io.Serializable;

public class DataPoint2D
implements Comparable,
Serializable {
    protected static final String C = "DataPoint2D";
    protected static final boolean D = false;
    private double x = Double.NaN;
    private double y = Double.NaN;

    public DataPoint2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double newX) {
        this.x = newX;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double newY) {
        this.y = newY;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void set(DataPoint2D point) {
        this.x = point.getX();
        this.y = point.getY();
    }

    public boolean equals(DataPoint2D point) {
        double xx = point.getX();
        return this.x == xx;
    }

    public boolean equals(DataPoint2D point, double tolerance) {
        double x = this.x;
        double xx = point.getX();
        return Math.abs(x - xx) <= tolerance;
    }

    public boolean equals(double x, double y) {
        return this.x == x && this.y == y;
    }

    public boolean equals(double x) {
        return this.x == x;
    }

    public int compareTo(Object obj) throws ClassCastException {
        String S = "DataPoint2D:compareTo(): ";
        if (!(obj instanceof DataPoint2D)) {
            throw new ClassCastException(S + "Object not a DataPoint2D, unable to compare");
        }
        DataPoint2D point = (DataPoint2D)obj;
        boolean result = false;
        Double x = new Double(this.x);
        Double xx = new Double(point.getX());
        return x.compareTo(xx);
    }

    public boolean equals(Object obj) throws ClassCastException {
        return this.compareTo(obj) == 0;
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        b.append(C);
        b.append(TAB + "X = " + this.x + '\n');
        b.append(TAB + "Y = " + this.y + '\n');
        return b.toString();
    }

    protected void invert() {
        double yy;
        double xx = this.y;
        this.y = yy = this.x;
        this.x = xx;
    }

    public Object clone() {
        double xx = this.x;
        double yy = this.y;
        DataPoint2D point = new DataPoint2D(xx, yy);
        return point;
    }
}

