/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data;

import org.opensha.param.DoubleParameter;

public class Direction {
    protected static final String C = "Direction";
    protected static final boolean D = false;
    protected double vertDistance;
    protected double horzDistance;
    protected DoubleParameter azimuth = new DoubleParameter("azimuth");
    protected DoubleParameter backAzimuth = new DoubleParameter("backAzimuth");

    public Direction() {
        this.azimuth.setValue(new Double(180.0));
        this.backAzimuth.setValue(new Double(0.0));
        this.horzDistance = 0.0;
        this.vertDistance = 0.0;
    }

    public Direction(double vDist, double hDist, double az, double backAz) {
        this.azimuth.setValue(new Double(az));
        this.backAzimuth.setValue(new Double(backAz));
        this.horzDistance = hDist;
        this.vertDistance = vDist;
    }

    public void setVertDistance(double vertDistance) {
        this.vertDistance = vertDistance;
    }

    public void setHorzDistance(double horzDistance) {
        this.horzDistance = horzDistance;
    }

    public void setAzimuth(double azimuth) {
        this.azimuth.setValue(new Double(azimuth));
    }

    public void setBackAzimuth(double backAzimuth) {
        this.backAzimuth.setValue(new Double(backAzimuth));
    }

    public double getVertDistance() {
        return this.vertDistance;
    }

    public double getHorzDistance() {
        return this.horzDistance;
    }

    public double getAzimuth() {
        return (Double)this.azimuth.getValue();
    }

    public double getBackAzimuth() {
        return (Double)this.backAzimuth.getValue();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(C);
        b.append(" : ");
        b.append("horzDistance = ");
        b.append(this.horzDistance);
        b.append(" : ");
        b.append("vertDistance = ");
        b.append(this.vertDistance);
        b.append(" : ");
        b.append("azimuth = ");
        b.append(this.azimuth);
        b.append(" : ");
        b.append("backAzimuth = ");
        b.append(this.backAzimuth);
        b.append(" : ");
        return b.toString();
    }

    public boolean equalsDirection(Direction dir) {
        if (this.horzDistance != dir.horzDistance) {
            return false;
        }
        if (this.vertDistance != dir.vertDistance) {
            return false;
        }
        if (this.azimuth != dir.azimuth) {
            return false;
        }
        return this.backAzimuth == dir.backAzimuth;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Direction) {
            return this.equalsDirection((Direction)obj);
        }
        return false;
    }
}

