/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.opensha.exceptions.InvalidRangeException;

public class Location
implements Serializable {
    protected static final String C = "Location";
    protected static final boolean D = false;
    protected double depth = Double.NaN;
    protected double latitude = Double.NaN;
    protected double longitude = Double.NaN;
    public static final double MAX_LAT = 90.0;
    public static final double MIN_LAT = -90.0;
    public static final double MAX_LON = 360.0;
    public static final double MIN_LON = -360.0;
    public static final double MIN_DEPTH = 0.0;
    public static final DecimalFormat latLonFormat = new DecimalFormat("0.0#####");
    private static final char TAB = '\t';

    public Location() {
    }

    public Location(double lat, double lon) throws InvalidRangeException {
        this(lat, lon, 0.0);
    }

    public Location(double lat, double lon, double depth) throws InvalidRangeException {
        String S = "Location: Constructor2(): ";
        Location.validateLatitude(lat, S);
        Location.validateLongitude(lon, S);
        this.latitude = lat;
        this.longitude = lon;
        this.depth = depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public void setLatitude(double latitude) throws InvalidRangeException {
        Location.validateLatitude(latitude, "Location: setLatitude(): ");
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) throws InvalidRangeException {
        Location.validateLongitude(longitude, "Location: setLongitude(): ");
        this.longitude = longitude;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    protected static void validateLatitude(double lat, String S) throws InvalidRangeException {
        if (lat < -90.0) {
            throw new InvalidRangeException(S + "Latitude cannot be less than -90");
        }
        if (lat > 90.0) {
            throw new InvalidRangeException(S + "Latitude cannot be greater than 90");
        }
    }

    protected static void validateLongitude(double lon, String S) throws InvalidRangeException {
        if (lon < -360.0) {
            throw new InvalidRangeException(S + "Longitude cannot be less than " + -360.0);
        }
        if (lon > 360.0) {
            throw new InvalidRangeException(S + "Longitude cannot be greater than " + 360.0);
        }
    }

    protected static void validateDepth(double depth, String S) throws InvalidRangeException {
        if (depth < 0.0) {
            throw new InvalidRangeException(S + "Depth is a negative number");
        }
    }

    public Object clone() {
        Location loc = new Location();
        loc.setDepth(this.depth);
        loc.setLatitude(this.latitude);
        loc.setLongitude(this.longitude);
        return loc;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(latLonFormat.format(this.latitude) + "," + latLonFormat.format(this.longitude) + "," + latLonFormat.format(this.depth));
        return b.toString();
    }

    public boolean equalsLocation(Location loc) {
        if ((float)this.latitude != (float)loc.latitude) {
            return false;
        }
        if ((float)this.longitude != (float)loc.longitude) {
            return false;
        }
        return (float)this.depth == (float)loc.depth;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            return this.equalsLocation((Location)obj);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.latitude + this.longitude + this.depth);
    }

    public static void main(String[] args) {
        long time = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            Location loc = new Location(44.0, 30.0, 0.0);
        }
        System.out.println("time = " + (System.currentTimeMillis() - time));
    }
}

