/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Location;
import org.opensha.data.LocationComparator;
import org.opensha.exceptions.InvalidRangeException;

public class LocationList
implements Serializable {
    protected static final String C = "LocationList";
    protected static final boolean D = false;
    protected ArrayList locations = new ArrayList();
    private static final String TAB = "  ";

    public Location getLocationAt(int index) throws InvalidRangeException {
        this.checkIndex(index);
        return (Location)this.locations.get(index);
    }

    private void checkIndex(int index) throws InvalidRangeException {
        if (this.size() < index + 1) {
            throw new InvalidRangeException("LocationList: getLocationAt(): Specified index larger than array size.");
        }
    }

    public void replaceLocationAt(Location location, int index) throws InvalidRangeException {
        this.checkIndex(index);
        this.locations.set(index, location);
    }

    public void sort() {
        Collections.sort(this.locations, new LocationComparator());
    }

    public void addLocation(Location location) {
        this.locations.add(location);
    }

    public void addLocationAt(Location location, int index) {
        this.locations.add(index, location);
    }

    public ListIterator listIterator() {
        return this.locations.listIterator();
    }

    public void clear() {
        this.locations.clear();
    }

    public void reverse() {
        int size = this.locations.size();
        int reverseIndex = size - 1;
        ArrayList newList = new ArrayList();
        for (int i = reverseIndex; i >= 0; --i) {
            newList.add(this.locations.get(i));
        }
        this.locations = newList;
    }

    public int size() {
        return this.locations.size();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append('\n');
        b.append("  Size = " + this.size());
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            Location location = (Location)it.next();
            b.append(TAB + location.toString());
        }
        return b.toString();
    }

    public double getHorzDistToClosestLocation(Location loc) {
        double min = Double.MAX_VALUE;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            double temp = RelativeLocation.getHorzDistance(loc, (Location)it.next());
            if (!(temp < min)) continue;
            min = temp;
        }
        return min;
    }

    public int compareTo(Object obj) {
        boolean compareFlag = true;
        if (!(obj instanceof LocationList)) {
            throw new ClassCastException("LocationListObject not a LocationList, unable to compare");
        }
        LocationList locList = (LocationList)obj;
        ListIterator it = locList.listIterator();
        ListIterator it1 = this.listIterator();
        if (this.size() != locList.size()) {
            return -1;
        }
        while (it.hasNext()) {
            Location loc = (Location)it.next();
            Location loc1 = (Location)it1.next();
            compareFlag = loc1.equals(loc);
            if (compareFlag) continue;
            break;
        }
        if (!compareFlag) {
            return -1;
        }
        return 0;
    }

    public int getLocationIndex(Location loc) {
        return this.locations.indexOf(loc);
    }

    public double getMinHorzDistToLine(Location loc) {
        double min = Double.MAX_VALUE;
        for (int i = 1; i < this.size(); ++i) {
            double temp = RelativeLocation.getApproxHorzDistToLine(loc, this.getLocationAt(i - 1), this.getLocationAt(i));
            if (!(temp < min)) continue;
            min = temp;
        }
        return min;
    }
}

