/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data;

import java.io.Serializable;

public class Window2D
implements Serializable {
    protected static final String C = "ContainerSubset2D";
    protected static final boolean D = false;
    protected int startRow = 0;
    protected int endRow = 0;
    protected int numRows = 0;
    protected int maxNumRows = 0;
    protected int startCol = 0;
    protected int endCol = 0;
    protected int numCols = 0;
    protected int maxNumCols = 0;

    public boolean isValidRow(int row) {
        if (row < 0) {
            return false;
        }
        return this.startRow + row <= this.endRow;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public boolean isValidCol(int col) {
        if (col < 0) {
            return false;
        }
        return this.startCol + col <= this.endCol;
    }

    public int getTranslatedRow(int row) {
        return this.startRow + row;
    }

    public int getTranslatedCol(int col) {
        return this.startCol + col;
    }

    public int windowSize() {
        return this.numRows * this.numCols;
    }

    public void shiftRows(int delta) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: shiftCols():";
        this.startRow += delta;
        this.checkLowerBounds(S);
        this.calcUpperBounds();
        this.checkUpperBounds(S);
    }

    public void shiftCols(int delta) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: shiftCols():";
        this.startCol += delta;
        this.checkLowerBounds(S);
        this.calcUpperBounds();
        this.checkUpperBounds(S);
    }

    public void calcUpperBounds() {
        this.endRow = this.startRow + this.numRows - 1;
        this.endCol = this.startCol + this.numCols - 1;
    }

    public void checkLowerBounds(String S) throws ArrayIndexOutOfBoundsException {
        if (this.startRow < 0) {
            throw new ArrayIndexOutOfBoundsException(S + "Start row cannot be less than zero");
        }
        if (this.startCol < 0) {
            throw new ArrayIndexOutOfBoundsException(S + "Start column cannot be less than zero");
        }
        if (this.numRows < 0) {
            throw new ArrayIndexOutOfBoundsException(S + "Number of rows cannot be less than zero");
        }
        if (this.numCols < 0) {
            throw new ArrayIndexOutOfBoundsException(S + "Number of columns cannot be less than zero");
        }
    }

    public void checkUpperBounds(String S) throws ArrayIndexOutOfBoundsException {
        if (this.startRow > this.maxNumRows) {
            throw new ArrayIndexOutOfBoundsException(S + "Start row cannot be greater than the last index of the larger dataset");
        }
        if (this.startCol > this.maxNumCols) {
            throw new ArrayIndexOutOfBoundsException(S + "Start column cannot be greater than the last index of the larger dataset");
        }
        if (this.endRow > this.maxNumRows) {
            throw new ArrayIndexOutOfBoundsException(S + "End row cannot be greater than the last index of the larger dataset");
        }
        if (this.endCol > this.maxNumCols) {
            throw new ArrayIndexOutOfBoundsException(S + "End column cannot be greater than the last index of the larger dataset");
        }
    }

    public Object clone() {
        return this.cloneWindow();
    }

    public Window2D cloneWindow() {
        Window2D window = new Window2D();
        window.startCol = this.startCol;
        window.startRow = this.startRow;
        window.endCol = this.endCol;
        window.endRow = this.endRow;
        window.numCols = this.numCols;
        window.numRows = this.numRows;
        window.maxNumCols = this.maxNumCols;
        window.maxNumRows = this.maxNumRows;
        return window;
    }

    public boolean equalsWindow(Window2D window) {
        if (window.startCol != this.startCol) {
            return false;
        }
        if (window.startRow != this.startRow) {
            return false;
        }
        if (window.endCol != this.endCol) {
            return false;
        }
        if (window.endRow != this.endRow) {
            return false;
        }
        if (window.numCols != this.numCols) {
            return false;
        }
        if (window.numRows != this.numRows) {
            return false;
        }
        if (window.maxNumCols != this.maxNumCols) {
            return false;
        }
        return window.maxNumRows == this.maxNumRows;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Window2D) {
            return this.equalsWindow((Window2D)obj);
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(C);
        b.append('\n');
        b.append("startCol = ");
        b.append(this.startCol);
        b.append('\n');
        b.append("endCol = ");
        b.append(this.endCol);
        b.append('\n');
        b.append("numCols = ");
        b.append(this.numCols);
        b.append('\n');
        b.append("maxNumCols = ");
        b.append(this.maxNumCols);
        b.append('\n');
        b.append("startRow = ");
        b.append(this.startRow);
        b.append('\n');
        b.append("endRow = ");
        b.append(this.endRow);
        b.append('\n');
        b.append("numRows = ");
        b.append(this.numRows);
        b.append('\n');
        b.append("maxNumRows = ");
        b.append(this.maxNumRows);
        return b.toString();
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setStartCol(int startCol) {
        this.startCol = startCol;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public int getMaxNumRows() {
        return this.maxNumRows;
    }

    public int getMaxNumCols() {
        return this.maxNumCols;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getEndCol() {
        return this.endCol;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public void setNumCols(int numCols) {
        this.numCols = numCols;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public void setEndCol(int endCol) {
        this.endCol = endCol;
    }
}

