/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.estimate;

import org.opensha.data.estimate.Estimate;
import org.opensha.data.estimate.InvalidParamValException;
import org.opensha.data.function.DiscretizedFunc;

public class FractileListEstimate
extends Estimate {
    public static final String NAME = "Fractile List";
    private static final double tol = 1.0E-6;
    private DiscretizedFunc func = null;

    public FractileListEstimate(DiscretizedFunc func) {
        this.setValues(func);
    }

    public String toString() {
        String text = "EstimateType=" + this.getName() + "\n";
        text = text + super.toString() + "\n";
        text = text + "Values from toString() method of specific estimate\nValue\tProbability\n";
        for (int i = 0; this.func != null && i < this.func.getNum(); ++i) {
            text = text + "\n" + this.func.getX(i) + "\t" + this.func.getY(i);
        }
        return text;
    }

    public void setValues(DiscretizedFunc func) {
        this.max = func.getMaxX();
        this.min = func.getMinX();
        int numValues = func.getNum();
        double y_last = -1.0;
        double sum = 0.0;
        for (int i = 0; i < numValues; ++i) {
            double y = func.getY(i);
            sum += y;
            if (y < 0.0 || y > 1.0) {
                throw new InvalidParamValException("Error: All probabilities must be \u2265 0 and \u2264 1");
            }
            if (y_last >= y) {
                throw new InvalidParamValException("Error: Probabilities must be in increasing order");
            }
            y_last = y;
        }
        if (Math.abs(sum - 1.0) > 1.0E-6) {
            throw new InvalidParamValException("Error: The probability values do not sum to 1");
        }
        this.func = (DiscretizedFunc)func.deepClone();
    }

    public double getMedian() {
        int numValues = this.func.getNum();
        if (numValues == 1 && this.func.getY(0) != 0.5) {
            throw new InvalidParamValException("Error: Median is undefined");
        }
        if (numValues > 1 && (this.func.getY(0) > 0.5 || this.func.getY(numValues - 1) < 0.5)) {
            throw new InvalidParamValException("Error: Median is undefined");
        }
        return this.func.getFirstInterpolatedX(0.5);
    }

    public double getFractile(double prob) {
        if (prob > this.func.getY(0) && prob > this.func.getY(this.func.getNum() - 1)) {
            return this.func.getFirstInterpolatedX(prob);
        }
        throw new InvalidParamValException("Error: Fractile is undefined");
    }

    public DiscretizedFunc getValues() {
        return this.func;
    }

    public String getName() {
        return NAME;
    }
}

