/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.estimate;

import org.opensha.data.estimate.Estimate;
import org.opensha.data.estimate.InvalidParamValException;

public class MinMaxPrefEstimate
extends Estimate {
    public static final String NAME = "Min, Max and Preferred";
    private double pref;
    private double minProb;
    private double maxProb;
    private double prefProb;
    private static final double tol = 1.0E-6;
    private static final String MSG_INVALID_X_VALS = "Error: Preferred value should be \u2265  Min &\nMax should be \u2264 Preferred";
    private static final String MSG_INVALID_PROB_VALS = "Error: Preferred Prob should be > Min Prob &\nMax Prob should be >  Preferred Prob";

    public MinMaxPrefEstimate(double min, double max, double pref, double minProb, double maxProb, double prefProb) {
        if (!Double.isNaN(min) && !Double.isNaN(pref) && min > pref) {
            throw new InvalidParamValException(MSG_INVALID_X_VALS);
        }
        if (!Double.isNaN(min) && !Double.isNaN(max) && min > max) {
            throw new InvalidParamValException(MSG_INVALID_X_VALS);
        }
        if (!Double.isNaN(pref) && !Double.isNaN(max) && pref > max) {
            throw new InvalidParamValException(MSG_INVALID_X_VALS);
        }
        if (!Double.isNaN(minProb) && !Double.isNaN(prefProb) && minProb >= prefProb) {
            throw new InvalidParamValException(MSG_INVALID_PROB_VALS);
        }
        if (!Double.isNaN(minProb) && !Double.isNaN(maxProb) && minProb >= maxProb) {
            throw new InvalidParamValException(MSG_INVALID_PROB_VALS);
        }
        if (!Double.isNaN(prefProb) && !Double.isNaN(maxProb) && prefProb >= maxProb) {
            throw new InvalidParamValException(MSG_INVALID_PROB_VALS);
        }
        if (!Double.isNaN(minProb) && (minProb < 0.0 || minProb > 1.0)) {
            throw new InvalidParamValException("Error: All probabilities must be \u2265 0 and \u2264 1");
        }
        if (!Double.isNaN(maxProb) && (maxProb < 0.0 || maxProb > 1.0)) {
            throw new InvalidParamValException("Error: All probabilities must be \u2265 0 and \u2264 1");
        }
        if (!Double.isNaN(prefProb) && (prefProb < 0.0 || prefProb > 1.0)) {
            throw new InvalidParamValException("Error: All probabilities must be \u2265 0 and \u2264 1");
        }
        this.min = min;
        this.max = max;
        this.pref = pref;
        this.minProb = minProb;
        this.maxProb = maxProb;
        this.prefProb = prefProb;
    }

    public String toString() {
        return "Estimate Type=" + this.getName() + "\n" + super.toString() + "\n" + "Values from toString() method of specific estimate\n" + "Min " + "=" + this.min + "[" + this.minProb + "]\n" + "Max " + "=" + this.max + "[" + this.maxProb + "]\n" + "Pref " + "=" + this.pref + "[" + this.prefProb + "]\n";
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public double getPreferred() {
        return this.pref;
    }

    public double getMinimumProb() {
        return this.minProb;
    }

    public double getMaximumProb() {
        return this.maxProb;
    }

    public double getPreferredProb() {
        return this.prefProb;
    }

    public double getMax() {
        if (!Double.isNaN(this.max)) {
            return this.max;
        }
        if (!Double.isNaN(this.pref)) {
            return this.pref;
        }
        if (!Double.isNaN(this.min)) {
            return this.min;
        }
        return Double.NaN;
    }

    public double getMin() {
        if (!Double.isNaN(this.min)) {
            return this.min;
        }
        if (!Double.isNaN(this.pref)) {
            return this.pref;
        }
        if (!Double.isNaN(this.max)) {
            return this.max;
        }
        return Double.NaN;
    }

    public String getName() {
        return NAME;
    }
}

