/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.estimate;

import org.opensha.data.estimate.DiscretizedFuncEstimate;
import org.opensha.data.estimate.InvalidParamValException;
import org.opensha.data.function.DiscretizedFunc;
import org.opensha.data.function.EvenlyDiscretizedFunc;

public class PDF_Estimate
extends DiscretizedFuncEstimate {
    public static final String NAME = "PDF";
    public static final String MSG_EVENLY_DISCRETIZED_ALLOWED = "Only evenly discretized function is allowed for PDF estimate";

    public PDF_Estimate(EvenlyDiscretizedFunc func, boolean isNormalized) {
        super(func, isNormalized);
    }

    public void setValues(DiscretizedFunc newFunc, boolean isNormalized) {
        if (!(newFunc instanceof EvenlyDiscretizedFunc)) {
            throw new InvalidParamValException(MSG_EVENLY_DISCRETIZED_ALLOWED);
        }
        super.setValues(newFunc, isNormalized);
    }

    public String getName() {
        return NAME;
    }

    public DiscretizedFunc getCDF_Test() {
        DiscretizedFunc cdfFunc = (DiscretizedFunc)this.cumDistFunc.deepClone();
        cdfFunc.setInfo("CDF from PDF Distribution");
        return cdfFunc;
    }

    public double getProbLessThanEqual(double x) {
        if (x < this.cumDistFunc.getX(0)) {
            return 0.0;
        }
        if (x > this.cumDistFunc.getX(this.cumDistFunc.getNum() - 1)) {
            return 1.0;
        }
        return this.cumDistFunc.getInterpolatedY(x);
    }

    public DiscretizedFunc getPDF_Test() {
        EvenlyDiscretizedFunc pdfFunc = (EvenlyDiscretizedFunc)this.func.deepClone();
        double deltaX = pdfFunc.getDelta();
        int numPoints = pdfFunc.getNum();
        for (int i = 0; i < numPoints; ++i) {
            double x = pdfFunc.getX(i);
            pdfFunc.set(i, this.getProbLessThanEqual(x + deltaX / 2.0) - this.getProbLessThanEqual(x - deltaX / 2.0));
        }
        pdfFunc.setInfo("PDF from PDF Distribution");
        return pdfFunc;
    }
}

