/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.function;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.data.DataPoint2D;
import org.opensha.data.NamedObjectAPI;
import org.opensha.data.function.DiscretizedFunc;
import org.opensha.data.function.DiscretizedFuncAPI;
import org.opensha.exceptions.DiscretizedFuncException;

public class DiscretizedFuncList
implements NamedObjectAPI {
    protected static final String C = "DiscretizedFuncList";
    protected static final boolean D = false;
    protected ArrayList functions = new ArrayList();
    protected String info = "";
    protected String name = "";
    protected String xAxisName = "";
    protected String yAxisName = "";
    private static String TAB = "\t";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getXAxisName() {
        return this.xAxisName;
    }

    public void setXAxisName(String name) {
        this.xAxisName = name;
    }

    public String getYAxisName() {
        return this.yAxisName;
    }

    public void setYAxisName(String name) {
        this.yAxisName = name;
    }

    public String getXYAxesName() {
        return this.xAxisName + ',' + this.yAxisName;
    }

    private boolean hasFunctionAtIndex(int index) {
        return index + 1 <= this.functions.size();
    }

    private DiscretizedFuncAPI getFunction(int index) {
        return (DiscretizedFuncAPI)this.functions.get(index);
    }

    public boolean isFuncAllowed(DiscretizedFuncAPI function) {
        return true;
    }

    public void clear() {
        this.functions.clear();
    }

    public ListIterator listIterator() {
        return this.functions.listIterator();
    }

    public Iterator iterator() {
        return this.functions.iterator();
    }

    public int size() {
        return this.functions.size();
    }

    public int indexOf(DiscretizedFunc function) {
        int counter = 0;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            DiscretizedFuncAPI f1 = (DiscretizedFuncAPI)it.next();
            if (f1.equals(function)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public void remove(int index) {
        this.functions.remove(index);
    }

    public void remove(DiscretizedFuncAPI function) {
        ListIterator it = this.listIterator();
        if (it != null) {
            while (it.hasNext()) {
                DiscretizedFuncAPI f1 = (DiscretizedFuncAPI)it.next();
                if (!f1.equals(function)) continue;
                this.functions.remove(f1);
                return;
            }
        }
    }

    public void removeAll(DiscretizedFuncList list) {
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            DiscretizedFuncAPI function = (DiscretizedFuncAPI)it.next();
            this.remove(function);
        }
    }

    public boolean contains(DiscretizedFuncAPI function) {
        ListIterator it = this.listIterator();
        if (it != null) {
            while (it.hasNext()) {
                DiscretizedFuncAPI f1 = (DiscretizedFuncAPI)it.next();
                if (!f1.equals(function)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean containsAll(DiscretizedFuncList list) {
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            DiscretizedFuncAPI function = (DiscretizedFuncAPI)it.next();
            if (this.contains(function)) continue;
            return false;
        }
        return true;
    }

    public void add(DiscretizedFuncAPI function) throws DiscretizedFuncException {
        if (!this.isFuncAllowed(function)) {
            throw new DiscretizedFuncException("DiscretizedFuncList: add(): This function is not allowed.");
        }
        this.functions.add(function);
    }

    public void addAll(DiscretizedFuncList list) throws DiscretizedFuncException {
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            DiscretizedFuncAPI function = (DiscretizedFuncAPI)it.next();
            try {
                this.add(function);
            }
            catch (DiscretizedFuncException ex) {}
        }
    }

    public DiscretizedFuncAPI get(int index) {
        DiscretizedFuncAPI f = null;
        if (this.hasFunctionAtIndex(index)) {
            f = (DiscretizedFuncAPI)this.functions.get(index);
        }
        return f;
    }

    public void update(DiscretizedFuncAPI function) {
        this.remove(function);
        this.add(function);
    }

    public boolean equals(DiscretizedFuncList list) {
        if (this.size() != list.size()) {
            return false;
        }
        return this.containsAll(list);
    }

    public DiscretizedFuncList deepClone() {
        DiscretizedFuncList l = new DiscretizedFuncList();
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            DiscretizedFuncAPI f = ((DiscretizedFuncAPI)it.next()).deepClone();
            l.add(f);
        }
        l.name = this.name;
        l.info = this.info;
        l.xAxisName = this.xAxisName;
        l.yAxisName = this.yAxisName;
        return l;
    }

    public String toString() {
        String S = "DiscretizedFuncList: toString(): ";
        StringBuffer b = new StringBuffer();
        b.append("\n");
        b.append("X-Axis: " + this.xAxisName + '\n');
        b.append("Y-Axis: " + this.yAxisName + '\n');
        b.append("Number of Data Sets: " + this.size() + '\n');
        ListIterator it = this.listIterator();
        boolean first = true;
        int counter = 0;
        while (it.hasNext()) {
            DiscretizedFuncAPI function = (DiscretizedFuncAPI)it.next();
            Iterator it2 = function.getPointsIterator();
            b.append("\nData Set #" + ++counter + '\n');
            b.append("Name: " + function.getName() + '\n');
            b.append("Num Points: " + function.getNum() + '\n');
            b.append("Info: " + function.getInfo() + "\n\n");
            b.append("X, Y Data:\n");
            while (it2.hasNext()) {
                DataPoint2D point = (DataPoint2D)it2.next();
                double x = point.getX();
                double y = point.getY();
                b.append((float)x + TAB + (float)y + '\n');
            }
        }
        return b.toString();
    }

    public String toStringOld() {
        String S = "DiscretizedFuncList: toString(): ";
        StringBuffer b = new StringBuffer();
        b.append("Discretized Function Data Points\n");
        b.append("X-Axis: " + this.xAxisName + '\n');
        b.append("Y-Axis: " + this.yAxisName + '\n');
        b.append("Number of Data Sets: " + this.size() + '\n');
        StringBuffer b2 = new StringBuffer();
        int numPoints = 100;
        int numSets = this.size();
        Number[][] model = new Number[numSets][100];
        double[] xx = new double[100];
        String[] rows = new String[100];
        ListIterator it1 = this.listIterator();
        boolean first = true;
        int counter = 0;
        b.append("\nColumn " + (counter + 1) + ". X-Axis");
        while (it1.hasNext()) {
            DiscretizedFuncAPI function = (DiscretizedFuncAPI)it1.next();
            b.append("\nColumn " + (counter + 2) + ". Y-Axis: " + ((Object)function).toString());
            Iterator it = function.getPointsIterator();
            int i = 0;
            while (it.hasNext()) {
                DataPoint2D point = (DataPoint2D)it.next();
                if (first) {
                    double x1;
                    xx[i] = x1 = point.getX();
                }
                double y1 = point.getY();
                model[counter][i] = new Double(y1);
                ++i;
            }
            if (first) {
                first = false;
            }
            ++counter;
        }
        for (int i = 0; i < 100; ++i) {
            b2.append('\n');
            for (int j = 0; j < numSets; ++j) {
                if (j == 0) {
                    b2.append("" + xx[i] + '\t' + model[j][i].toString());
                    continue;
                }
                b2.append('\t' + model[j][i].toString());
            }
        }
        b.append("\n\n-------------------------");
        b.append(b2.toString());
        b.append("\n-------------------------\n");
        return b.toString();
    }
}

