/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.region;

import java.awt.Polygon;
import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.region.GeographicRegionAPI;

public class GeographicRegion
implements GeographicRegionAPI,
Serializable {
    protected LocationList locList;
    protected double minLat;
    protected double minLon;
    protected double maxLat;
    protected double maxLon;
    private Polygon poly;
    private int DEGREES_TO_INT_FACTOR = (int)Math.pow(10.0, 7.0);
    private static final String C = "GeographicRegion";
    private static final boolean D = false;

    public GeographicRegion() {
    }

    public GeographicRegion(LocationList locs) {
        this.createGeographicRegion(locs);
    }

    public void createGeographicRegion(LocationList locs) {
        this.locList = locs;
        this.setMinMaxLatLon();
        this.createPoly();
    }

    public boolean isLocationInside(Location location) {
        return this.poly.contains((int)(location.getLatitude() * (double)this.DEGREES_TO_INT_FACTOR), (int)(location.getLongitude() * (double)this.DEGREES_TO_INT_FACTOR));
    }

    private void createPoly() {
        int[] lat = new int[this.getNumRegionOutlineLocations()];
        int[] lon = new int[this.getNumRegionOutlineLocations()];
        int index = 0;
        ListIterator lt = this.getRegionOutlineIterator();
        while (lt.hasNext()) {
            Location l = (Location)lt.next();
            lat[index] = (int)(l.getLatitude() * (double)this.DEGREES_TO_INT_FACTOR);
            lon[index] = (int)(l.getLongitude() * (double)this.DEGREES_TO_INT_FACTOR);
            ++index;
        }
        this.poly = new Polygon(lat, lon, this.getNumRegionOutlineLocations());
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public int getNumRegionOutlineLocations() {
        return this.locList.size();
    }

    public ListIterator getRegionOutlineIterator() {
        return this.locList.listIterator();
    }

    public LocationList getRegionOutline() {
        return this.locList;
    }

    protected void setMinMaxLatLon() {
        ListIterator it = this.getRegionOutlineIterator();
        Location l = (Location)it.next();
        this.minLat = l.getLatitude();
        this.minLon = l.getLongitude();
        this.maxLat = l.getLatitude();
        this.maxLon = l.getLongitude();
        while (it.hasNext()) {
            l = (Location)it.next();
            if (l.getLatitude() < this.minLat) {
                this.minLat = l.getLatitude();
            }
            if (l.getLatitude() > this.maxLat) {
                this.maxLat = l.getLatitude();
            }
            if (l.getLongitude() < this.minLon) {
                this.minLon = l.getLongitude();
            }
            if (!(l.getLongitude() > this.maxLon)) continue;
            this.maxLon = l.getLongitude();
        }
    }

    public double getMinHorzDistToRegion(Location loc) {
        if (this.isLocationInside(loc)) {
            return 0.0;
        }
        double min = this.locList.getMinHorzDistToLine(loc);
        double temp = RelativeLocation.getApproxHorzDistToLine(loc, this.locList.getLocationAt(this.locList.size() - 1), this.locList.getLocationAt(0));
        if (temp < min) {
            return temp;
        }
        return min;
    }
}

