/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.data.region;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.Site;
import org.opensha.data.region.EvenlyGriddedRectangularGeographicRegion;
import org.opensha.data.region.SitesInGriddedRegionAPI;
import org.opensha.exceptions.RegionConstraintException;
import org.opensha.param.ParameterAPI;
import org.opensha.sha.gui.infoTools.ConnectToCVM;
import org.opensha.sha.util.SiteTranslator;

public class SitesInGriddedRectangularRegion
extends EvenlyGriddedRectangularGeographicRegion
implements SitesInGriddedRegionAPI,
Serializable {
    public static final boolean D = false;
    Site site = new Site();
    private boolean setSameSiteParams = true;
    ArrayList willsSiteClassList;
    ArrayList basinDepth;
    private ArrayList defaultSiteParams;
    SiteTranslator siteTranslator = new SiteTranslator();

    public SitesInGriddedRectangularRegion(double minLat, double maxLat, double minLon, double maxLon, double gridSpacing) throws RegionConstraintException {
        super(minLat, maxLat, minLon, maxLon, gridSpacing);
    }

    public void setSiteParamsForRegion(String[] willsSiteClass, double[] bd) {
        block7: {
            int i;
            int size;
            if (willsSiteClass != null && bd != null && willsSiteClass.length != bd.length) {
                throw new RuntimeException("Invalid Range Site Type Values, both Wills Site Class and Basindepth should have same number of values");
            }
            if (willsSiteClass == null && bd == null) break block7;
            this.setSameSiteParams = false;
            if (willsSiteClass != null) {
                size = willsSiteClass.length;
                this.willsSiteClassList = new ArrayList();
                for (i = 0; i < size; ++i) {
                    this.willsSiteClassList.add(new String(willsSiteClass[i]));
                }
            }
            if (bd != null) {
                size = bd.length;
                this.basinDepth = new ArrayList();
                for (i = 0; i < size; ++i) {
                    this.basinDepth.add(new Double(bd[i]));
                }
            } else {
                size = this.willsSiteClassList.size();
                this.basinDepth = new ArrayList();
                for (i = 0; i < size; ++i) {
                    this.basinDepth.add(new Double(Double.NaN));
                }
            }
        }
    }

    public void setSiteParamsForRegionFromServlet(boolean connectForBasinDepth) {
        block6: {
            LocationList locList;
            block5: {
                this.setSameSiteParams = false;
                locList = this.getGridLocationsList();
                try {
                    this.willsSiteClassList = ConnectToCVM.getWillsSiteTypeFromCVM(locList);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (connectForBasinDepth) break block5;
                int size = this.willsSiteClassList.size();
                this.basinDepth = new ArrayList();
                for (int i = 0; i < size; ++i) {
                    this.basinDepth.add(new Double(Double.NaN));
                }
                break block6;
            }
            if (!connectForBasinDepth) break block6;
            try {
                this.willsSiteClassList = ConnectToCVM.getWillsSiteTypeFromCVM(locList);
                this.basinDepth = ConnectToCVM.getBasinDepthFromCVM(locList);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Site getSite(int index) throws RegionConstraintException {
        this.site.setLocation(this.getGridLocation(index));
        Object siteInfo = null;
        if (!this.setSameSiteParams) {
            ListIterator it = this.site.getParametersIterator();
            while (it.hasNext()) {
                ParameterAPI tempParam = (ParameterAPI)it.next();
                boolean flag = this.siteTranslator.setParameterValue(tempParam, (String)this.willsSiteClassList.get(index), (Double)this.basinDepth.get(index));
                if (flag) continue;
                Iterator it1 = this.defaultSiteParams.iterator();
                while (it1.hasNext()) {
                    ParameterAPI param = (ParameterAPI)it1.next();
                    if (!tempParam.getName().equals(param.getName())) continue;
                    tempParam.setValue(param.getValue());
                }
            }
        }
        return this.site;
    }

    public void addSiteParams(Iterator it) {
        while (it.hasNext()) {
            ParameterAPI tempParam = (ParameterAPI)it.next();
            if (this.site.containsParameter(tempParam)) continue;
            this.site.addParameter(tempParam);
        }
    }

    public void removeSiteParams() {
        ListIterator it1 = this.site.getParametersIterator();
        while (it1.hasNext()) {
            this.site.removeParameter((ParameterAPI)it1.next());
        }
    }

    public Iterator getSitesIterator() {
        ArrayList<Site> sitesVector = new ArrayList<Site>();
        ListIterator it = this.getGridLocationsIterator();
        ListIterator siteParamsIt = this.site.getParametersIterator();
        while (it.hasNext()) {
            Site newSite = new Site((Location)it.next());
            while (siteParamsIt.hasNext()) {
                ParameterAPI tempParam = (ParameterAPI)siteParamsIt.next();
                if (newSite.containsParameter(tempParam)) continue;
                newSite.addParameter(tempParam);
            }
            sitesVector.add(newSite);
        }
        return sitesVector.iterator();
    }

    public void setSameSiteParams() {
        this.setSameSiteParams = true;
        this.willsSiteClassList = null;
        this.basinDepth = null;
    }

    public void setDefaultSiteParams(ArrayList defaultSiteParams) {
        this.defaultSiteParams = defaultSiteParams;
    }

    public ArrayList getWillsClassVector() {
        return this.willsSiteClassList;
    }

    public ArrayList getBasinDepthVector() {
        return this.basinDepth;
    }
}

