/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.gui.plot.jfreechart;

import java.util.ArrayList;
import java.util.ListIterator;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.DatasetGroup;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;
import org.opensha.data.NamedObjectAPI;
import org.opensha.data.function.DiscretizedFuncAPI;
import org.opensha.data.function.DiscretizedFuncList;
import org.opensha.data.function.EvenlyDiscretizedFunc;

public class DiscretizedFunctionXYDataSet
implements XYDataset,
NamedObjectAPI,
IntervalXYDataset {
    protected static final String C = "DiscretizedFunctionXYDataSet";
    protected static final boolean D = false;
    protected boolean yLog = false;
    protected boolean xLog = false;
    protected DiscretizedFuncList functions = null;
    protected ArrayList listeners = new ArrayList();
    private double minVal = Double.MIN_VALUE;
    private boolean convertZeroToMin = false;
    private DatasetGroup group = new DatasetGroup();

    public boolean isYLog() {
        return this.yLog;
    }

    public void setYLog(boolean yLog) {
        this.yLog = yLog;
    }

    public boolean isXLog() {
        return this.xLog;
    }

    public void setXLog(boolean xLog) {
        this.xLog = xLog;
    }

    public void setName(String name) {
        this.functions.setName(name);
    }

    public String getName() {
        return this.functions.getName();
    }

    public ListIterator listIterator() {
        return this.functions.listIterator();
    }

    public int getSeriesCount() {
        return this.functions.size();
    }

    public String getSeriesName(int series) {
        if (series < this.functions.size()) {
            String str = this.functions.get(series).getInfo();
            return str;
        }
        return "";
    }

    public int getItemCount(int series) {
        int num = -1;
        if (series < this.functions.size()) {
            DiscretizedFuncAPI f = this.functions.get(series);
            num = f.getNum();
            if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(f, this.xLog, this.yLog)) {
                --num;
            }
        }
        return num;
    }

    public Number getXValue(int series, int item) {
        DiscretizedFuncAPI obj;
        if (series < this.functions.size() && (obj = this.functions.get(series)) != null && obj instanceof DiscretizedFuncAPI) {
            double x;
            if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(obj, this.xLog, this.yLog)) {
                ++item;
            }
            if ((x = obj.getX(item)) != Double.NaN) {
                return new Double(x);
            }
        }
        return null;
    }

    public Number getYValue(int series, int item) {
        DiscretizedFuncAPI obj;
        if (series < this.functions.size() && (obj = this.functions.get(series)) != null && obj instanceof DiscretizedFuncAPI) {
            if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(obj, this.xLog, this.yLog)) {
                ++item;
            }
            double y = obj.getY(item);
            if (this.convertZeroToMin && y <= this.minVal && this.yLog) {
                return new Double(this.minVal);
            }
            if (y != Double.NaN) {
                return new Double(y);
            }
        }
        return null;
    }

    protected static final boolean isAdjustedIndexIfFirstXZero(DiscretizedFuncAPI func, boolean xLog, boolean yLog) {
        return xLog && (func.getX(0) == 0.0 || func.getX(0) == Double.MIN_VALUE) || yLog && func.getY(0) == 0.0;
    }

    public void clear() {
        this.functions.clear();
    }

    public int size() {
        return this.functions.size();
    }

    public boolean equals(DiscretizedFunctionXYDataSet list) {
        return list.getFunctions().equals(this.functions);
    }

    public DiscretizedFunctionXYDataSet deepClone() {
        DiscretizedFunctionXYDataSet set = new DiscretizedFunctionXYDataSet();
        DiscretizedFuncList list = this.functions.deepClone();
        set.setFunctions(list);
        return set;
    }

    public void addChangeListener(DatasetChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(DatasetChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public DiscretizedFuncList getFunctions() {
        return this.functions;
    }

    public void setFunctions(DiscretizedFuncList functions) {
        this.functions = functions;
    }

    public void setConvertZeroToMin(boolean zeroToMin) {
        this.convertZeroToMin = zeroToMin;
    }

    public void setConvertZeroToMin(boolean zeroMin, double minVal) {
        this.convertZeroToMin = zeroMin;
        this.minVal = minVal;
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup group) {
        this.group = group;
    }

    public Number getStartXValue(int series, int item) {
        double x = (Double)this.getXValue(series, item);
        DiscretizedFuncAPI obj = this.functions.get(series);
        if (obj != null && obj instanceof EvenlyDiscretizedFunc) {
            x -= ((EvenlyDiscretizedFunc)obj).getDelta() / 2.0;
        }
        return new Double(x);
    }

    public Number getEndXValue(int series, int item) {
        double x = (Double)this.getXValue(series, item);
        DiscretizedFuncAPI obj = this.functions.get(series);
        if (obj != null && obj instanceof EvenlyDiscretizedFunc) {
            x += ((EvenlyDiscretizedFunc)obj).getDelta() / 2.0;
        }
        return new Double(x);
    }

    public Number getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }
}

