/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.param.DiscreteParameterConstraintAPI;
import org.opensha.param.ParameterConstraint;

public class DoubleDiscreteConstraint
extends ParameterConstraint
implements DiscreteParameterConstraintAPI {
    protected static final String C = "DoubleDiscreteConstraint";
    protected static final boolean D = false;
    private ArrayList doubles = new ArrayList();

    public DoubleDiscreteConstraint() {
    }

    public DoubleDiscreteConstraint(ArrayList doubles) throws ConstraintException {
        if (doubles.size() <= 0) {
            String S = "DoubleDiscreteConstraint: Constructor(ArrayList doubles): ";
            throw new ConstraintException(S + "Input vector of constraint values cannot be empty");
        }
        this.doubles = doubles;
    }

    public void setDoubles(ArrayList doubles) throws EditableException {
        if (!this.editable) {
            throw new EditableException("DoubleDiscreteConstraint: setStrings(): This constraint is currently not editable.");
        }
        this.doubles = doubles;
    }

    public ArrayList getAllowedValues() {
        return this.getAllowedDoubles();
    }

    public ArrayList getAllowedDoubles() {
        return (ArrayList)this.doubles.clone();
    }

    public boolean isAllowed(Object obj) {
        if (this.nullAllowed && obj == null) {
            return true;
        }
        if (!(obj instanceof Double)) {
            return false;
        }
        return this.containsDouble((Double)obj);
    }

    public boolean isAllowed(Double d) {
        if (this.nullAllowed && d == null) {
            return true;
        }
        return this.containsDouble(d);
    }

    public boolean isAllowed(double d) {
        return this.isAllowed(new Double(d));
    }

    public ListIterator listIterator() {
        return this.doubles.listIterator();
    }

    public void addDouble(double d) throws EditableException {
        this.addDouble(new Double(d));
    }

    public void addDouble(Double d) throws EditableException {
        String S = "DoubleDiscreteConstraint: addDouble( Double ): ";
        this.checkEditable(S);
        if (!this.containsDouble(d)) {
            this.doubles.add(d);
        }
    }

    public void removeDouble(Double d) throws EditableException {
        String S = "DoubleDiscreteConstraint: removeDouble( Double ): ";
        this.checkEditable(S);
        if (this.containsDouble(d)) {
            this.doubles.remove(d);
        }
    }

    public void removeDouble(double d) throws EditableException {
        this.removeDouble(new Double(d));
    }

    public boolean containsDouble(Double d) {
        return this.doubles.contains(d);
    }

    public boolean containsDouble(double d) {
        return this.containsDouble(new Double(d));
    }

    public int size() {
        return this.doubles.size();
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getName());
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + '\n');
        }
        b.append(TAB.concat("Allowed values = "));
        ListIterator it = this.doubles.listIterator();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                b.append(TAB + ", " + it.next());
                continue;
            }
            b.append(TAB + it.next());
            first = false;
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + '\n');
        return b.toString();
    }

    public Object clone() {
        DoubleDiscreteConstraint c1 = new DoubleDiscreteConstraint();
        c1.setName(this.name);
        ArrayList v = this.getAllowedDoubles();
        ListIterator it = v.listIterator();
        while (it.hasNext()) {
            Double val = (Double)it.next();
            Double val2 = new Double(val);
            c1.addDouble(val2);
        }
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

