/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import org.opensha.data.ValueWeight;
import org.opensha.exceptions.EditableException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.ParameterConstraint;

public class DoubleValueWeightConstraint
extends ParameterConstraint {
    protected static final String C = "DoubleValueWeightConstraint";
    protected static final boolean D = false;
    protected DoubleConstraint valueConstraint = null;
    protected DoubleConstraint weightConstraint = null;

    public DoubleValueWeightConstraint() {
    }

    public DoubleValueWeightConstraint(double minVal, double maxVal, double minWt, double maxWt) {
        this(new Double(minVal), new Double(maxVal), new Double(minWt), new Double(maxWt));
    }

    public DoubleValueWeightConstraint(Double minVal, Double maxVal, Double minWt, Double maxWt) {
        this.valueConstraint = new DoubleConstraint(minVal, maxVal);
        this.weightConstraint = new DoubleConstraint(minWt, maxWt);
    }

    public void setMinMax(double minVal, double maxVal, double minWt, double maxWt) throws EditableException {
        this.setMinMax(new Double(minVal), new Double(maxVal), new Double(minWt), new Double(maxWt));
    }

    public void setMinMax(Double minVal, Double maxVal, Double minWt, Double maxWt) throws EditableException {
        String S = "DoubleValueWeightConstraint: setMinMax(Double, Double): ";
        this.checkEditable(S);
        this.valueConstraint = new DoubleConstraint(minVal, maxVal);
        this.weightConstraint = new DoubleConstraint(minWt, maxWt);
    }

    public Double getMinVal() {
        return this.valueConstraint.getMin();
    }

    public Double getMaxVal() {
        return this.valueConstraint.getMax();
    }

    public Double getMinWt() {
        return this.weightConstraint.getMin();
    }

    public Double getMaxWt() {
        return this.weightConstraint.getMax();
    }

    public boolean isAllowed(Object obj) {
        if (this.nullAllowed && obj == null) {
            return true;
        }
        if (!(obj instanceof ValueWeight)) {
            return false;
        }
        return this.isAllowed((ValueWeight)obj);
    }

    public boolean isAllowed(ValueWeight valueWt) {
        if (this.nullAllowed && valueWt == null) {
            return true;
        }
        return this.valueConstraint.isAllowed(valueWt.getValue()) && this.weightConstraint.isAllowed(valueWt.getWeight());
    }

    public boolean isAllowed(double val, double wt) {
        return this.isAllowed(new ValueWeight(val, wt));
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + '\n');
        }
        if (this.valueConstraint.getMin() != null) {
            b.append(TAB + "Min Val = " + this.valueConstraint.getMin().toString() + '\n');
        }
        if (this.valueConstraint.getMax() != null) {
            b.append(TAB + "Max Val = " + this.valueConstraint.getMax().toString() + '\n');
        }
        if (this.weightConstraint.getMin() != null) {
            b.append(TAB + "Min Weight = " + this.weightConstraint.getMin().toString() + '\n');
        }
        if (this.weightConstraint.getMax() != null) {
            b.append(TAB + "Max Weight = " + this.weightConstraint.getMax().toString() + '\n');
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + '\n');
        return b.toString();
    }

    public Object clone() {
        DoubleValueWeightConstraint c1 = new DoubleValueWeightConstraint(this.valueConstraint.getMin(), this.valueConstraint.getMax(), this.weightConstraint.getMin(), this.weightConstraint.getMax());
        c1.setName(this.name);
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

