/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.io.Serializable;
import org.opensha.data.function.EvenlyDiscretizedFunc;
import org.opensha.exceptions.EditableException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DependentParameter;
import org.opensha.param.DoubleParameter;
import org.opensha.param.IntegerParameter;
import org.opensha.param.ParameterList;

public class EvenlyDiscretizedFuncParameter
extends DependentParameter
implements Serializable {
    protected static final String C = "EvenlyDiscretizedFuncParameter";
    protected static final boolean D = false;
    protected static final String PARAM_TYPE = "EvenlyDiscretizedFuncParameter";
    private String xUnits = "";
    private DoubleParameter minParam;
    public static final String MIN_PARAM_NAME = "Min ";
    private DoubleParameter maxParam;
    public static final String MAX_PARAM_NAME = "Max ";
    private IntegerParameter numParam;
    public static final String NUM_PARAM_NAME = "Number of Points";
    private ParameterList paramList;

    public EvenlyDiscretizedFuncParameter(String name, EvenlyDiscretizedFunc discretizedFunc) {
        super(name, null, null, discretizedFunc);
        this.initParamListAndEditor();
    }

    private void initParamListAndEditor() {
        String S = "EvenlyDiscretizedFuncParameter: initControlsParamListAndEditor(): ";
        EvenlyDiscretizedFunc func = (EvenlyDiscretizedFunc)this.getValue();
        double min = func.getMinX();
        double max = func.getMaxX();
        int num = func.getNum();
        this.minParam = new DoubleParameter(MIN_PARAM_NAME, new Double(min));
        this.maxParam = new DoubleParameter(MAX_PARAM_NAME, new Double(max));
        this.numParam = new IntegerParameter(NUM_PARAM_NAME, new Integer(num));
        this.paramList = new ParameterList();
        this.paramList.addParameter(this.minParam);
        this.paramList.addParameter(this.maxParam);
        this.paramList.addParameter(this.numParam);
        this.setIndependentParameters(this.paramList);
    }

    public ParameterList getEvenlyDiscretizedParams() {
        return this.paramList;
    }

    public void setXUnits(String units) throws EditableException {
        this.checkEditable("EvenlyDiscretizedFuncParameter: setUnits(): ");
        this.xUnits = units;
    }

    public String getXUnits() {
        return this.xUnits;
    }

    public int compareTo(Object obj) {
        EvenlyDiscretizedFunc n2;
        String S = "EvenlyDiscretizedFuncParameter:compareTo(): ";
        if (!(obj instanceof EvenlyDiscretizedFunc)) {
            throw new ClassCastException(S + "Object not a DiscretizedFuncAPI, unable to compare");
        }
        EvenlyDiscretizedFuncParameter param = (EvenlyDiscretizedFuncParameter)obj;
        if (this.value == null && param.value == null) {
            return 0;
        }
        boolean result = false;
        EvenlyDiscretizedFunc n1 = (EvenlyDiscretizedFunc)this.getValue();
        if (n1.equals(n2 = (EvenlyDiscretizedFunc)param.getValue())) {
            return 0;
        }
        return -1;
    }

    public void setValue(EvenlyDiscretizedFunc value) throws ParameterException {
        this.setValue((Object)value);
    }

    public boolean isAllowed(Object obj) {
        if (obj == null && this.isNullAllowed()) {
            return true;
        }
        return obj instanceof EvenlyDiscretizedFunc;
    }

    public boolean equals(Object obj) {
        String S = "EvenlyDiscretizedFuncParameter:equals(): ";
        if (!(obj instanceof EvenlyDiscretizedFunc)) {
            throw new ClassCastException(S + "Object not a DiscretizedFuncAPI, unable to compare");
        }
        return ((EvenlyDiscretizedFunc)this.value).equals(((EvenlyDiscretizedFuncParameter)obj).value);
    }

    public Object clone() {
        EvenlyDiscretizedFuncParameter param = null;
        param = new EvenlyDiscretizedFuncParameter(this.name, (EvenlyDiscretizedFunc)((EvenlyDiscretizedFunc)this.value).deepClone());
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }

    public EvenlyDiscretizedFunc getParameter() {
        return (EvenlyDiscretizedFunc)this.getValue();
    }

    public String getType() {
        String type = "EvenlyDiscretizedFuncParameter";
        return type;
    }

    public String getMetadataString() {
        String metadata = this.getDependentParamMetadataString();
        metadata = metadata + "\nFunction Info= [ ";
        EvenlyDiscretizedFunc func = (EvenlyDiscretizedFunc)this.getValue();
        int num = func.getNum();
        for (int i = 0; i < num; ++i) {
            metadata = metadata + (float)func.getX(i) + " " + (float)func.getY(i) + " , ";
        }
        metadata = metadata.substring(0, metadata.lastIndexOf(","));
        metadata = metadata + " ]";
        return metadata;
    }
}

