/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.param.DiscreteParameterConstraintAPI;
import org.opensha.param.ParameterConstraint;

public class LocationConstraint
extends ParameterConstraint
implements DiscreteParameterConstraintAPI {
    protected static final String C = "LocationConstraint";
    protected static final boolean D = false;
    private ArrayList locations;

    public LocationConstraint() {
        this.locations = new ArrayList();
    }

    public LocationConstraint(ArrayList locations) throws ConstraintException {
        if (locations.size() <= 0) {
            String S = "LocationConstraint: Constructor(ArrayList locations): ";
            throw new ConstraintException(S + "Input vector of constraint values cannot be empty");
        }
        this.locations = locations;
    }

    public void setLocations(ArrayList locations) throws ConstraintException, EditableException {
        String S = "LocationConstraint: setLocations(): ";
        this.checkEditable(S);
        if (locations == null || locations.size() <= 0) {
            throw new ConstraintException(S + "Input vector of constraint values cannot be null or empty");
        }
        this.locations = locations;
    }

    public ArrayList getAllowedLocations() {
        return (ArrayList)this.locations.clone();
    }

    public ArrayList getAllowedValues() {
        return this.getAllowedLocations();
    }

    public boolean isAllowed(Object obj) {
        if (this.nullAllowed && obj == null) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        return this.containsLocation((Location)obj);
    }

    public ListIterator listIterator() {
        return this.locations.listIterator();
    }

    public void addLocation(Location loc) throws EditableException {
        this.checkEditable("LocationConstraint: addLocation(): ");
        if (!this.containsLocation(loc)) {
            this.locations.add(loc);
        }
    }

    public void removeLocation(Location loc) throws EditableException {
        this.checkEditable("LocationConstraint: removeLocation(): ");
        if (this.containsLocation(loc)) {
            this.locations.remove(loc);
        }
    }

    public boolean containsLocation(Location loc) {
        return this.locations.contains(loc);
    }

    public int size() {
        return this.locations.size();
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        b.append(C);
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + '\n');
        }
        b.append(TAB + "Allowed values = ");
        boolean first = true;
        ListIterator it = this.locations.listIterator();
        while (it.hasNext()) {
            if (!first) {
                b.append(TAB + ", " + it.next().toString());
                continue;
            }
            b.append(TAB + it.next().toString());
            first = false;
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + '\n');
        return b.toString();
    }

    public Object clone() {
        LocationConstraint c1 = new LocationConstraint();
        c1.name = this.name;
        ArrayList v = this.getAllowedLocations();
        ListIterator it = v.listIterator();
        while (it.hasNext()) {
            Location loc = (Location)it.next();
            c1.addLocation(loc);
        }
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

