/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeFailEvent;
import org.opensha.param.event.ParameterChangeFailListener;
import org.opensha.param.event.ParameterChangeListener;

public abstract class Parameter
implements ParameterAPI,
Serializable {
    protected static final String C = "Parameter";
    protected static final boolean D = false;
    protected String name = "";
    protected String info = "";
    protected String units = "";
    protected ParameterConstraintAPI constraint = null;
    protected boolean editable = true;
    protected Object value = null;
    private transient ArrayList changeListeners;
    private transient ArrayList failListeners;

    public Parameter() {
    }

    protected void checkEditable(String S) throws EditableException {
        if (!this.editable) {
            throw new EditableException(S + "This parameter is currently not editable");
        }
    }

    public Parameter(String name, ParameterConstraintAPI constraint, String units, Object value) throws ConstraintException {
        String S = "Parameter: Constructor(): ";
        if (value != null && constraint != null && !constraint.isAllowed(value)) {
            System.out.println(S + "Value not allowed");
            throw new ConstraintException(S + "Value not allowed");
        }
        this.constraint = constraint;
        this.name = name;
        this.value = value;
        this.units = units;
    }

    public boolean isAllowed(Object obj) {
        if (this.constraint != null) {
            return this.constraint.isAllowed(obj);
        }
        return true;
    }

    public void setValue(Object value) throws ConstraintException, ParameterException {
        String S = this.getName() + ": setValue(): ";
        if (!this.isAllowed(value)) {
            throw new ConstraintException(S + "Value is not allowed: " + value.toString());
        }
        this.value = value;
        ParameterChangeEvent event = new ParameterChangeEvent(this, this.getName(), this.getValue(), value);
        this.firePropertyChange(event);
    }

    public void unableToSetValue(Object value) throws ConstraintException {
        String S = "Parameter: unableToSetValue():";
        ParameterChangeFailEvent event = new ParameterChangeFailEvent(this, this.getName(), this.getValue(), value);
        this.firePropertyChangeFailed(event);
    }

    public synchronized void addParameterChangeFailListener(ParameterChangeFailListener listener) {
        if (this.failListeners == null) {
            this.failListeners = new ArrayList();
        }
        if (!this.failListeners.contains(listener)) {
            this.failListeners.add(listener);
        }
    }

    public String getConstraintName() {
        if (this.constraint != null) {
            String name = this.constraint.getName();
            if (name == null) {
                return "";
            }
            return name;
        }
        return "";
    }

    public synchronized void removeParameterChangeFailListener(ParameterChangeFailListener listener) {
        if (this.failListeners != null && this.failListeners.contains(listener)) {
            this.failListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChangeFailed(ParameterChangeFailEvent event) {
        ArrayList vector;
        String S = "Parameter: firePropertyChange(): ";
        Parameter parameter = this;
        synchronized (parameter) {
            if (this.failListeners == null) {
                return;
            }
            vector = (ArrayList)this.failListeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ParameterChangeFailListener listener = (ParameterChangeFailListener)vector.get(i);
            listener.parameterChangeFailed(event);
        }
    }

    public synchronized void addParameterChangeListener(ParameterChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public synchronized void removeParameterChangeListener(ParameterChangeListener listener) {
        if (this.changeListeners != null && this.changeListeners.contains(listener)) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(ParameterChangeEvent event) {
        ArrayList vector;
        String S = "Parameter: firePropertyChange(): ";
        Parameter parameter = this;
        synchronized (parameter) {
            if (this.changeListeners == null) {
                return;
            }
            vector = (ArrayList)this.changeListeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ParameterChangeListener listener = (ParameterChangeListener)vector.get(i);
            listener.parameterChange(event);
        }
    }

    public boolean isNullAllowed() {
        if (this.constraint != null) {
            return this.constraint.isNullAllowed();
        }
        return true;
    }

    public void setInfo(String info) throws EditableException {
        this.checkEditable("Parameter: setInfo(): ");
        this.info = info;
    }

    public void setUnits(String units) throws EditableException {
        this.checkEditable("Parameter: setUnits(): ");
        this.units = units;
    }

    public Object getValue() {
        return this.value;
    }

    public String getUnits() {
        return this.units;
    }

    public ParameterConstraintAPI getConstraint() {
        return this.constraint;
    }

    public void setConstraint(ParameterConstraintAPI constraint) throws EditableException {
        this.checkEditable("Parameter: setConstraint(): ");
        this.constraint = constraint;
        Object value = this.getValue();
        if (!constraint.isAllowed(value)) {
            constraint.setNullAllowed(true);
            this.setValue(null);
            constraint.setNullAllowed(false);
        }
    }

    public String getInfo() {
        return this.info;
    }

    public void setNonEditable() {
        this.editable = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkEditable("Parameter: setName(): ");
        this.name = name;
    }

    public String getType() {
        return C;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getMetadataString() {
        if (this.value != null) {
            return this.name + " = " + this.value.toString();
        }
        return this.name + " = " + "null";
    }

    public abstract Object clone();
}

