/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.param.DiscreteParameterConstraintAPI;
import org.opensha.param.ParameterConstraint;

public class StringConstraint
extends ParameterConstraint
implements DiscreteParameterConstraintAPI {
    protected static final String C = "StringConstraint";
    protected static final boolean D = false;
    private ArrayList strings = new ArrayList();

    public StringConstraint() {
    }

    public StringConstraint(ArrayList strings) throws ConstraintException {
        if (strings.size() <= 0) {
            String S = "StringConstraint: Constructor(ArrayList strings): ";
            throw new ConstraintException(S + "Input vector of constraint values cannot be empty");
        }
        this.strings = strings;
    }

    public void setStrings(ArrayList strings) throws ConstraintException, EditableException {
        String S = "StringConstraint: setStrings(): ";
        this.checkEditable(S);
        if (strings == null || strings.size() <= 0) {
            throw new ConstraintException(S + "Input vector of constraint values cannot be null or empty");
        }
        this.strings = strings;
    }

    public ArrayList getAllowedStrings() {
        return (ArrayList)this.strings.clone();
    }

    public ArrayList getAllowedValues() {
        return this.getAllowedStrings();
    }

    public boolean isAllowed(Object obj) {
        if (this.nullAllowed && obj == null) {
            return true;
        }
        if (!(obj instanceof String)) {
            return false;
        }
        return this.containsString(obj.toString());
    }

    public ListIterator listIterator() {
        return this.strings.listIterator();
    }

    public void addString(String str) throws EditableException {
        this.checkEditable("StringConstraint: addString(): ");
        if (!this.containsString(str)) {
            this.strings.add(str);
        }
    }

    public void removeString(String str) throws EditableException {
        this.checkEditable("StringConstraint: removeString(): ");
        if (this.containsString(str)) {
            this.strings.remove(str);
        }
    }

    public boolean containsString(String str) {
        return this.strings.contains(str);
    }

    public int size() {
        return this.strings.size();
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        b.append(C);
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + '\n');
        }
        b.append(TAB + "Allowed values = ");
        boolean first = true;
        ListIterator it = this.strings.listIterator();
        while (it.hasNext()) {
            if (!first) {
                b.append(TAB + ", " + it.next());
                continue;
            }
            b.append(TAB + it.next());
            first = false;
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + '\n');
        return b.toString();
    }

    public Object clone() {
        StringConstraint c1 = new StringConstraint();
        c1.name = this.name;
        ArrayList v = this.getAllowedStrings();
        ListIterator it = v.listIterator();
        while (it.hasNext()) {
            String val = (String)it.next();
            c1.addString(val);
        }
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

