/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.exceptions.ConstraintException;
import org.opensha.param.StringConstraint;

public class StringListConstraint
extends StringConstraint {
    public StringListConstraint() {
    }

    public StringListConstraint(ArrayList strings) throws ConstraintException {
        super(strings);
    }

    public boolean isAllowed(Object obj) {
        if (this.nullAllowed && obj == null) {
            return true;
        }
        if (obj instanceof ArrayList) {
            return this.isAllowed((ArrayList)obj);
        }
        if (obj instanceof String) {
            return this.isAllowed((String)obj);
        }
        return false;
    }

    private boolean isAllowed(ArrayList valsList) {
        int size = valsList.size();
        for (int i = 0; i < size; ++i) {
            if (!(valsList.get(i) instanceof String)) {
                return false;
            }
            if (this.isAllowed((String)valsList.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isAllowed(String str) {
        return this.containsString(str);
    }

    public Object clone() {
        StringListConstraint c1 = new StringListConstraint();
        c1.name = this.name;
        ArrayList v = this.getAllowedStrings();
        ListIterator it = v.listIterator();
        while (it.hasNext()) {
            String val = (String)it.next();
            c1.addString(val);
        }
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

