/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.util.ArrayList;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DependentParameter;
import org.opensha.param.DependentParameterAPI;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.StringConstraint;

public class StringParameter
extends DependentParameter
implements DependentParameterAPI,
ParameterAPI {
    protected static final String C = "StringParameter";
    protected static final boolean D = false;

    public StringParameter(String name) {
        this.name = name;
    }

    public StringParameter(String name, ArrayList strings) throws ConstraintException {
        this(name, new StringConstraint(strings), null, null);
    }

    public StringParameter(String name, StringConstraint constraint) throws ConstraintException {
        this(name, constraint, null, null);
    }

    public StringParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public StringParameter(String name, String units, String value) throws ConstraintException {
        this(name, null, units, value);
    }

    public StringParameter(String name, ArrayList strings, String value) throws ConstraintException {
        this(name, new StringConstraint(strings), null, value);
    }

    public StringParameter(String name, StringConstraint constraint, String value) throws ConstraintException {
        this(name, constraint, null, value);
    }

    public StringParameter(String name, StringConstraint constraint, String units, String value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    public void setConstraint(ParameterConstraintAPI constraint) throws ParameterException, EditableException {
        String S = "StringParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof StringConstraint)) {
            throw new ParameterException(S + "This parameter only accepts StringConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    public String getType() {
        String type = C;
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public ArrayList getAllowedStrings() {
        return ((StringConstraint)this.constraint).getAllowedStrings();
    }

    public int compareTo(Object obj) throws ClassCastException {
        String S = "StringParameter:compareTo(): ";
        if (!(obj instanceof StringParameter)) {
            throw new ClassCastException(S + "Object not a StringParameter, unable to compare");
        }
        StringParameter param = (StringParameter)obj;
        if (this.value == null && param.value == null) {
            return 0;
        }
        boolean result = false;
        String n1 = (String)this.getValue();
        String n2 = (String)param.getValue();
        return n1.compareTo(n2);
    }

    public boolean equals(Object obj) throws ClassCastException {
        String S = "StringParameter:equals(): ";
        if (!(obj instanceof StringParameter)) {
            throw new ClassCastException(S + "Object not a StringParameter, unable to compare");
        }
        String otherName = ((StringParameter)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    public Object clone() {
        StringConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (StringConstraint)this.constraint.clone();
        }
        StringParameter param = null;
        if (this.value == null) {
            param = new StringParameter(this.name, c1);
            param.setUnits(this.units);
        } else {
            param = new StringParameter(this.name, c1, this.units, this.value.toString());
        }
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }
}

